/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecialization;
import ro.amiq.dvt.elaboration.model.ELLiblist;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELDesign;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.RootDesignElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;

public class ELInstance {
    private final ElementPath hierarchyPath;
    private final IRfInstanceElement cachedDescription;
    private ELSpecialization spec;
    private IRfConfiguration elabConfig;
    private ELLiblist elabLiblist;
    private IRfConfigurationRule elabRule;
    private Collection<? extends IRfConfigurationRule> elabChildrenRules;

    public static ELInstance of(IRfInstanceElement description, ElementPath hierarchyPath, ELManager manager) {
        if (description == null) {
            throw new IllegalArgumentException("Instance description cannot be null");
        }
        if (hierarchyPath == null) {
            throw new IllegalArgumentException("Hierarchy path cannot be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Manager cannot be null");
        }
        manager.state.increaseNofInstances();
        ELInstance elInstance = new ELInstance(description, hierarchyPath);
        elInstance.spec = ELSpecialization.of(null);
        return elInstance;
    }

    public static ELInstance of(IRfInstanceElement description, ElementPath hierarchyPath, IELDesign binding, IRfConfiguration config, ELLiblist liblist, IRfConfigurationRule configRule, Collection<? extends IRfConfigurationRule> childrenRules, ELManager manager) {
        if (description == null) {
            throw new IllegalArgumentException("Instance description cannot be null");
        }
        if (hierarchyPath == null) {
            throw new IllegalArgumentException("Hierarchy path cannot be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Manager cannot be null");
        }
        manager.state.increaseNofInstances();
        ELInstance elInstance = new ELInstance(description, hierarchyPath);
        elInstance.spec = ELSpecialization.of(binding);
        elInstance.elabConfig = config;
        elInstance.elabLiblist = liblist;
        elInstance.elabRule = configRule;
        elInstance.elabChildrenRules = childrenRules;
        return elInstance;
    }

    public static ELInstance copyOf(ELInstance instance, ElementPath hierarchyPath, boolean includeParamValues) {
        return ELInstance.copyOf(instance, instance.cachedDescription, hierarchyPath, includeParamValues);
    }

    public static ELInstance copyOf(ELInstance instance, IRfInstanceElement description, ElementPath hierarchyPath, boolean includeParamValues) {
        ELInstance copy = new ELInstance(description, hierarchyPath);
        copy.spec = includeParamValues ? instance.spec : (instance.spec != null ? ELSpecialization.of((IELDesign)instance.spec.getBinding(false), instance.spec.getInterfacePortInstances()) : ELSpecialization.of(null));
        copy.elabConfig = instance.elabConfig;
        copy.elabLiblist = instance.elabLiblist;
        copy.elabRule = instance.elabRule;
        copy.elabChildrenRules = instance.elabChildrenRules;
        return copy;
    }

    @NotNull
    static ELInstance rootFor(RootDesignElement root, ELLiblist liblist, IRfConfiguration config) {
        ELInstance copy = new ELInstance(DummyInstance.of("$root", root), ElementPath.$ROOT_NAME_PATH);
        copy.spec = ELSpecialization.of(root);
        copy.elabConfig = config;
        copy.elabLiblist = liblist;
        return copy;
    }

    private ELInstance(IRfInstanceElement description, ElementPath hierarchyPath) {
        this.cachedDescription = description;
        this.hierarchyPath = hierarchyPath;
    }

    @NotNull
    public IRfInstanceElement getDescription() {
        return this.cachedDescription;
    }

    @NotNull
    public ElementPath getHierarchyPath() {
        return this.hierarchyPath;
    }

    public IRfNamedElement getBinding(boolean stripToEntity) {
        return this.spec.getBinding(stripToEntity);
    }

    public void setBinding(IELDesign associatedType) {
        this.spec = ELSpecialization.of(associatedType);
        this.cachedDescription.setParentScope(associatedType);
    }

    void setSpecialization(ELSpecialization spec) {
        this.spec = spec;
    }

    public ELSpecialization getSpecialization() {
        return this.spec;
    }

    IRfDesignElement getVHDLPreElaborationDesign() {
        return this.cachedDescription.getVHDLPreElaborationDesign();
    }

    public IRfConfigurationRule getElaborationRule() {
        return this.elabRule;
    }

    void setElaborationRule(IRfConfigurationRule elabRule) {
        this.elabRule = elabRule;
    }

    public ELLiblist getElaborationLiblist() {
        return this.elabLiblist;
    }

    void setElaborationLiblist(ELLiblist bindingLiblist) {
        this.elabLiblist = bindingLiblist;
    }

    public IRfConfiguration getElaborationConfig() {
        return this.elabConfig;
    }

    void setElaborationConfig(IRfConfiguration bindingConfig) {
        this.elabConfig = bindingConfig;
    }

    public Collection<? extends IRfConfigurationRule> getElaborationChildrenRules() {
        return this.elabChildrenRules;
    }

    void setElaborationChildrenRules(Collection<? extends IRfConfigurationRule> childrenRules) {
        this.elabChildrenRules = childrenRules;
    }

    void setSemanticEnable(byte semanticEnable) {
        this.spec.setSemanticEnable(semanticEnable);
    }

    String getDefaultNettype() {
        return this.spec.getDefaultNettype();
    }

    public ELParamValues getParamValues() {
        return this.spec.getParamValues(ELUtils.isVHDL(this.cachedDescription));
    }

    public ELParamValues getParamValuesWithKeyFilter(Predicate<String> keyFilter) {
        return this.spec.getParamValuesWithKeyFilter(keyFilter, ELUtils.isVHDL(this.cachedDescription));
    }

    public ELSpecialization.InterfacePortInstance getInterfacePortInstance(String port) {
        return this.spec.getInterfacePortInstance(port);
    }

    public void addInterfacePortInstance(String port, Supplier<ELSpecialization.InterfacePortInstance> portInstance) {
        this.spec.addInterfacePortInstance(port, portInstance);
    }

    void deepClean() {
        this.spec.deepClean();
        this.spec = null;
        this.elabConfig = null;
        this.elabLiblist = null;
        this.elabRule = null;
        this.elabChildrenRules = null;
    }

    boolean isArrayOfInstancesBlock() {
        return this.spec.isArrayOfInstancesBlock();
    }

    boolean isSkipped() {
        return this.spec.isSkipped();
    }

    public boolean isTop() {
        return this.hierarchyPath.length() == 1;
    }

    public boolean isBlock() {
        return this.spec != null && DesignUtils.isBlock(this.spec.getBinding(false));
    }

    void storeDependencies() {
        this.cachedDescription.setDependencies(this.spec.getBinding(false), this.elabRule);
    }

    public String print() {
        IRfInstanceElement descr = this.getDescription();
        StringBuilder result = new StringBuilder();
        result.append(descr);
        IRfNamedElement bin = this.getBinding(false);
        result.append(" : ").append(bin.getNameAndEnclosing());
        return result.toString();
    }

    public String toString() {
        return "" + this.getDescription();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.hierarchyPath == null ? 0 : this.hierarchyPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ELInstance other = (ELInstance)obj;
        return !(this.hierarchyPath == null ? other.hierarchyPath != null : !this.hierarchyPath.equals(other.hierarchyPath));
    }

    boolean deepEquals(Object obj, boolean checkOnlyParamValues) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ELInstance other = (ELInstance)obj;
        if (this.hierarchyPath == null ? other.hierarchyPath != null : !this.hierarchyPath.equals(other.hierarchyPath)) {
            return false;
        }
        if (this.cachedDescription == null ? other.cachedDescription != null : !this.cachedDescription.equals(other.cachedDescription)) {
            return false;
        }
        if (this.elabConfig != other.elabConfig) {
            return false;
        }
        if (this.elabRule == null ? other.elabRule != null : !this.elabRule.equals(other.elabRule)) {
            return false;
        }
        if (this.elabChildrenRules == null ? other.elabChildrenRules != null : !this.elabChildrenRules.equals(other.elabChildrenRules)) {
            return false;
        }
        return !(this.spec == null ? other.spec != null : !this.spec.equals(other.spec, true, checkOnlyParamValues));
    }
}

