/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import java.text.MessageFormat;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.elaboration.core.ELManagerState;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.benchmark.StopWatch;

public class ELLogger {
    public static final String ELABORATION_ERROR_MESSAGE_FORMAT = "*** Error: {0}\n    at line {1} in {2}";
    public static final String ELABORATION_ERROR_MESSAGE_FORMAT_NO_LINE = "*** Error: {0}";
    public static final String ELABORATION_WARNING_MESSAGE_FORMAT = "*** Warning: {0}\n    at line {1} in {2}";
    public static final String ELABORATION_WARNING_MESSAGE_FORMAT_NO_LINE = "*** Warning: {0}";
    private DVTBuildConsole console;
    private ELManagerState state;

    public ELLogger(DVTBuildConsole console, ELManagerState state) {
        this.console = console;
        this.state = state;
    }

    private void printToConsole(String message, DVTBuildConsoleCommon.MessageSink ms) {
        if (message.length() > 1200) {
            message = String.valueOf(message.substring(0, 1200)) + "...";
        }
        this.console.print(message, ms);
    }

    void printToConsole(String message) {
        this.printToConsole(message, DVTBuildConsoleCommon.MessageSink.REPORT);
    }

    private void forceDebug(String message, DVTBuildConsoleCommon.MessageSink ms, Object ... args) {
        this.printToConsole(String.valueOf(message) + (args != null ? " " + DVTStringUtil.join(args, " ") : ""), ms);
    }

    void debug(ElaborationDebugZone zone, String message, DVTBuildConsoleCommon.MessageSink ms, Object ... args) {
        if (!this.state.allowAny || !this.state.debugZones.contains(zone)) {
            return;
        }
        this.forceDebug(message, ms, args);
    }

    public void debug(ElaborationDebugZone zone, String message, Object ... args) {
        if (!this.state.allowAny || !this.state.debugZones.contains(zone)) {
            return;
        }
        this.forceDebug(message, DVTBuildConsoleCommon.MessageSink.CONSOLE, args);
    }

    public void debugToLog(ElaborationDebugZone zone, String message, Object ... args) {
        if (!this.state.allowAny || !this.state.debugZones.contains(zone)) {
            return;
        }
        DVTLogger.INSTANCE.logError(String.valueOf(message) + (args != null ? " " + DVTStringUtil.join(args, " ") : ""));
    }

    public void stopWatchResetAll() {
        STOP_WATCH[] sTOP_WATCHArray = STOP_WATCH.values();
        int n = sTOP_WATCHArray.length;
        int n2 = 0;
        while (n2 < n) {
            STOP_WATCH val = sTOP_WATCHArray[n2];
            StopWatch.get(val.name()).reset();
            ++n2;
        }
    }

    public void stopWatchPrintAll() {
        STOP_WATCH[] sTOP_WATCHArray = STOP_WATCH.values();
        int n = sTOP_WATCHArray.length;
        int n2 = 0;
        while (n2 < n) {
            STOP_WATCH val = sTOP_WATCHArray[n2];
            StopWatch.get(val.name()).print(val.name());
            ++n2;
        }
    }

    public void stopWatchStart(STOP_WATCH stopWatch) {
        StopWatch.get(stopWatch.name()).start();
    }

    public void stopWatchStop(STOP_WATCH stopWatch) {
        StopWatch.get(stopWatch.name()).stop();
    }

    private void printErrorToConsole(String message, int line, String filePath) {
        String messageAtLine = MessageFormat.format(line == -1 ? ELABORATION_ERROR_MESSAGE_FORMAT_NO_LINE : ELABORATION_ERROR_MESSAGE_FORMAT, message, line == -1 ? "" : Integer.toString(line), filePath, "", "");
        this.printToConsole(messageAtLine, DVTBuildConsoleCommon.MessageSink.REPORT);
    }

    private void printWarningToConsole(String message, int line, String filePath) {
        String messageAtLine = MessageFormat.format(line == -1 ? ELABORATION_WARNING_MESSAGE_FORMAT_NO_LINE : ELABORATION_WARNING_MESSAGE_FORMAT, message, line == -1 ? "" : Integer.toString(line), filePath, "", "");
        this.printToConsole(messageAtLine, DVTBuildConsoleCommon.MessageSink.REPORT);
    }

    void forceWarning(String pattern, int line, String filePath, ElementPath hierarchyPath, Object ... arguments) {
        try {
            String message = MessageFormat.format(pattern, arguments);
            message = message + (hierarchyPath != null ? " [" + hierarchyPath.toString() + "]" : "");
            this.printWarningToConsole(message, line, filePath);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    void forceError(String pattern, int line, String filePath, ElementPath hierarchyPath, Object ... arguments) {
        try {
            String message = MessageFormat.format(pattern, arguments);
            message = message + (hierarchyPath != null ? " [" + hierarchyPath.toString() + "]" : "");
            this.printErrorToConsole(message, line, filePath);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    public static enum STOP_WATCH {
        FP_TOTAL,
        FP_COMPUTE_BINDING,
        FP_RESOLVE_LOCAL_HIDS,
        FP_ASSIGNS_IMPLICITS,
        FP_ASSIGNS_IMPLICITS_2,
        FP_INSTANCE_IMPLICITS,
        FP_INSTANCE_IMPLICITS_2,
        FP_DEFPARAMS,
        FP_SUBINSTANCES;

    }
}

