/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.ElaborationControl;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.buildconfig.ElaborationKind;
import ro.amiq.dvt.buildconfig.FullChecksAndLibs;
import ro.amiq.dvt.buildconfig.FullChecksKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.MinTypMax;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELBuildConfigOverriddenParameter;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELContext;
import ro.amiq.dvt.elaboration.core.ELCore;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELLogger;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.core.ELManagerState;
import ro.amiq.dvt.elaboration.core.ELResolver;
import ro.amiq.dvt.elaboration.core.ELSpecialization;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.core.ElaborationCancelException;
import ro.amiq.dvt.elaboration.model.ELBindElementPath;
import ro.amiq.dvt.elaboration.model.ELEnumTypeWrapper;
import ro.amiq.dvt.elaboration.model.ELInstanceInContext;
import ro.amiq.dvt.elaboration.model.ELLiblist;
import ro.amiq.dvt.elaboration.model.ELMemoryStandard;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELDescription;
import ro.amiq.dvt.elaboration.model.IELDesign;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationFixer;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.reflection.DVTImplicitConfiguration;
import ro.amiq.dvt.model.reflection.DVTPackageConfiguration;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RootDesignElement;
import ro.amiq.dvt.model.reflection.semantic.extension.DisabledMethodEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalConverter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.MaxLoopCountEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.OverflowDimensionEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownScopeEvaluationException;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedIdentityHashSet;
import ro.amiq.dvt.utils.OptimizedLinkedHashMap;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.XGlobalCache;

public class ELManager {
    private IELMemory mem;
    private final RootDesignElement $root;
    private final RfMixedLangProject mixedLangProject;
    private IRfSingleLangProject vlogRfProjectCache;
    private IRfSingleLangProject vhdlRfProjectCache;
    private ELParamValues.BuildConfigDefparams buildConfigDefparamValues;
    private Map<ElementPath, Map<String, List<ELParamValues.ParamKeyValueLocationTuple>>> potentialDefparamValues;
    private Map<ElementPath, Map<String, List<ELParamValues.ParamKeyValueLocationTuple>>> defparamValues;
    private Map<IRfInstanceElement, List<ElaboratedTargetPathWithOrigin>> elaboratedBinds;
    private Map<IRfNamedElement, List<PreElaboratedBindInstance>> potentialBindsByElement;
    private Map<String, List<PreElaboratedBindInstance>> potentialBindsByName;
    private Map<IRfScopeElement, BindWithElaboratedPaths> elaboratedBindScopePaths;
    private ConcurrentHashMap<IRfNamedElement, ConcurrentHashMap<IRfInstanceElement, List<HidOperatorWrapper>>> portConnectionsCache;
    private ConcurrentHashMap<IRfNamedElement, ConcurrentHashMap<IRfInstanceElement, List<HidOperatorWrapper>>> parameterOverridesCache;
    private ConcurrentHashMap<IRfNamedElement, Map<String, HidOperatorWrapper>> caseSensitiveParameterDefaultValuesCache;
    private ConcurrentHashMap<IRfNamedElement, Map<String, HidOperatorWrapper>> caseInsensitiveParameterDefaultValuesCache;
    private ConcurrentHashMap<IRfNamedElement, List<HidOperatorWrapper>> defparamsCache;
    private List<ElementPath> subInstanceCopiesCache;
    private ConcurrentHashMap<IRfNamedElement, ConcurrentHashMap<ELSpecializationWrapper, ELSpecializationWrapper>> specsPerElement;
    private ConcurrentHashMap<IELDescription, Set<ELSpecializationWrapper>> specsPerInstance;
    private Map<Thread, Map<IDataType, BitVectorContext>> dataTypeContexts;
    private ConcurrentHashMap<IRfMethodElement, IHidOperator> methodBodiesCache;
    private ConcurrentHashMap<MethodWithArguments, IELParamValue> methodCallResultCache;
    private ConcurrentHashMap<IRfNamedElement, ELEnumTypeWrapper> enumTypeWrapperCache;
    private ConcurrentHashMap<ElementPath, ElementPath> deferredParamValues;
    private Set<IRfNamedElement> defferedResolutionScopes;
    private Function<ElementPath, ELInstance> instanceSupplierIncremental;
    public final ELLogger logger;
    public final ELManagerState state;
    private final ELManagerConfiguration config;
    private long timestamp;
    private IProgressMonitor progressMonitor;
    private int nofBuildCanceledQueries;
    private boolean cachedBuildCanceled;
    private AbstractExecutorService executor;
    private final Object SYNC_MONITOR_INSTANCE = new Object();
    private final Object SYNC_MONITOR_DEFPARAMS = new Object();
    private final Object SYNC_MONITOR_PT_DEFPARAMS = new Object();
    private final Object SYNC_MONITOR_BINDS = new Object();
    private final Object SYNC_MONITOR_BIND_SCOPES = new Object();
    private boolean hasDirtyMemory;
    private ELConstantsManager constantsManager;
    private boolean isSinglePass;
    private boolean allowSubInstanceCopies;
    private ELBuildPhase buildPhase;

    public static ELManager createNonElabManager(RfMixedLangProject project) {
        ELManager manager = new ELManager(project, IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newXVlogConfig(project.getProject()), new ELConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class)){

            @Override
            public void checkBuildCanceled() throws BuildCancelException {
            }
        };
        XGlobalCache.INSTANCE.clearCache();
        manager.cleanWorking();
        return manager;
    }

    public ELManager(RfMixedLangProject mixedLangProject, IELMemory.ELMemoryType memType, ELBuildPhase buildPhase, ELManagerConfiguration config, ELConstantsManager constantsManager, Set<ElaborationDebugZone> zones) {
        this.mixedLangProject = mixedLangProject;
        this.mem = this.newMemory(memType);
        this.$root = new RootDesignElement();
        this.buildPhase = buildPhase;
        this.state = new ELManagerState(zones);
        this.logger = new ELLogger(DVTBuildConsoleRegistry.getConsole(mixedLangProject.getProject()), this.state);
        this.config = config;
        this.state.setLoopCutoffs(this.getLoopBlockCutoff(), this.getLoopStatementCutoff());
        this.constantsManager = constantsManager != null ? constantsManager : new ELConstantsManager();
        this.defferedResolutionScopes = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public void setMemory(IELMemory mem) {
        this.mem = mem;
    }

    public void resetMemory(IELMemory.ELMemoryType memType) {
        this.mem = this.newMemory(memType);
    }

    private void initExecutor() {
        this.executor = this.config.maxNofRecursionThreads < 2 ? null : (AbstractExecutorService)Executors.newFixedThreadPool(this.config.maxNofRecursionThreads);
    }

    private IELMemory newMemory(IELMemory.ELMemoryType memType) {
        switch (memType) {
            case STANDARD: 
            case FAST_UTILS: 
            case FST: 
            case MAPDB: {
                return new ELMemoryStandard();
            }
        }
        throw new IllegalArgumentException();
    }

    public void addToMemory(IELMemory memory) {
        if (memory == null || memory.isEmpty()) {
            return;
        }
        this.mem.putAll(memory);
    }

    private void initMonitor(IProgressMonitor buildProgressMonitor) {
        this.progressMonitor = buildProgressMonitor;
        this.nofBuildCanceledQueries = 0;
        this.cachedBuildCanceled = false;
    }

    private void cleanElabWorking() {
        if (this.buildConfigDefparamValues != null) {
            this.buildConfigDefparamValues.clear();
        }
        this.buildConfigDefparamValues = null;
        if (this.potentialDefparamValues != null) {
            this.potentialDefparamValues.clear();
        }
        this.potentialDefparamValues = null;
        if (this.defparamValues != null) {
            this.defparamValues.clear();
        }
        this.defparamValues = null;
        if (this.caseSensitiveParameterDefaultValuesCache != null) {
            this.caseSensitiveParameterDefaultValuesCache.clear();
        }
        this.caseSensitiveParameterDefaultValuesCache = new ConcurrentHashMap();
        if (this.caseInsensitiveParameterDefaultValuesCache != null) {
            this.caseInsensitiveParameterDefaultValuesCache.clear();
        }
        this.caseInsensitiveParameterDefaultValuesCache = new ConcurrentHashMap();
        if (this.elaboratedBinds != null) {
            this.elaboratedBinds.clear();
        }
        this.elaboratedBinds = null;
        if (this.potentialBindsByElement != null) {
            this.potentialBindsByElement.clear();
        }
        this.potentialBindsByElement = null;
        if (this.potentialBindsByName != null) {
            this.potentialBindsByName.clear();
        }
        this.potentialBindsByName = null;
        if (this.elaboratedBindScopePaths != null) {
            this.elaboratedBindScopePaths.clear();
        }
        this.elaboratedBindScopePaths = null;
        if (this.methodBodiesCache != null) {
            this.methodBodiesCache.clear();
        }
        this.methodBodiesCache = new ConcurrentHashMap();
        if (this.methodCallResultCache != null) {
            this.methodCallResultCache.clear();
        }
        this.methodCallResultCache = new ConcurrentHashMap();
        if (this.portConnectionsCache != null) {
            this.portConnectionsCache.clear();
        }
        this.portConnectionsCache = new ConcurrentHashMap();
        if (this.parameterOverridesCache != null) {
            this.parameterOverridesCache.clear();
        }
        this.parameterOverridesCache = new ConcurrentHashMap();
        if (this.defparamsCache != null) {
            this.defparamsCache.clear();
        }
        this.defparamsCache = new ConcurrentHashMap();
        if (this.enumTypeWrapperCache != null) {
            this.enumTypeWrapperCache.clear();
        }
        this.enumTypeWrapperCache = new ConcurrentHashMap();
        this.subInstanceCopiesCache = Collections.synchronizedList(new ArrayList());
        this.isSinglePass = false;
        this.allowSubInstanceCopies = false;
        this.timestamp = System.currentTimeMillis();
    }

    private void cleanHidsAndOperatorsWorking() {
        if (this.specsPerElement != null) {
            this.specsPerElement.clear();
        }
        this.specsPerElement = new ConcurrentHashMap();
        if (this.specsPerInstance != null) {
            this.specsPerInstance.clear();
        }
        this.specsPerInstance = new ConcurrentHashMap();
        if (this.dataTypeContexts != null) {
            this.dataTypeContexts.clear();
        }
        this.dataTypeContexts = null;
        if (this.deferredParamValues != null) {
            this.deferredParamValues.clear();
        }
        this.deferredParamValues = new ConcurrentHashMap();
        if (this.defferedResolutionScopes != null) {
            this.defferedResolutionScopes.clear();
        }
        this.defferedResolutionScopes = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    private void cleanWorking() {
        this.cleanElabWorking();
        this.cleanHidsAndOperatorsWorking();
    }

    public void deepCleanMemory() {
        if (this.mem == null) {
            return;
        }
        if (!this.mem.hasBindings()) {
            return;
        }
        this.mem.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                instance.deepClean();
                return true;
            }
        });
    }

    private void sanitizePhase() {
        this.setBuildPhase(ELBuildPhase.ELABORATION_SANITIZE);
        this.sanitizeInstances();
        if (!this.mem.hasBindings()) {
            return;
        }
        this.sanitizeDeferredParamValues();
        this.sanitizeDefferedResolutionScopes();
    }

    private void sanitizeInstances() {
        final LinkedHashMap blockSpecs = new LinkedHashMap();
        this.mem.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                instance.storeDependencies();
                if (DesignUtils.isBlock(instance.getBinding(false))) {
                    ELManager.this.sanitizeBlockParamValues(instance, blockSpecs);
                }
                instance.setElaborationLiblist(null);
                return true;
            }
        });
        this.logger.debug(ElaborationDebugZone.MEMORY, "Cleaned " + this.state.getNofBlocks() + " blocks of values.", new Object[0]);
    }

    private void sanitizeBlockParamValues(ELInstance blockInstance, Map<IRfNamedElement, Map<ELSpecialization, ELSpecialization>> existingBlockSpecs) {
        this.state.incrementNofBlocks();
        IRfDesignElement block = (IRfDesignElement)blockInstance.getBinding(false);
        ELSpecialization newSpec = null;
        Map<String, IRfNamedElement> workingParamMap = ELUtils.internalComputeConstantsMap(block, blockInstance.getDescription());
        newSpec = workingParamMap.isEmpty() ? ELSpecialization.packedOf((IELDesign)((Object)block), ELUtils.getValidParamValues(null)) : ELSpecialization.packedOf((IELDesign)((Object)block), blockInstance.getParamValuesWithKeyFilter(paramName -> workingParamMap.containsKey(paramName)));
        Map specs = existingBlockSpecs.computeIfAbsent(block, key -> new LinkedHashMap());
        ELSpecialization prevSpec = specs.putIfAbsent(newSpec, newSpec);
        if (prevSpec != null) {
            newSpec = prevSpec;
            this.state.increaseNofOptimizedBlocks();
        }
        blockInstance.setSpecialization(newSpec);
    }

    private void sanitizeDeferredParamValues() {
        if (this.deferredParamValues == null || this.deferredParamValues.isEmpty()) {
            return;
        }
        for (ElementPath hierarchyPath : new LinkedHashSet(this.deferredParamValues.keySet())) {
            ELInstance contextInstance;
            ELInstance instance = this.mem.instanceFor(hierarchyPath);
            if (instance == null) continue;
            ELInstance eLInstance = contextInstance = hierarchyPath.length() == 1 ? ELInstance.rootFor(this.getRoot(), instance.getElaborationLiblist(), instance.getElaborationConfig()) : this.mem.instanceFor(hierarchyPath.removeLastSegment());
            if (contextInstance == null) continue;
            ELInstanceInContext instanceInContext = ELInstanceInContext.ofTop(instance, ELContext.of(contextInstance));
            ELParamValues newValues = ELResolver.computeParamValuesAndInterfacePortConnectionsExtended(instanceInContext, false, this);
            ELParamValues existingValues = instance.getParamValues();
            if (newValues.size() <= existingValues.size()) continue;
            ELParamValues working = existingValues.copy();
            working.putAll(existingValues);
            working.putAllIfAbsent(newValues);
            ELSpecialization newSpec = ELSpecialization.packedOf((IELDesign)instance.getBinding(false), ELUtils.getValidParamValues(working));
            instance.setSpecialization(newSpec);
        }
    }

    private void sanitizeDefferedResolutionScopes() {
        if (this.defferedResolutionScopes == null || this.defferedResolutionScopes.isEmpty()) {
            return;
        }
        for (IRfNamedElement defferedResolutionScope : this.defferedResolutionScopes) {
            defferedResolutionScope.resolveHidsAndOperators(this);
        }
    }

    public void elaborateIncrementalStart(List<IRfDesignElement> changedDesigns, List<IRfInstanceElement> changedDescriptions, Set<IRfPackageElement> changedPackages, Set<IRfNamedElement> changedNonDesignElements, boolean hasRemovedDescriptions, Set<IRfNamedElement> unelaboratedCandidates, List<ELInstance> elaboratedCandidates, List<ElementPath> updatedElaboratedPaths, IProgressMonitor monitor) {
        if (changedDesigns == null || changedDescriptions == null || changedNonDesignElements == null) {
            return;
        }
        this.cleanWorking();
        this.initMonitor(monitor);
        this.setBuildPhase(ELBuildPhase.ELABORATION_MAIN);
        Set<IRfInstanceElement> remainingDescriptions = Collections.newSetFromMap(new IdentityHashMap());
        remainingDescriptions.addAll(changedDescriptions);
        Set<IRfDesignElement> remainingDesigns = Collections.newSetFromMap(new IdentityHashMap());
        remainingDesigns.addAll(changedDesigns);
        LinkedHashSet<String> changedDesignNames = new LinkedHashSet<String>();
        for (IRfDesignElement changedDesign : changedDesigns) {
            if (changedDesign instanceof IELDesign) {
                ((IELDesign)((Object)changedDesign)).cleanElaborationInfo();
            }
            String changedDesignName = DesignUtils.getDesignKind(changedDesign) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE ? ((IRfEntityComplement)((Object)changedDesign)).getEntityName() : changedDesign.getName();
            changedDesignNames.add(changedDesignName);
        }
        if (!this.mem.hasBindings()) {
            this.cleanIncrementalPackages(changedPackages);
            changedNonDesignElements.clear();
            this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Changed packages:", changedPackages.stream().map(IRfNamedElement::getNameAndEnclosing).collect(Collectors.toList()));
            this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Elaboration memory is empty", new Object[0]);
            return;
        }
        List<ELInstance> delta = this.computeIncrementalDelta(this.mem, changedDesigns, changedDescriptions, remainingDesigns, remainingDescriptions);
        this.logger.debug(ElaborationDebugZone.INCREMENTAL, "\nChanged designs:", changedDesigns.stream().map(IRfNamedElement::getNameAndEnclosing).collect(Collectors.toList()));
        this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Changed instances:", changedDescriptions.stream().map(IRfNamedElement::getNameAndEnclosing).collect(Collectors.toList()));
        this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Changed packages:", changedPackages.stream().map(IRfNamedElement::getNameAndEnclosing).collect(Collectors.toList()));
        this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Changed non-design elements:", changedNonDesignElements.stream().map(IRfNamedElement::getNameAndEnclosing).collect(Collectors.toList()), "\n");
        this.internalPrintConfigControl();
        this.cleanIncrementalPackages(changedPackages);
        List<IELMemory> updatedMemorySegments = this.updateIncrementalDelta(delta, changedDesigns, changedDescriptions, remainingDesigns, remainingDescriptions, updatedElaboratedPaths, unelaboratedCandidates, elaboratedCandidates, monitor);
        this.cleanIncrementalObsolete(changedDesignNames, remainingDesigns, remainingDescriptions, hasRemovedDescriptions, updatedMemorySegments, unelaboratedCandidates, elaboratedCandidates, monitor);
        this.resolveBoundInstancesIncremental(changedDescriptions, updatedElaboratedPaths, unelaboratedCandidates, elaboratedCandidates, monitor);
        this.validateCandidates(unelaboratedCandidates);
        this.logger.debug(ElaborationDebugZone.INCREMENTAL, "\nUnelaborated changed designs:", unelaboratedCandidates);
        if (hasRemovedDescriptions) {
            this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Removed descriptions", new Object[0]);
        }
        this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Remaining designs:", remainingDesigns);
        this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Remaining descriptions:", remainingDescriptions, "\n");
    }

    private void cleanIncrementalPackages(Set<IRfPackageElement> changedPackages) {
        if (changedPackages == null || changedPackages.isEmpty()) {
            return;
        }
        for (IRfPackageElement pkg : changedPackages) {
            if (pkg.getSemanticEnableRaw() == 3) {
                this.cleanPackageInfo(pkg);
                pkg.elaborateConstants(this);
                continue;
            }
            this.cleanPackageInfo(pkg);
        }
    }

    public void resolveChangedNonDesignsHidsAndOperators(Map<IRfNamedElement, IRfNamedElement> changedNonDesignElementScope, Map<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> specsGroupedByScope) {
        if (changedNonDesignElementScope == null || changedNonDesignElementScope.isEmpty() || specsGroupedByScope == null) {
            return;
        }
        for (Map.Entry<IRfNamedElement, IRfNamedElement> changedNonDesignEntry : changedNonDesignElementScope.entrySet()) {
            IRfNamedElement changedNondesignElement = changedNonDesignEntry.getKey();
            IRfNamedElement elaboratedScope = changedNonDesignEntry.getValue();
            changedNondesignElement.resolveHidsAndOperatorsAtIncremental(this, elaboratedScope, specsGroupedByScope.get(elaboratedScope));
        }
    }

    private void cleanPackageInfo(IRfPackageElement pkg) {
        this.removeExternalConstants(pkg);
        pkg.cleanElaborationInfo();
    }

    public void elaborateIncrementalEnd(List<IRfDesignElement> changedDesigns, Set<IRfNamedElement> unelaboratedCandidates, List<ELInstance> elaboratedCandidates, Set<IRfNamedElement> changedNonDesignElements, List<ElementPath> updatedElaboratedPaths, IProgressMonitor monitor) {
        if (changedDesigns == null) {
            return;
        }
        if (!this.mem.hasBindings()) {
            return;
        }
        try {
            Set<IRfDesignElement> changedElaborated = Collections.newSetFromMap(new IdentityHashMap());
            changedElaborated.addAll(changedDesigns);
            for (ELInstance candidate : elaboratedCandidates) {
                this.checkBuildCanceled();
                IRfDesignElement candidateDesign = (IRfDesignElement)candidate.getBinding(false);
                if (candidateDesign == null) continue;
                changedElaborated.add(candidateDesign);
                ElementPath candidateHierarchyPath = candidate.getHierarchyPath();
                if (unelaboratedCandidates.contains(candidateDesign) || updatedElaboratedPaths.contains(candidateHierarchyPath)) continue;
                ELContext context = this.internalComputeIncrementalContext(candidate);
                if (context == null) {
                    this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Could not determine context for:", candidateHierarchyPath);
                    continue;
                }
                IELMemory memorySegment = this.incrementalUpdateDesign(candidate, context, monitor);
                if (memorySegment == null) {
                    this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Could not update design for:", candidateHierarchyPath);
                    continue;
                }
                this.setDirtyMemory(true);
                this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Incremental design without update:", candidateDesign, "@", candidateHierarchyPath);
            }
            this.resolveChangedDesignsHidsAndOperators(changedElaborated);
            HashMap<IRfNamedElement, IRfNamedElement> changedNonDesignElementScope = new HashMap<IRfNamedElement, IRfNamedElement>();
            HashSet<IRfScopeElement> visitedFieldScopes = new HashSet<IRfScopeElement>();
            HashSet<IRfDesignElement> changedElaboratedForNonDesignElements = new HashSet<IRfDesignElement>();
            ArrayList<IRfNamedElement> ignoredNonDesignElements = new ArrayList<IRfNamedElement>();
            for (IRfNamedElement changedNonDesignElement : changedNonDesignElements) {
                IRfScopeElement enclosingScope = changedNonDesignElement.getEnclosingScope();
                if (changedNonDesignElement instanceof IRfFieldElement && visitedFieldScopes.contains(enclosingScope)) continue;
                IRfScopeElement elaboratedScope = ELUtils.computeElaboratedScope(changedNonDesignElement);
                if (!(elaboratedScope instanceof IRfNamedElement)) {
                    ignoredNonDesignElements.add(changedNonDesignElement);
                    continue;
                }
                changedNonDesignElementScope.put(changedNonDesignElement, (IRfNamedElement)elaboratedScope);
                if (elaboratedScope instanceof IRfDesignElement && !(elaboratedScope instanceof IRfLibraryElement)) {
                    changedElaboratedForNonDesignElements.add((IRfDesignElement)elaboratedScope);
                    continue;
                }
                if (!(changedNonDesignElement instanceof IRfFieldElement)) continue;
                visitedFieldScopes.add(enclosingScope);
            }
            changedNonDesignElements.removeAll(ignoredNonDesignElements);
            Map<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> changedInstances = this.computeUniqueSpecs(changedElaboratedForNonDesignElements);
            this.resolveChangedNonDesignsHidsAndOperators(changedNonDesignElementScope, changedInstances);
        }
        finally {
            XGlobalCache.INSTANCE.clearCache();
            this.cleanWorking();
            this.cleanInstanceSupplierIncremental();
            this.setBuildPhase(ELBuildPhase.POST_ELABORATION);
        }
    }

    private void validateCandidates(final Set<IRfNamedElement> unelaboratedCandidates) {
        if (unelaboratedCandidates.isEmpty()) {
            return;
        }
        this.mem.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                IRfNamedElement binding = instance.getBinding(false);
                unelaboratedCandidates.remove(binding);
                return !unelaboratedCandidates.isEmpty();
            }
        });
        for (IRfNamedElement unelaboratedDesign : unelaboratedCandidates) {
            if (!(unelaboratedDesign instanceof IELDesign)) continue;
            ((IELDesign)unelaboratedDesign).cleanElaborationInfo();
        }
    }

    private void resolveChangedDesignsHidsAndOperators(Collection<IRfDesignElement> changedDesigns) {
        if (changedDesigns == null || changedDesigns.isEmpty()) {
            return;
        }
        for (IRfDesignElement changedDesign : changedDesigns) {
            this.resolveHidsAndOperatorsStep(changedDesign, this.mixedLangProject.isLinting());
        }
    }

    private void resolveBoundInstancesIncremental(List<IRfInstanceElement> changedDescriptions, List<ElementPath> updatedElaboratedPaths, Set<IRfNamedElement> unelaboratedCandidates, List<ELInstance> elaboratedCandidates, IProgressMonitor monitor) {
        int limit = 1;
        for (IRfInstanceElement changedDescription : changedDescriptions) {
            if (!changedDescription.isInstanceToBind()) continue;
            if (limit++ > 200) {
                this.setDirtyMemory(true);
                break;
            }
            IRfNamedElement enclosingScope = (IRfNamedElement)changedDescription.getEnclosingScope();
            this.preElaborateBind(changedDescription, enclosingScope);
        }
        if (!this.hasPotentialBinds() && !this.hasElaboratedBinds()) {
            return;
        }
        this.mem.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                ELResolver.computeElaboratedBinds(instance, null, ELManager.this);
                return true;
            }
        });
        ArrayList<ELInstanceInContext> newTops = new ArrayList<ELInstanceInContext>(4);
        ELResolver.findBoundInstancesNew(newTops, true, this);
        for (ELInstanceInContext newTop : newTops) {
            this.internalResolveBoundInstancesIncremental(newTop, updatedElaboratedPaths, unelaboratedCandidates, elaboratedCandidates, monitor);
        }
    }

    private void internalResolveBoundInstancesIncremental(ELInstanceInContext instanceInContext, List<ElementPath> updatedElaboratedPaths, Set<IRfNamedElement> unelaboratedCandidates, final List<ELInstance> elaboratedCandidates, IProgressMonitor monitor) {
        ELInstance boundInstance = instanceInContext.instance;
        ElementPath boundPath = boundInstance.getHierarchyPath();
        IELMemory memorySegment = this.incrementalUpdateDesign(boundInstance, instanceInContext.context, monitor);
        if (memorySegment == null) {
            this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Could not update design for bound instance:", boundPath);
            return;
        }
        updatedElaboratedPaths.add(boundPath);
        if (this.mem.instanceFor(boundPath) == null) {
            this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Added bound instance:", boundPath);
            memorySegment.visitBindings(new IELMemory.IELMemoryVisitor(){

                @Override
                public boolean visitBindings(ElementPath path, ELInstance instance) {
                    ELManager.this.internalCollectCandidateInstance(elaboratedCandidates, instance);
                    ELManager.this.mem.put(path, instance);
                    return true;
                }
            });
        } else {
            this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Overridden bound instance:", boundPath);
            boolean overridden = this.overrideMemory(this.mem, memorySegment, unelaboratedCandidates, elaboratedCandidates);
            this.setDirtyMemory(overridden);
            this.pruneObsoleteGenerates(this.mem, memorySegment, unelaboratedCandidates);
        }
    }

    private List<IELMemory> updateIncrementalDelta(List<ELInstance> delta, List<IRfDesignElement> changedDesigns, List<IRfInstanceElement> changedDescriptions, Set<IRfDesignElement> remainingDesigns, Set<IRfInstanceElement> remainingDescriptions, List<ElementPath> updateElaboratedPaths, Set<IRfNamedElement> unelaboratedCandidates, List<ELInstance> elaboratedCandidates, IProgressMonitor monitor) {
        if (delta.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IELMemory> updatedMemorySegments = new ArrayList<IELMemory>(delta.size());
        HashSet<ElementPath> visitedPaths = new HashSet<ElementPath>();
        ArrayDeque<ELInstance> work = new ArrayDeque<ELInstance>(delta);
        int limit = 1;
        while (!work.isEmpty()) {
            this.checkBuildCanceled();
            ELInstance original = (ELInstance)work.poll();
            ElementPath originalPath = original.getHierarchyPath();
            if (visitedPaths.contains(originalPath)) continue;
            visitedPaths.add(originalPath);
            if (limit++ > 200) {
                this.setDirtyMemory(true);
                break;
            }
            ELInstance existing = this.mem.instanceFor(originalPath);
            if (existing != original) {
                if (existing != null) {
                    IRfNamedElement existingBinding = existing.getBinding(false);
                    for (IRfDesignElement changedDesign : changedDesigns) {
                        if (changedDesign != existingBinding) continue;
                        original = existing;
                        remainingDesigns.remove(existingBinding);
                        remainingDescriptions.remove(existingBinding);
                        break;
                    }
                }
                if (existing != original) {
                    this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Could not find design:", originalPath);
                    continue;
                }
            }
            this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Incremental design:", original.getBinding(false), "@", originalPath);
            ELContext context = this.internalComputeIncrementalContext(original);
            if (context == null) {
                this.setDirtyMemory(true);
                this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Could not determine context for:", originalPath);
                continue;
            }
            IELMemory memorySegment = this.incrementalUpdateDesign(original, context, monitor);
            if (memorySegment == null) {
                this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Could not update design for:", originalPath);
                continue;
            }
            updateElaboratedPaths.add(originalPath);
            updatedMemorySegments.add(memorySegment);
            boolean overridden = this.overrideMemory(this.mem, memorySegment, unelaboratedCandidates, elaboratedCandidates);
            this.setDirtyMemory(overridden);
            this.pruneObsoleteGenerates(this.mem, memorySegment, unelaboratedCandidates);
            List<ELInstance> newDelta = this.computeIncrementalDelta(memorySegment, changedDesigns, changedDescriptions, remainingDesigns, remainingDescriptions);
            work.addAll(newDelta);
        }
        return updatedMemorySegments;
    }

    private void cleanIncrementalObsolete(final Set<String> changedDesignNames, Set<IRfDesignElement> remainingDesigns, Set<IRfInstanceElement> remainingDescriptions, final boolean hasRemovedDescriptions, List<IELMemory> updatedMemorySegments, Set<IRfNamedElement> unelaboratedCandidates, List<ELInstance> elaboratedCandidates, IProgressMonitor monitor) {
        ElementPath obsoletePath;
        if (this.$root != null && this.$root.getLocalInstances() != null) {
            for (IRfInstanceElement iRfInstanceElement : this.$root.getLocalInstances()) {
                if (!(iRfInstanceElement instanceof DummyInstance) || !ELManager.isObsoleteDescription(iRfInstanceElement)) continue;
                ElementPath obsoletePath2 = ELUtils.appendToPath(null, iRfInstanceElement.getName());
                this.internalRemoveSubTreeInclusive(this.mem, this.mem.instanceFor(obsoletePath2), obsoletePath2, unelaboratedCandidates);
                this.setDirtyMemory(true);
                this.$root.removeTopInstance((DummyInstance)iRfInstanceElement);
            }
        }
        if (remainingDesigns.isEmpty() && remainingDescriptions.isEmpty() && !hasRemovedDescriptions) {
            return;
        }
        final LinkedHashSet linkedHashSet = new LinkedHashSet();
        final LinkedHashSet obsoleteBindings = new LinkedHashSet();
        final LinkedHashSet unresolvedBindings = new LinkedHashSet();
        final boolean hasRemainingDesigns = !remainingDesigns.isEmpty();
        final boolean hasRemainingDescriptions = !remainingDescriptions.isEmpty();
        this.mem.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance original) {
                ELManager.this.checkBuildCanceled();
                IRfInstanceElement originalDescription = original.getDescription();
                IRfNamedElement originalBinding = original.getBinding(false);
                if (hasRemovedDescriptions && !(originalDescription instanceof DummyInstance) && ELManager.isObsoleteDescription(originalDescription)) {
                    linkedHashSet.add(original);
                    ELManager.this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Found obsolete description:", original.getHierarchyPath());
                    return true;
                }
                if (hasRemainingDescriptions && !(originalDescription instanceof DummyInstance) && !(originalBinding instanceof ErrorDesignElement) && ELManager.isObsoleteBinding(originalBinding)) {
                    obsoleteBindings.add(original);
                    ELManager.this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Found obsolete binding:", original.getHierarchyPath());
                    return true;
                }
                if (hasRemainingDesigns && originalBinding == ELConstants.UNRESOLVED_INSTANCE_TYPE && changedDesignNames.contains(originalDescription.getAssociatedTypeName())) {
                    obsoleteBindings.add(original);
                    unresolvedBindings.add(original);
                    ELManager.this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Found unresolved binding:", original.getHierarchyPath());
                    return true;
                }
                return true;
            }
        });
        for (ELInstance obsolete : linkedHashSet) {
            this.checkBuildCanceled();
            obsoletePath = obsolete.getHierarchyPath();
            this.setDirtyMemory(true);
            this.internalRemoveSubTreeInclusive(this.mem, obsolete, obsoletePath, unelaboratedCandidates);
        }
        block2: for (ELInstance existing : obsoleteBindings) {
            this.checkBuildCanceled();
            obsoletePath = existing.getHierarchyPath();
            for (IELMemory updatedMemory : updatedMemorySegments) {
                if (updatedMemory.instanceFor(obsoletePath) != null) continue block2;
            }
            ELContext context = this.internalComputeIncrementalContext(existing);
            if (context == null) {
                this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Could not determine context for:", obsoletePath);
                continue;
            }
            IELMemory memorySegment = this.incrementalUpdateDescription(existing, context, monitor);
            if (memorySegment != null) {
                boolean overridden = this.overrideMemory(this.mem, memorySegment, unelaboratedCandidates, elaboratedCandidates);
                this.setDirtyMemory(overridden);
            }
            this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Updated binding:", obsoletePath);
        }
    }

    private static boolean isObsoleteDescription(IRfInstanceElement description) {
        return description.hasNoDefs(true);
    }

    private static boolean isObsoleteBinding(IRfNamedElement binding) {
        return binding.hasNoDefs(true) && !binding.isPredefined();
    }

    private Map<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> computeUniqueSpecs(final Set<IRfDesignElement> changedDesigns) {
        if (changedDesigns.isEmpty()) {
            return Collections.emptyMap();
        }
        final LinkedHashMap<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> uniqueSpecsPerDesign = new LinkedHashMap<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>>();
        this.mem.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance original) {
                ELManager.this.checkBuildCanceled();
                IRfNamedElement originalBinding = original.getBinding(false);
                if (changedDesigns.contains(originalBinding)) {
                    ELSpecializationWrapper spec = ELSpecializationWrapper.of(original.getSpecialization(), ELUtils.isVHDL(original.getDescription()), original.getHierarchyPath());
                    Map specs = uniqueSpecsPerDesign.computeIfAbsent(originalBinding, key -> new LinkedHashMap());
                    ELSpecializationWrapper existingOrNull = specs.putIfAbsent(spec, spec);
                    if (existingOrNull != null) {
                        existingOrNull.addPaths(spec.paths);
                    }
                }
                return true;
            }
        });
        return uniqueSpecsPerDesign;
    }

    private List<ELInstance> computeIncrementalDelta(IELMemory source, List<IRfDesignElement> changedDesigns, final List<IRfInstanceElement> changedDescriptions, Set<IRfDesignElement> remainingDesigns, Set<IRfInstanceElement> remainingDescriptions) {
        if (changedDesigns.isEmpty()) {
            return Collections.emptyList();
        }
        if (changedDesigns.size() == 1) {
            return this.computeIncrementalDeltaForDesign(source, changedDesigns.get(0), changedDescriptions, remainingDesigns, remainingDescriptions);
        }
        ArrayList<ELInstance> result = new ArrayList<ELInstance>(changedDesigns.size());
        final IdentityHashMap originalBindingMap = new IdentityHashMap();
        source.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance original) {
                ELManager.this.checkBuildCanceled();
                IRfInstanceElement originalDescription = original.getDescription();
                if (originalDescription.isInstanceToBind() && changedDescriptions.contains(originalDescription)) {
                    return true;
                }
                IRfNamedElement originalBinding = original.getBinding(false);
                List instances = originalBindingMap.computeIfAbsent(originalBinding, key -> new ArrayList(4));
                instances.add(original);
                return true;
            }
        });
        if (originalBindingMap.isEmpty()) {
            return result;
        }
        for (IRfDesignElement changedDesign : changedDesigns) {
            List instances = (List)originalBindingMap.get(changedDesign);
            if (instances == null) continue;
            for (ELInstance instance : instances) {
                remainingDesigns.remove(changedDesign);
                remainingDescriptions.remove(instance.getDescription());
                result.add(instance);
            }
        }
        if (result.size() > 1) {
            Collections.sort(result, (me, other) -> me.getHierarchyPath().compareTo(other.getHierarchyPath()));
        }
        return result;
    }

    private List<ELInstance> computeIncrementalDeltaForDesign(IELMemory source, final IRfDesignElement changedDesign, final List<IRfInstanceElement> changedDescriptions, final Set<IRfDesignElement> remainingDesigns, final Set<IRfInstanceElement> remainingDescriptions) {
        final ArrayList<ELInstance> result = new ArrayList<ELInstance>(4);
        source.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance original) {
                ELManager.this.checkBuildCanceled();
                IRfInstanceElement originalDescription = original.getDescription();
                if (originalDescription.isInstanceToBind() && changedDescriptions.contains(originalDescription)) {
                    return true;
                }
                IRfNamedElement originalBinding = original.getBinding(false);
                if (changedDesign == originalBinding) {
                    remainingDesigns.remove(originalBinding);
                    remainingDescriptions.remove(originalDescription);
                    result.add(original);
                    return true;
                }
                return true;
            }
        });
        return result;
    }

    private IELMemory incrementalUpdateDescription(ELInstance original, ELContext context, IProgressMonitor monitor) {
        ElementPath originalHierarchyPath = original.getHierarchyPath();
        ELInstance copy = ELInstance.copyOf(original, originalHierarchyPath, false);
        copy.setBinding(null);
        copy.setElaborationRule(null);
        copy.setElaborationLiblist(null);
        int[] depth = new int[]{-1};
        OptimizedIdentityHashSet<IRfNamedElement> visited = new OptimizedIdentityHashSet<IRfNamedElement>();
        ELUtils.computeVisitedAndDepthFromElementPath(originalHierarchyPath, visited, depth, this.mem);
        ELInstanceInContext copyInContext = ELInstanceInContext.of(copy, context, visited, depth[0], false);
        ELManagerConfiguration updateConfig = ELManagerConfiguration.newUpdateConfig(this.config, copyInContext.depth);
        EnumSet<ElaborationDebugZone> debugZones = this.state.debugZones != null && this.state.debugZones.contains(ElaborationDebugZone.EVAL) ? EnumSet.of(ElaborationDebugZone.EVAL) : EnumSet.noneOf(ElaborationDebugZone.class);
        ELManager manager = new ELManager(this.mixedLangProject, IELMemory.ELMemoryType.STANDARD, ELBuildPhase.ELABORATION_MAIN, updateConfig, this.constantsManager, debugZones);
        manager.setInstanceSupplierIncremental(this.mem::instanceFor);
        manager.setAccumulatingIncremental(this.specsPerElement, this.specsPerInstance, this.deferredParamValues, this.defferedResolutionScopes);
        return manager.elaborateStep(copyInContext, monitor);
    }

    private IELMemory incrementalUpdateDesign(ELInstance original, ELContext context, IProgressMonitor monitor) {
        ElementPath originalHierarchyPath = original.getHierarchyPath();
        ELInstance copy = ELInstance.copyOf(original, originalHierarchyPath, false);
        copy.setElaborationLiblist(ELUtils.computeLiblist(context, original.getElaborationConfig()));
        copy.setElaborationChildrenRules(original.isTop() ? ELUtils.computeChildrenRulesFromConfig(original.getElaborationConfig(), null) : ELUtils.computeChildrenRulesFromConfigRule(original.getElaborationRule()));
        copy.setBinding((IELDesign)copy.getBinding(false));
        int[] parentDepth = new int[]{-1};
        OptimizedIdentityHashSet<IRfNamedElement> visited = new OptimizedIdentityHashSet<IRfNamedElement>();
        ELUtils.computeVisitedAndDepthFromElementPath(originalHierarchyPath, visited, parentDepth, this.mem);
        ELInstanceInContext copyInContext = ELInstanceInContext.of(copy, context, visited, parentDepth[0], false);
        ELManagerConfiguration updateConfig = ELManagerConfiguration.newUpdateConfig(this.config, copyInContext.depth + 1);
        EnumSet<ElaborationDebugZone> debugZones = this.state.debugZones != null && this.state.debugZones.contains(ElaborationDebugZone.EVAL) ? EnumSet.of(ElaborationDebugZone.EVAL) : EnumSet.noneOf(ElaborationDebugZone.class);
        ELManager manager = new ELManager(this.mixedLangProject, IELMemory.ELMemoryType.STANDARD, ELBuildPhase.ELABORATION_MAIN, updateConfig, this.constantsManager, debugZones);
        manager.setInstanceSupplierIncremental(this.mem::instanceFor);
        manager.setAccumulatingIncremental(this.specsPerElement, this.specsPerInstance, this.deferredParamValues, this.defferedResolutionScopes);
        return manager.elaborateStep(copyInContext, monitor);
    }

    private ELContext internalComputeIncrementalContext(ELInstance original) {
        ElementPath parentPath;
        IRfConfiguration config = original.getElaborationConfig();
        if (config == null) {
            return null;
        }
        ElementPath hierarchyPath = original.getHierarchyPath();
        if (hierarchyPath.length() <= 0) {
            return null;
        }
        ELLiblist liblist = ELUtils.computeLiblist(config, this.getMixedLangProjectParent());
        if (liblist == null) {
            return null;
        }
        if (hierarchyPath.length() == 1) {
            ELInstance rootInstance = ELInstance.rootFor(this.getRoot(), null, config);
            rootInstance.setElaborationLiblist(liblist);
            rootInstance.setElaborationChildrenRules(ELUtils.computeChildrenRulesFromConfig(config, null));
            return ELContext.of(rootInstance);
        }
        IELMemory memory = this.getMemory();
        ELInstance parentInstance = memory.instanceFor(parentPath = ElementPath.upperPathOf(hierarchyPath));
        if (parentInstance == null) {
            return null;
        }
        ArrayDeque<ELInstance> ancestors = new ArrayDeque<ELInstance>();
        ELInstance ancestor = parentInstance;
        while (ancestor != null && ancestor.isBlock()) {
            ancestors.push(ancestor);
            parentPath = ElementPath.upperPathOf(parentPath);
            ancestor = memory.instanceFor(parentPath);
        }
        if (ancestor != parentInstance) {
            ancestors.push(ancestor);
        }
        ELParamValues parentParamValues = null;
        if (ancestors.isEmpty()) {
            parentParamValues = parentInstance.getParamValues();
        } else {
            boolean isCaseSensitive = !ELUtils.isVHDL(parentInstance.getBinding(false));
            parentParamValues = ELParamValues.create(4, isCaseSensitive);
            for (ELInstance instance : ancestors) {
                parentParamValues.putAll(instance.getParamValues());
            }
        }
        ELInstance parentCopy = ELInstance.copyOf(parentInstance, parentInstance.getHierarchyPath(), false);
        ELSpecialization parentSpec = ELSpecialization.packedOf((IELDesign)parentInstance.getBinding(false), parentParamValues);
        parentCopy.setSpecialization(parentSpec);
        parentCopy.setElaborationLiblist(liblist);
        parentCopy.setElaborationChildrenRules(ELUtils.computeChildrenRulesFromConfigRule(original.getElaborationRule()));
        return ELContext.of(parentCopy);
    }

    private boolean overrideMemory(final IELMemory destination, IELMemory source, final Set<IRfNamedElement> unelaboratedCandidates, final List<ELInstance> elaboratedCandidates) {
        if (destination == null || source == null || !source.hasBindings()) {
            return false;
        }
        final boolean[] isDirty = new boolean[1];
        source.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                boolean isEquals;
                ELInstance prev = destination.instanceFor(path);
                boolean isEqualsOnlyValues = isEquals = instance.deepEquals(prev, false);
                if (!isEquals) {
                    ELManager.this.internalRemoveSubTreeInclusive(destination, prev, path, unelaboratedCandidates);
                    destination.put(path, instance);
                    ELManager.this.internalCollectCandidateInstance(elaboratedCandidates, instance);
                    isEqualsOnlyValues = instance.deepEquals(prev, true);
                }
                isDirty[0] = isDirty[0] | !isEqualsOnlyValues;
                return true;
            }
        });
        return isDirty[0];
    }

    private void pruneObsoleteGenerates(IELMemory destination, IELMemory source, Set<IRfNamedElement> unelaboratedCandidates) {
        ELInstance parentInstance = source.getFirstInstance();
        if (parentInstance == null) {
            return;
        }
        ElementPath parentPath = parentInstance.getHierarchyPath();
        Map<ElementPath, ELInstance> subtree = destination.subtreeOf(parentPath, false);
        if (subtree == null) {
            return;
        }
        int parentPathLength = parentPath.length();
        ArrayList<ElementPath> obsoleteGenerates = new ArrayList<ElementPath>(2);
        Set prevGenerates = Collections.newSetFromMap(new IdentityHashMap());
        for (Map.Entry<ElementPath, ELInstance> subTreeEntry : subtree.entrySet()) {
            ELInstance subInstance = subTreeEntry.getValue();
            IRfNamedElement subInstanceBinding = subInstance.getBinding(false);
            if (!DesignUtils.isBlock(subInstanceBinding)) continue;
            ElementPath subInstancePath = subTreeEntry.getKey();
            IRfInstanceElement subInstanceDescription = subInstance.getDescription();
            IRfScopeElement subInstanceEnclosing = subInstanceDescription.getEnclosingScope();
            if (subInstancePath.length() != parentPathLength + 1 && !prevGenerates.contains(subInstanceEnclosing)) continue;
            if (source.instanceFor(subInstancePath) == null) {
                obsoleteGenerates.add(subInstancePath);
                continue;
            }
            prevGenerates.add(subInstanceBinding);
        }
        for (ElementPath obsoletePath : obsoleteGenerates) {
            this.internalRemoveSubTreeInclusive(destination, destination.instanceFor(obsoletePath), obsoletePath, unelaboratedCandidates);
        }
    }

    private void internalRemoveSubTreeInclusive(IELMemory destination, ELInstance obsolete, ElementPath obsoletePath, Set<IRfNamedElement> unelaboratedCandidates) {
        Map<ElementPath, ELInstance> obsoleteSubTree = destination.subtreeOf(obsoletePath, false);
        for (ELInstance subInstance : obsoleteSubTree.values()) {
            this.internalCollectCandidateDesign(unelaboratedCandidates, subInstance);
        }
        obsoleteSubTree.clear();
        this.internalCollectCandidateDesign(unelaboratedCandidates, obsolete);
        destination.remove(obsoletePath);
        this.logger.debug(ElaborationDebugZone.INCREMENTAL, "Removed instance and subtree:", obsoletePath);
    }

    private void internalCollectCandidateDesign(Collection<IRfNamedElement> candidates, ELInstance instance) {
        if (candidates == null || instance == null || instance.isBlock()) {
            return;
        }
        IRfNamedElement binding = instance.getBinding(false);
        if (!(binding instanceof IELDesign) || binding instanceof ErrorDesignElement) {
            return;
        }
        candidates.add(binding);
    }

    private void internalCollectCandidateInstance(Collection<ELInstance> candidates, ELInstance instance) {
        if (candidates == null || instance == null || instance.isBlock()) {
            return;
        }
        IRfNamedElement binding = instance.getBinding(false);
        if (!(binding instanceof IELDesign) || binding instanceof ErrorDesignElement) {
            return;
        }
        candidates.add(instance);
    }

    public Set<ElaborationExpressionControl> getExpressionControl() {
        return this.config.expressionControl;
    }

    public Set<String> getExpressionOperatorControl() {
        return this.config.expressionOperatorControl;
    }

    public boolean isMethodEvalDisabled() {
        return this.config.methodEvalDisabled;
    }

    public boolean skipLongExpressions() {
        return this.config.skipLongExpressions;
    }

    public boolean isElabWidthCheckDisabled() {
        return this.config.elabWidthCheckDisabled;
    }

    public boolean isElabWidthCheckFiltered() {
        return this.config.elabWidthCheckFiltered;
    }

    public boolean markElabHidObjects() {
        return this.config.markElabHidObjects;
    }

    boolean bboxBinding(IRfNamedElement binding) {
        if (binding == null) {
            return false;
        }
        if (this.config.bboxModulesFilter != null) {
            return this.config.bboxModulesFilter.apply(binding.getName());
        }
        if (this.config.bboxPathsFilter != null) {
            IRfDefElement declaration = binding.getDeclaration();
            if (declaration == null) {
                return false;
            }
            return this.config.bboxPathsFilter.apply(declaration.getParserPath());
        }
        return false;
    }

    boolean bboxHierarchyPath(ElementPath hierarchicalPath) {
        return this.config.bboxInstancesFilter != null && this.config.bboxInstancesFilter.apply(hierarchicalPath);
    }

    boolean skipBinding(IRfNamedElement binding) {
        if (binding == null) {
            return false;
        }
        if (this.config.skipModulesFilter != null) {
            return this.config.skipModulesFilter.apply(binding.getName());
        }
        if (this.config.skipPathsFilter != null) {
            IRfDefElement declaration = binding.getDeclaration();
            if (declaration == null) {
                return false;
            }
            return this.config.skipPathsFilter.apply(declaration.getParserPath());
        }
        return false;
    }

    boolean skipHierarchyPath(ElementPath hierarchicalPath) {
        return this.config.skipInstancesFilter != null && this.config.skipInstancesFilter.apply(hierarchicalPath);
    }

    boolean skipDefparams() {
        return this.config.skipDefparams;
    }

    public boolean isLocalElaboration() {
        return this.buildPhase == ELBuildPhase.NONE;
    }

    public boolean isPermanentElaboration() {
        return this.buildPhase == ELBuildPhase.ELABORATION_MAIN || this.buildPhase == ELBuildPhase.ELABORATION_SANITIZE;
    }

    public boolean isSanitizePhase() {
        return this.buildPhase == ELBuildPhase.ELABORATION_SANITIZE;
    }

    public boolean isPermanentAfterElaboration() {
        return this.buildPhase == ELBuildPhase.POST_ELABORATION;
    }

    void setBuildPhase(ELBuildPhase phase) {
        this.buildPhase = phase;
    }

    public boolean isControlEachGenerateBlockOnce() {
        return this.config.controlSet.contains(ElaborationControl.EACH_GENERATE_BLOCK_ONCE);
    }

    boolean isControlNoGenerateBlocks() {
        return this.config.controlSet.contains(ElaborationControl.NO_GENERATE_BLOCKS);
    }

    public boolean isControlNoParamEval() {
        return this.config.controlSet.contains(ElaborationControl.NO_PARAM_EVAL);
    }

    boolean isControlEachSpecOnce() {
        return this.config.controlSet.contains(ElaborationControl.EACH_SPEC_ONCE);
    }

    public MinTypMax getMinTypMaxSelection() {
        return this.config.minTypMaxSelection;
    }

    boolean allowSubInstanceCopies() {
        return this.allowSubInstanceCopies;
    }

    public FullChecksAndLibs getFullChecksAndLibs() {
        return this.config.fullChecksKind;
    }

    public RootDesignElement getRoot() {
        return this.$root;
    }

    @NotNull
    public IELMemory getMemory() {
        return this.mem;
    }

    private static List<IRfConfiguration> getValidDesignTopConfigurations(List<IRfConfiguration> candidates) {
        if (candidates == null) {
            return Collections.emptyList();
        }
        ArrayList<IRfConfiguration> result = new ArrayList<IRfConfiguration>();
        for (IRfConfiguration configuration : candidates) {
            List<IRfDesignElement> topDesigns;
            if (!ELUtils.isValidTopConfig(configuration) || (topDesigns = configuration.getDesignTops()) == null || topDesigns.isEmpty()) continue;
            result.add(configuration);
        }
        return result;
    }

    private static List<IRfConfiguration> getValidPackageTopConfigurations(List<IRfConfiguration> candidates) {
        if (candidates == null) {
            return Collections.emptyList();
        }
        ArrayList<IRfConfiguration> result = new ArrayList<IRfConfiguration>();
        for (IRfConfiguration configuration : candidates) {
            if (!ELUtils.isValidTopConfig(configuration) || !(configuration instanceof DVTPackageConfiguration)) continue;
            result.add(configuration);
        }
        return result;
    }

    @NotNull
    public List<IRfConfiguration> computeConfigurations(List<BuildConfigProperty> topProperties, boolean reportToConsole, boolean computeImplicitConfig) {
        List<IRfConfiguration> validPackageTopConfigurations;
        if (topProperties == null || topProperties.isEmpty()) {
            if (!computeImplicitConfig) {
                return Collections.emptyList();
            }
            List<IRfConfiguration> implicitConfigurations = this.computeNoTopImplicitConfiguration();
            return implicitConfigurations;
        }
        List<IRfConfiguration> topConfigurations = this.mixedLangProject.resolveBuildConfigTopProperties(topProperties, reportToConsole);
        List<IRfConfiguration> validTopConfigurations = ELManager.getValidDesignTopConfigurations(topConfigurations);
        if (validTopConfigurations == null || validTopConfigurations.isEmpty()) {
            List<Object> list = validTopConfigurations = !computeImplicitConfig ? Collections.emptyList() : this.computeNoTopImplicitConfiguration();
        }
        if ((validPackageTopConfigurations = ELManager.getValidPackageTopConfigurations(topConfigurations)) != null && !validPackageTopConfigurations.isEmpty()) {
            validTopConfigurations = new ArrayList<IRfConfiguration>(validTopConfigurations);
            validTopConfigurations.addAll(validPackageTopConfigurations);
        }
        return validTopConfigurations;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private List<IRfConfiguration> computeNoTopImplicitConfiguration() {
        void var8_15;
        final List<IRfLibraryElement> libs = this.mixedLangProject.getAllLibraries();
        if (libs == null || libs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IRfDesignElement> allDesign = new ArrayList<IRfDesignElement>();
        this.collectDesign(allDesign, libs);
        if (allDesign == null || allDesign.isEmpty()) {
            return Collections.emptyList();
        }
        boolean allowEmptyTops = BuildConfigManager.isEnableElaborationEmptyTops(this.mixedLangProject.getProject());
        LinkedHashSet<String> instantiatedNames = new LinkedHashSet<String>();
        for (IRfDesignElement design : allDesign) {
            ArrayList<IRfInstanceElement> localInstances = new ArrayList<IRfInstanceElement>();
            DesignUtils.getInstancesIncludingGenerate(localInstances, design, true);
            if (localInstances.isEmpty()) {
                Collection<? extends IRfBlockElement> collection;
                if (allowEmptyTops || (collection = design.getLocalGenerateBlocks()) != null && !collection.isEmpty()) continue;
                instantiatedNames.add(design.getName());
                continue;
            }
            IRfNamedElement.ElementKind elementKind = DesignUtils.getDesignKind(design);
            for (IRfInstanceElement iRfInstanceElement : localInstances) {
                String instantiatedName;
                String string = instantiatedName = elementKind == IRfNamedElement.ElementKind.VLOG_MODULE ? iRfInstanceElement.getAssociatedTypeName("logic", null) : iRfInstanceElement.getAssociatedTypeName();
                if (instantiatedName == null || instantiatedName.isEmpty()) continue;
                instantiatedNames.add(instantiatedName);
            }
        }
        for (IRfLibraryElement lib : libs) {
            Map<IRfNamedElement, List<IRfInstanceElement>> binds = lib.collectAllBindInstances(this.timestamp);
            if (binds == null || binds.isEmpty()) continue;
            for (Map.Entry entry : binds.entrySet()) {
                for (IRfInstanceElement potential : (List)entry.getValue()) {
                    String moduleName = potential.getAssociatedTypeName();
                    instantiatedNames.add(moduleName);
                }
            }
        }
        ArrayList<IRfDesignElement> topCandidates = new ArrayList<IRfDesignElement>(10);
        block5: for (IRfDesignElement design : allDesign) {
            boolean bl = design.getLanguageKind() == LanguageKind.VHDL;
            String string = design.getName();
            if (!bl) {
                if (instantiatedNames.contains(string)) {
                    continue;
                }
            } else {
                for (String instantiatedName : instantiatedNames) {
                    if (instantiatedName.equalsIgnoreCase(string)) continue block5;
                }
            }
            topCandidates.add(design);
        }
        if (topCandidates.isEmpty()) {
            return Collections.emptyList();
        }
        final IRfSingleLangProject firstRfProject = ((IRfDesignElement)topCandidates.iterator().next()).getRfProject();
        StringJoiner topsText = new StringJoiner(", ");
        boolean bl = false;
        while (var8_15 < topCandidates.size()) {
            if (var8_15 > 10) {
                topsText.add("...");
                break;
            }
            topsText.add(((IRfDesignElement)topCandidates.get((int)var8_15)).getName());
            ++var8_15;
        }
        this.logger.debug(ElaborationDebugZone.STATS, "Found top design candidates: ", topsText.toString());
        DVTImplicitConfiguration dVTImplicitConfiguration = new DVTImplicitConfiguration("DEFAULT_CONFIG", null, topCandidates){
            private static final long serialVersionUID = 1L;
            private List<IRfLibraryElement> defaultLibList;

            @Override
            public List<IRfLibraryElement> getDefaultLiblist() {
                return this.defaultLibList;
            }

            @Override
            public void setDefaultLiblist(List<IRfLibraryElement> libList) {
                this.defaultLibList = libList;
            }

            @Override
            public void init() {
                this.defaultLibList = libs;
            }

            @Override
            public IRfSingleLangProject getRfProject() {
                return firstRfProject;
            }

            @Override
            public boolean isDummyConfig() {
                return true;
            }
        };
        return Collections.singletonList(dVTImplicitConfiguration);
    }

    private void collectDesign(List<IRfDesignElement> allDesign, Collection<? extends IRfLibraryElement> libs) {
        for (IRfLibraryElement iRfLibraryElement : libs) {
            List<? extends IRfDesignElement> locals = iRfLibraryElement.getDesignsWithPrefix("", 2);
            if (locals == null || locals.isEmpty()) continue;
            for (IRfDesignElement iRfDesignElement : locals) {
                IRfNamedElement.ElementKind designKind = DesignUtils.getDesignKind(iRfDesignElement);
                if (designKind == IRfNamedElement.ElementKind.VHDL_CONFIGURATION || designKind == IRfNamedElement.ElementKind.VLOG_CHECKER || designKind == IRfNamedElement.ElementKind.VLOG_INTERFACE || designKind == IRfNamedElement.ElementKind.VHDL_ENTITY && iRfDesignElement.getArchitecture() == null) continue;
                allDesign.add(iRfDesignElement);
            }
        }
    }

    public int elaborate(IProject project, boolean reportToConsole, boolean hideImplicitTopsWarning, IProgressMonitor progressMonitor) {
        List<IRfConfiguration> topConfigs;
        List<BuildConfigProperty> buildConfigTopProperties;
        boolean returnValue;
        long time;
        block28: {
            block27: {
                time = System.currentTimeMillis();
                returnValue = true;
                this.cleanWorking();
                this.initMonitor(progressMonitor);
                this.logger.debug(ElaborationDebugZone.STATS, "\nElaboration START", new Object[0]);
                this.checkBuildCanceled(true, 20);
                this.mixedLangProject.resolveConfigurations();
                buildConfigTopProperties = BuildConfigManager.getTopConfigurationProperties(project);
                topConfigs = this.computeConfigurations(buildConfigTopProperties, reportToConsole, true);
                if (topConfigs != null && !topConfigs.isEmpty()) break block27;
                if (!hideImplicitTopsWarning) {
                    this.logger.forceWarning("UNSPECIFIED_TOP: Please specify a -top module/entity/configuration in the project build file", -1, null, null, new Object[0]);
                }
                returnValue = false;
                this.sanitizePhase();
                if (returnValue) {
                    this.printMemory();
                    this.printStats();
                }
                XGlobalCache.INSTANCE.clearCache();
                this.cleanWorking();
                this.cleanInstanceSupplierIncremental();
                this.setBuildPhase(ELBuildPhase.POST_ELABORATION);
                this.logger.debug(ElaborationDebugZone.STATS, "Cleaning DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
                this.logger.debug(ElaborationDebugZone.STATS, "Elaboration DONE\n", new Object[0]);
                return 0;
            }
            if (!this.config.markElabHidObjects) break block28;
            this.sanitizePhase();
            if (returnValue) {
                this.printMemory();
                this.printStats();
            }
            XGlobalCache.INSTANCE.clearCache();
            this.cleanWorking();
            this.cleanInstanceSupplierIncremental();
            this.setBuildPhase(ELBuildPhase.POST_ELABORATION);
            this.logger.debug(ElaborationDebugZone.STATS, "Cleaning DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
            this.logger.debug(ElaborationDebugZone.STATS, "Elaboration DONE\n", new Object[0]);
            return 0;
        }
        try {
            boolean hasNoMinusTopDirective;
            boolean bl = hasNoMinusTopDirective = buildConfigTopProperties == null || buildConfigTopProperties.isEmpty();
            if (!hideImplicitTopsWarning && hasNoMinusTopDirective) {
                this.logger.forceWarning("UNSPECIFIED_TOP: Please specify a -top module/entity/configuration in the project build file", -1, null, null, new Object[0]);
            }
            ArrayList<ELInstanceInContext> tops = new ArrayList<ELInstanceInContext>(topConfigs.size());
            LinkedHashSet<String> visitedTopNames = new LinkedHashSet<String>();
            ArrayList<String> topsAndEnclosing = new ArrayList<String>(topConfigs.size());
            ArrayList<DVTPackageConfiguration> packageConfigurations = new ArrayList<DVTPackageConfiguration>(topConfigs.size());
            Set<IRfLibraryElement> visitedLibraries = Collections.newSetFromMap(new IdentityHashMap());
            ArrayList<IRfLibraryElement> uniqueBindLibraries = new ArrayList<IRfLibraryElement>(2);
            boolean hasExplicitDesignTopConfigs = false;
            for (IRfConfiguration topConfig : topConfigs) {
                this.checkBuildCanceled();
                if (topConfig instanceof DVTPackageConfiguration) {
                    packageConfigurations.add((DVTPackageConfiguration)topConfig);
                    continue;
                }
                hasExplicitDesignTopConfigs |= !(topConfig instanceof DVTImplicitConfiguration);
                List<IRfDesignElement> topDesigns = topConfig.getDesignTops();
                if (topDesigns == null || topDesigns.isEmpty()) {
                    this.logger.forceError("INVALID_TOP_CONFIGURATION: Configuration ''{0}'' has no valid tops", -1, null, null, topConfig.getNameAndEnclosing());
                    continue;
                }
                ELUtils.adjustNonCustomLiblist(topConfig, this.mixedLangProject);
                ELLiblist liblist = ELUtils.computeLiblist(topConfig, this.mixedLangProject);
                ELInstance rootInstance = ELInstance.rootFor(this.$root, liblist, topConfig);
                ELContext topContext = ELContext.of(rootInstance);
                this.collectUniqueLibraries(uniqueBindLibraries, liblist, visitedLibraries);
                for (IRfDesignElement topDesign : topDesigns) {
                    this.checkBuildCanceled();
                    String topName = topDesign.getName();
                    if (visitedTopNames.contains(topName)) {
                        this.reportProblemForElement(ElaborationDebugZone.FIRST_PASS, true, "DUPLICATE_TOP_NAME: Another top with the same name ''{0}'' has been elaborated", topDesign, null, topName);
                        continue;
                    }
                    visitedTopNames.add(topName);
                    topsAndEnclosing.add(topDesign.getNameAndEnclosing());
                    IRfDesignElement binding = ELUtils.computeBindingFromConfig(topConfig, topDesign, null);
                    if (!(binding instanceof IELDesign)) {
                        this.reportProblemForElement(ElaborationDebugZone.FIRST_PASS, true, "INVALID_TOP: Top ''{0}'' cannot be instantiated", topDesign, null, topName);
                        continue;
                    }
                    tops.add(ELManager.computeTop(topName, binding, this.$root, topConfig, topContext, liblist, this));
                    DVTLogger.INSTANCE.logDebug("[ELABORATION] Found top '" + topName + "'");
                }
            }
            this.preElaborateBuildConfigDefparams(project);
            this.preElaborateAllBinds(uniqueBindLibraries);
            boolean hasNoDefparams = this.config.skipDefparams || !this.internalFindAnyDefparam() && !this.hasDefparams();
            boolean isSinglePassCompatible = hasNoDefparams && !hasExplicitDesignTopConfigs;
            this.isSinglePass = this.config.elaborationKind == ElaborationKind.SINGLE_PASS || isSinglePassCompatible && this.config.elaborationKind == ElaborationKind.ADAPTIVE;
            this.allowSubInstanceCopies = this.isSinglePass && !this.config.controlSet.contains(ElaborationControl.NO_SUBINSTANCE_COPIES);
            this.internalPrintConfigControl();
            this.logger.debug(ElaborationDebugZone.STATS, "Setup DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
            time = System.currentTimeMillis();
            this.internalReportTopsToConsole(reportToConsole, hasNoMinusTopDirective, topsAndEnclosing);
            try {
                this.initExecutor();
                this.resolve(tops, this);
            }
            finally {
                this.waitForExecutor();
            }
            this.logger.debug(ElaborationDebugZone.STATS, "Hierarchy (" + (this.isSinglePass ? "Single-Pass" : "Multi-Pass") + ") DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
            time = System.currentTimeMillis();
            this.resolveSubInstanceCopies();
            if (this.allowSubInstanceCopies) {
                this.logger.debug(ElaborationDebugZone.STATS, "SubInstance Copies DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
            }
            time = System.currentTimeMillis();
            this.resolveBoundInstances(tops, false);
            this.logger.debug(ElaborationDebugZone.STATS, "Binds DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
            time = System.currentTimeMillis();
            this.cleanElabWorking();
            this.logger.debug(ElaborationDebugZone.STATS, "Clean Elab Working DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
            time = System.currentTimeMillis();
            this.resolveTopPackages(packageConfigurations);
            this.logger.debug(ElaborationDebugZone.STATS, "Top Packages DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
            time = System.currentTimeMillis();
            this.resolveHidsAndOperators();
            this.logger.debug(ElaborationDebugZone.STATS, "Hids and Operators DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
            time = System.currentTimeMillis();
        }
        catch (BuildCancelException ex) {
            throw ex;
        }
        catch (ElaborationCancelException elaborationCancelException) {
            DVTLogger.INSTANCE.logError("Canceled elaboration");
            this.sanitizePhase();
            if (returnValue) {
                this.printMemory();
                this.printStats();
            }
            XGlobalCache.INSTANCE.clearCache();
            this.cleanWorking();
            this.cleanInstanceSupplierIncremental();
            this.setBuildPhase(ELBuildPhase.POST_ELABORATION);
            this.logger.debug(ElaborationDebugZone.STATS, "Cleaning DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
            this.logger.debug(ElaborationDebugZone.STATS, "Elaboration DONE\n", new Object[0]);
        }
        catch (Exception ex) {
            try {
                DVTLogger.INSTANCE.logError((Throwable)ex);
                this.sanitizePhase();
                if (returnValue) {
                    this.printMemory();
                    this.printStats();
                }
                XGlobalCache.INSTANCE.clearCache();
                this.cleanWorking();
                this.cleanInstanceSupplierIncremental();
                this.setBuildPhase(ELBuildPhase.POST_ELABORATION);
            }
            catch (Throwable throwable) {
                this.sanitizePhase();
                if (returnValue) {
                    this.printMemory();
                    this.printStats();
                }
                XGlobalCache.INSTANCE.clearCache();
                this.cleanWorking();
                this.cleanInstanceSupplierIncremental();
                this.setBuildPhase(ELBuildPhase.POST_ELABORATION);
                this.logger.debug(ElaborationDebugZone.STATS, "Cleaning DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
                this.logger.debug(ElaborationDebugZone.STATS, "Elaboration DONE\n", new Object[0]);
                throw throwable;
            }
            this.logger.debug(ElaborationDebugZone.STATS, "Cleaning DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
            this.logger.debug(ElaborationDebugZone.STATS, "Elaboration DONE\n", new Object[0]);
        }
        this.sanitizePhase();
        if (returnValue) {
            this.printMemory();
            this.printStats();
        }
        XGlobalCache.INSTANCE.clearCache();
        this.cleanWorking();
        this.cleanInstanceSupplierIncremental();
        this.setBuildPhase(ELBuildPhase.POST_ELABORATION);
        this.logger.debug(ElaborationDebugZone.STATS, "Cleaning DONE", String.valueOf(System.currentTimeMillis() - time) + " ms");
        this.logger.debug(ElaborationDebugZone.STATS, "Elaboration DONE\n", new Object[0]);
        return 1;
    }

    private void resolve(Collection<ELInstanceInContext> tops, ELManager manager) {
        if (this.isSinglePass) {
            ELResolver.INSTANCE.resolveOnePass(tops, manager);
        } else {
            ELResolver.INSTANCE.resolve(tops, manager);
        }
    }

    private void resolveSubInstanceCopies() {
        this.checkBuildCanceled(true, 20);
        if (this.mem == null || !this.mem.hasBindings()) {
            return;
        }
        if (this.subInstanceCopiesCache == null || this.subInstanceCopiesCache.isEmpty()) {
            return;
        }
        ArrayDeque<ElementPath> work = new ArrayDeque<ElementPath>(this.subInstanceCopiesCache);
        while (!work.isEmpty()) {
            Map<ElementPath, ELInstance> originalSubtree;
            this.checkBuildCanceled();
            ElementPath copyPath = (ElementPath)work.pop();
            ELInstance copyInstance = this.mem.instanceFor(copyPath);
            if (copyInstance == null) {
                this.logger.debug(ElaborationDebugZone.SUBINSTANCE_COPIES, "Copy target path not found:", copyPath);
                continue;
            }
            IRfNamedElement copyBinding = copyInstance.getBinding(false);
            if (!(copyBinding instanceof ErrorDesignElement.SubInstanceCopyDesignElement)) {
                this.logger.debug(ElaborationDebugZone.SUBINSTANCE_COPIES, "Could not retrieve original path of:", copyPath);
                continue;
            }
            ElementPath originalPath = ((ErrorDesignElement.SubInstanceCopyDesignElement)copyBinding).getOriginalPath();
            ELInstance originalInstance = this.mem.instanceFor(originalPath);
            if (originalInstance == null) {
                this.logger.debug(ElaborationDebugZone.SUBINSTANCE_COPIES, "Original target path not found:", originalPath);
                continue;
            }
            IRfInstanceElement newInstanceDescription = copyInstance.getDescription();
            ELInstance newInstance = ELInstance.copyOf(originalInstance, newInstanceDescription, copyPath, true);
            HashMap<ElementPath, ELInstance> changes = new HashMap<ElementPath, ELInstance>();
            this.setInstanceSupplierIncremental(changes::get);
            if (ELUtils.hasValidBinding(newInstance)) {
                ELResolver.computeElaboratedBinds(newInstance, null, this);
            }
            if ((originalSubtree = this.mem.subtreeOf(originalPath, false)) != null && !originalSubtree.isEmpty()) {
                IRfNamedElement newTopBinding = newInstance.getBinding(false);
                int originalPathLength = originalPath.length();
                for (Map.Entry<ElementPath, ELInstance> entry : originalSubtree.entrySet()) {
                    ElementPath subInstancePath = entry.getKey();
                    ELInstance subInstance = entry.getValue();
                    this.state.increaseNofInstances();
                    this.state.increaseNofOptimizedInstances();
                    this.state.increaseNofCompleteInstances();
                    ElementPath newSubInstancePath = ElementPath.usePrefix(copyPath, subInstancePath, originalPathLength);
                    ELInstance newSubInstance = ELInstance.copyOf(subInstance, newSubInstancePath, true);
                    if (this.isSubInstanceCopyRecurrence(newSubInstance, newTopBinding)) {
                        newInstance.setBinding(ELUtils.getValidDesign(ELConstants.RECURRENCE_INSTANCE_TYPE));
                        changes.clear();
                        IRfDefElement declaration = newInstanceDescription.getDeclaration();
                        if (declaration == null) break;
                        String assocTypeName = newInstanceDescription.getAssociatedTypeName();
                        IDataType dataType = newInstanceDescription.getDataType();
                        int offsetStart = dataType != null ? dataType.getOffset() : declaration.getStartOffset();
                        int offsetEnd = offsetStart + assocTypeName.length();
                        int line = declaration.getStartLine();
                        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                        attributes.put("QUICKFIX_ELEMENT_NAME", assocTypeName);
                        attributes.put("QUICKFIX_KIND", 54);
                        this.reportProblem(ElaborationDebugZone.FIRST_PASS, true, "RECURRENCE_DETECTED: Recurrence detected for instance type ''{0}''", newInstanceDescription, declaration, offsetStart, offsetEnd, line, attributes, newSubInstancePath, assocTypeName);
                        break;
                    }
                    IELDesign newSubInstanceBinding = (IELDesign)newSubInstance.getBinding(false);
                    if (newSubInstanceBinding instanceof ErrorDesignElement.SubInstanceCopyDesignElement) {
                        this.logger.debug(ElaborationDebugZone.SUBINSTANCE_COPIES, "SubInstance copy detected:", newSubInstancePath);
                        changes.put(newSubInstancePath, newSubInstance);
                        work.add(newSubInstancePath);
                        ElementPath originalSubInstancePath = ((ErrorDesignElement.SubInstanceCopyDesignElement)newSubInstanceBinding).getOriginalPath();
                        ELInstance originalSubInstance = this.mem.instanceFor(originalSubInstancePath);
                        if (originalSubInstance == null) {
                            this.logger.debug(ElaborationDebugZone.SUBINSTANCE_COPIES, "Original target path not found:", originalSubInstancePath);
                            continue;
                        }
                        if (!ELUtils.hasValidBinding(originalSubInstance)) continue;
                        IRfInstanceElement newSubInstanceDescription = newSubInstance.getDescription();
                        ELInstance validNewSubInstance = ELInstance.copyOf(originalSubInstance, newSubInstanceDescription, newSubInstancePath, true);
                        ELResolver.computeElaboratedBinds(validNewSubInstance, null, this);
                        continue;
                    }
                    if (ELUtils.hasValidBinding(newSubInstance)) {
                        this.state.increaseNofResolvedInstances();
                        ELResolver.computeElaboratedBinds(newSubInstance, null, this);
                    }
                    changes.put(newSubInstancePath, newSubInstance);
                }
            }
            copyInstance.setSpecialization(newInstance.getSpecialization());
            for (ELInstance newSubInstance : changes.values()) {
                this.storeInstanceAndParamValues(newSubInstance);
            }
        }
    }

    private boolean isSubInstanceCopyRecurrence(ELInstance newSubInstance, IRfNamedElement newTopBinding) {
        IELDesign newSubInstanceBinding = (IELDesign)newSubInstance.getBinding(false);
        if (newSubInstanceBinding instanceof ErrorDesignElement.SubInstanceCopyDesignElement) {
            ElementPath originalSubInstancePath = ((ErrorDesignElement.SubInstanceCopyDesignElement)newSubInstanceBinding).getOriginalPath();
            ELInstance originalSubInstance = this.mem.instanceFor(originalSubInstancePath);
            if (originalSubInstance == null) {
                this.logger.debug(ElaborationDebugZone.SUBINSTANCE_COPIES, "Original target subpath not found:", originalSubInstancePath);
                return true;
            }
            newSubInstanceBinding = (IELDesign)originalSubInstance.getBinding(false);
        }
        ElementPath newSubInstancePath = newSubInstance.getHierarchyPath();
        if (newSubInstanceBinding == newTopBinding && ELCore.testRecurrenceDepth(newSubInstance.getDescription(), newSubInstanceBinding, newSubInstancePath, this)) {
            this.logger.debug(ElaborationDebugZone.SUBINSTANCE_COPIES, "Recurrence detected:", newSubInstancePath);
            return true;
        }
        return false;
    }

    private void resolveBoundInstances(List<ELInstanceInContext> tops, boolean incremental) {
        this.checkBuildCanceled(true, 20);
        if (!this.hasElaboratedBinds()) {
            return;
        }
        int maxNofBindsPasses = this.getMaxNofBindsPasses();
        if (maxNofBindsPasses <= 0) {
            this.logger.debug(ElaborationDebugZone.BINDS_PASS, "\nBind directives are not resolved for +" + IBuildConfigParserConstants.Directive.ELABORATION_MAX_NOF_RESOLVE_BINDS_PASSES.toString() + "+" + maxNofBindsPasses, new Object[0]);
            return;
        }
        if (this.mem == null || !this.mem.hasBindings()) {
            return;
        }
        int passCount = 0;
        this.isSinglePass = false;
        this.allowSubInstanceCopies = false;
        while (passCount < maxNofBindsPasses) {
            this.checkBuildCanceled(true, 20);
            this.logger.debug(ElaborationDebugZone.BINDS_PASS, "\nSTART BIND PASS", passCount);
            ArrayList<ELInstanceInContext> newTops = new ArrayList<ELInstanceInContext>(4);
            ELResolver.findBoundInstancesNew(newTops, incremental, this);
            this.logger.debug(ElaborationDebugZone.BINDS_PASS, "\nEND BIND PASS", passCount);
            if (newTops.isEmpty()) break;
            for (ELInstanceInContext newTop : newTops) {
                this.resolve(Collections.singleton(newTop), this);
            }
            ++passCount;
        }
        if (passCount >= maxNofBindsPasses) {
            this.reportProblemForElement(ElaborationDebugZone.BINDS_PASS, true, "INVALID_BINDS: Failed to resolve all the bind directives in {0} tries", tops.iterator().next().instance.getBinding(false), null, this.config.maxNofBindsPasses);
        }
    }

    private void resolveTopPackages(List<DVTPackageConfiguration> packageConfigurations) {
        if (packageConfigurations == null || packageConfigurations.isEmpty()) {
            return;
        }
        for (DVTPackageConfiguration packageConfiguration : packageConfigurations) {
            IRfPackageElement pkg = packageConfiguration.getPackage();
            if (pkg == null) continue;
            pkg.elaborateConstants(this);
        }
    }

    private boolean internalFindAnyDefparam() {
        List<IRfLibraryElement> libs = this.mixedLangProject.getAllLibraries();
        if (libs == null || libs.isEmpty()) {
            return false;
        }
        for (IRfLibraryElement lib : libs) {
            List<? extends IRfDesignElement> locals;
            if (lib.getLanguageKind() != LanguageKind.VLOG || (locals = lib.getDesignsWithPrefix("", 2)) == null || locals.isEmpty()) continue;
            for (IRfDesignElement iRfDesignElement : locals) {
                if (!(iRfDesignElement instanceof IELDesign) || !((IELDesign)((Object)iRfDesignElement)).hasDefparams()) continue;
                return true;
            }
        }
        return false;
    }

    private void internalPrintConfigControl() {
        if (this.config.controlSet.isEmpty()) {
            return;
        }
        StringJoiner sj = new StringJoiner(", ");
        for (ElaborationControl control : this.config.controlSet) {
            sj.add(control.toString());
        }
        this.logger.debug(ElaborationDebugZone.STATS, "Control:", sj.toString());
    }

    private void resolveHidsAndOperators() {
        this.state.increaseDesignSpecsCount(this.specsPerElement);
        this.state.increaseInstanceSpecsCount(this.specsPerInstance);
        this.specsPerInstance.clear();
        if (!this.isPermanentElaboration()) {
            return;
        }
        this.checkBuildCanceled(true, 20);
        boolean isLinting = this.mixedLangProject.isLinting();
        FullChecksKind kind = this.config.fullChecksKind.getFullChecksKind(isLinting);
        if (kind == FullChecksKind.OFF) {
            return;
        }
        this.state.increaseNofDesignHidOps(this.specsPerElement.size());
        this.state.resetNofCompleteDesignsHidOps();
        Map<String, Set<String>> onlyLibAndPkgNames = this.config.fullChecksKind.getLibraryAndPackageNames(isLinting);
        try {
            this.initExecutor();
            this.resolveHidsAndOperators(this.config.maxNofRecursionThreads, kind, onlyLibAndPkgNames);
        }
        finally {
            this.waitForHidOpsExecutor(false);
        }
    }

    private void resolveHids(int nofThreads, FullChecksKind kind, Map<String, Set<String>> onlyLibAndPkgNames) {
        this.initDataTypeCache();
        for (Map.Entry<IRfNamedElement, ConcurrentHashMap<ELSpecializationWrapper, ELSpecializationWrapper>> entry : this.specsPerElement.entrySet()) {
            IRfLibraryElement library;
            IRfNamedElement design = entry.getKey();
            Map specs = entry.getValue();
            if (specs == null || specs.isEmpty()) {
                this.recusiveIncreaseNofCompletePerDesign((IELDesign)design);
                continue;
            }
            IRfNamedElement.ElementKind designKind = DesignUtils.getDesignKind(design);
            if (designKind == IRfNamedElement.ElementKind.VLOG_GENERATE) continue;
            if (designKind == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                this.state.increaseNofCompleteDesignsHidOps();
                continue;
            }
            if (onlyLibAndPkgNames != null && (library = design.getEnclosingLibrary()) != null) {
                String libraryName = library.getName();
                if (kind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName)) {
                    this.recusiveIncreaseNofCompletePerDesign((IELDesign)design);
                    continue;
                }
                if (kind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) {
                    this.recusiveIncreaseNofCompletePerDesign((IELDesign)design);
                    continue;
                }
            }
            Runnable worker = () -> this.resolveHidsPerDesign((IELDesign)design);
            if (nofThreads < 2) {
                worker.run();
                continue;
            }
            this.executor.execute(worker);
        }
    }

    private void resolveOperators(int nofThreads, FullChecksKind kind, Map<String, Set<String>> onlyLibAndPkgNames) {
        this.initDataTypeCache();
        for (Map.Entry<IRfNamedElement, ConcurrentHashMap<ELSpecializationWrapper, ELSpecializationWrapper>> entry : this.specsPerElement.entrySet()) {
            IRfLibraryElement library;
            IRfNamedElement design = entry.getKey();
            Map specs = entry.getValue();
            if (specs == null || specs.isEmpty()) {
                this.recusiveIncreaseNofCompletePerDesign((IELDesign)design);
                continue;
            }
            IRfNamedElement.ElementKind designKind = DesignUtils.getDesignKind(design);
            if (designKind == IRfNamedElement.ElementKind.VLOG_GENERATE) continue;
            if (designKind == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                this.state.increaseNofCompleteDesignsHidOps();
                continue;
            }
            if (onlyLibAndPkgNames != null && (library = design.getEnclosingLibrary()) != null) {
                String libraryName = library.getName();
                if (kind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName)) {
                    this.recusiveIncreaseNofCompletePerDesign((IELDesign)design);
                    continue;
                }
                if (kind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) {
                    this.recusiveIncreaseNofCompletePerDesign((IELDesign)design);
                    continue;
                }
            }
            Runnable worker = () -> this.resolveOperatorsPerDesign((IELDesign)design);
            if (nofThreads < 2) {
                worker.run();
                continue;
            }
            this.executor.execute(worker);
        }
    }

    private void resolveHidsAndOperators(int nofThreads, FullChecksKind kind, Map<String, Set<String>> onlyLibAndPkgNames) {
        this.initDataTypeCache();
        Collection<Map.Entry<IRfNamedElement, ConcurrentHashMap<ELSpecializationWrapper, ELSpecializationWrapper>>> entrySet = this.specsPerElement.entrySet();
        if (TestHelper.isTestMode() && !TestHelper.isPerformanceTest()) {
            entrySet = new ArrayList<Map.Entry<IRfNamedElement, ConcurrentHashMap<ELSpecializationWrapper, ELSpecializationWrapper>>>(entrySet);
            Collections.sort((List)entrySet, (me, other) -> {
                IRfNamedElement mKey = (IRfNamedElement)me.getKey();
                IRfNamedElement otherKey = (IRfNamedElement)other.getKey();
                return mKey.getName().compareTo(otherKey.getName());
            });
        }
        for (Map.Entry entry : entrySet) {
            IRfLibraryElement library;
            IRfNamedElement design = (IRfNamedElement)entry.getKey();
            Map specs = (Map)entry.getValue();
            if (specs == null || specs.isEmpty()) {
                this.recusiveIncreaseNofCompletePerDesign((IELDesign)design);
                continue;
            }
            IRfNamedElement.ElementKind designKind = DesignUtils.getDesignKind(design);
            if (designKind == IRfNamedElement.ElementKind.VLOG_GENERATE) continue;
            if (designKind == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                this.state.increaseNofCompleteDesignsHidOps();
                continue;
            }
            if (onlyLibAndPkgNames != null && (library = design.getEnclosingLibrary()) != null) {
                String libraryName = library.getName();
                if (kind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName)) {
                    this.recusiveIncreaseNofCompletePerDesign((IELDesign)design);
                    continue;
                }
                if (kind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) {
                    this.recusiveIncreaseNofCompletePerDesign((IELDesign)design);
                    continue;
                }
            }
            Runnable worker = () -> this.resolveHidsAndOperatorsPerDesign((IELDesign)design);
            if (nofThreads < 2) {
                worker.run();
                continue;
            }
            this.executor.execute(worker);
        }
    }

    private void recusiveIncreaseNofCompletePerDesign(IELDesign design) {
        Collection<? extends IRfBlockElement> firstLevelGenerates;
        if (this.specsPerElement.containsKey(design)) {
            this.state.increaseNofCompleteDesignsHidOps();
        }
        if ((firstLevelGenerates = ((IRfDesignElement)((Object)design)).getLocalGenerateBlocks()) == null) {
            return;
        }
        for (IRfBlockElement iRfBlockElement : firstLevelGenerates) {
            this.recusiveIncreaseNofCompletePerDesign(iRfBlockElement);
        }
    }

    private void resolveHidsAndOperatorsStep(IRfNamedElement design, boolean isLintingEnabled) {
        this.state.increaseDesignSpecsCount(this.specsPerElement);
        this.state.increaseInstanceSpecsCount(this.specsPerInstance);
        this.specsPerInstance.clear();
        if (!this.isPermanentElaboration()) {
            return;
        }
        this.checkBuildCanceled(false, 20);
        Map specs = this.specsPerElement.get(design);
        if (specs == null || specs.isEmpty()) {
            return;
        }
        FullChecksKind kind = this.config.fullChecksKind.getFullChecksKind(isLintingEnabled);
        if (kind == FullChecksKind.OFF) {
            return;
        }
        Map<String, Set<String>> onlyLibAndPkgNames = this.config.fullChecksKind.getLibraryAndPackageNames(isLintingEnabled);
        if (onlyLibAndPkgNames != null) {
            IRfLibraryElement library = design.getEnclosingLibrary();
            if (library == null) {
                return;
            }
            String libraryName = library.getName();
            if (kind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName)) {
                return;
            }
            if (kind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) {
                return;
            }
        }
        this.initDataTypeCache();
        this.resolveHidsAndOperatorsPerDesign((IELDesign)design);
    }

    private void recusiveResolveHidsPerDesign(IELDesign design, Thread currentThread) {
        Map specs = this.config.markElabHidObjects ? Collections.emptyMap() : (Map)this.specsPerElement.get(design);
        this.internalResolveHids(design, specs, currentThread);
        Collection<? extends IRfBlockElement> firstLevelGenerates = ((IRfDesignElement)((Object)design)).getLocalGenerateBlocks();
        if (firstLevelGenerates == null) {
            return;
        }
        for (IRfBlockElement iRfBlockElement : firstLevelGenerates) {
            this.recusiveResolveHidsPerDesign(iRfBlockElement, currentThread);
        }
    }

    private void recursiveResolveOperatorsPerDesign(IELDesign design, Thread currentThread) {
        Map specs = this.config.markElabHidObjects ? Collections.emptyMap() : (Map)this.specsPerElement.get(design);
        this.internalResolveOperators(design, specs, currentThread);
        Collection<? extends IRfBlockElement> firstLevelGenerates = ((IRfDesignElement)((Object)design)).getLocalGenerateBlocks();
        if (firstLevelGenerates == null) {
            return;
        }
        for (IRfBlockElement iRfBlockElement : firstLevelGenerates) {
            this.recursiveResolveOperatorsPerDesign(iRfBlockElement, currentThread);
        }
    }

    private void recursiveResolveHidsAndOperatorsPerDesign(IELDesign design, Thread currentThread) {
        Map specs = this.config.markElabHidObjects ? Collections.singletonMap(ELSpecializationWrapper.EMPTY, ELSpecializationWrapper.EMPTY) : (Map)this.specsPerElement.get(design);
        this.internalResolveHidsAndOperators(design, specs, currentThread);
        Collection<? extends IRfBlockElement> firstLevelGenerates = ((IRfDesignElement)((Object)design)).getLocalGenerateBlocks();
        if (firstLevelGenerates == null) {
            return;
        }
        for (IRfBlockElement iRfBlockElement : firstLevelGenerates) {
            this.recursiveResolveHidsAndOperatorsPerDesign(iRfBlockElement, currentThread);
        }
    }

    private void internalResolveHids(IELDesign design, Map<ELSpecializationWrapper, ELSpecializationWrapper> specs, Thread currentThread) {
        if (specs == null) {
            return;
        }
        try {
            byte semanticEnableRaw = this.getSemanticEnableRaw();
            boolean isFirst = true;
            for (ELSpecializationWrapper spec : specs.keySet()) {
                this.resetDataTypeCache(currentThread);
                design.resolveHidsFromElaboration(spec.getElabContext(this), true, isFirst, semanticEnableRaw);
                isFirst = false;
            }
        }
        finally {
            this.state.increaseNofCompleteDesignsHidOps();
        }
    }

    private void internalResolveOperators(IELDesign design, Map<ELSpecializationWrapper, ELSpecializationWrapper> specs, Thread currentThread) {
        if (specs == null) {
            return;
        }
        try {
            byte semanticEnableRaw = this.getSemanticEnableRaw();
            for (ELSpecializationWrapper spec : specs.keySet()) {
                this.resetDataTypeCache(currentThread);
                design.resolveOperatorsFromElaboration(this.config.elabWidthCheckDisabled, this.config.elabWidthCheckFiltered, spec.getElabContext(this), true, semanticEnableRaw);
            }
        }
        finally {
            this.state.increaseNofCompleteDesignsHidOps();
        }
    }

    private void internalResolveHidsAndOperators(IELDesign design, Map<ELSpecializationWrapper, ELSpecializationWrapper> specs, Thread currentThread) {
        if (specs == null) {
            return;
        }
        try {
            Collection<ELSpecializationWrapper> keySet = specs.keySet();
            if (TestHelper.isTestMode() && !TestHelper.isPerformanceTest()) {
                keySet = new ArrayList<ELSpecializationWrapper>(keySet);
                Collections.sort((List)keySet, (left, right) -> {
                    int result = left.spec.compareTo(right.spec);
                    if (result != 0) {
                        return result;
                    }
                    ElementPath firstLeftPath = left.paths.stream().min(ElementPath::compareTo).orElse(ElementPath.EMPTY_PATH);
                    ElementPath firstRightPath = right.paths.stream().min(ElementPath::compareTo).orElse(ElementPath.EMPTY_PATH);
                    return firstLeftPath.compareTo(firstRightPath);
                });
            }
            byte semanticEnableRaw = this.getSemanticEnableRaw();
            boolean isFirst = true;
            for (ELSpecializationWrapper spec : keySet) {
                this.resetDataTypeCache(currentThread);
                ELWidthCheckContext elabContext = spec.getElabContext(this);
                design.resolveHidsFromElaboration(elabContext, true, isFirst, semanticEnableRaw);
                if (!this.config.markElabHidObjects) {
                    design.resolveOperatorsFromElaboration(this.config.elabWidthCheckDisabled, this.config.elabWidthCheckFiltered, elabContext, true, semanticEnableRaw);
                }
                isFirst = false;
            }
        }
        finally {
            this.state.increaseNofCompleteDesignsHidOps();
        }
    }

    private void resolveHidsPerDesign(IELDesign design) {
        try {
            Thread currentThread = Thread.currentThread();
            this.resetDataTypeCache(currentThread);
            this.recusiveResolveHidsPerDesign(design, currentThread);
        }
        catch (BuildCancelException buildCancelException) {
            this.state.throwBuildCancelException();
        }
        catch (ElaborationCancelException elaborationCancelException) {
            this.state.throwElaborationCancelException();
        }
        catch (Exception ex) {
            this.state.throwElaborationCancelException();
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    private void resolveOperatorsPerDesign(IELDesign design) {
        try {
            Thread currentThread = Thread.currentThread();
            this.resetDataTypeCache(currentThread);
            this.recursiveResolveOperatorsPerDesign(design, currentThread);
        }
        catch (BuildCancelException buildCancelException) {
            this.state.throwBuildCancelException();
        }
        catch (ElaborationCancelException elaborationCancelException) {
            this.state.throwElaborationCancelException();
        }
        catch (Exception ex) {
            this.state.throwElaborationCancelException();
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    private void resolveHidsAndOperatorsPerDesign(IELDesign design) {
        try {
            Thread currentThread = Thread.currentThread();
            this.resetDataTypeCache(currentThread);
            this.recursiveResolveHidsAndOperatorsPerDesign(design, currentThread);
        }
        catch (BuildCancelException buildCancelException) {
            this.state.throwBuildCancelException();
        }
        catch (ElaborationCancelException elaborationCancelException) {
            this.state.throwElaborationCancelException();
        }
        catch (Exception ex) {
            this.state.throwElaborationCancelException();
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    public IELMemory elaborateLocal(IRfDesignElement topDesign, IProgressMonitor progressMonitor) {
        if (topDesign == null) {
            return null;
        }
        DVTImplicitConfiguration topConfig = new DVTImplicitConfiguration("DEFAULT_CONFIG", null, Collections.singletonList(topDesign)){
            private static final long serialVersionUID = 1L;
            private List<IRfLibraryElement> defaultLiblist;

            @Override
            public void init() {
                this.defaultLiblist = ELManager.this.mixedLangProject.getAllLibraries();
            }

            @Override
            public List<IRfLibraryElement> getDefaultLiblist() {
                return this.defaultLiblist;
            }

            @Override
            public IRfSingleLangProject getRfProject() {
                return this.getRfProject();
            }

            @Override
            public boolean isDummyConfig() {
                return true;
            }
        };
        IRfDesignElement binding = ELUtils.computeBindingFromConfig(topConfig, topDesign, null);
        if (!(binding instanceof IELDesign)) {
            return null;
        }
        ELLiblist liblist = ELUtils.computeLiblist(topConfig, this.mixedLangProject);
        ELInstance rootInstance = ELInstance.rootFor(this.$root, liblist, topConfig);
        ELContext topContext = ELContext.of(rootInstance);
        ELInstanceInContext top = ELManager.computeTop(topDesign.getName(), binding, this.$root, topConfig, topContext, liblist, this);
        try {
            this.cleanWorking();
            this.initMonitor(progressMonitor);
            try {
                this.initExecutor();
                this.resolve(Collections.singletonList(top), this);
            }
            finally {
                this.waitForExecutor();
            }
            this.resolveHidsAndOperatorsStep(binding, this.mixedLangProject.isLinting());
            IELMemory iELMemory = this.getMemory();
            return iELMemory;
        }
        catch (BuildCancelException ex) {
            throw ex;
        }
        catch (ElaborationCancelException elaborationCancelException) {
            DVTLogger.INSTANCE.logError("Canceled elaboration");
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        finally {
            this.sanitizePhase();
            XGlobalCache.INSTANCE.clearCache();
            this.cleanWorking();
            this.cleanInstanceSupplierIncremental();
            this.setBuildPhase(ELBuildPhase.POST_ELABORATION);
        }
        return null;
    }

    private IELMemory elaborateStep(ELInstanceInContext instanceInContext, IProgressMonitor progressMonitor) {
        try {
            this.cleanElabWorking();
            this.initMonitor(progressMonitor);
            try {
                this.initExecutor();
                this.resolve(Collections.singletonList(instanceInContext), this);
            }
            finally {
                this.waitForExecutor();
            }
            IELMemory iELMemory = this.getMemory();
            return iELMemory;
        }
        catch (BuildCancelException ex) {
            throw ex;
        }
        catch (ElaborationCancelException elaborationCancelException) {
            DVTLogger.INSTANCE.logError("Canceled elaboration");
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        finally {
            this.sanitizePhase();
            XGlobalCache.INSTANCE.clearCache();
            this.cleanElabWorking();
            this.cleanInstanceSupplierIncremental();
            this.setBuildPhase(ELBuildPhase.POST_ELABORATION);
        }
        return null;
    }

    private void internalReportTopsToConsole(boolean reportToConsole, boolean hasNoMinusTopDirective, List<String> topsAndEnclosing) {
        if (!reportToConsole || topsAndEnclosing.isEmpty()) {
            return;
        }
        StringJoiner topsText = new StringJoiner(", ");
        int i = 0;
        while (i < topsAndEnclosing.size()) {
            if (i > 10) {
                topsText.add("...");
                break;
            }
            topsText.add(topsAndEnclosing.get(i));
            ++i;
        }
        String prefix = hasNoMinusTopDirective ? "*** Top design candidates: " : "*** Top designs: ";
        this.logger.printToConsole(String.valueOf(prefix) + topsText.toString());
    }

    private static ELInstanceInContext computeTop(String topName, IRfDesignElement binding, RootDesignElement root, IRfConfiguration topConfig, ELContext topContext, ELLiblist liblist, ELManager manager) {
        DummyInstance topDescription = DummyInstance.of(topName, binding);
        root.addTopInstance(topDescription);
        ELInstance topInstance = ELInstance.of(topDescription, ELUtils.appendToPath(null, topName), ELUtils.getValidDesign(binding), topConfig, liblist, null, ELUtils.computeChildrenRulesFromConfig(topConfig, null), manager);
        return ELInstanceInContext.ofTop(topInstance, topContext);
    }

    private void collectUniqueLibraries(List<IRfLibraryElement> collect, ELLiblist liblist, Set<IRfLibraryElement> visited) {
        if (liblist == null || liblist.content == null) {
            return;
        }
        for (IRfLibraryElement library : liblist.content) {
            if (visited.contains(library)) continue;
            visited.add(library);
            collect.add(library);
        }
    }

    private void preElaborateBuildConfigDefparams(IProject project) {
        Map<ElementPath, ELBuildConfigOverriddenParameter> bcDefparams = BuildConfigManager.getBuildConfigOverriddenParameters(project);
        for (Map.Entry<ElementPath, ELBuildConfigOverriddenParameter> entry : bcDefparams.entrySet()) {
            ElementPath absolutePath = entry.getKey();
            ELBuildConfigOverriddenParameter overriddenParameter = entry.getValue();
            String paramName = absolutePath.lastSegment();
            ElementPath absolutePathNoLastSegment = absolutePath.removeLastSegment();
            this.addBuildConfigDefparamValue(absolutePathNoLastSegment, new ELParamValues.BuildConfigParamKeyValueLocationTuple(paramName, overriddenParameter.value, absolutePath, overriddenParameter.offset, overriddenParameter.parserPath));
        }
    }

    private void preElaborateAllBinds(Collection<IRfLibraryElement> uniqueBindLibraries) {
        if (uniqueBindLibraries == null || uniqueBindLibraries.isEmpty()) {
            return;
        }
        for (IRfLibraryElement enclosingLibrary : uniqueBindLibraries) {
            Map<IRfNamedElement, List<IRfInstanceElement>> binds = enclosingLibrary.collectAllBindInstances(this.timestamp);
            if (binds == null || binds.isEmpty()) continue;
            for (Map.Entry<IRfNamedElement, List<IRfInstanceElement>> entry : binds.entrySet()) {
                IRfNamedElement definitionScope = entry.getKey();
                for (IRfInstanceElement potential : entry.getValue()) {
                    this.logger.debug(ElaborationDebugZone.BINDS_PASS, "Found bound instance:", potential.getNameAndEnclosing());
                    this.preElaborateBind(potential, definitionScope);
                    potential.setDependencies(null, null);
                }
            }
        }
    }

    private void preElaborateBind(IRfInstanceElement potential, IRfNamedElement definitionScope) {
        List<ELBindElementPath> preElaborations = potential.preElaborateBindTargetPaths();
        if (preElaborations == null || preElaborations.isEmpty()) {
            return;
        }
        block9: for (ELBindElementPath preElaboration : preElaborations) {
            this.state.incrementNofPotentialBinds();
            IRfScopeElement potentialEnclosingScope = potential.getEnclosingScope();
            block0 : switch (preElaboration.getKind()) {
                case BY_ABSOLUTE_PATH: 
                case BY_RELATIVE_PATH: {
                    if (definitionScope instanceof IRfLibraryElement) {
                        IHidObject hidObject = preElaboration.getTarget();
                        ElementPath newPath = ElementPath.from(HidUtils.toNiceString(hidObject), ".");
                        if (newPath == null) break;
                        ElaboratedTargetPathWithOrigin newPathWithOrigin = ElaboratedTargetPathWithOrigin.of(newPath, preElaboration.getKind(), ELConstants.LIBRARY_PATH);
                        this.addElaboratedBind(potential, newPathWithOrigin);
                        this.logger.debug(ElaborationDebugZone.BINDS_PASS, "\n**** Added bind: ", newPathWithOrigin);
                        break;
                    }
                    if (this.potentialBindsByElement == null) {
                        this.potentialBindsByElement = new OptimizedLinkedHashMap<IRfNamedElement, List<PreElaboratedBindInstance>>();
                    }
                    List bindsByElement = this.potentialBindsByElement.computeIfAbsent(definitionScope, key -> new ArrayList(4));
                    bindsByElement.add(PreElaboratedBindInstance.of(potential, preElaboration));
                    break;
                }
                case BY_TYPE_NAME: {
                    Hid hid;
                    IHidObject hidObject = preElaboration.getTarget();
                    if (hidObject == null) continue block9;
                    switch (hidObject.getHidKind()) {
                        case ACCESS: {
                            hid = ((HidAccess)hidObject).getParentHid();
                            break;
                        }
                        case HID: {
                            hid = (Hid)hidObject;
                            break;
                        }
                        default: {
                            break block0;
                        }
                    }
                    if (hid.getParentAccess() != null) continue block9;
                    if (this.potentialBindsByName == null) {
                        this.potentialBindsByName = new OptimizedLinkedHashMap<String, List<PreElaboratedBindInstance>>();
                    }
                    String targetScope = hid.getName();
                    List bindsByName = this.potentialBindsByName.computeIfAbsent(targetScope, key -> new ArrayList(4));
                    bindsByName.add(PreElaboratedBindInstance.of(potential, preElaboration));
                    if (this.elaboratedBindScopePaths == null) {
                        this.elaboratedBindScopePaths = new IdentityHashMap<IRfScopeElement, BindWithElaboratedPaths>();
                    }
                    BindWithElaboratedPaths bindsWithPathByTypeName = this.elaboratedBindScopePaths.computeIfAbsent(potentialEnclosingScope, key -> new BindWithElaboratedPaths());
                    ArrayList<ElementPath> prevPathsByTypeName = new ArrayList<ElementPath>(2);
                    if (potentialEnclosingScope instanceof IRfLibraryElement) {
                        prevPathsByTypeName.add(ELConstants.LIBRARY_PATH);
                    }
                    bindsWithPathByTypeName.addPreElaboratedBind(potential, prevPathsByTypeName);
                    break;
                }
                case BY_TYPE_NAME_AND_INSTANCE_NAME: {
                    String targetScope = potential.getTargetScope();
                    if (targetScope == null) continue block9;
                    if (this.potentialBindsByName == null) {
                        this.potentialBindsByName = new OptimizedLinkedHashMap<String, List<PreElaboratedBindInstance>>();
                    }
                    List bindsByName = this.potentialBindsByName.computeIfAbsent(targetScope, key -> new ArrayList(4));
                    bindsByName.add(PreElaboratedBindInstance.of(potential, preElaboration));
                    if (this.elaboratedBindScopePaths == null) {
                        this.elaboratedBindScopePaths = new IdentityHashMap<IRfScopeElement, BindWithElaboratedPaths>();
                    }
                    BindWithElaboratedPaths bindsWithPathByInstanceName = this.elaboratedBindScopePaths.computeIfAbsent(potentialEnclosingScope, key -> new BindWithElaboratedPaths());
                    ArrayList<ElementPath> prevPathsByInstanceName = new ArrayList<ElementPath>(2);
                    if (potentialEnclosingScope instanceof IRfLibraryElement) {
                        prevPathsByInstanceName.add(ELConstants.LIBRARY_PATH);
                    }
                    bindsWithPathByInstanceName.addPreElaboratedBind(potential, prevPathsByInstanceName);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeInstanceAndParamValues(ELInstance instance) {
        if (instance.isArrayOfInstancesBlock()) {
            return;
        }
        if (instance.isSkipped()) {
            return;
        }
        ElementPath currentPath = instance.getHierarchyPath();
        Object object = this.SYNC_MONITOR_INSTANCE;
        synchronized (object) {
            this.mem.put(currentPath, instance);
        }
        this.logger.debug(ElaborationDebugZone.FIRST_PASS, "* Stored instance and param values for :", currentPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ELInstance safeMemInstanceFor(ElementPath path) {
        Object object = this.SYNC_MONITOR_INSTANCE;
        synchronized (object) {
            ELInstance instance = this.mem.instanceFor(path);
            if (instance != null || this.instanceSupplierIncremental == null) {
                return instance;
            }
            return this.instanceSupplierIncremental.apply(path);
        }
    }

    public ELSpecialization.InterfacePortInstance getInterfacePortInstance(ElementPath instancePath, IRfPortElement port) {
        ELInstance instance = this.safeMemInstanceFor(instancePath);
        return instance != null ? instance.getInterfacePortInstance(port.getName()) : null;
    }

    public RfMixedLangProject getMixedLangProjectParent() {
        return this.mixedLangProject;
    }

    IRfSingleLangProject getSingleLangProjectParent(LanguageKind languageKind) {
        if (languageKind == LanguageKind.VLOG && this.vlogRfProjectCache == null) {
            this.vlogRfProjectCache = this.mixedLangProject.getSingleLangProject(LanguageKind.VLOG.NATURE_ID);
        }
        if (languageKind == LanguageKind.VHDL && this.vhdlRfProjectCache == null) {
            this.vhdlRfProjectCache = this.mixedLangProject.getSingleLangProject(LanguageKind.VHDL.NATURE_ID);
        }
        return languageKind == LanguageKind.VLOG ? this.vlogRfProjectCache : (languageKind == LanguageKind.VHDL ? this.vhdlRfProjectCache : null);
    }

    ConcurrentHashMap<IRfNamedElement, Map<String, HidOperatorWrapper>> getParameterDefaultValuesCache(boolean isCaseSensitive) {
        return isCaseSensitive ? this.caseSensitiveParameterDefaultValuesCache : this.caseInsensitiveParameterDefaultValuesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBuildConfigDefparamValue(ElementPath newKey, ELParamValues.BuildConfigParamKeyValueLocationTuple value) {
        Object object = this.SYNC_MONITOR_PT_DEFPARAMS;
        synchronized (object) {
            ELParamValues.BuildConfigParamKeyValueLocationTuple prevDefparam;
            if (this.buildConfigDefparamValues == null) {
                this.buildConfigDefparamValues = new ELParamValues.BuildConfigDefparams();
            }
            if ((prevDefparam = this.buildConfigDefparamValues.addDefparam(newKey, value)) != null) {
                this.logger.debug(ElaborationDebugZone.FIRST_PASS, "Additional potential defparam value for:", value);
                this.state.incrementNofPotentialDefparams();
            }
        }
    }

    Map<String, ELParamValues.BuildConfigParamKeyValueLocationTuple> getBuildConfigDefparamValues(ElementPath key, boolean caseSensitive) {
        return this.buildConfigDefparamValues != null ? this.buildConfigDefparamValues.getDefparams(key, caseSensitive) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPotentialDefparamValue(ElementPath newKey, ELParamValues.ParamKeyValueLocationTuple value) {
        Object object = this.SYNC_MONITOR_PT_DEFPARAMS;
        synchronized (object) {
            if (this.potentialDefparamValues == null) {
                this.potentialDefparamValues = new LinkedHashMap<ElementPath, Map<String, List<ELParamValues.ParamKeyValueLocationTuple>>>();
            }
            Map entries = this.potentialDefparamValues.computeIfAbsent(newKey, key -> new OptimizedLinkedHashMap());
            List defparams = entries.computeIfAbsent(value.key, key -> new ArrayList());
            defparams.add(value);
            if (defparams.size() > 1) {
                this.logger.debug(ElaborationDebugZone.FIRST_PASS, "Additional potential defparam value for:", value);
            }
            this.state.incrementNofPotentialDefparams();
        }
    }

    Map<String, List<ELParamValues.ParamKeyValueLocationTuple>> getPotentialDefparamValues(ElementPath key) {
        return this.potentialDefparamValues != null ? this.potentialDefparamValues.get(key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean maxGenerateRecurrenceDepthReached(IRfNamedElement binding, ElementPath elementPath) {
        int count = 1;
        if (count >= this.config.maxReccurenceDepth) {
            return true;
        }
        ElementPath parent = ElementPath.upperPathOf(ElementPath.upperPathOf(elementPath));
        if (parent == null) {
            return true;
        }
        Object object = this.SYNC_MONITOR_INSTANCE;
        synchronized (object) {
            while (true) {
                ELInstance instance;
                if (parent == null || parent.length() <= 0) {
                    if (count < this.config.maxReccurenceDepth) return false;
                    return true;
                }
                IRfNamedElement parentBinding = this.mem.bindingFor(parent, false);
                if (parentBinding == null && this.instanceSupplierIncremental != null && (instance = this.instanceSupplierIncremental.apply(parent)) != null) {
                    parentBinding = instance.getBinding(false);
                }
                if (parentBinding == null) {
                    return true;
                }
                if (parentBinding == binding) {
                    ++count;
                }
                if (count >= this.config.maxReccurenceDepth) {
                    return true;
                }
                parent = ElementPath.upperPathOf(parent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDefparamValue(ElementPath newKey, ELParamValues.ParamKeyValueLocationTuple value) {
        Object object = this.SYNC_MONITOR_DEFPARAMS;
        synchronized (object) {
            if (this.defparamValues == null) {
                this.defparamValues = new LinkedHashMap<ElementPath, Map<String, List<ELParamValues.ParamKeyValueLocationTuple>>>();
            }
            Map entries = this.defparamValues.computeIfAbsent(newKey, key -> new OptimizedLinkedHashMap());
            List defparams = entries.computeIfAbsent(value.key, key -> new ArrayList());
            defparams.add(value);
            if (defparams.size() > 1) {
                this.logger.debug(ElaborationDebugZone.FIRST_PASS, "Additional defparam value for:", value);
            }
            this.state.incrementNofDefparams();
        }
    }

    Map<String, List<ELParamValues.ParamKeyValueLocationTuple>> getDefparamValues(ElementPath key) {
        return this.defparamValues != null ? this.defparamValues.get(key) : null;
    }

    boolean hasDefparams() {
        return this.buildConfigDefparamValues != null || this.potentialDefparamValues != null || this.defparamValues != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addElaboratedBind(IRfInstanceElement description, ElaboratedTargetPathWithOrigin elabPathWithOrigin) {
        if (elabPathWithOrigin == null) {
            return;
        }
        Object object = this.SYNC_MONITOR_BINDS;
        synchronized (object) {
            if (this.elaboratedBinds == null) {
                this.elaboratedBinds = new OptimizedLinkedHashMap<IRfInstanceElement, List<ElaboratedTargetPathWithOrigin>>();
            }
            List values = this.elaboratedBinds.computeIfAbsent(description, key -> OptimizedUtils.listCreate(1));
            values.add(elabPathWithOrigin);
            this.state.incrementNofBinds();
        }
    }

    void addDeferredParamValues(ElementPath hierarchyPath) {
        this.deferredParamValues.computeIfAbsent(hierarchyPath, key -> hierarchyPath);
    }

    public void addDeferredResolutionScope(IRfNamedElement defferedResolutionScope) {
        this.defferedResolutionScopes.add(defferedResolutionScope);
    }

    public Set<IRfNamedElement> getDeferredResolutionScope() {
        return this.defferedResolutionScopes;
    }

    boolean hasElaboratedBinds() {
        return this.elaboratedBinds != null && !this.elaboratedBinds.isEmpty();
    }

    Map<IRfInstanceElement, List<ElaboratedTargetPathWithOrigin>> getElaboratedBinds() {
        return this.elaboratedBinds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateElaboratedBindScopePath(IRfScopeElement scope, ElementPath hierarchyPath) {
        if (this.elaboratedBindScopePaths == null || scope == null) {
            return;
        }
        Object object = this.SYNC_MONITOR_BIND_SCOPES;
        synchronized (object) {
            BindWithElaboratedPaths bindsWithPaths = this.elaboratedBindScopePaths.get(scope);
            if (bindsWithPaths == null) {
                return;
            }
            bindsWithPaths.updateAllBindsWithPath(hierarchyPath);
        }
    }

    List<ElementPath> getElaboratedBindScopePaths(IRfScopeElement scope, IRfInstanceElement bind) {
        if (this.elaboratedBindScopePaths == null || scope == null || bind == null) {
            return null;
        }
        BindWithElaboratedPaths bindsWithPaths = this.elaboratedBindScopePaths.get(scope);
        if (bindsWithPaths == null) {
            return null;
        }
        return bindsWithPaths.getPathsForBind(bind);
    }

    private boolean hasPotentialBinds() {
        return this.potentialBindsByName != null && !this.potentialBindsByName.isEmpty() || this.potentialBindsByElement != null && !this.potentialBindsByElement.isEmpty();
    }

    List<PreElaboratedBindInstance> getPotentialBindsByName(String name) {
        if (this.potentialBindsByName == null || this.potentialBindsByName.isEmpty()) {
            return Collections.emptyList();
        }
        return this.potentialBindsByName.get(name);
    }

    List<PreElaboratedBindInstance> getPotentialBindsByElement(IRfNamedElement binding) {
        if (this.potentialBindsByElement == null || this.potentialBindsByElement.isEmpty()) {
            return Collections.emptyList();
        }
        return this.potentialBindsByElement.get(binding);
    }

    public IHidOperator computeIfAbsentResolvedMethodBody(IRfMethodElement methodElement, IHidEvaluationGuardian guardian, IHidEvaluator methodEvaluator) {
        if (methodElement == null || guardian == null || methodEvaluator == null || this.methodBodiesCache == null) {
            return null;
        }
        return this.methodBodiesCache.computeIfAbsent(methodElement, key -> {
            if (this.isPermanentElaboration()) {
                methodElement.resolveHidsForElaboration(this.config.semanticEnable);
            }
            return HidEvalConverter.INSTANCE.convertMethod(methodElement, guardian.copy(), methodEvaluator);
        });
    }

    public void prepareHotSwap() {
        if (this.methodBodiesCache != null) {
            this.methodBodiesCache.clear();
        }
    }

    public void addMethodCallResult(IRfMethodElement method, ELParamValues argValues, IELParamValue result) {
        if (this.methodCallResultCache == null) {
            return;
        }
        if (this.methodCallResultCache.size() < 10000) {
            this.methodCallResultCache.putIfAbsent(new MethodWithArguments(method, argValues), result);
        }
    }

    public IELParamValue getMethodCallResult(IRfMethodElement method, ELParamValues argValues) {
        if (this.methodCallResultCache == null) {
            return null;
        }
        this.state.incrementMethodTypeCacheCounts();
        IELParamValue result = this.methodCallResultCache.get(new MethodWithArguments(method, argValues));
        if (result != null) {
            this.state.incrementMethodTypeCacheHits();
            return result;
        }
        return null;
    }

    void cleanInstanceSupplierIncremental() {
        this.instanceSupplierIncremental = null;
    }

    ConcurrentHashMap<IRfNamedElement, ConcurrentHashMap<IRfInstanceElement, List<HidOperatorWrapper>>> getPortConnectionsCache() {
        return this.portConnectionsCache;
    }

    ConcurrentHashMap<IRfNamedElement, ConcurrentHashMap<IRfInstanceElement, List<HidOperatorWrapper>>> getParameterOverridesCache() {
        return this.parameterOverridesCache;
    }

    ConcurrentHashMap<IRfNamedElement, List<HidOperatorWrapper>> getDefparamsCache() {
        return this.defparamsCache;
    }

    void addSubInstanceCopyPath(ElementPath elementPath) {
        this.subInstanceCopiesCache.add(elementPath);
    }

    private void initDataTypeCache() {
        this.dataTypeContexts = new ConcurrentHashMap<Thread, Map<IDataType, BitVectorContext>>();
    }

    public Map<IDataType, BitVectorContext> getDataTypeCache(Thread thread) {
        if (this.dataTypeContexts == null) {
            return null;
        }
        return this.dataTypeContexts.get(thread);
    }

    public void resetDataTypeCache(Thread thread) {
        if (this.dataTypeContexts == null) {
            return;
        }
        this.dataTypeContexts.put(thread, new IdentityHashMap());
    }

    private void waitForHidOpsExecutor(boolean resolveHids) {
        try {
            if (this.executor == null) {
                return;
            }
            String nofThreadsText = String.valueOf(this.config.maxNofRecursionThreads) + " " + (this.config.maxNofRecursionThreads == 1 ? "thread" : "threads");
            this.logger.debug(ElaborationDebugZone.STATS, String.valueOf(resolveHids ? "Hids" : "Operators") + " executor is working on " + nofThreadsText + "...", new Object[0]);
            while (this.hidOpsExecutorIsWorking()) {
                try {
                    this.checkBuildCanceled(false, 20);
                }
                catch (BuildCancelException buildCancelException) {
                    this.state.throwBuildCancelException();
                }
                ELManager.delay(50L);
            }
            this.executor.shutdown();
            while (!this.executor.isTerminated()) {
                try {
                    this.checkBuildCanceled(false, 20);
                }
                catch (BuildCancelException buildCancelException) {
                    this.state.throwBuildCancelException();
                    this.executor.shutdownNow();
                }
                ELManager.delay(50L);
            }
            this.logger.debug(ElaborationDebugZone.STATS, String.valueOf(resolveHids ? "Hids" : "Operators") + " executor has finished.", new Object[0]);
            if (this.state.hasBuildCancelException()) {
                throw new BuildCancelException();
            }
            if (this.state.hasElaborationCancelException()) {
                throw new ElaborationCancelException();
            }
        }
        finally {
            this.executor = null;
        }
    }

    private boolean hidOpsExecutorIsWorking() {
        return !this.state.hasElaborationCancelException() && !this.state.hasBuildCancelException() && this.state.getNofDesignsHidOps() > this.state.getNofCompleteDesignsHidOps();
    }

    ConcurrentHashMap<IRfNamedElement, ConcurrentHashMap<ELSpecializationWrapper, ELSpecializationWrapper>> getCachedSpecsPerElement() {
        return this.specsPerElement;
    }

    ConcurrentHashMap<IELDescription, Set<ELSpecializationWrapper>> getCachedSpecsPerInstance() {
        return this.specsPerInstance;
    }

    public void checkBuildCanceled() throws BuildCancelException {
        this.checkBuildCanceled(false, 5000);
    }

    void checkBuildCanceled(boolean force, int count) throws BuildCancelException {
        if (force || this.nofBuildCanceledQueries % count == 0 && this.progressMonitor != null) {
            this.cachedBuildCanceled = this.progressMonitor.isCanceled();
            if (FIncrementalNotificationTracker.INSTANCE.isUpdating(this.mixedLangProject.getProject()) && FIncrementalNotificationFixer.INSTANCE.isCanceled()) {
                this.cachedBuildCanceled = true;
            }
        }
        if (this.mixedLangProject.hasCanceledGUITimer()) {
            this.cachedBuildCanceled = true;
        }
        ++this.nofBuildCanceledQueries;
        if (MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            throw new BuildCancelException();
        }
        if (this.cachedBuildCanceled) {
            throw new BuildCancelException();
        }
    }

    public void getTopDesignsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        Collection<? extends IRfInstanceElement> topInstances = this.$root.getLocalInstances();
        if (topInstances == null || topInstances.isEmpty()) {
            return;
        }
        for (IRfInstanceElement iRfInstanceElement : topInstances) {
            IRfNamedElement topDesign = iRfInstanceElement.getGenericDesign(null);
            if (!(topDesign instanceof IRfDesignElement) || prefix != null && !DVTStringUtil.regionMatches(topDesign.getName(), prefix, matchType)) continue;
            result.add(topDesign);
            if (elementFilter.resultMaxSize() != result.size()) continue;
            throw new MaxSizeReachedException();
        }
    }

    public IRfDesignElement getTopDesign(String name) {
        if (name == null) {
            return null;
        }
        Collection<? extends IRfInstanceElement> topInstances = this.$root.getLocalInstances();
        if (topInstances == null || topInstances.isEmpty()) {
            return null;
        }
        for (IRfInstanceElement iRfInstanceElement : topInstances) {
            IRfNamedElement topDesign = iRfInstanceElement.getGenericDesign(null);
            if (!(topDesign instanceof IRfDesignElement) || !name.equals(topDesign.getName())) continue;
            return (IRfDesignElement)topDesign;
        }
        return null;
    }

    public List<IRfDesignElement> getTopDesigns() {
        Collection<? extends IRfInstanceElement> topInstances = this.$root.getLocalInstances();
        if (topInstances == null || topInstances.isEmpty()) {
            return null;
        }
        ArrayList<IRfDesignElement> topDesigns = new ArrayList<IRfDesignElement>(topInstances.size());
        for (IRfInstanceElement iRfInstanceElement : topInstances) {
            IRfNamedElement topDesign = iRfInstanceElement.getGenericDesign(null);
            if (!(topDesign instanceof IRfDesignElement)) continue;
            topDesigns.add((IRfDesignElement)topDesign);
        }
        return topDesigns;
    }

    int getMaxNofBindsPasses() {
        return this.config.maxNofBindsPasses;
    }

    public int getLoopBlockCutoff() {
        return this.config.loopBlockCutoff;
    }

    public int getLoopStatementCutoff() {
        return this.config.loopStatementCutoff;
    }

    int getMaxDepth() {
        return this.config.maxDepth;
    }

    boolean shouldTriggerElabError() {
        return this.config.triggerElabError;
    }

    public byte getSemanticEnableRaw() {
        return this.config.semanticEnable;
    }

    public boolean getSemanticShowAliasName() {
        return this.config.semanticShowAliasName;
    }

    public void setDirtyMemory(boolean value) {
        this.hasDirtyMemory |= value;
    }

    public boolean hasDirtyMemory() {
        return this.hasDirtyMemory;
    }

    public boolean hasSimRelevantProblems() {
        return this.state.hasSimRelevantProblems();
    }

    public void addExternalConstants(IRfNamedElement scope, ELParamValues values) {
        this.constantsManager.addExternalConstants(scope, values);
    }

    public void removeExternalConstants(IRfNamedElement scope) {
        this.constantsManager.removeExternalConstants(scope);
    }

    public ELParamValues getExternalConstants(IRfNamedElement scope) {
        return this.constantsManager.getExternalConstants(scope);
    }

    public void addEnumTypeWrapper(IRfNamedElement element, ELEnumTypeWrapper enumType) {
        this.enumTypeWrapperCache.putIfAbsent(element, enumType);
    }

    public ELEnumTypeWrapper getEnumTypeWrapper(IRfNamedElement element) {
        return this.enumTypeWrapperCache.get(element);
    }

    void setInstanceSupplierIncremental(Function<ElementPath, ELInstance> supplier) {
        this.instanceSupplierIncremental = supplier;
    }

    void setAccumulatingIncremental(ConcurrentHashMap<IRfNamedElement, ConcurrentHashMap<ELSpecializationWrapper, ELSpecializationWrapper>> specsPerElement, ConcurrentHashMap<IELDescription, Set<ELSpecializationWrapper>> specsPerInstance, ConcurrentHashMap<ElementPath, ElementPath> deferredParamValues, Set<IRfNamedElement> defferedResolutionScopes) {
        this.specsPerElement = specsPerElement;
        this.specsPerInstance = specsPerInstance;
        this.deferredParamValues = deferredParamValues;
        this.defferedResolutionScopes = defferedResolutionScopes;
    }

    private static void delay(long waitTimeMillis) {
        try {
            Thread.sleep(waitTimeMillis);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void waitForExecutor() {
        try {
            if (this.executor == null) {
                return;
            }
            String nofThreadsText = String.valueOf(this.config.maxNofRecursionThreads) + " " + (this.config.maxNofRecursionThreads == 1 ? "thread" : "threads");
            this.logger.debug(ElaborationDebugZone.STATS, "Main executor is working on " + nofThreadsText + "...", new Object[0]);
            while (this.executorIsWorking()) {
                try {
                    this.checkBuildCanceled(false, 20);
                }
                catch (BuildCancelException buildCancelException) {
                    this.state.throwBuildCancelException();
                }
                ELManager.delay(50L);
            }
            this.executor.shutdown();
            while (!this.executor.isTerminated()) {
                try {
                    this.checkBuildCanceled(false, 20);
                }
                catch (BuildCancelException buildCancelException) {
                    this.state.throwBuildCancelException();
                    this.executor.shutdownNow();
                }
                ELManager.delay(50L);
            }
            this.logger.debug(ElaborationDebugZone.STATS, "Main executor has finished.", new Object[0]);
            if (this.state.hasBuildCancelException()) {
                throw new BuildCancelException();
            }
            if (this.state.hasElaborationCancelException()) {
                throw new ElaborationCancelException();
            }
        }
        finally {
            this.executor = null;
        }
    }

    private boolean executorIsWorking() {
        return !this.state.hasElaborationCancelException() && !this.state.hasBuildCancelException() && this.state.getNofInstances() > this.state.getNofCompleteInstances();
    }

    boolean recursion(List<ELInstanceInContext> newTopInstances) {
        if (newTopInstances == null || newTopInstances.isEmpty()) {
            return false;
        }
        int workSize = newTopInstances.size();
        if (this.config.maxNofRecursionThreads < 2 || this.executor == null || workSize == 1) {
            this.checkBuildCanceled();
            if (this.state.hasBuildCancelException()) {
                throw new BuildCancelException();
            }
            if (this.state.hasElaborationCancelException()) {
                throw new ElaborationCancelException();
            }
            this.logger.debug(ElaborationDebugZone.STATS, "Resolving", workSize, "generate(s) in chunks of", workSize, "on", this.config.maxNofRecursionThreads, "thread(s)");
            this.resolve(newTopInstances, this);
            return true;
        }
        int chunkSize = workSize / this.config.maxNofRecursionThreads;
        if (workSize % this.config.maxNofRecursionThreads > 0) {
            ++chunkSize;
        }
        int finalChunkSize = chunkSize;
        this.logger.debug(ElaborationDebugZone.STATS, "Resolving", workSize, "generate(s) in chunks of", finalChunkSize, "on", this.config.maxNofRecursionThreads, "thread(s)");
        int i = 0;
        while (i < workSize) {
            this.checkBuildCanceled();
            if (this.state.hasBuildCancelException()) {
                throw new BuildCancelException();
            }
            if (this.state.hasElaborationCancelException()) {
                throw new ElaborationCancelException();
            }
            int index = i;
            Runnable worker = () -> {
                List<ELInstanceInContext> sublist = newTopInstances.subList(index, Math.min(index + finalChunkSize, workSize));
                this.resolve(sublist, this);
            };
            this.executor.execute(worker);
            i += chunkSize;
        }
        return true;
    }

    public IRfSingleLangProject getStartingVLOGProject() {
        return this.getSingleLangProjectParent(LanguageKind.VLOG);
    }

    public IRfSingleLangProject getStartingVHDLProject() {
        return this.getSingleLangProjectParent(LanguageKind.VHDL);
    }

    public void reportProblemForElement(ElaborationDebugZone zone, boolean isSimRelevant, String pattern, IRfNamedElement source, ElementPath hierarchyPath, Object ... arguments) {
        try {
            if (zone == null) {
                throw new IllegalArgumentException("Elaboration debug zone cannot be null");
            }
            if (!this.shouldTriggerElabError()) {
                return;
            }
            if (!this.isPermanentElaboration()) {
                return;
            }
            if (this.state.checkNofProblemsLimit(zone, this.config.maxNofProblemsPerZone)) {
                return;
            }
            if (source == null || source.getName() == null) {
                return;
            }
            IRfDefElement declaration = source.getDeclaration();
            if (declaration == null) {
                return;
            }
            IRfSingleLangProject rfProject = source.getRfProject();
            if (rfProject == null) {
                return;
            }
            try {
                int offsetStart = declaration.getLabelStartOffset();
                int offsetEnd = offsetStart + source.getName().length();
                int line = declaration.getLabelStartLine();
                StringBuilder mb = new StringBuilder().append(pattern);
                if (hierarchyPath != null && this.config.appendHierarchyPathInProblemMessage) {
                    mb.append("[").append(hierarchyPath.toString()).append("]");
                }
                rfProject.addSemanticError(this.getElaborationProblemSeverity(), mb.toString(), source.getLibPkgScope(), offsetStart, offsetEnd, null, line, declaration.getParserPath(), arguments);
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
        }
        finally {
            if (isSimRelevant) {
                this.state.setHasSimRelevantProblems();
            }
        }
    }

    public void reportProblem(ElaborationDebugZone zone, boolean isSimRelevant, String pattern, IRfNamedElement source, IRfDefElement declaration, int offsetStart, int offsetEnd, int line, Map<String, Object> attributes, ElementPath hierarchyPath, Object ... arguments) {
        this.reportProblem(this.getElaborationProblemSeverity(), zone, isSimRelevant, pattern, source, declaration, offsetStart, offsetEnd, line, attributes, hierarchyPath, arguments);
    }

    public void reportProblem(int problemType, ElaborationDebugZone zone, boolean isSimRelevant, String pattern, IRfNamedElement source, IRfDefElement declaration, int offsetStart, int offsetEnd, int line, Map<String, Object> attributes, ElementPath hierarchyPath, Object ... arguments) {
        try {
            if (zone == null) {
                throw new IllegalArgumentException("Elaboration debug zone cannot be null");
            }
            if (!this.shouldTriggerElabError()) {
                return;
            }
            if (!this.isPermanentElaboration()) {
                return;
            }
            if (this.state.checkNofProblemsLimit(zone, this.config.maxNofProblemsPerZone)) {
                return;
            }
            if (source == null || declaration == null) {
                return;
            }
            IRfSingleLangProject rfProject = source.getRfProject();
            if (rfProject == null) {
                return;
            }
            try {
                StringBuilder mb = new StringBuilder().append(pattern);
                if (hierarchyPath != null && this.config.appendHierarchyPathInProblemMessage) {
                    mb.append("[").append(hierarchyPath.toString()).append("]");
                }
                rfProject.addSemanticError(problemType, mb.toString(), source.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, declaration.getParserPath(), arguments);
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
        }
        finally {
            if (isSimRelevant) {
                this.state.setHasSimRelevantProblems();
            }
        }
    }

    public void reportEvalProblem(UnknownEvaluationException evalEx, ELConstants.EvalExceptionZone evalZone, IRfNamedElement element, ElementPath hierarchyPath) {
        try {
            int offsetEnd;
            int offsetStart;
            HidOccurrence occurrence;
            int line;
            if (!this.state.allowEval) {
                return;
            }
            if (!this.shouldTriggerElabError()) {
                return;
            }
            if (!this.isPermanentElaboration()) {
                return;
            }
            if (this.state.checkNofProblemsLimit(ElaborationDebugZone.EVAL, this.config.maxNofProblemsPerZone)) {
                return;
            }
            if (element == null) {
                return;
            }
            IRfDefElement declaration = element.getDeclaration();
            if (declaration == null) {
                return;
            }
            IRfSingleLangProject rfProject = element.getRfProject();
            if (rfProject == null) {
                return;
            }
            if (evalEx instanceof UnknownScopeEvaluationException) {
                UnknownScopeEvaluationException ex = (UnknownScopeEvaluationException)evalEx;
                int line2 = ex.getLine();
                int offsetStart2 = ex.getOffset();
                int offsetEnd2 = offsetStart2 + 1;
                StringBuilder mb = new StringBuilder().append("UNKNOWN_EXPRESSION: Could not determine expression: {0} [{1}]");
                if (hierarchyPath != null && this.config.appendHierarchyPathInProblemMessage) {
                    mb.append("[").append(hierarchyPath.toString()).append("]");
                }
                rfProject.addSemanticError(1, mb.toString(), element.getLibPkgScope(), offsetStart2, offsetEnd2, null, line2, declaration.getParserPath(), new Object[]{evalEx.getMessage(), evalZone});
                return;
            }
            if (!(evalEx instanceof UnknownHidObjectEvaluationException)) {
                return;
            }
            UnknownHidObjectEvaluationException ex = (UnknownHidObjectEvaluationException)evalEx;
            IHidObject causeObject = ex.getCauseObject();
            if (HidUtils.isHidAccess(causeObject)) {
                causeObject = ((HidAccess)causeObject).getParentHid();
            }
            if ((line = HidUtils.getLine(occurrence = causeObject instanceof IHidOccurrenceHolder ? ((IHidOccurrenceHolder)((Object)causeObject)).getOccurrence() : null)) < 0) {
                line = declaration.getStartLine();
            }
            if ((offsetStart = HidUtils.getStartOffset(occurrence)) < 0) {
                offsetStart = declaration.getStartOffset();
            }
            if ((offsetEnd = HidUtils.getEndOffset(causeObject, offsetStart, occurrence)) < 0) {
                offsetEnd = offsetStart + 1;
            }
            if (evalEx instanceof OverflowDimensionEvaluationException) {
                String problematicRangeString = HidUtils.toStringBuilder(causeObject, true, true, false, true, true, false, element.getLanguageKind()).toString();
                String elementName = evalEx.getMessage();
                rfProject.addSemanticError(1, "ARRAY_DIMENSION_OVERFLOW: Array dimension ''{0}'' of ''{1}'' overflows integer range", element.getLibPkgScope(), offsetStart, offsetEnd, null, line, declaration.getParserPath(), problematicRangeString, elementName);
                return;
            }
            try {
                StringBuilder mb = new StringBuilder().append(evalEx instanceof DisabledMethodEvaluationException ? "DISABLED_METHOD_CALL_EVAL: Disabled method call ''{0}'' [{1}]" : (evalEx instanceof MaxLoopCountEvaluationException ? "MAX_COUNT_LOOP_STATEMENT: Max loop count ''{0}'' exceeded (increase limit with directive +dvt_elaboration_loop_statement_cutoff) [{1}]" : "UNKNOWN_EXPRESSION: Could not determine expression: {0} [{1}]"));
                if (hierarchyPath != null && this.config.appendHierarchyPathInProblemMessage) {
                    mb.append("[").append(hierarchyPath.toString()).append("]");
                }
                rfProject.addSemanticError(1, mb.toString(), element.getLibPkgScope(), offsetStart, offsetEnd, null, line, declaration.getParserPath(), new Object[]{evalEx.getMessage(), evalZone});
            }
            catch (Exception ex2) {
                DVTLogger.INSTANCE.logError((Throwable)evalEx);
                DVTLogger.INSTANCE.logError((Throwable)ex2);
            }
        }
        finally {
            if (evalEx instanceof DisabledMethodEvaluationException || evalEx instanceof MaxLoopCountEvaluationException || evalEx instanceof OverflowDimensionEvaluationException) {
                this.state.setHasSimRelevantProblems();
            }
        }
    }

    public void printMemory() {
        if (!this.state.debugZones.contains(ElaborationDebugZone.MEMORY)) {
            return;
        }
        this.mem.print(this, -1);
    }

    private void printStats() {
        if (!this.state.allowStats) {
            return;
        }
        if (this.state.getNofDesignSpecs() == 0) {
            this.state.increaseDesignSpecsCount(this.specsPerElement);
        }
        if (this.state.getNofInstanceSpecs() == 0) {
            this.state.increaseInstanceSpecsCount(this.specsPerInstance);
        }
        this.logger.debug(ElaborationDebugZone.STATS, this.state.toString(), DVTBuildConsoleCommon.MessageSink.REPORT, new Object[0]);
    }

    private int getElaborationProblemSeverity() {
        return this.state.allowEval ? 1 : 2;
    }

    public String testGetElaborationMemory() {
        String result = this.mem.toString(this, -1);
        return result.substring(1);
    }

    static class BindWithElaboratedPaths {
        Map<IRfInstanceElement, List<ElementPath>> content = new IdentityHashMap<IRfInstanceElement, List<ElementPath>>();

        private BindWithElaboratedPaths() {
        }

        void addPreElaboratedBind(IRfInstanceElement bind, List<ElementPath> paths) {
            this.content.put(bind, paths);
        }

        void updateAllBindsWithPath(ElementPath hierarchyPath) {
            for (Map.Entry<IRfInstanceElement, List<ElementPath>> entry : this.content.entrySet()) {
                List<ElementPath> value = entry.getValue();
                if (value == null) continue;
                value.add(hierarchyPath);
            }
        }

        List<ElementPath> getPathsForBind(IRfInstanceElement bind) {
            return this.content.get(bind);
        }
    }

    static class BindWithOrigin {
        public final IRfInstanceElement bind;
        public final ElementPath origin;
        public final int passCount;

        private BindWithOrigin(IRfInstanceElement bind, ElementPath origin, int masterCount) {
            this.bind = bind;
            this.origin = origin;
            this.passCount = masterCount;
        }

        public static BindWithOrigin of(IRfInstanceElement bind, ElementPath origin, int masterCount) {
            if (bind == null || origin == null) {
                return null;
            }
            return new BindWithOrigin(bind, origin, masterCount);
        }

        public String toString() {
            return this.origin + " -> " + this.bind;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.bind == null ? 0 : this.bind.hashCode());
            result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
            result = 31 * result + this.passCount;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BindWithOrigin other = (BindWithOrigin)obj;
            if (this.bind == null ? other.bind != null : !this.bind.equals(other.bind)) {
                return false;
            }
            if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
                return false;
            }
            return this.passCount == other.passCount;
        }
    }

    static class ElaboratedTargetPathWithOrigin {
        public final ElementPath targetPath;
        public final ELBindElementPath.ELBindElementPathKind kind;
        public final ElementPath origin;

        private ElaboratedTargetPathWithOrigin(ElementPath targetPath, ELBindElementPath.ELBindElementPathKind kind, ElementPath origin) {
            this.targetPath = targetPath;
            this.kind = kind;
            this.origin = origin;
        }

        static ElaboratedTargetPathWithOrigin of(ElementPath targetPath, ELBindElementPath.ELBindElementPathKind kind, ElementPath origin) {
            if (targetPath == null || kind == null || origin == null) {
                return null;
            }
            return new ElaboratedTargetPathWithOrigin(targetPath, kind, origin);
        }

        public String toString() {
            return this.origin + "#" + (Object)((Object)this.kind) + "#" + this.targetPath;
        }
    }

    static class MethodWithArguments {
        public final IRfNamedElement method;
        public final ELParamValues argValues;

        private MethodWithArguments(IRfNamedElement method, ELParamValues argValues) {
            this.method = method;
            this.argValues = argValues;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            result = 31 * result + (this.argValues == null ? 0 : this.argValues.internalHashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodWithArguments other = (MethodWithArguments)obj;
            if (!Objects.equals(this.method, other.method)) {
                return false;
            }
            if (this.argValues == null) {
                return other.argValues == null;
            }
            return this.argValues.internalEquals(other.argValues);
        }

        public String toString() {
            return String.valueOf(this.method != null ? this.method.toString() : "null") + " - " + (this.argValues != null ? this.argValues.toString() : "null");
        }
    }

    static class PreElaboratedBindInstance {
        public final IRfInstanceElement description;
        public final ELBindElementPath preElab;

        private PreElaboratedBindInstance(IRfInstanceElement description, ELBindElementPath targetPathWithKind) {
            this.description = description;
            this.preElab = targetPathWithKind;
        }

        public static PreElaboratedBindInstance of(IRfInstanceElement description, ELBindElementPath targetPathWithKind) {
            if (description == null || targetPathWithKind == null) {
                return null;
            }
            return new PreElaboratedBindInstance(description, targetPathWithKind);
        }

        public String toString() {
            return this.preElab + " -> " + this.description;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.preElab == null ? 0 : this.preElab.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PreElaboratedBindInstance other = (PreElaboratedBindInstance)obj;
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            return !(this.preElab == null ? other.preElab != null : !this.preElab.equals(other.preElab));
        }
    }
}

