/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.ElaborationControl;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.buildconfig.ElaborationKind;
import ro.amiq.dvt.buildconfig.ElaborationSkipInstanceFilter;
import ro.amiq.dvt.buildconfig.ElaborationSkipModuleFilter;
import ro.amiq.dvt.buildconfig.ElaborationSkipPathFilter;
import ro.amiq.dvt.buildconfig.FullChecksAndLibs;
import ro.amiq.dvt.buildconfig.FullChecksKind;
import ro.amiq.dvt.buildconfig.MinTypMax;

public class ELManagerConfiguration {
    protected final int maxDepth;
    protected final int maxNofRecursionThreads;
    protected final boolean triggerElabError;
    protected final ElaborationKind elaborationKind;
    protected final EnumSet<ElaborationControl> controlSet;
    protected final byte semanticEnable;
    protected final FullChecksAndLibs fullChecksKind;
    protected final boolean semanticShowAliasName;
    protected final int maxReccurenceDepth;
    protected final int maxNofBindsPasses;
    protected final int maxNofProblemsPerZone;
    protected final int loopBlockCutoff;
    protected final int loopStatementCutoff;
    protected final ElaborationSkipModuleFilter skipModulesFilter;
    protected final ElaborationSkipPathFilter skipPathsFilter;
    protected final ElaborationSkipInstanceFilter skipInstancesFilter;
    protected final ElaborationSkipModuleFilter bboxModulesFilter;
    protected final ElaborationSkipPathFilter bboxPathsFilter;
    protected final ElaborationSkipInstanceFilter bboxInstancesFilter;
    protected final boolean skipLongExpressions;
    protected final boolean skipDefparams;
    protected final boolean elabWidthCheckDisabled;
    protected final boolean elabWidthCheckFiltered;
    protected final Set<ElaborationExpressionControl> expressionControl;
    protected final Set<String> expressionOperatorControl;
    protected final boolean methodEvalDisabled;
    protected final boolean markElabHidObjects;
    protected final MinTypMax minTypMaxSelection;
    protected final boolean appendHierarchyPathInProblemMessage;

    public static ELManagerConfiguration newElabConfig(IProject project) {
        int maxDepth = Integer.MAX_VALUE;
        int maxNofThreads = BuildConfigManager.getElaborationMaxNofRecursionThreads(project);
        boolean triggerElabError = true;
        byte semanticEnable = 3;
        ElaborationKind elaborationKind = BuildConfigManager.getElaborationKind(project);
        int maxReccurenceDepth = BuildConfigManager.getElaborationMaxRecurrenceDepth(project);
        int maxNofBindsPasses = BuildConfigManager.getElaborationMaxNofBindPasses(project);
        int maxNofProblemsPerZone = BuildConfigManager.getElaborationMaxNofProblemsPerZone(project);
        int loopBlockCutoff = BuildConfigManager.getElaborationLoopBlockCutoff(project);
        int loopStatementCutoff = BuildConfigManager.getElaborationLoopStatementCutoff(project);
        ElaborationSkipModuleFilter skipModulesFilter = BuildConfigManager.getElaborationSkipModulesFilter(project);
        ElaborationSkipPathFilter skipPathsFilter = BuildConfigManager.getElaborationSkipPathsFilter(project);
        ElaborationSkipInstanceFilter skipInstancesFilter = BuildConfigManager.getElaborationSkipInstancesFilter(project);
        ElaborationSkipModuleFilter bboxModulesFilter = BuildConfigManager.getElaborationBBoxModulesFilter(project);
        ElaborationSkipPathFilter bboxPathsFilter = BuildConfigManager.getElaborationBBoxPathsFilter(project);
        ElaborationSkipInstanceFilter bboxInstancesFilter = BuildConfigManager.getElaborationBBoxInstancesFilter(project);
        boolean skipLongExpressions = BuildConfigManager.isElaborationSkipLongExpressions(project);
        boolean skipDefparams = BuildConfigManager.isElaborationSkipDefparams(project);
        boolean semanticShowAliasName = DVTPlugin.getDefault().getPreferenceStore().getBoolean("semantic.show.alias.name");
        Set<ElaborationExpressionControl> expressionControl = BuildConfigManager.getElaborationExpressionControl(project);
        Set<String> expressionOperatorControl = BuildConfigManager.getElaborationExpressionOperatorControl(project);
        boolean methodEvalDisabled = BuildConfigManager.isElabDisabledMethodEvaluation(project);
        FullChecksAndLibs fullChecksKind = BuildConfigManager.getFullCompileChecks(project);
        boolean elabWidthCheckDisabled = BuildConfigManager.isElaborationWidthMismatchDisabled(project);
        boolean elabWidthCheckFiltered = BuildConfigManager.isElaborationFilterWidthMismatch(project);
        EnumSet<ElaborationControl> controlSet = BuildConfigManager.getElaborationControl(project);
        boolean markEvaluatedHidObjects = BuildConfigManager.isPrecompiledDbSaveMode(project);
        MinTypMax minTypMaxSelection = BuildConfigManager.getMinTypMaxSelection(project);
        return new ELManagerConfiguration(maxDepth, maxNofThreads, triggerElabError, semanticEnable, elaborationKind, maxReccurenceDepth, maxNofBindsPasses, maxNofProblemsPerZone, loopBlockCutoff, loopStatementCutoff, semanticShowAliasName, skipDefparams, skipModulesFilter, skipPathsFilter, skipInstancesFilter, bboxModulesFilter, bboxPathsFilter, bboxInstancesFilter, skipLongExpressions, expressionControl, expressionOperatorControl, markEvaluatedHidObjects, methodEvalDisabled, fullChecksKind, elabWidthCheckDisabled, elabWidthCheckFiltered, minTypMaxSelection, controlSet);
    }

    public static ELManagerConfiguration newElabLocalConfig(IProject project, int maxDepth, byte semanticEnable, boolean semanticShowAliasName, int loopBlockCutoff, int loopStatementCutoff, boolean markElabHidObjects, EnumSet<ElaborationControl> controlSet) {
        int maxReccurenceDepth = BuildConfigManager.getElaborationMaxRecurrenceDepth(project);
        boolean skipLongExpressions = BuildConfigManager.isElaborationSkipLongExpressions(project);
        boolean skipDefparams = BuildConfigManager.isElaborationSkipDefparams(project);
        Set<ElaborationExpressionControl> expressionControl = BuildConfigManager.getElaborationExpressionControl(project);
        Set<String> expressionOperatorControl = BuildConfigManager.getElaborationExpressionOperatorControl(project);
        boolean methodEvalDisabled = BuildConfigManager.isElabDisabledMethodEvaluation(project);
        FullChecksAndLibs fullChecksKind = BuildConfigManager.getFullCompileChecks(project);
        MinTypMax minTypMaxSelection = BuildConfigManager.getMinTypMaxSelection(project);
        return new ELManagerConfiguration(maxDepth, 1, false, semanticEnable, ElaborationKind.ADAPTIVE, maxReccurenceDepth, 0, Integer.MAX_VALUE, loopBlockCutoff, loopStatementCutoff, semanticShowAliasName, skipDefparams, null, null, null, null, null, null, skipLongExpressions, expressionControl, expressionOperatorControl, markElabHidObjects, methodEvalDisabled, fullChecksKind, true, true, minTypMaxSelection, controlSet);
    }

    public static ELManagerConfiguration newNonElabConfig() {
        return new ELManagerConfiguration(1, 0, false, 1, ElaborationKind.ADAPTIVE, 0, 0, Integer.MAX_VALUE, 0, 0, DVTPlugin.getDefault().getPreferenceStore().getBoolean("semantic.show.alias.name"), true, null, null, null, null, null, null, false, EnumSet.noneOf(ElaborationExpressionControl.class), Collections.emptySet(), false, true, new FullChecksAndLibs(FullChecksKind.OFF, null), true, true, MinTypMax.TYP, ElaborationControl.UNELABORATED_CONTROL_SET);
    }

    public static ELManagerConfiguration newUpdateConfig(ELManagerConfiguration original, int depth) {
        return new ELManagerConfiguration(depth, 1, original.triggerElabError, original.semanticEnable, ElaborationKind.ADAPTIVE, original.maxReccurenceDepth, original.maxNofBindsPasses, original.maxNofProblemsPerZone, original.loopBlockCutoff, original.loopStatementCutoff, original.semanticShowAliasName, original.skipDefparams, original.skipModulesFilter, original.skipPathsFilter, original.skipInstancesFilter, original.bboxModulesFilter, original.bboxPathsFilter, original.bboxInstancesFilter, original.skipLongExpressions, original.expressionControl, original.expressionOperatorControl, original.markElabHidObjects, original.methodEvalDisabled, original.fullChecksKind, original.elabWidthCheckDisabled, original.elabWidthCheckFiltered, original.minTypMaxSelection, original.controlSet);
    }

    public static ELManagerConfiguration newDummyWithControlConfig(boolean skipLongExpression, Set<ElaborationExpressionControl> expressionControl, Set<String> expressionOperatorControl, boolean methodEvalDisabled) {
        return new ELManagerConfiguration(Integer.MAX_VALUE, 1, false, 0, ElaborationKind.ADAPTIVE, 2, 0, Integer.MAX_VALUE, 200, 1000, false, true, null, null, null, null, null, null, skipLongExpression, expressionControl, expressionOperatorControl, false, methodEvalDisabled, new FullChecksAndLibs(FullChecksKind.OFF, null), true, true, MinTypMax.TYP, EnumSet.noneOf(ElaborationControl.class));
    }

    public static ELManagerConfiguration newXVlogConfig(IProject project) {
        MinTypMax minTypMaxSelection = BuildConfigManager.getMinTypMaxSelection(project);
        return new ELManagerConfiguration(Integer.MAX_VALUE, 1, false, 3, ElaborationKind.ADAPTIVE, 2, 0, Integer.MAX_VALUE, 200, 1000, false, true, null, null, null, null, null, null, false, Collections.emptySet(), Collections.emptySet(), false, false, new FullChecksAndLibs(FullChecksKind.OFF, null), true, true, minTypMaxSelection, EnumSet.noneOf(ElaborationControl.class));
    }

    public ELManagerConfiguration(int maxDepth, int maxNofRecursionThreads, boolean triggerElabError, byte semanticEnable, ElaborationKind elaborationKind, int maxReccurenceDepth, int maxNofBindsPasses, int maxNofProblemsPerZone, int loopBlockCutoff, int loopStatementCutoff, boolean semanticShowAliasName, boolean skipDefparams, ElaborationSkipModuleFilter skipModulesFilter, ElaborationSkipPathFilter skipPathsFilter, ElaborationSkipInstanceFilter skipInstancesFilter, ElaborationSkipModuleFilter bboxModulesFilter, ElaborationSkipPathFilter bboxPathsFilter, ElaborationSkipInstanceFilter bboxInstancesFilter, boolean skipLongExpressions, Set<ElaborationExpressionControl> expressionControl, Set<String> expressionOperatorControl, boolean markElabHidObjects, boolean methodEvalDisabled, FullChecksAndLibs fullChecksKind, boolean elabWidthCheckDisabled, boolean elabWidthCheckFiltered, MinTypMax minTypMaxSelection, EnumSet<ElaborationControl> controlSet) {
        this.maxDepth = maxDepth;
        this.maxNofRecursionThreads = maxNofRecursionThreads;
        this.triggerElabError = triggerElabError;
        this.fullChecksKind = fullChecksKind;
        this.semanticEnable = semanticEnable;
        this.elaborationKind = elaborationKind;
        this.maxReccurenceDepth = maxReccurenceDepth;
        this.maxNofBindsPasses = maxNofBindsPasses;
        this.maxNofProblemsPerZone = maxNofProblemsPerZone;
        this.loopBlockCutoff = loopBlockCutoff;
        this.loopStatementCutoff = loopStatementCutoff;
        this.skipLongExpressions = skipLongExpressions;
        this.skipDefparams = skipDefparams;
        this.semanticShowAliasName = semanticShowAliasName;
        this.markElabHidObjects = markElabHidObjects;
        this.expressionControl = expressionControl;
        this.expressionOperatorControl = expressionOperatorControl;
        this.methodEvalDisabled = methodEvalDisabled;
        this.skipModulesFilter = skipModulesFilter;
        this.skipPathsFilter = skipPathsFilter;
        this.skipInstancesFilter = skipInstancesFilter;
        this.bboxModulesFilter = bboxModulesFilter;
        this.bboxPathsFilter = bboxPathsFilter;
        this.bboxInstancesFilter = bboxInstancesFilter;
        this.elabWidthCheckDisabled = elabWidthCheckDisabled;
        this.elabWidthCheckFiltered = elabWidthCheckFiltered;
        this.minTypMaxSelection = minTypMaxSelection;
        this.controlSet = controlSet;
        this.appendHierarchyPathInProblemMessage = false;
    }
}

