/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.IELDescription;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class ELManagerState {
    protected final boolean allowAny;
    protected final boolean allowStats;
    protected final boolean allowEval;
    public final Set<ElaborationDebugZone> debugZones;
    private final AtomicInteger nofInstances = new AtomicInteger(0);
    private final AtomicInteger nofCompleteInstances = new AtomicInteger(0);
    private final AtomicInteger nofDesignsHidOps = new AtomicInteger(0);
    private final AtomicInteger nofCompleteDesignsHidOps = new AtomicInteger(0);
    private final int[] nofProblemsInZones = new int[ElaborationDebugZone.values().length];
    private final AtomicBoolean hasBuildCancelException = new AtomicBoolean(false);
    private final AtomicBoolean hasElaborationCancelException = new AtomicBoolean(false);
    private IRfNamedElement stackOverflowMethod;
    private final AtomicBoolean hasSimRelevantProblems = new AtomicBoolean();
    private final AtomicInteger loopCutoffValue = new AtomicInteger(0);
    private final AtomicInteger loopStatementCutoffValue = new AtomicInteger(0);
    private final AtomicInteger nofOptimizedInstances = new AtomicInteger(0);
    private final AtomicInteger nofResolvedInstances = new AtomicInteger(0);
    private final AtomicInteger nofBlocks = new AtomicInteger(0);
    private final AtomicInteger nofOptimizedBlocks = new AtomicInteger(0);
    private final AtomicInteger nofUserMethodCallsEvals = new AtomicInteger(0);
    private final AtomicInteger nofUserMethodCallsSuccEvals = new AtomicInteger(0);
    private final AtomicInteger nofSystemMethodCallsEvals = new AtomicInteger(0);
    private final AtomicInteger nofSystemMethodCallsSuccEvals = new AtomicInteger(0);
    private final AtomicInteger nofParameters = new AtomicInteger(0);
    private final AtomicInteger nofParameterEvals = new AtomicInteger(0);
    private final AtomicInteger maxNofParameters = new AtomicInteger(0);
    private final AtomicInteger maxNofParameterOverrides = new AtomicInteger(0);
    private final AtomicInteger nofParameterDefaultEvals = new AtomicInteger(0);
    private final AtomicInteger nofParameterSuccEvals = new AtomicInteger(0);
    private final AtomicInteger nofPotentialBinds = new AtomicInteger(0);
    private final AtomicInteger nofBinds = new AtomicInteger(0);
    private final AtomicInteger nofPotentialDefparams = new AtomicInteger(0);
    private final AtomicInteger nofDefparams = new AtomicInteger(0);
    private final AtomicInteger nofDataTypeCacheHits = new AtomicInteger(0);
    private final AtomicInteger nofDataTypeCacheCounts = new AtomicInteger(0);
    private final AtomicInteger nofMethodResultCacheHits = new AtomicInteger(0);
    private final AtomicInteger nofMethodResultCacheCounts = new AtomicInteger(0);
    private final AtomicInteger nofUniqueDesignsCount = new AtomicInteger(0);
    private final AtomicInteger nofDesignSpecsCount = new AtomicInteger(0);
    private final AtomicInteger nofInstanceSpecsCount = new AtomicInteger(0);
    private final AtomicInteger maxNofSpecsPerDesign = new AtomicInteger(0);

    public ELManagerState(Set<ElaborationDebugZone> zones) {
        this.debugZones = zones;
        this.allowAny = !zones.isEmpty();
        this.allowStats = zones.contains(ElaborationDebugZone.STATS);
        this.allowEval = zones.contains(ElaborationDebugZone.EVAL);
    }

    public void increaseNofInstances() {
        this.nofInstances.incrementAndGet();
    }

    public int getNofInstances() {
        return this.nofInstances.get();
    }

    public void setLoopCutoffs(int loopCutoff, int loopStatementCutoff) {
        this.loopCutoffValue.set(loopCutoff);
        this.loopStatementCutoffValue.set(loopStatementCutoff);
    }

    public void increaseNofOptimizedInstances() {
        if (!this.allowStats) {
            return;
        }
        this.nofOptimizedInstances.incrementAndGet();
    }

    public void increaseNofOptimizedBlocks() {
        if (!this.allowStats) {
            return;
        }
        this.nofOptimizedBlocks.incrementAndGet();
    }

    public void increaseNofDesignHidOps(int size) {
        this.nofDesignsHidOps.set(size);
    }

    public int getNofDesignsHidOps() {
        return this.nofDesignsHidOps.get();
    }

    public void increaseNofCompleteDesignsHidOps() {
        this.nofCompleteDesignsHidOps.incrementAndGet();
    }

    public void resetNofCompleteDesignsHidOps() {
        this.nofCompleteDesignsHidOps.set(0);
    }

    public int getNofCompleteDesignsHidOps() {
        return this.nofCompleteDesignsHidOps.get();
    }

    public void increaseNofCompleteInstances() {
        this.nofCompleteInstances.incrementAndGet();
    }

    public int getNofCompleteInstances() {
        return this.nofCompleteInstances.get();
    }

    public synchronized void setStackOverflowMethod(IRfNamedElement method) {
        if (method == null) {
            return;
        }
        this.stackOverflowMethod = method;
    }

    public synchronized IRfNamedElement getStackOverflowMethod() {
        return this.stackOverflowMethod;
    }

    public void setHasSimRelevantProblems() {
        if (!this.hasSimRelevantProblems.get()) {
            this.hasSimRelevantProblems.set(true);
        }
    }

    public boolean hasSimRelevantProblems() {
        return this.hasSimRelevantProblems.get();
    }

    public boolean checkNofProblemsLimit(ElaborationDebugZone zone, int limit) {
        int n = zone.ordinal();
        int n2 = this.nofProblemsInZones[n];
        this.nofProblemsInZones[n] = n2 + 1;
        return n2 > limit;
    }

    public void incrementNofBlocks() {
        if (!this.allowStats) {
            return;
        }
        this.nofBlocks.incrementAndGet();
    }

    public int getNofBlocks() {
        return this.nofBlocks.get();
    }

    public void throwBuildCancelException() {
        this.hasBuildCancelException.set(true);
    }

    public boolean hasBuildCancelException() {
        return this.hasBuildCancelException.get();
    }

    public void throwElaborationCancelException() {
        this.hasElaborationCancelException.set(true);
    }

    public boolean hasElaborationCancelException() {
        return this.hasElaborationCancelException.get();
    }

    public void increaseNofResolvedInstances() {
        if (!this.allowStats) {
            return;
        }
        this.nofResolvedInstances.incrementAndGet();
    }

    public void increaseNofParameters(int parameterCount) {
        if (!this.allowStats) {
            return;
        }
        this.nofParameters.addAndGet(parameterCount);
        this.maxNofParameters.updateAndGet(i -> parameterCount > i ? parameterCount : i);
    }

    public void maxNofParameterOverrides(int nofParameterOverides) {
        if (!this.allowStats) {
            return;
        }
        this.maxNofParameterOverrides.updateAndGet(i -> nofParameterOverides > i ? nofParameterOverides : i);
    }

    public void incrementNofPotentialBinds() {
        if (!this.allowStats) {
            return;
        }
        this.nofPotentialBinds.incrementAndGet();
    }

    public void incrementNofBinds() {
        if (!this.allowStats) {
            return;
        }
        this.nofBinds.incrementAndGet();
    }

    public void incrementNofPotentialDefparams() {
        if (!this.allowStats) {
            return;
        }
        this.nofPotentialDefparams.incrementAndGet();
    }

    public void incrementNofDefparams() {
        if (!this.allowStats) {
            return;
        }
        this.nofDefparams.incrementAndGet();
    }

    public void increaseNofParameterEvals(IELParamValue finalValue) {
        if (!this.allowStats) {
            return;
        }
        this.nofParameterEvals.incrementAndGet();
        if (ELUtils.isUnsuccessfulEval(finalValue)) {
            return;
        }
        this.nofParameterSuccEvals.incrementAndGet();
    }

    public void incrementNofParameterDefaultEvals() {
        if (!this.allowStats) {
            return;
        }
        this.nofParameterDefaultEvals.incrementAndGet();
    }

    public void incrementUserMethodCalls() {
        if (!this.allowStats) {
            return;
        }
        this.nofUserMethodCallsEvals.incrementAndGet();
    }

    public void incrementUserMethodCallsSuccEvals(IELParamValue finalValue) {
        if (!this.allowStats) {
            return;
        }
        if (ELUtils.isUnsuccessfulEval(finalValue)) {
            return;
        }
        this.nofUserMethodCallsSuccEvals.incrementAndGet();
    }

    public void incrementSystemMethodCallsEvals() {
        if (!this.allowStats) {
            return;
        }
        this.nofSystemMethodCallsEvals.incrementAndGet();
    }

    public void incrementSystemMethodCallsSuccEvals(IELParamValue finalValue) {
        if (!this.allowStats) {
            return;
        }
        if (ELUtils.isUnsuccessfulEval(finalValue)) {
            return;
        }
        this.nofSystemMethodCallsSuccEvals.incrementAndGet();
    }

    public void incrementDataTypeCacheHits() {
        if (!this.allowStats) {
            return;
        }
        this.nofDataTypeCacheHits.incrementAndGet();
    }

    public void incrementDataTypeCacheCounts() {
        if (!this.allowStats) {
            return;
        }
        this.nofDataTypeCacheCounts.incrementAndGet();
    }

    public void incrementMethodTypeCacheHits() {
        if (!this.allowStats) {
            return;
        }
        this.nofMethodResultCacheHits.incrementAndGet();
    }

    public void incrementMethodTypeCacheCounts() {
        if (!this.allowStats) {
            return;
        }
        this.nofMethodResultCacheCounts.incrementAndGet();
    }

    public int getNofDesignSpecs() {
        return this.nofDesignSpecsCount.get();
    }

    public int getNofInstanceSpecs() {
        return this.nofInstanceSpecsCount.get();
    }

    public void increaseDesignSpecsCount(Map<IRfNamedElement, ConcurrentHashMap<ELSpecializationWrapper, ELSpecializationWrapper>> specsPerDesign) {
        if (!this.allowStats) {
            return;
        }
        this.nofUniqueDesignsCount.set(specsPerDesign.size());
        this.nofDesignSpecsCount.set(0);
        int maxSize = 0;
        for (Map.Entry<IRfNamedElement, ConcurrentHashMap<ELSpecializationWrapper, ELSpecializationWrapper>> entry : specsPerDesign.entrySet()) {
            ConcurrentHashMap<ELSpecializationWrapper, ELSpecializationWrapper> value = entry.getValue();
            if (value == null) continue;
            int size = value.size();
            this.nofDesignSpecsCount.addAndGet(size);
            if (size <= maxSize) continue;
            maxSize = size;
        }
        this.maxNofSpecsPerDesign.set(maxSize);
    }

    public void increaseInstanceSpecsCount(Map<IELDescription, Set<ELSpecializationWrapper>> specsPerInstance) {
        if (!this.allowStats) {
            return;
        }
        this.nofInstanceSpecsCount.set(0);
        for (Map.Entry<IELDescription, Set<ELSpecializationWrapper>> entry : specsPerInstance.entrySet()) {
            Set<ELSpecializationWrapper> value = entry.getValue();
            if (value == null) continue;
            this.nofInstanceSpecsCount.addAndGet(value.size());
        }
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        StringBuilder builder = new StringBuilder();
        builder.append("\nElaboration Statistics:\n");
        builder.append("\nInstances: ").append(this.nofResolvedInstances).append("/").append(this.nofInstances);
        if (this.nofInstances.get() > 0) {
            builder.append(" (").append(this.nofInstances.get() - this.nofResolvedInstances.get()).append(" unresolved)");
            builder.append(" (").append(df.format((double)this.nofResolvedInstances.get() * 100.0 / (double)this.nofInstances.get())).append("%)");
        }
        builder.append("\nOptimized instances: ").append(this.nofOptimizedInstances).append("/").append(this.nofInstances);
        if (this.nofInstances.get() > 0) {
            builder.append(" (").append(this.nofInstances.get() - this.nofOptimizedInstances.get()).append(" unoptimized)");
            builder.append(" (").append(df.format((double)this.nofOptimizedInstances.get() * 100.0 / (double)this.nofInstances.get())).append("%)");
        }
        builder.append("\nParameters: ").append(this.nofParameters.get());
        builder.append("\nParameter evaluations: ").append(this.nofParameterSuccEvals).append("/").append(this.nofParameterEvals);
        if (this.nofParameterEvals.get() > 0) {
            builder.append(" (").append(this.nofParameterEvals.get() - this.nofParameterSuccEvals.get()).append(" unresolved)");
            builder.append(" (").append(df.format((double)this.nofParameterSuccEvals.get() * 100.0 / (double)this.nofParameterEvals.get())).append("%)");
        }
        builder.append("\nParameter default evaluations: ").append(this.nofParameterDefaultEvals.get());
        builder.append("\nMax nof parameters: ").append(this.maxNofParameters.get());
        builder.append("\nMax nof parameter overrides: ").append(this.maxNofParameterOverrides.get());
        builder.append("\nLoop cutoff: ").append(this.loopCutoffValue);
        builder.append("\nBlocks: ").append(this.nofBlocks);
        builder.append("\nOptimized Blocks: ").append(this.nofOptimizedBlocks).append("/").append(this.nofBlocks);
        if (this.nofBlocks.get() > 0) {
            builder.append(" (").append(this.nofBlocks.get() - this.nofOptimizedBlocks.get()).append(" unoptimized)");
            builder.append(" (").append(df.format((double)this.nofOptimizedBlocks.get() * 100.0 / (double)this.nofBlocks.get())).append("%)");
        }
        builder.append("\nPotential binds: ").append(this.nofPotentialBinds);
        builder.append("\nBinds: ").append(this.nofBinds);
        builder.append("\nPotential defparams: ").append(this.nofPotentialDefparams);
        builder.append("\nDefparams: ").append(this.nofDefparams);
        builder.append("\nUser method calls evaluations: ").append(this.nofUserMethodCallsSuccEvals).append("/").append(this.nofUserMethodCallsEvals);
        if (this.nofUserMethodCallsEvals.get() > 0) {
            builder.append(" (").append(this.nofUserMethodCallsEvals.get() - this.nofUserMethodCallsSuccEvals.get()).append(" unresolved)");
            builder.append(" (").append(df.format((double)this.nofUserMethodCallsSuccEvals.get() * 100.0 / (double)this.nofUserMethodCallsEvals.get())).append("%)");
        }
        builder.append("\nSystem method calls evaluations: ").append(this.nofSystemMethodCallsSuccEvals).append("/").append(this.nofSystemMethodCallsEvals);
        if (this.nofSystemMethodCallsEvals.get() > 0) {
            builder.append(" (").append(this.nofSystemMethodCallsEvals.get() - this.nofSystemMethodCallsSuccEvals.get()).append(" unresolved)");
            builder.append(" (").append(df.format((double)this.nofSystemMethodCallsSuccEvals.get() * 100.0 / (double)this.nofSystemMethodCallsEvals.get())).append("%)");
        }
        builder.append("\nLoop statement cutoff: ").append(this.loopStatementCutoffValue);
        builder.append("\nNof Unique Designs: ").append(this.nofUniqueDesignsCount);
        builder.append("\nNof Design Specs: ").append(this.nofDesignSpecsCount.get());
        builder.append("\nMax Specs per Design: ").append(this.maxNofSpecsPerDesign.get());
        builder.append("\nNof Instance Specs: ").append(this.nofInstanceSpecsCount.get());
        builder.append("\nDataType cache: ").append(this.nofDataTypeCacheHits).append("/").append(this.nofDataTypeCacheCounts);
        if (this.nofDataTypeCacheCounts.get() > 0) {
            builder.append(" (").append(df.format((double)this.nofDataTypeCacheHits.get() * 100.0 / (double)this.nofDataTypeCacheCounts.get())).append("%)");
        }
        builder.append("\nMethod Result cache: ").append(this.nofMethodResultCacheHits).append("/").append(this.nofMethodResultCacheCounts);
        if (this.nofMethodResultCacheCounts.get() > 0) {
            builder.append(" (").append(df.format((double)this.nofMethodResultCacheHits.get() * 100.0 / (double)this.nofMethodResultCacheCounts.get())).append("%)");
        }
        if (this.stackOverflowMethod instanceof IRfMethodElement) {
            builder.append("\nStackOverflow method: ");
            IRfScopeElement enclosingScope = this.stackOverflowMethod.getEnclosingScope();
            if (enclosingScope instanceof IRfNamedElement) {
                builder.append(((IRfNamedElement)enclosingScope).getNameAndEnclosing()).append(".").append(((IRfMethodElement)this.stackOverflowMethod).getFullName(false));
            } else {
                builder.append(((IRfMethodElement)this.stackOverflowMethod).getFullName(false));
            }
        }
        ElaborationDebugZone[] elaborationDebugZoneArray = ElaborationDebugZone.values();
        int n = elaborationDebugZoneArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElaborationDebugZone zone = elaborationDebugZoneArray[n2];
            builder.append("\nProblems (").append(zone).append("): ").append(this.nofProblemsInZones[zone.ordinal()]);
            ++n2;
        }
        builder.append("\n");
        builder.append("\nHeap size: ").append(DVTUtilsCommon.INSTANCE.convertByteToMb(Runtime.getRuntime().totalMemory())).append(" MB");
        builder.append("\n");
        return builder.toString();
    }
}

