/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELContext;
import ro.amiq.dvt.elaboration.core.ELGraph;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecialization;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.core.ELVHDLCore;
import ro.amiq.dvt.elaboration.core.ELVLOGCore;
import ro.amiq.dvt.elaboration.core.ElaborationCancelException;
import ro.amiq.dvt.elaboration.core.IELBindingFinder;
import ro.amiq.dvt.elaboration.model.ELBindElementPath;
import ro.amiq.dvt.elaboration.model.ELDimension;
import ro.amiq.dvt.elaboration.model.ELInstanceInContext;
import ro.amiq.dvt.elaboration.model.ELLiblist;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELDesign;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.ArrayOfInstancesBlockElement;
import ro.amiq.dvt.model.reflection.BaseConfigInfo;
import ro.amiq.dvt.model.reflection.DVTImplicitConfiguration;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidNameAndSelects;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.GenericValueUtils;
import ro.amiq.dvt.model.reflection.util.HidOperatorVisitorWithPaths;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.OptimizedIdentityHashSet;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.VhdlFunction;

public enum ELResolver {
    INSTANCE;


    /*
     * Unable to fully structure code
     */
    void resolve(Collection<ELInstanceInContext> tops, ELManager manager) {
        block9: {
            try {
                manager.checkBuildCanceled();
                graph = new ELGraph<ElementPath, ELInstanceInContext, ELParamValues>();
                generateTops = new ArrayList<ELInstanceInContext>(4);
                ELResolver.firstPass(tops, graph, manager);
                ELResolver.secondAndThirdPasses(tops, graph, generateTops, manager);
                ELResolver.recursion(generateTops, manager);
                break block9;
            }
            catch (BuildCancelException v0) {
                manager.state.throwBuildCancelException();
                break block9;
            }
            catch (ElaborationCancelException v1) {
                manager.state.throwElaborationCancelException();
                break block9;
            }
            catch (Exception ex) {
                manager.state.throwElaborationCancelException();
                DVTLogger.INSTANCE.logError((Throwable)ex);
                break block9;
            }
            catch (Error ex) {
                manager.state.throwElaborationCancelException();
                sb = new StringBuilder();
                stackOverflowMethod = manager.state.getStackOverflowMethod();
                if (stackOverflowMethod instanceof IRfMethodElement) {
                    enclosingScope = stackOverflowMethod.getEnclosingScope();
                    sb.append("After evaluating method ");
                    if (enclosingScope instanceof IRfNamedElement) {
                        sb.append(((IRfNamedElement)enclosingScope).getNameAndEnclosing()).append(".").append(((IRfMethodElement)stackOverflowMethod).getFullName(false));
                    } else {
                        sb.append(((IRfMethodElement)stackOverflowMethod).getFullName(false));
                    }
                }
                sb.append(" Unexpected exception ").append(ex.getClass().getCanonicalName());
                stackTrace = ex.getStackTrace();
                i = 0;
                ** while (i < stackTrace.length)
            }
lbl-1000:
            // 1 sources

            {
                stackText = stackTrace[i].toString();
                sb.append("\n\tat ").append(stackText);
                ++i;
                continue;
            }
lbl43:
            // 1 sources

            DVTLogger.INSTANCE.logError(sb.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    void resolveOnePass(Collection<ELInstanceInContext> tops, ELManager manager) {
        block9: {
            try {
                manager.checkBuildCanceled();
                ELResolver.firstSecondAndThirdPasses(tops, manager);
                break block9;
            }
            catch (BuildCancelException v0) {
                manager.state.throwBuildCancelException();
                break block9;
            }
            catch (ElaborationCancelException v1) {
                manager.state.throwElaborationCancelException();
                break block9;
            }
            catch (Exception ex) {
                manager.state.throwElaborationCancelException();
                DVTLogger.INSTANCE.logError((Throwable)ex);
                break block9;
            }
            catch (Error ex) {
                manager.state.throwElaborationCancelException();
                sb = new StringBuilder();
                stackOverflowMethod = manager.state.getStackOverflowMethod();
                if (stackOverflowMethod instanceof IRfMethodElement) {
                    enclosingScope = stackOverflowMethod.getEnclosingScope();
                    sb.append("After evaluating method ");
                    if (enclosingScope instanceof IRfNamedElement) {
                        sb.append(((IRfNamedElement)enclosingScope).getNameAndEnclosing()).append(".").append(((IRfMethodElement)stackOverflowMethod).getFullName(false));
                    } else {
                        sb.append(((IRfMethodElement)stackOverflowMethod).getFullName(false));
                    }
                }
                sb.append(" Unexpected exception ").append(ex.getClass().getCanonicalName());
                stackTrace = ex.getStackTrace();
                i = 0;
                ** while (i < stackTrace.length)
            }
lbl-1000:
            // 1 sources

            {
                stackText = stackTrace[i].toString();
                sb.append("\n\tat ").append(stackText);
                ++i;
                continue;
            }
lbl39:
            // 1 sources

            DVTLogger.INSTANCE.logError(sb.toString());
        }
    }

    private static void firstPass(Collection<ELInstanceInContext> tops, ELGraph<ElementPath, ELInstanceInContext, ELParamValues> graph, ELManager manager) {
        for (ELInstanceInContext top : tops) {
            ELResolver.firstPassDFS(top, graph, manager);
        }
    }

    private static void firstPassDFS(ELInstanceInContext instanceInContext, ELGraph<ElementPath, ELInstanceInContext, ELParamValues> graph, ELManager manager) {
        manager.checkBuildCanceled();
        manager.logger.debug(ElaborationDebugZone.FIRST_PASS, "\n**** Instance: ", instanceInContext);
        graph.addVertex(instanceInContext, manager);
        ELInstance instance = instanceInContext.instance;
        ELResolver.resolveVHDLPackageComponent(instance, manager);
        ELResolver.computeOrGetBinding(instanceInContext, manager);
        ELResolver.checkSkippedInstance(instanceInContext, manager);
        if (!ELUtils.hasValidBinding(instance)) {
            return;
        }
        manager.state.increaseNofResolvedInstances();
        ELResolver.checkBBoxInstance(instanceInContext, manager);
        if (instanceInContext.depth >= manager.getMaxDepth()) {
            return;
        }
        ELResolver.updateInstanceSemanticEnable(instance, manager);
        ELResolver.searchAndElaborateImportedPackages(instance, manager);
        ELResolver.resolveVHDLHidsAndOperators(instance, manager);
        ELResolver.computeDefparamAssigns(instanceInContext, graph, manager);
        ELResolver.findDirectSubInstancesIgnoreArrays(instanceInContext, graph, manager);
    }

    private static void secondAndThirdPasses(Collection<ELInstanceInContext> tops, ELGraph<ElementPath, ELInstanceInContext, ELParamValues> graph, List<ELInstanceInContext> generateTops, ELManager manager) {
        try {
            int unresolvedCount = graph.topologicalSort(ELResolver.secondPassHandler(manager), ELResolver.thirdPassHandler(generateTops, manager), manager);
            if (unresolvedCount > 0) {
                Map<ElementPath, ELInstanceInContext> unsortedCandidates = graph.getVertices();
                if (unsortedCandidates != null) {
                    for (Map.Entry<ElementPath, ELInstanceInContext> unsortedEntry : unsortedCandidates.entrySet()) {
                        ELInstanceInContext unsortedCandidate = unsortedEntry.getValue();
                        if (unsortedCandidate.getDegree() <= 0) continue;
                        manager.storeInstanceAndParamValues(unsortedCandidate.instance);
                    }
                }
                ELInstanceInContext firstTop = tops.iterator().next();
                manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "CYCLICAL_ORDER: Cycle discovered when elaborating parameters", firstTop.instance.getBinding(false), null, new Object[0]);
                manager.state.throwElaborationCancelException();
                throw new ElaborationCancelException();
            }
        }
        finally {
            graph.clean();
        }
    }

    static Function<ELInstanceInContext, ELParamValues> secondPassHandler(ELManager manager) {
        return instanceInContext -> {
            ELInstance instance = instanceInContext.instance;
            IRfInstanceElement description = instance.getDescription();
            if (!ELUtils.hasValidBinding(instance)) {
                manager.storeInstanceAndParamValues(instance);
                description.cleanPreElabTransientType();
                return null;
            }
            eLManager.logger.debug(ElaborationDebugZone.SECOND_PASS, "\n**** Instance: ", instance);
            IELDesign binding = (IELDesign)instance.getBinding(false);
            boolean isVHDLDescription = ELUtils.isVHDL(description);
            ELResolver.adjustDelayedUDPInstance(instanceInContext, manager);
            Map<String, IRfNamedElement> instanceConstants = ELResolver.internalGetInstanceConstants(instance, manager);
            Map<String, IRfNamedElement> instanceParameters = ELResolver.internalGetInstanceParams(instance, manager);
            Map<String, HidOperatorWrapper> instanceOverrides = ELResolver.internalGetInstanceOverrides(instance, instanceParameters, manager);
            ELParamValues contextParamValues = instanceInContext.context.getParamValues();
            if (contextParamValues == null) {
                boolean isCaseSensitive = !ELUtils.isVHDL(binding) && !isVHDLDescription;
                contextParamValues = ELParamValues.create(instanceConstants.size(), isCaseSensitive);
            }
            ElementPath hierarchyPath = instance.getHierarchyPath();
            manager.storeInstanceAndParamValues(instance);
            ELParamValues values = ELResolver.computeParamValuesAndInterfacePortConnections(instanceInContext, instanceOverrides, instanceConstants, contextParamValues, true, manager);
            values = ELUtils.getValidParamValues(values);
            ELSpecialization newSpec = ELSpecialization.packedOf(binding, values, instance.getSpecialization().getInterfacePortInstances());
            ELSpecializationWrapper newSpecWrapper = ELSpecializationWrapper.of(newSpec, isVHDLDescription, hierarchyPath);
            ELSpecializationWrapper contextSpecWrapper = ELSpecializationWrapper.contextOf(instanceInContext.context.getSpecialization());
            if (instanceInContext.depth >= manager.getMaxDepth()) {
                boolean hasNewContext;
                ELSpecializationWrapper existingSpecWrapper = binding.getSpecialization(newSpecWrapper, manager.getCachedSpecsPerElement());
                if (existingSpecWrapper != null) {
                    newSpec = existingSpecWrapper.spec;
                    eLManager.state.increaseNofOptimizedInstances();
                }
                boolean isNewSpec = existingSpecWrapper == null;
                boolean bl = hasNewContext = !description.hasSpecialization(contextSpecWrapper, manager.getCachedSpecsPerInstance());
                if (isNewSpec || hasNewContext) {
                    ELResolver.checkParameterOverrides(instanceInContext, instanceOverrides, instanceParameters, instanceConstants, values, contextParamValues, manager);
                    ELResolver.checkPortConnections(instanceInContext, values, contextParamValues, manager);
                }
                if (instanceInContext.depth == Integer.MAX_VALUE) {
                    eLManager.logger.debug(ElaborationDebugZone.SECOND_PASS, "\n**** Black boxed instance: ", hierarchyPath);
                    newSpec = ELSpecialization.of(ELConstants.BLACK_BOX_INSTANCE_TYPE);
                }
                instance.setSpecialization(newSpec);
                return null;
            }
            ELSpecializationWrapper existingSpecWrapper = binding.putIfAbsentSpecialization(newSpecWrapper, manager.getCachedSpecsPerElement());
            if (existingSpecWrapper != null) {
                newSpec = existingSpecWrapper.spec;
                eLManager.state.increaseNofOptimizedInstances();
            }
            instance.setSpecialization(newSpec);
            boolean isNewSpec = existingSpecWrapper == null;
            boolean hasNewContext = description.addSpecialization(contextSpecWrapper, manager.getCachedSpecsPerInstance());
            if (isNewSpec || hasNewContext) {
                ELResolver.checkParameterOverrides(instanceInContext, instanceOverrides, instanceParameters, instanceConstants, values, contextParamValues, manager);
                ELResolver.checkPortConnections(instanceInContext, values, contextParamValues, manager);
            }
            return values;
        };
    }

    static BiConsumer<ELInstanceInContext, ELParamValues> thirdPassHandler(List<ELInstanceInContext> generateTops, ELManager manager) {
        return (instanceInContext, values) -> {
            try {
                ELInstance instance = instanceInContext.instance;
                if (!ELUtils.hasValidBinding(instance)) {
                    return;
                }
                if (values == null) {
                    return;
                }
                ELResolver.computeElaboratedBinds(instance, values, manager);
                ELResolver.findDirectArraySubInstances(instanceInContext, values, generateTops, manager);
                ELResolver.findActiveBlocks(instanceInContext, values, generateTops, manager);
            }
            finally {
                eLManager.state.increaseNofCompleteInstances();
            }
        };
    }

    static boolean secondAndThirdPassesDirect(ELInstanceInContext instanceInContext, List<ELInstanceInContext> generateTops, ELManager manager) {
        ELInstance instance = instanceInContext.instance;
        IRfInstanceElement description = instance.getDescription();
        manager.logger.debug(ElaborationDebugZone.SECOND_PASS, "\n**** Instance: ", instance);
        IELDesign binding = (IELDesign)instance.getBinding(false);
        boolean isVHDLDescription = ELUtils.isVHDL(description);
        ELResolver.adjustDelayedUDPInstance(instanceInContext, manager);
        Map<String, IRfNamedElement> instanceConstants = ELResolver.internalGetInstanceConstants(instance, manager);
        Map<String, IRfNamedElement> instanceParameters = ELResolver.internalGetInstanceParams(instance, manager);
        Map<String, HidOperatorWrapper> instanceOverrides = ELResolver.internalGetInstanceOverrides(instance, instanceParameters, manager);
        ELParamValues contextParamValues = instanceInContext.context.getParamValues();
        if (contextParamValues == null) {
            boolean isCaseSensitive = !ELUtils.isVHDL(binding) && !isVHDLDescription;
            contextParamValues = ELParamValues.create(instanceConstants.size(), isCaseSensitive);
        }
        ElementPath hierarchyPath = instance.getHierarchyPath();
        manager.storeInstanceAndParamValues(instance);
        ELParamValues values = ELResolver.computeParamValuesAndInterfacePortConnections(instanceInContext, instanceOverrides, instanceConstants, contextParamValues, true, manager);
        values = ELUtils.getValidParamValues(values);
        ELSpecialization newSpec = ELSpecialization.packedOf(binding, values, instance.getSpecialization().getInterfacePortInstances());
        ELSpecializationWrapper newSpecWrapper = ELSpecializationWrapper.of(newSpec, isVHDLDescription, hierarchyPath);
        ELSpecializationWrapper contextSpecWrapper = ELSpecializationWrapper.contextOf(instanceInContext.context.getSpecialization());
        if (instanceInContext.depth >= manager.getMaxDepth()) {
            boolean hasNewContext;
            ELSpecializationWrapper existingSpecWrapper = binding.getSpecialization(newSpecWrapper, manager.getCachedSpecsPerElement());
            if (existingSpecWrapper != null) {
                newSpec = existingSpecWrapper.spec;
                manager.state.increaseNofOptimizedInstances();
            }
            boolean isNewSpec = existingSpecWrapper == null;
            boolean bl = hasNewContext = !description.hasSpecialization(contextSpecWrapper, manager.getCachedSpecsPerInstance());
            if (isNewSpec || hasNewContext) {
                ELResolver.checkParameterOverrides(instanceInContext, instanceOverrides, instanceParameters, instanceConstants, values, contextParamValues, manager);
                ELResolver.checkPortConnections(instanceInContext, values, contextParamValues, manager);
            }
            if (instanceInContext.depth == Integer.MAX_VALUE) {
                manager.logger.debug(ElaborationDebugZone.SECOND_PASS, "\n**** Black boxed instance: ", hierarchyPath);
                newSpec = ELSpecialization.of(ELConstants.BLACK_BOX_INSTANCE_TYPE);
            }
            instanceInContext.visited.remove(binding);
            instance.setSpecialization(newSpec);
            return false;
        }
        ELSpecializationWrapper existingSpecWrapper = binding.putIfAbsentSpecialization(newSpecWrapper, manager.getCachedSpecsPerElement());
        if (existingSpecWrapper != null) {
            newSpec = existingSpecWrapper.spec;
            manager.state.increaseNofOptimizedInstances();
        }
        instance.setSpecialization(newSpec);
        boolean isNewSpec = existingSpecWrapper == null;
        boolean hasNewContext = description.addSpecialization(contextSpecWrapper, manager.getCachedSpecsPerInstance());
        if (isNewSpec || hasNewContext) {
            ELResolver.checkParameterOverrides(instanceInContext, instanceOverrides, instanceParameters, instanceConstants, values, contextParamValues, manager);
            ELResolver.checkPortConnections(instanceInContext, values, contextParamValues, manager);
        }
        if (existingSpecWrapper != null && !instance.isBlock()) {
            if (manager.isControlEachSpecOnce()) {
                newSpec = ELSpecialization.of(ELConstants.BLACK_BOX_INSTANCE_TYPE);
                instanceInContext.visited.remove(binding);
                instance.setSpecialization(newSpec);
                return false;
            }
            if (manager.allowSubInstanceCopies() && !description.isArray() && (!isVHDLDescription || ELResolver.testVHDLSubInstanceCopy(instance))) {
                ElementPath firstPath;
                ElementPath elementPath = firstPath = existingSpecWrapper.paths != null && !existingSpecWrapper.paths.isEmpty() ? existingSpecWrapper.paths.peek() : null;
                if (firstPath == null) {
                    manager.logger.debug(ElaborationDebugZone.STATS, "No original path found for subInstance path:", hierarchyPath);
                } else {
                    newSpec = ELSpecialization.of(new ErrorDesignElement.SubInstanceCopyDesignElement(firstPath));
                    manager.addSubInstanceCopyPath(hierarchyPath);
                    instanceInContext.visited.remove(binding);
                    instance.setSpecialization(newSpec);
                    return false;
                }
            }
        }
        ELResolver.computeElaboratedBinds(instance, values, manager);
        ELResolver.findDirectArraySubInstances(instanceInContext, values, generateTops, manager);
        ELResolver.findActiveBlocks(instanceInContext, values, generateTops, manager);
        return true;
    }

    private static void firstSecondAndThirdPasses(Collection<ELInstanceInContext> tops, ELManager manager) {
        for (ELInstanceInContext top : tops) {
            ELResolver.firstSecondAndThirdPassesDFS(top, manager);
        }
    }

    private static void firstSecondAndThirdPassesDFS(ELInstanceInContext instanceInContext, ELManager manager) {
        try {
            manager.checkBuildCanceled();
            manager.logger.debug(ElaborationDebugZone.FIRST_PASS, "\n**** Instance: ", instanceInContext);
            ELInstance instance = instanceInContext.instance;
            IRfInstanceElement description = instance.getDescription();
            ELResolver.resolveVHDLPackageComponent(instance, manager);
            ELResolver.computeOrGetBinding(instanceInContext, manager);
            ELResolver.checkSkippedInstance(instanceInContext, manager);
            if (!ELUtils.hasValidBinding(instance)) {
                manager.storeInstanceAndParamValues(instance);
                description.cleanPreElabTransientType();
                return;
            }
            manager.state.increaseNofResolvedInstances();
            ELResolver.checkBBoxInstance(instanceInContext, manager);
            ArrayList<ELInstanceInContext> generateTops = new ArrayList<ELInstanceInContext>(4);
            if (instanceInContext.depth >= manager.getMaxDepth()) {
                ELResolver.secondAndThirdPassesDirect(instanceInContext, generateTops, manager);
                return;
            }
            ELResolver.updateInstanceSemanticEnable(instance, manager);
            ELResolver.searchAndElaborateImportedPackages(instance, manager);
            ELResolver.resolveVHDLHidsAndOperators(instance, manager);
            if (!ELResolver.secondAndThirdPassesDirect(instanceInContext, generateTops, manager)) {
                return;
            }
            ELResolver.findDirectSubInstancesIgnoreArrays(instanceInContext, null, manager);
            ELResolver.recursion(generateTops, manager);
        }
        finally {
            manager.state.increaseNofCompleteInstances();
        }
    }

    private static void recursion(List<ELInstanceInContext> generateTops, ELManager manager) {
        manager.recursion(generateTops);
    }

    private static void updateInstanceSemanticEnable(ELInstance instance, ELManager manager) {
        if (manager.isPermanentElaboration()) {
            instance.setSemanticEnable(manager.getSemanticEnableRaw());
        }
    }

    private static void searchAndElaborateImportedPackages(ELInstance instance, ELManager manager) {
        if (!manager.isPermanentElaboration()) {
            return;
        }
        manager.checkBuildCanceled();
        IELDesign binding = (IELDesign)instance.getBinding(false);
        binding.elaborateImportedPackages(manager);
    }

    private static void resolveVHDLPackageComponent(ELInstance instance, ELManager manager) {
        if (!manager.isPermanentElaboration()) {
            return;
        }
        IRfDesignElement preElabDesign = instance.getVHDLPreElaborationDesign();
        if (DesignUtils.getDesignKind(preElabDesign) == IRfNamedElement.ElementKind.VHDL_COMPONENT && preElabDesign.getEnclosingScope() instanceof IRfPackageElement) {
            ((IRfPackageElement)preElabDesign.getEnclosingScope()).elaborateConstants(manager);
            manager.logger.debug(ElaborationDebugZone.FIRST_PASS, "* Resolving VHDL Package component:", preElabDesign);
        }
    }

    private static void resolveVHDLHidsAndOperators(ELInstance instance, ELManager manager) {
        if (!manager.isPermanentElaboration()) {
            return;
        }
        IELDesign binding = (IELDesign)instance.getBinding(false);
        if (ELUtils.isVHDL(binding)) {
            binding.resolveHidsFromElaboration(ELWidthCheckContext.of(ELParamValues.EMPTY, Arrays.asList(instance.getHierarchyPath()), manager), true, true, manager.getSemanticEnableRaw());
            manager.logger.debug(ElaborationDebugZone.FIRST_PASS, "* Resolving VHDL Hids and Operators for:", binding);
        }
    }

    private static void checkParameterOverrides(ELInstanceInContext instanceInContext, Map<String, HidOperatorWrapper> instanceOverrides, Map<String, IRfNamedElement> instanceParameters, Map<String, IRfNamedElement> instanceConstants, ELParamValues values, ELParamValues contextParamValues, ELManager manager) {
        IRfInstanceElement description = instanceInContext.instance.getDescription();
        if (!manager.isPermanentElaboration() || description instanceof DummyInstance || !ELUtils.isVLOG(description)) {
            return;
        }
        manager.checkBuildCanceled();
        IRfDesignElement binding = (IRfDesignElement)instanceInContext.instance.getBinding(true);
        ElementPath contextHierarchyPath = instanceInContext.context.getHierarchyPath();
        BaseConfigInfo configInfo = new BaseConfigInfo(false, manager.getMixedLangProjectParent(), false, null);
        IRfSingleLangProject vlogRfProject = manager.getSingleLangProjectParent(LanguageKind.VLOG);
        description.checkParameterOverrides(instanceOverrides, instanceParameters, instanceConstants, binding, ELWidthCheckContext.of(values, instanceInContext.instance.getHierarchyPath(), binding, contextParamValues, contextHierarchyPath, manager), manager.shouldTriggerElabError(), vlogRfProject.isIrunRNMTech(), manager.isElabWidthCheckDisabled(), manager.isElabWidthCheckFiltered(), configInfo);
        manager.logger.debug(ElaborationDebugZone.SECOND_PASS, "* Checked parameter overrides of:", description);
    }

    private static void checkPortConnections(ELInstanceInContext instanceInContext, ELParamValues values, ELParamValues contextParamValues, ELManager manager) {
        IRfInstanceElement description = instanceInContext.instance.getDescription();
        if (!manager.isPermanentElaboration() || description instanceof DummyInstance || !ELUtils.isVLOG(description)) {
            return;
        }
        manager.checkBuildCanceled();
        List<HidOperatorWrapper> portConnections = ELResolver.internalGetPortConnections(description, instanceInContext.context.getBinding(false), manager);
        IRfDesignElement binding = (IRfDesignElement)instanceInContext.instance.getBinding(false);
        ElementPath contextHierarchyPath = instanceInContext.context.getHierarchyPath();
        BaseConfigInfo configInfo = new BaseConfigInfo(false, manager.getMixedLangProjectParent(), false, null);
        IRfSingleLangProject vlogRfProject = manager.getSingleLangProjectParent(LanguageKind.VLOG);
        description.checkPortConnections(portConnections, binding, ELWidthCheckContext.of(values, instanceInContext.instance.getHierarchyPath(), binding, contextParamValues, contextHierarchyPath, manager), manager.shouldTriggerElabError(), vlogRfProject.isIrunRNMTech(), manager.isElabWidthCheckDisabled(), manager.isElabWidthCheckFiltered(), configInfo);
        manager.logger.debug(ElaborationDebugZone.SECOND_PASS, "* Checked port connections of:", description);
    }

    private static void findDirectSubInstancesIgnoreArrays(ELInstanceInContext parentInstanceInContext, ELGraph<ElementPath, ELInstanceInContext, ELParamValues> graph, ELManager manager) {
        boolean isVLOGPermanentBinding;
        manager.checkBuildCanceled();
        ELInstance parentInstance = parentInstanceInContext.instance;
        IRfDesignElement parentBinding = (IRfDesignElement)parentInstance.getBinding(false);
        Collection<? extends IRfInstanceElement> descriptions = parentBinding.getLocalInstances();
        if (descriptions == null || descriptions.isEmpty()) {
            return;
        }
        ELContext newContext = parentInstanceInContext.context.newContext(parentInstance);
        ElementPath parentPath = parentInstance.getHierarchyPath();
        boolean isUnderArrayOfInstanceBlock = parentInstance.isArrayOfInstancesBlock();
        boolean bl = isVLOGPermanentBinding = manager.isPermanentElaboration() && ELUtils.isVLOG(parentBinding);
        if (isVLOGPermanentBinding) {
            parentInstance.getDescription().cleanPreElabTransientType();
        }
        HashSet<String> visitedNames = new HashSet<String>();
        int currentDepth = parentInstanceInContext.depth;
        IRfNamedElement.ElementKind parentBindingKind = DesignUtils.getDesignKind(parentBinding);
        boolean isUnderProgram = parentBindingKind == IRfNamedElement.ElementKind.VLOG_PROGRAM || parentBindingKind == IRfNamedElement.ElementKind.VLOG_GENERATE && parentInstanceInContext.isUnderProgram();
        for (IRfInstanceElement iRfInstanceElement : descriptions) {
            manager.checkBuildCanceled();
            String newName = iRfInstanceElement.getName();
            if (visitedNames.contains(newName)) continue;
            visitedNames.add(newName);
            if (!isUnderArrayOfInstanceBlock && iRfInstanceElement.isArray()) continue;
            ElementPath newPath = isUnderArrayOfInstanceBlock ? ELUtils.arrayOfInstancesPath(parentPath) : ELUtils.appendToPath(parentPath, newName);
            ELInstance subInstance = ELInstance.of(iRfInstanceElement, newPath, manager);
            ELInstanceInContext subInstanceInContext = ELInstanceInContext.of(subInstance, newContext, ELUtils.computeVisited(parentInstanceInContext.visited, false), currentDepth, isUnderProgram);
            if (graph != null) {
                graph.addEdge(parentInstanceInContext, subInstanceInContext);
                ELResolver.firstPassDFS(subInstanceInContext, graph, manager);
            } else {
                ELResolver.firstSecondAndThirdPassesDFS(subInstanceInContext, manager);
            }
            parentInstanceInContext.visited.remove(subInstance.getBinding(false));
        }
    }

    private static void findDirectArraySubInstances(ELInstanceInContext parentInstanceInContext, ELParamValues parentParamValues, List<ELInstanceInContext> generateTops, ELManager manager) {
        manager.checkBuildCanceled();
        if (manager.isControlNoGenerateBlocks()) {
            return;
        }
        ELInstance parentInstance = parentInstanceInContext.instance;
        IRfDesignElement parentBinding = (IRfDesignElement)parentInstance.getBinding(false);
        Collection<? extends IRfInstanceElement> descriptions = parentBinding.getLocalInstances();
        if (descriptions == null || descriptions.isEmpty()) {
            return;
        }
        ELContext newContext = parentInstanceInContext.context.newContext(parentInstance);
        boolean isUnderArrayOfInstanceBlock = parentInstance.isArrayOfInstancesBlock();
        IRfNamedElement.ElementKind parentBindingKind = DesignUtils.getDesignKind(parentBinding);
        boolean isUnderProgram = parentBindingKind == IRfNamedElement.ElementKind.VLOG_PROGRAM || parentBindingKind == IRfNamedElement.ElementKind.VLOG_GENERATE && parentInstanceInContext.isUnderProgram();
        HashSet<String> visitedNames = new HashSet<String>();
        for (IRfInstanceElement iRfInstanceElement : descriptions) {
            String newName;
            manager.checkBuildCanceled();
            if (isUnderArrayOfInstanceBlock || !iRfInstanceElement.isArray() || visitedNames.contains(newName = iRfInstanceElement.getName())) continue;
            visitedNames.add(newName);
            ELResolver.internalFindArrayOfInstances(iRfInstanceElement, parentInstance, parentParamValues, newContext, null, generateTops, parentInstanceInContext.visited, parentInstanceInContext.depth, isUnderProgram, manager);
        }
    }

    private static void internalFindArrayOfInstances(IRfInstanceElement arrayDescription, ELInstance parentInstance, ELParamValues parentParamValues, ELContext context, ElementPath bindOrigin, List<ELInstanceInContext> generateTops, Set<IRfNamedElement> parentVisited, int parentDepth, boolean isUnderProgram, ELManager manager) {
        List<ELDimension> ranges = arrayDescription.elaborateArrayRange(parentParamValues, manager);
        String arrayDescrName = arrayDescription.getName();
        if (ranges == null || ranges.isEmpty()) {
            manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "UNKNOWN_ARRAY_OF_INSTANCES_RANGE: Could not determine range of array of instances ''{0}''", arrayDescription, ELUtils.appendToPath(parentInstance.getHierarchyPath(), arrayDescrName), arrayDescrName);
            return;
        }
        ArrayList<String> allRangesText = new ArrayList<String>(ranges.size());
        ELResolver.recursiveComputeAllRangeValues(ranges, 0, new StringBuilder(), allRangesText, manager);
        if (allRangesText.isEmpty()) {
            return;
        }
        ElementPath currentPath = parentInstance.getHierarchyPath();
        ELLiblist liblist = context.getLiblist();
        IRfConfiguration config = context.getConfig();
        ArrayOfInstancesBlockElement dummyBlock = new ArrayOfInstancesBlockElement(arrayDescription, arrayDescrName);
        DummyInstance dummyBlockInstance = DummyInstance.of(arrayDescrName, dummyBlock);
        for (String rangeText : allRangesText) {
            manager.checkBuildCanceled();
            if (bindOrigin != null) {
                String elaboratedBlockName = String.valueOf(arrayDescrName) + rangeText;
                ElementPath finalPath = ELUtils.appendToPath(currentPath, elaboratedBlockName);
                ELInstance existingBoundInstance = manager.getMemory().instanceFor(finalPath);
                if (existingBoundInstance != null) {
                    manager.reportProblemForElement(ElaborationDebugZone.BINDS_PASS, true, "DUPLICATE_BOUND_INSTANCE: Duplicate bound instance ''{0}'' added from instance ''{1}''", arrayDescription, null, arrayDescription.getName(), bindOrigin);
                    continue;
                }
            }
            ElementPath newPath = ELUtils.appendToPath(ELUtils.appendToPath(currentPath, arrayDescrName), rangeText);
            ELInstance subInstance = ELInstance.of(dummyBlockInstance, newPath, dummyBlock, config, liblist, null, null, manager);
            Set<IRfNamedElement> visited = null;
            if (bindOrigin != null) {
                visited = ELUtils.computeVisited(parentVisited, true);
            } else {
                visited = ELUtils.computeVisited(parentVisited, true);
                IRfScopeElement enclosingDesign = ELResolver.internalGetDesignScope(dummyBlockInstance);
                if (enclosingDesign instanceof IRfNamedElement) {
                    visited.add((IRfNamedElement)enclosingDesign);
                }
            }
            generateTops.add(ELInstanceInContext.of(subInstance, context, visited, parentDepth, isUnderProgram));
        }
    }

    private static boolean testVHDLSubInstanceCopy(ELInstance instance) {
        IRfConfiguration config = instance.getElaborationConfig();
        if (!(config instanceof DVTImplicitConfiguration)) {
            return false;
        }
        IRfConfigurationRule elaborationRule = instance.getElaborationRule();
        return elaborationRule == null;
    }

    private static void recursiveComputeAllRangeValues(List<ELDimension> ranges, int index, StringBuilder current, List<String> result, ELManager manager) {
        if (index >= ranges.size()) {
            if (current.length() > 0) {
                result.add(current.toString());
            }
            return;
        }
        manager.checkBuildCanceled();
        ELDimension currentRange = ranges.get(index);
        int origStart = currentRange.getStart();
        int origEnd = currentRange.getEnd();
        int start = Math.min(origStart, origEnd);
        int max_nof_tries = manager.isControlEachGenerateBlockOnce() ? 1 : manager.getLoopBlockCutoff();
        int end = Math.min(Math.max(origStart, origEnd), start - 1 + max_nof_tries);
        int i = start;
        while (i <= end) {
            String addition = "[" + i + "]";
            StringBuilder nextCurrent = index == 0 ? new StringBuilder() : new StringBuilder(current);
            nextCurrent.append(addition);
            ELResolver.recursiveComputeAllRangeValues(ranges, index + 1, nextCurrent, result, manager);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void findActiveBlocks(ELInstanceInContext parentInstanceInContext, ELParamValues parentParamValues, List<ELInstanceInContext> generateTops, ELManager manager) {
        manager.checkBuildCanceled();
        if (manager.isControlNoGenerateBlocks()) {
            return;
        }
        ELInstance parentInstance = parentInstanceInContext.instance;
        IRfNamedElement parentBinding = parentInstance.getBinding(false);
        Collection<? extends IRfBlockElement> blocks = ((IRfDesignElement)parentBinding).getLocalGenerateBlocks();
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        ELContext newContext = parentInstanceInContext.context.newContext(parentInstance);
        IRfConfiguration config = newContext.getConfig();
        ELLiblist liblist = newContext.getLiblist();
        int generateIndex = -1;
        boolean hasActiveBlock = true;
        ElementPath currentPath = parentInstance.getHierarchyPath();
        Collection<? extends IRfConfigurationRule> childrenRules = newContext.getChildrenRules();
        HashSet<String> visitedNames = new HashSet<String>();
        IRfNamedElement.ElementKind parentBindingKind = DesignUtils.getDesignKind(parentBinding);
        boolean isUnderProgram = parentBindingKind == IRfNamedElement.ElementKind.VLOG_PROGRAM || parentBindingKind == IRfNamedElement.ElementKind.VLOG_GENERATE && parentInstanceInContext.isUnderProgram();
        boolean controlEachGenerateBlockOnce = manager.isControlEachGenerateBlockOnce();
        int unambiguousBlockIndex = 1;
        for (IRfBlockElement iRfBlockElement : blocks) {
            List<DummyInstance> blockInstances;
            manager.checkBuildCanceled();
            int newGenerateIndex = iRfBlockElement.getGenerateConstructIndex();
            if (newGenerateIndex != generateIndex) {
                generateIndex = newGenerateIndex;
                hasActiveBlock = true;
            }
            if (!hasActiveBlock && !controlEachGenerateBlockOnce) continue;
            boolean isVHDLBlock = ELUtils.isVHDL(iRfBlockElement);
            boolean isLeftoverBranchVHDL = isVHDLBlock && (iRfBlockElement.isElseGenerate() || iRfBlockElement.isCaseOthersGenerate());
            List<IRfInstanceElement> list = blockInstances = isLeftoverBranchVHDL ? Collections.singletonList(ELConstants.GENERATE_BLOCK_DEFAULT_INSTANCE) : iRfBlockElement.elaborateBlockParameters(parentParamValues, currentPath, manager);
            if (blockInstances == null || blockInstances.isEmpty()) continue;
            hasActiveBlock = false;
            String blockName = iRfBlockElement.getName();
            if (visitedNames.contains(blockName)) {
                if (!controlEachGenerateBlockOnce) continue;
                blockName = blockName + "<" + ++unambiguousBlockIndex + ">";
            } else {
                unambiguousBlockIndex = 1;
            }
            visitedNames.add(blockName);
            for (IRfInstanceElement iRfInstanceElement : blockInstances) {
                void var26_26;
                manager.checkBuildCanceled();
                if (iRfInstanceElement == ELConstants.GENERATE_BLOCK_UNDEFINED_INSTANCE) continue;
                String elaboratedBlockName = null;
                if (iRfInstanceElement == ELConstants.GENERATE_BLOCK_DEFAULT_INSTANCE) {
                    elaboratedBlockName = blockName;
                    DummyInstance dummyInstance = DummyInstance.of(elaboratedBlockName, iRfBlockElement);
                } else {
                    elaboratedBlockName = iRfInstanceElement.getName();
                }
                IRfConfigurationRule blockRule = ELVHDLCore.getBlockConfigurationRule(iRfBlockElement, var26_26 instanceof DummyInstance ? ((DummyInstance)var26_26).getBlockParameterValue() : null, parentParamValues, manager, childrenRules);
                Collection<? extends IRfConfigurationRule> newChildrenRules = blockRule != null ? blockRule.getLocalRules() : null;
                ElementPath newInstancePath = ELUtils.appendToPath(currentPath, elaboratedBlockName);
                ELInstance subInstance = ELInstance.of((IRfInstanceElement)var26_26, newInstancePath, iRfBlockElement, config, liblist, blockRule, newChildrenRules, manager);
                Set<IRfNamedElement> visited = ELUtils.computeVisited(parentInstanceInContext.visited, true);
                IRfScopeElement enclosingDesign = ELResolver.internalGetDesignScope(iRfBlockElement);
                if (enclosingDesign instanceof IRfNamedElement) {
                    visited.add((IRfNamedElement)enclosingDesign);
                }
                generateTops.add(ELInstanceInContext.of(subInstance, newContext, visited, parentInstanceInContext.depth, isUnderProgram));
            }
        }
    }

    private static IRfScopeElement internalGetDesignScope(IRfNamedElement element) {
        IRfScopeElement scope = element;
        do {
            IRfNamedElement.ElementKind designKind;
            if ((designKind = DesignUtils.getDesignKind(scope)) == IRfNamedElement.ElementKind.UNKNOWN || designKind == IRfNamedElement.ElementKind.VLOG_GENERATE || designKind == IRfNamedElement.ElementKind.VHDL_BLOCK) continue;
            return scope;
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }

    private static void adjustDelayedUDPInstance(ELInstanceInContext instanceInContext, ELManager manager) {
        manager.checkBuildCanceled();
        ELInstance instance = instanceInContext.instance;
        IRfInstanceElement description = instance.getDescription();
        if (!description.isDelayedUDPInstance()) {
            return;
        }
        description.adjustDelayedUDPInstance(instance.getBinding(false));
    }

    private static List<HidOperatorWrapper> internalGetPortConnections(IRfInstanceElement description, IRfNamedElement instanceScope, ELManager manager) {
        ConcurrentHashMap<IRfNamedElement, ConcurrentHashMap<IRfInstanceElement, List<HidOperatorWrapper>>> portConnectionsCache = manager.getPortConnectionsCache();
        ConcurrentHashMap localResolvedMap = portConnectionsCache.computeIfAbsent(instanceScope, key -> new ConcurrentHashMap());
        return localResolvedMap.computeIfAbsent(description, key -> {
            List<HidOperatorWrapper> pcWrappers = HidOperatorVisitorWithPaths.getHidOperators(key, ELConstants.PORT_CONNECTIONS_QUALIFIERS_ARRAY, true);
            if (pcWrappers == null) {
                return Collections.emptyList();
            }
            return pcWrappers;
        });
    }

    private static Map<String, HidOperatorWrapper> internalGetInstanceOverrides(ELInstance instance, Map<String, IRfNamedElement> instanceParams, ELManager manager) {
        manager.checkBuildCanceled();
        IRfNamedElement binding = instance.getBinding(true);
        IRfInstanceElement description = instance.getDescription();
        IRfDesignElement componentCandidate = description.getVHDLPreElaborationDesign();
        IRfDesignElement componentDesign = DesignUtils.isVHDLComponent(componentCandidate) ? componentCandidate : null;
        boolean isComponentInstance = componentDesign != null;
        return description.getParameterOverrides(isComponentInstance ? componentDesign : (IRfDesignElement)binding, instanceParams, manager.markElabHidObjects(), manager.getParameterOverridesCache());
    }

    private static Map<String, IRfNamedElement> internalGetInstanceParams(ELInstance instance, ELManager manager) {
        manager.checkBuildCanceled();
        IRfNamedElement entityBinding = instance.getBinding(true);
        IRfInstanceElement description = instance.getDescription();
        IRfDesignElement componentCandidate = description.getVHDLPreElaborationDesign();
        IRfDesignElement componentDesign = DesignUtils.isVHDLComponent(componentCandidate) ? componentCandidate : null;
        boolean isComponentInstance = componentDesign != null;
        return ELUtils.internalComputeParamMap(isComponentInstance ? componentDesign : (IRfDesignElement)entityBinding, description);
    }

    private static Map<String, IRfNamedElement> internalGetInstanceConstants(ELInstance instance, ELManager manager) {
        manager.checkBuildCanceled();
        IRfNamedElement architectureBinding = instance.getBinding(false);
        IRfInstanceElement description = instance.getDescription();
        return ELUtils.internalComputeConstantsMap((IRfDesignElement)architectureBinding, description);
    }

    @NotNull
    private static Map<String, HidOperatorWrapper> internalGetBindingOrComponentDefaultValues(Object[] defaults, IRfDesignElement bindingOrComponent, boolean isCaseSensitive, ELManager manager) {
        Map<String, HidOperatorWrapper> assigns = (Map<String, HidOperatorWrapper>)defaults[0];
        if (assigns == null) {
            assigns = bindingOrComponent.collectDefaultValueAssigns(isCaseSensitive, manager.markElabHidObjects(), manager.getParameterDefaultValuesCache(isCaseSensitive));
            defaults[0] = assigns == null || assigns.isEmpty() ? Collections.emptyMap() : assigns;
        }
        return assigns;
    }

    @NotNull
    private static ELParamValues computeParamValuesAndInterfacePortConnections(ELInstanceInContext instanceInContext, Map<String, HidOperatorWrapper> instanceOverrides, Map<String, IRfNamedElement> workingParamMap, ELParamValues contextParamValues, boolean controlDeferredValueEval, ELManager manager) {
        try {
            boolean isComponentInstance;
            manager.checkBuildCanceled();
            if (manager.isControlNoParamEval()) {
                return ELParamValues.EMPTY;
            }
            ELInstance instance = instanceInContext.instance;
            ElementPath hierarchyPath = instance.getHierarchyPath();
            IRfNamedElement binding = instance.getBinding(true);
            IRfNamedElement architectureBinding = instance.getBinding(false);
            IRfInstanceElement description = instance.getDescription();
            Collection<? extends IRfPortElement> interfacePorts = ((IRfDesignElement)binding).getLocalInterfacePorts();
            boolean hasInterfacePorts = interfacePorts != null && !interfacePorts.isEmpty();
            int workingParamMapSize = workingParamMap.size();
            ELParamValues working = ELResolver.internalComputeStartingParamValues((IRfDesignElement)binding, description, contextParamValues, workingParamMapSize);
            if (workingParamMap.isEmpty()) {
                if (hasInterfacePorts) {
                    List<HidOperatorWrapper> portConnections = ELResolver.internalGetPortConnections(description, instanceInContext.context.getBinding(false), manager);
                    ELWidthCheckContext elabContext = ELWidthCheckContext.of(working, hierarchyPath, (IRfDesignElement)binding, contextParamValues, instanceInContext.context.getHierarchyPath(), manager);
                    description.computeInterfacePortConnections(portConnections, (IRfDesignElement)binding, elabContext, instance);
                }
                return working;
            }
            manager.state.increaseNofParameters(workingParamMapSize);
            ELContext context = instanceInContext.context;
            IRfConfigurationRule configRule = instance.getElaborationRule();
            IRfDesignElement componentCandidate = description.getVHDLPreElaborationDesign();
            IRfDesignElement componentDesign = DesignUtils.isVHDLComponent(componentCandidate) ? componentCandidate : null;
            Map<String, HidOperatorWrapper> configOverrides = configRule != null ? configRule.getParameterOverrides(manager.markElabHidObjects()) : null;
            Map<String, List<ELParamValues.ParamKeyValueLocationTuple>> defparams = manager.getDefparamValues(hierarchyPath);
            Map<String, List<ELParamValues.ParamKeyValueLocationTuple>> potentialDefparams = manager.getPotentialDefparamValues(hierarchyPath);
            Map<String, ELParamValues.BuildConfigParamKeyValueLocationTuple> buildConfigDefparams = manager.getBuildConfigDefparamValues(hierarchyPath, ELUtils.isVLOG(binding));
            Map<String, IRfNamedElement> componentParamMap = ELUtils.internalComputeParamMap(componentDesign, null);
            boolean bl = isComponentInstance = componentDesign != null;
            if (isComponentInstance) {
                int componentParamMapSize = componentParamMap.size();
                ELParamValues componentWorking = ELParamValues.create(componentParamMapSize, false);
                manager.state.increaseNofParameters(componentParamMapSize);
                boolean[] hasDeferredValues = new boolean[2];
                Object[] defaults = new Object[1];
                ELResolver.computeParamValueCombined(componentWorking, componentParamMap, null, null, null, instanceOverrides, null, null, null, null, contextParamValues, context.getConfig(), componentDesign, componentDesign, description, false, false, hierarchyPath, manager, defaults, hasDeferredValues);
                componentWorking = ELResolver.finishComputeParamValues(componentWorking, componentParamMap, binding, componentDesign, description, contextParamValues, hierarchyPath, manager, defaults, hasDeferredValues, false, false);
                if (!componentWorking.isEmpty()) {
                    contextParamValues = contextParamValues.copy();
                    contextParamValues.putAll(componentWorking);
                }
            }
            boolean[] hasDeferredValues = new boolean[2];
            Object[] defaults = new Object[1];
            ELResolver.computeParamValueCombined(working, workingParamMap, isComponentInstance ? componentParamMap : null, configRule, configOverrides, instanceOverrides, defparams, potentialDefparams, buildConfigDefparams, context.getParamValuesForDefparams(), contextParamValues, context.getConfig(), (IRfDesignElement)binding, (IRfDesignElement)architectureBinding, description, controlDeferredValueEval, hasInterfacePorts, hierarchyPath, manager, defaults, hasDeferredValues);
            if (hasInterfacePorts) {
                List<HidOperatorWrapper> portConnections = ELResolver.internalGetPortConnections(description, instanceInContext.context.getBinding(false), manager);
                ELWidthCheckContext elabContext = ELWidthCheckContext.of(working, hierarchyPath, (IRfDesignElement)binding, contextParamValues, instanceInContext.context.getHierarchyPath(), manager);
                description.computeInterfacePortConnections(portConnections, (IRfDesignElement)binding, elabContext, instance);
            }
            return ELResolver.finishComputeParamValues(working, workingParamMap, binding, (IRfDesignElement)architectureBinding, description, contextParamValues, hierarchyPath, manager, defaults, hasDeferredValues, controlDeferredValueEval, true);
        }
        catch (BuildCancelException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return ELParamValues.EMPTY;
        }
    }

    static ELParamValues computeParamValuesAndInterfacePortConnectionsExtended(ELInstanceInContext instanceInContext, boolean controlDeferredValueEval, ELManager manager) {
        ELInstance instance = instanceInContext.instance;
        IRfInstanceElement description = instance.getDescription();
        IELDesign binding = (IELDesign)instance.getBinding(false);
        boolean isVHDLDescription = ELUtils.isVHDL(description);
        Map<String, IRfNamedElement> instanceConstants = ELResolver.internalGetInstanceConstants(instance, manager);
        Map<String, IRfNamedElement> instanceParameters = ELResolver.internalGetInstanceParams(instance, manager);
        Map<String, HidOperatorWrapper> instanceOverrides = ELResolver.internalGetInstanceOverrides(instance, instanceParameters, manager);
        ELParamValues contextParamValues = instanceInContext.context.getParamValues();
        if (contextParamValues == null) {
            boolean isCaseSensitive = !ELUtils.isVHDL(binding) && !isVHDLDescription;
            contextParamValues = ELParamValues.create(instanceConstants.size(), isCaseSensitive);
        }
        return ELResolver.computeParamValuesAndInterfacePortConnections(instanceInContext, instanceOverrides, instanceConstants, contextParamValues, controlDeferredValueEval, manager);
    }

    private static ELParamValues finishComputeParamValues(ELParamValues working, Map<String, IRfNamedElement> workingParamMap, IRfNamedElement binding, IRfDesignElement architectureBinding, IRfInstanceElement description, ELParamValues contextParamValues, ElementPath hierarchyPath, ELManager manager, Object[] defaults, boolean[] hasDeferredValues, boolean controlDeferredValueEval, boolean removeUnsuccessfulEvals) {
        if (hasDeferredValues[1]) {
            return ELResolver.finishComputeParamValuesComplex(working, workingParamMap, binding, architectureBinding, description, contextParamValues, hierarchyPath, manager, defaults, hasDeferredValues, controlDeferredValueEval, removeUnsuccessfulEvals);
        }
        return ELResolver.finishComputeParamValuesSimple(working, workingParamMap, binding, description, hierarchyPath, manager, removeUnsuccessfulEvals);
    }

    private static ELParamValues finishComputeParamValuesComplex(ELParamValues working, Map<String, IRfNamedElement> workingParamMap, IRfNamedElement binding, IRfDesignElement architectureBinding, IRfInstanceElement description, ELParamValues contextParamValues, ElementPath hierarchyPath, ELManager manager, Object[] defaults, boolean[] hasDeferredValues, boolean controlDeferredValueEval, boolean removeUnsuccessfulEvals) {
        IHidEvaluationGuardian defaultGuardian = ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.DEFAULT_VALUE_PARAM, binding, hierarchyPath, false, manager);
        ELParamValuesHidEvaluator paramContextEvaluator = working.getHidEvaluator(manager);
        if (DesignUtils.isVHDLComponent(binding)) {
            ELParamValues enclosingParamValues = contextParamValues.copy();
            paramContextEvaluator = enclosingParamValues.getHidEvaluator(manager);
        }
        boolean isVHDLBinding = ELUtils.isVHDL(binding);
        boolean isVHDLDescription = ELUtils.isVHDL(description);
        ELParamValues newWorking = ELResolver.internalComputeStartingParamValues((IRfDesignElement)binding, description, contextParamValues, contextParamValues.size());
        for (Map.Entry<String, IRfNamedElement> entry : workingParamMap.entrySet()) {
            String paramName = entry.getKey();
            IRfNamedElement paramElement = entry.getValue();
            IELParamValue paramValue = working.getValueDirectly(paramName);
            if (paramValue == null && paramElement instanceof IRfFieldElement var22_23 && !field.isInParameterPortList()) {
                ELResolver.computeParamValueFromDefaultPart(false, working, paramName, paramElement, defaults, paramContextEvaluator, architectureBinding, isVHDLBinding, isVHDLDescription, controlDeferredValueEval, hasDeferredValues, hierarchyPath, defaultGuardian, manager);
                paramValue = working.getValueDirectly(paramName);
            }
            if (ELUtils.isUnsuccessfulEval(paramValue)) {
                if (paramValue == null && !ELUtils.isVHDLEffectiveConstant(paramElement)) {
                    IRfDefElement iRfDefElement = declaration = description instanceof DummyInstance && DesignUtils.getDesignKind(binding) == IRfNamedElement.ElementKind.VHDL_ENTITY ? binding.getDeclaration() : description.getDeclaration();
                    if (declaration == null) continue;
                    int offsetStart = declaration.getLabelStartOffset();
                    int offsetEnd = offsetStart + description.getName().length();
                    int line = declaration.getLabelStartLine();
                    manager.reportProblem(ElaborationDebugZone.SECOND_PASS, true, "UNCONNECTED_PARAMETER: Parameter ''{0}'' of {2} ''{1}'' is not connected", description, declaration, offsetStart, offsetEnd, line, null, hierarchyPath, paramElement.getName(), binding.getName(), DesignUtils.getDesignKindInstanceText(binding));
                }
                if (removeUnsuccessfulEvals) continue;
                newWorking.putDirectly(paramName, paramValue);
                continue;
            }
            newWorking.putDirectly(paramName, paramValue);
        }
        return newWorking;
    }

    private static ELParamValues finishComputeParamValuesSimple(ELParamValues working, Map<String, IRfNamedElement> workingParamMap, IRfNamedElement binding, IRfInstanceElement description, ElementPath hierarchyPath, ELManager manager, boolean removeUnsuccessfulEvals) {
        for (Map.Entry<String, IRfNamedElement> entry : workingParamMap.entrySet()) {
            String paramName = entry.getKey();
            IRfNamedElement paramElement = entry.getValue();
            IELParamValue finalValue = working.getValueDirectly(paramName);
            if (!ELUtils.isUnsuccessfulEval(finalValue)) continue;
            if (finalValue == null && !ELUtils.isVHDLEffectiveConstant(paramElement)) {
                IRfDefElement declaration;
                IRfDefElement iRfDefElement = declaration = description instanceof DummyInstance && DesignUtils.getDesignKind(binding) == IRfNamedElement.ElementKind.VHDL_ENTITY ? binding.getDeclaration() : description.getDeclaration();
                if (declaration == null) continue;
                int offsetStart = declaration.getLabelStartOffset();
                int offsetEnd = offsetStart + description.getName().length();
                int line = declaration.getLabelStartLine();
                manager.reportProblem(ElaborationDebugZone.SECOND_PASS, true, "UNCONNECTED_PARAMETER: Parameter ''{0}'' of {2} ''{1}'' is not connected", description, declaration, offsetStart, offsetEnd, line, null, hierarchyPath, paramElement.getName(), binding.getName(), DesignUtils.getDesignKindInstanceText(binding));
            }
            if (!removeUnsuccessfulEvals) continue;
            working.removeDirectly(paramName);
        }
        return working;
    }

    @NotNull
    private static ELParamValues internalComputeStartingParamValues(IRfDesignElement binding, IRfInstanceElement description, ELParamValues contextParamValues, int workingSize) {
        if (binding instanceof IRfBlockElement && DesignUtils.getDesignKind(binding) != IRfNamedElement.ElementKind.VHDL_ARCHITECTURE && contextParamValues != null) {
            return workingSize > 0 ? contextParamValues.copy() : contextParamValues;
        }
        boolean isCaseSensitive = !ELUtils.isVHDL(binding) && !ELUtils.isVHDL(description);
        return ELParamValues.create(workingSize, isCaseSensitive);
    }

    private static boolean internalComputeDefparamValue(String paramName, IRfNamedElement param, IHidOperator defparam, IRfNamedElement defparamScope, ParserPath defparamParserPath, ElementPath defparamHierarchyPath, ELParamValues working, IHidEvaluator contextEvaluator, List<ELParamValues> paramValuesForDefparams, IHidEvaluationGuardian guardian, ElementPath hierarchyPath, ELManager manager) {
        IHidObject valueHidObject = defparam.getFirstRHValue();
        int i = paramValuesForDefparams.size() - 1;
        while (i >= 0) {
            guardian.updateElements(defparamScope, defparamScope);
            ELParamValuesHidEvaluator evaluator = paramValuesForDefparams.get(i).getHidEvaluator(manager);
            BitVectorContext context = ELUtils.makeEvaluatorContext(contextEvaluator, param, hierarchyPath, manager);
            IELParamValue finalValue = XUtils.getValue(ELUtils.evaluate(valueHidObject, evaluator, context, guardian));
            manager.state.increaseNofParameterEvals(finalValue);
            if (!ELUtils.isUnsuccessfulEval(finalValue)) {
                working.putDirectly(paramName, ELResolver.getDefParamActualValue(finalValue, defparam, defparamParserPath, defparamHierarchyPath));
                manager.logger.debug(ElaborationDebugZone.SECOND_PASS, "* put(", paramName, ",", finalValue, ")");
                break;
            }
            --i;
        }
        if (i < 0) {
            if (defparamScope != null && defparamScope.getDeclaration() != null) {
                int startOffset = defparam.getOccurrence().getOffset();
                int endOffset = startOffset + 1;
                int line = defparam.getOccurrence().getLine();
                ElementPath errorHierarchyPath = guardian.getHierarchyPath();
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                if (errorHierarchyPath != null && !errorHierarchyPath.isEmpty()) {
                    attributes.put("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE", errorHierarchyPath.toString());
                }
                manager.reportProblem(1, ElaborationDebugZone.SECOND_PASS, true, "UNRESOLVED_PARAMETER_VALUE: Cannot determine {0} value of parameter ''{1}'' from expression: {2}", defparamScope, defparamScope.getDeclaration(), startOffset, endOffset, line, attributes.isEmpty() ? null : attributes, hierarchyPath, "defparam", paramName, HidUtils.toNiceString(valueHidObject));
            }
            return false;
        }
        return true;
    }

    private static IELParamValue getDefParamActualValue(IELParamValue finalValue, IHidOperator defparamOperator, ParserPath parserPath, ElementPath defparamHierarchyPath) {
        IHidObject lhValue = defparamOperator.getLHValue();
        if (!(lhValue instanceof Hid)) {
            return null;
        }
        Hid hid = (Hid)lhValue;
        HidOccurrence occurrence = hid.getOccurrence();
        if (occurrence == null) {
            return null;
        }
        return finalValue.setFromDefparam(occurrence.getOffset(), parserPath, defparamHierarchyPath);
    }

    private static void computeDefparamAssigns(ELInstanceInContext instanceInContext, ELGraph<ElementPath, ELInstanceInContext, ELParamValues> graph, ELManager manager) {
        manager.checkBuildCanceled();
        if (manager.skipDefparams()) {
            return;
        }
        if (manager.isControlNoParamEval()) {
            return;
        }
        ELInstance instance = instanceInContext.instance;
        IRfNamedElement binding = instance.getBinding(false);
        ElementPath hierarchyPath = instance.getHierarchyPath();
        List<HidOperatorWrapper> defparams = ((IELDesign)binding).collectDefparams(manager.markElabHidObjects(), manager.getDefparamsCache());
        if (defparams == null || defparams.isEmpty()) {
            return;
        }
        for (HidOperatorWrapper defparamWrapper : defparams) {
            ELResolver.internalComputeDefparamAssigns((HidOperator)defparamWrapper.hidObject, binding, binding, defparamWrapper.path, instanceInContext, hierarchyPath, graph, manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalComputeDefparamAssigns(HidOperator operator, IRfNamedElement binding, IRfNamedElement defparamScope, ParserPath parserPath, ELInstanceInContext instanceInContext, ElementPath hierarchyPath, ELGraph<ElementPath, ELInstanceInContext, ELParamValues> graph, ELManager manager) {
        IHidObject paramHidObject = operator.getLHValue();
        if (!HidUtils.isHid(paramHidObject)) {
            return;
        }
        if (!operator.hasRHValues()) {
            return;
        }
        Hid paramHid = (Hid)paramHidObject;
        HidAccess parentAccess = paramHid.getParentAccess();
        if (parentAccess == null) {
            return;
        }
        ElementPath path = ElementPath.from(HidUtils.toStringBuilder(parentAccess, true, true, false, true, true, false).toString(), ".");
        if (path == null || path.length() < 1) {
            return;
        }
        String paramName = paramHid.getName();
        if (paramName == null) {
            return;
        }
        IHidObject valueHidObject = operator.getFirstRHValue();
        boolean hasDependency = false;
        Set<IHid> valueHids = HidUtils.flattenToHids(valueHidObject, HidFlatteningOption.IMPLICITS_EXCLUDED);
        if (valueHids != null) {
            ELParamValuesHidEvaluator evaluator = ELParamValues.EMPTY.getHidEvaluator(manager);
            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.DEFPARAM_ASSIGN, binding, hierarchyPath, false, evaluator.getManager());
            for (IHid valueHid : valueHids) {
                if (!HidUtils.isHid(valueHid)) continue;
                Hid ancestorValueHid = ((Hid)valueHid).getAncestorHid();
                IRfNamedElement valueElement = null;
                Hid hid = ancestorValueHid;
                synchronized (hid) {
                    ancestorValueHid.resolveInContext(evaluator, guardian, null, false);
                    valueElement = ancestorValueHid.getElement();
                }
                if (valueElement == null) continue;
                boolean bl = hasDependency = valueElement.getEnclosingScope(binding.getClass()) == binding;
                if (hasDependency) break;
            }
        }
        if (binding != null && binding.equals(defparamScope)) {
            ElementPath newAbsolutePath = ElementPath.join(hierarchyPath, path);
            manager.addPotentialDefparamValue(newAbsolutePath, new ELParamValues.ParamKeyValueLocationTuple(paramName, operator, hierarchyPath, binding, parserPath));
            if (hasDependency) {
                graph.addPossibleEdge(instanceInContext, newAbsolutePath);
            }
        }
        manager.addDefparamValue(path, new ELParamValues.ParamKeyValueLocationTuple(paramName, operator, hierarchyPath, binding, parserPath));
        if (hasDependency) {
            graph.addPossibleEdge(instanceInContext, path);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean computeParamValueCombined(ELParamValues working, Map<String, IRfNamedElement> workingParamMap, Map<String, IRfNamedElement> componentParamMap, IRfConfigurationRule configRule, Map<String, HidOperatorWrapper> configOverrides, Map<String, HidOperatorWrapper> instanceOverrides, Map<String, List<ELParamValues.ParamKeyValueLocationTuple>> defparams, Map<String, List<ELParamValues.ParamKeyValueLocationTuple>> potentialDefparams, Map<String, ELParamValues.BuildConfigParamKeyValueLocationTuple> buildConfigDefparams, List<ELParamValues> paramValuesForDefparams, ELParamValues contextParamValues, IRfConfiguration config, IRfDesignElement binding, IRfDesignElement architectureBinding, IRfInstanceElement description, boolean controlDeferredValueEval, boolean hasInterfacePorts, ElementPath hierarchyPath, ELManager manager, Object[] defaults, boolean[] hasDeferredValues) {
        IHidEvaluationGuardian configRuleGuardian = ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.CONFIG_PARAM, configRule, hierarchyPath, false, manager);
        IHidEvaluationGuardian defparamGuardian = ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.DEFPARAM_ASSIGN, binding, hierarchyPath, false, manager);
        IHidEvaluationGuardian instanceGuardian = ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.INSTANCE_PARAM, description, hierarchyPath, false, manager);
        IHidEvaluationGuardian defaultGuardian = ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.DEFAULT_VALUE_PARAM, binding, hierarchyPath, false, manager);
        ELParamValuesHidEvaluator paramContextEvaluator = working.getHidEvaluator(manager);
        if (DesignUtils.isVHDLComponent(binding)) {
            ELParamValues enclosingParamValues = contextParamValues.copy();
            paramContextEvaluator = enclosingParamValues.getHidEvaluator(manager);
        }
        ELParamValuesHidEvaluator evaluator = contextParamValues.getHidEvaluator(manager);
        ELParamValues localConfigParamValues = contextParamValues;
        ELParamValuesHidEvaluator localConfigEvaluator = evaluator;
        if (configOverrides != null && !configOverrides.isEmpty()) {
            config.elaborateConstants(manager);
            ELParamValues configWorking = manager.getExternalConstants(config);
            if (configWorking != null && !configWorking.isEmpty()) {
                localConfigParamValues = contextParamValues.copy();
                localConfigParamValues.putAll(configWorking);
                localConfigEvaluator = localConfigParamValues.getHidEvaluator(manager);
            }
        }
        if (manager.hasDefparams() && (paramValuesForDefparams == null || paramValuesForDefparams.isEmpty())) {
            paramValuesForDefparams = OptimizedUtils.listCreate(1);
            paramValuesForDefparams.add(ELParamValues.create(false));
        }
        if (instanceOverrides != null && !instanceOverrides.isEmpty()) {
            manager.state.maxNofParameterOverrides(instanceOverrides.size());
        }
        boolean hasExplicitConfigOverrides = configOverrides != null && !configOverrides.isEmpty();
        boolean isVHDLBinding = ELUtils.isVHDL(binding);
        boolean isVHDLDescription = ELUtils.isVHDL(description);
        boolean hasMissingParameterPortList = binding.hasMissingParameterPortList();
        for (Map.Entry<String, IRfNamedElement> entry : workingParamMap.entrySet()) {
            void field;
            IRfFieldElement iRfFieldElement;
            IRfNamedElement iRfNamedElement;
            String paramName = entry.getKey();
            if (working.containsKey(paramName)) continue;
            IRfNamedElement paramElement = entry.getValue();
            boolean isSet = false;
            isSet |= ELResolver.computeParamValueFromConfigRulePart(isSet, working, paramName, paramElement, configRule, configOverrides, paramContextEvaluator, localConfigEvaluator, hierarchyPath, configRuleGuardian, manager);
            isSet |= ELResolver.computeParamValueFromDefparamPart(isSet, working, paramName, paramElement, defparams, potentialDefparams, buildConfigDefparams, paramContextEvaluator, paramValuesForDefparams, hasMissingParameterPortList, hierarchyPath, defparamGuardian, manager);
            if (componentParamMap != null) {
                if (!hasExplicitConfigOverrides) {
                    isSet |= ELResolver.computeParamValueFromImplicitConfigRulePart(isSet, working, paramName, componentParamMap, contextParamValues, manager);
                }
            } else {
                isSet |= ELResolver.computeParamValueFromInstancePart(isSet, working, paramName, paramElement, instanceOverrides, paramContextEvaluator, evaluator, description, isVHDLBinding, isVHDLDescription, hierarchyPath, instanceGuardian, manager);
            }
            if (!((iRfNamedElement = paramElement) instanceof IRfFieldElement) || (iRfFieldElement = (IRfFieldElement)iRfNamedElement) != (IRfFieldElement)iRfNamedElement) continue;
            if (!hasInterfacePorts || field.isInParameterPortList()) {
                isSet |= ELResolver.computeParamValueFromDefaultPart(isSet, working, paramName, paramElement, defaults, paramContextEvaluator, architectureBinding, isVHDLBinding, isVHDLDescription, controlDeferredValueEval, hasDeferredValues, hierarchyPath, defaultGuardian, manager);
                continue;
            }
            hasDeferredValues[1] = hasDeferredValues[1] | true;
        }
        if (manager.markElabHidObjects()) {
            ELResolver.internalGetBindingOrComponentDefaultValues(defaults, architectureBinding, !isVHDLBinding && !isVHDLDescription, manager);
        }
        return false;
    }

    private static boolean computeParamValueFromImplicitConfigRulePart(boolean isSet, ELParamValues working, String paramName, Map<String, IRfNamedElement> componentParamMap, ELParamValues contextParamValues, ELManager manager) {
        if (isSet) {
            return false;
        }
        IRfNamedElement paramComponentElement = componentParamMap.get(paramName);
        if (paramComponentElement == null) {
            return false;
        }
        IELParamValue finalValue = contextParamValues.getValueDirectly(paramName);
        working.putDirectly(paramName, finalValue);
        manager.logger.debug(ElaborationDebugZone.SECOND_PASS, "* put(", paramName, ",", finalValue, ")");
        return true;
    }

    private static boolean computeParamValueFromDefaultPart(boolean isSet, ELParamValues working, String paramName, IRfNamedElement param, Object[] defaults, ELParamValuesHidEvaluator paramContextEvaluator, IRfDesignElement bindingOrComponent, boolean isVHDLBinding, boolean isVHDLDescription, boolean controlDeferredValueEval, boolean[] hasDeferredValues, ElementPath hierarchyPath, IHidEvaluationGuardian guardian, ELManager manager) {
        boolean isTypeParameter;
        if (isSet) {
            return false;
        }
        boolean isCaseSensitive = !isVHDLBinding && !isVHDLDescription;
        Map<String, HidOperatorWrapper> assigns = ELResolver.internalGetBindingOrComponentDefaultValues(defaults, bindingOrComponent, isCaseSensitive, manager);
        if (assigns == null || assigns.isEmpty()) {
            return false;
        }
        HidOperatorWrapper assignWrapper = assigns.get(paramName);
        if (assignWrapper == null) {
            return false;
        }
        HidOperator assign = (HidOperator)assignWrapper.hidObject;
        ListContainer<IHidObject> valueHidObjects = assign.getRHValues();
        if (valueHidObjects == null || valueHidObjects.isEmpty()) {
            return false;
        }
        ELParamValuesHidEvaluator evaluator = working.getHidEvaluator(manager);
        IELParamValue finalValue = null;
        IHidObject valueHidObject = valueHidObjects.get(0);
        boolean isUnresolvedOrIncompleteEvaluation = true;
        boolean bl = isTypeParameter = param instanceof IRfFieldElement && ((IRfFieldElement)param).isTypeParameter();
        if (isTypeParameter) {
            BitVectorContext defaultContext = ((IRfFieldElement)param).getDataTypeBitVectorContext(evaluator, true, hierarchyPath, manager);
            if (defaultContext != null && defaultContext.getContextType() != null) {
                IRfNamedElement contextType = defaultContext.getContextType();
                isUnresolvedOrIncompleteEvaluation = contextType instanceof IRfTypeElement && !((IRfTypeElement)contextType).isComplete();
                finalValue = ELParamValues.ParamValueType.of(contextType, defaultContext.getContextNumber());
            }
        } else {
            boolean valueIsAggregate;
            ISDataAbstract operatorResolvedType = assign.getOperatorResolvedType();
            boolean bl2 = valueIsAggregate = HidUtils.isOperator(valueHidObject) && ((HidOperator)valueHidObject).isAggregate();
            if (SDataUtils.isIllegalDataType(operatorResolvedType) || valueIsAggregate && operatorResolvedType == SDataAbstracts.UNDEFINED) {
                finalValue = IELParamValue.UNDEFINED_VALUE;
            } else {
                guardian.updateElements(param, param);
                BitVectorContext context = ELUtils.makeEvaluatorContext(paramContextEvaluator, param, hierarchyPath, manager);
                finalValue = XUtils.getValue(ELUtils.evaluate(valueHidObject, evaluator, context, guardian));
            }
            if (param instanceof IRfFieldElement) {
                ((IRfFieldElement)param).updateInitialValueParametricDependencyValue(valueHidObject.getInducedParametricDependencyValue());
            }
            isUnresolvedOrIncompleteEvaluation = ELUtils.isUnsuccessfulEval(finalValue);
        }
        if (controlDeferredValueEval && isUnresolvedOrIncompleteEvaluation && param instanceof IRfFieldElement && ((IRfFieldElement)param).hasInitialValueWithHierarchyPathReferences(valueHidObject)) {
            if (isTypeParameter) {
                finalValue = null;
            }
            if (!hasDeferredValues[0]) {
                manager.addDeferredParamValues(hierarchyPath);
                hasDeferredValues[0] = true;
            }
        } else if (finalValue == null && !hasDeferredValues[0]) {
            int startOffset = param.getDeclaration().getStartOffset();
            int endOffset = startOffset + paramName.length();
            int line = param.getDeclaration().getStartLine();
            ElementPath errorHierarchyPath = guardian.getHierarchyPath();
            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
            if (errorHierarchyPath != null && !errorHierarchyPath.isEmpty()) {
                attributes.put("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE", errorHierarchyPath.toString());
            }
            manager.reportProblem(ElaborationDebugZone.SECOND_PASS, true, "UNRESOLVED_PARAMETER_VALUE: Cannot determine {0} value of parameter ''{1}'' from expression: {2}", param, param.getDeclaration(), startOffset, endOffset, line, attributes.isEmpty() ? null : attributes, hierarchyPath, "default", param.getNameAndEnclosing(), param.getLanguageKind() == LanguageKind.VHDL ? HidUtils.toNiceStringVHDL(valueHidObject) : HidUtils.toNiceString(valueHidObject));
        }
        working.putDirectly(paramName, finalValue != null ? finalValue : IELParamValue.UNDEFINED_VALUE);
        manager.logger.debug(ElaborationDebugZone.SECOND_PASS, "* put(", paramName, ",", finalValue, ")");
        manager.state.increaseNofParameterEvals(finalValue);
        manager.state.incrementNofParameterDefaultEvals();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean computeParamValueFromInstancePart(boolean isSet, ELParamValues working, String paramName, IRfNamedElement param, Map<String, HidOperatorWrapper> overrides, ELParamValuesHidEvaluator paramContextEvaluator, ELParamValuesHidEvaluator evaluator, IRfInstanceElement description, boolean isVHDLBinding, boolean isVHDLDescription, ElementPath hierarchyPath, IHidEvaluationGuardian guardian, ELManager manager) {
        boolean valueIsAggregate;
        if (isSet) {
            return false;
        }
        if (overrides == null || overrides.isEmpty()) {
            return false;
        }
        HidOperatorWrapper overrideWrapper = overrides.get(paramName);
        if (overrideWrapper == null) {
            return false;
        }
        HidOperator override = (HidOperator)overrideWrapper.hidObject;
        IHidObject valueHidObject = GenericValueUtils.getValue(override);
        if (valueHidObject == null) {
            return false;
        }
        IELParamValue finalValue = null;
        ISDataAbstract operatorResolvedType = override.getOperatorResolvedType();
        boolean bl = valueIsAggregate = HidUtils.isOperator(valueHidObject) && ((HidOperator)valueHidObject).isAggregate();
        if (SDataUtils.isIllegalDataType(operatorResolvedType) || valueIsAggregate && operatorResolvedType == SDataAbstracts.UNDEFINED) {
            finalValue = IELParamValue.UNDEFINED_VALUE;
        } else {
            HidOperator hidOperator = override;
            synchronized (hidOperator) {
                BitVectorContext context;
                boolean isVHDLMethodParameter;
                guardian.updateElements(description, description);
                boolean isTypeParameter = param instanceof IRfFieldElement && ((IRfFieldElement)param).isTypeParameter() || param instanceof IRfVhdlTypeElement || param instanceof IRfTypeAliasElement;
                boolean bl2 = isVHDLMethodParameter = isVHDLBinding && param instanceof IRfMethodElement;
                BitVectorContext bitVectorContext = isTypeParameter ? BitVectorContext.of(param, true) : (context = isVHDLMethodParameter ? BitVectorContext.of(VhdlFunction.FUNCTION_CONTEXT, param) : ELUtils.makeEvaluatorContext(paramContextEvaluator, param, hierarchyPath, manager));
                if (context != null) {
                    context.setTimescaleScope((IRfNamedElement)description.getEnclosingScope());
                }
                finalValue = XUtils.getValue(ELUtils.evaluate(valueHidObject, evaluator, context, guardian));
                if (isVHDLBinding && !isVHDLDescription && context != null && context.hasUnconstrainedFirstDimension() && finalValue instanceof ELParamValues.ParamValueNumber && !(finalValue instanceof ELParamValues.ParamValueType)) {
                    DVTNumber newNumber = context.getVLOGValueForUnconstrainedVHDLArray(finalValue.getDVTNumber());
                    IELParamValue iELParamValue = finalValue = newNumber == DVTNumber.UNDEFINED ? null : ELParamValues.ParamValueNumber.of(newNumber);
                }
                if (finalValue == null) {
                    ElementPath errorHierarchyPath = guardian.getHierarchyPath();
                    HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                    if (errorHierarchyPath != null && !errorHierarchyPath.isEmpty()) {
                        attributes.put("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE", errorHierarchyPath.toString());
                    }
                    if (ELUtils.isVLOG(param) && GenericValueUtils.isFullNamedConnected(override)) {
                        int startOffset = override.getOffset();
                        int endOffset = startOffset + paramName.length();
                        int line = override.getLine();
                        manager.reportProblem(ElaborationDebugZone.SECOND_PASS, true, "UNRESOLVED_PARAMETER_VALUE: Cannot determine {0} value of parameter ''{1}'' from expression: {2}", description, description.getDeclaration(), startOffset, endOffset, line, attributes.isEmpty() ? null : attributes, hierarchyPath, "actual", param.getNameAndEnclosing(), HidUtils.toNiceString(valueHidObject));
                    } else {
                        int startOffset = override.getOffset();
                        int endOffset = startOffset + override.getOperatorText().length();
                        int line = override.getLine();
                        manager.reportProblem(ElaborationDebugZone.SECOND_PASS, true, "UNRESOLVED_PARAMETER_VALUE: Cannot determine {0} value of parameter ''{1}'' from expression: {2}", description, description.getDeclaration(), startOffset, endOffset, line, attributes.isEmpty() ? null : attributes, hierarchyPath, "actual", param.getNameAndEnclosing(), description.getLanguageKind() == LanguageKind.VHDL ? HidUtils.toNiceStringVHDL(valueHidObject) : HidUtils.toNiceString(valueHidObject));
                    }
                }
            }
        }
        working.putDirectly(paramName, finalValue != null ? finalValue : IELParamValue.UNDEFINED_VALUE);
        manager.logger.debug(ElaborationDebugZone.SECOND_PASS, "* put(", paramName, ",", finalValue, ")");
        manager.state.increaseNofParameterEvals(finalValue);
        return true;
    }

    private static boolean computeParamValueFromDefparamPart(boolean isSet, ELParamValues working, String paramName, IRfNamedElement param, Map<String, List<ELParamValues.ParamKeyValueLocationTuple>> defparams, Map<String, List<ELParamValues.ParamKeyValueLocationTuple>> potentialDefparams, Map<String, ELParamValues.BuildConfigParamKeyValueLocationTuple> buildConfigDefparams, ELParamValuesHidEvaluator paramContextEvaluator, List<ELParamValues> paramValuesForDefparams, boolean hasMissingParameterPortList, ElementPath hierarchyPath, IHidEvaluationGuardian guardian, ELManager manager) {
        ELParamValues.BuildConfigParamKeyValueLocationTuple defparamTuple;
        String message;
        int line;
        int endOffset;
        int startOffset;
        HidOccurrence ocurrence;
        IHidObject paramHidCandidate;
        List<ELParamValues.ParamKeyValueLocationTuple> defparamTuples;
        if (isSet) {
            return false;
        }
        ELParamValues.ParamKeyValueLocationTuple lastParamTuple = null;
        if (potentialDefparams != null && !potentialDefparams.isEmpty() && (defparamTuples = potentialDefparams.get(paramName)) != null) {
            for (ELParamValues.ParamKeyValueLocationTuple defparamTuple2 : defparamTuples) {
                if (defparamTuple2 == null) continue;
                if (ELUtils.isVLOGTypeParam(param)) {
                    if (defparamTuple2.scopeLocation == null) continue;
                    paramHidCandidate = defparamTuple2.assign.getLHValue();
                    HidOccurrence hidOccurrence = ocurrence = HidUtils.isHid(paramHidCandidate) ? ((Hid)paramHidCandidate).getOccurrence() : null;
                    if (ocurrence == null) {
                        ocurrence = defparamTuple2.assign.getOccurrence();
                    }
                    startOffset = ocurrence.getOffset();
                    endOffset = startOffset + paramName.length();
                    line = ocurrence.getLine();
                    message = "NON_OVERRIDABLE_PARAMETER: Type parameter ''{0}'' cannot be overridden by defparam assignment";
                    manager.reportProblem(1, ElaborationDebugZone.SECOND_PASS, false, message, defparamTuple2.scopeLocation, defparamTuple2.scopeLocation.getDeclaration(), startOffset, endOffset, line, null, hierarchyPath, paramName);
                    continue;
                }
                if (ELUtils.isVLOGParam(param) && !ELUtils.isVLOGPortListParam((IRfFieldElement)param, hasMissingParameterPortList) && defparamTuple2.scopeLocation != null) {
                    paramHidCandidate = defparamTuple2.assign.getLHValue();
                    HidOccurrence hidOccurrence = ocurrence = HidUtils.isHid(paramHidCandidate) ? ((Hid)paramHidCandidate).getOccurrence() : null;
                    if (ocurrence == null) {
                        ocurrence = defparamTuple2.assign.getOccurrence();
                    }
                    startOffset = ocurrence.getOffset();
                    endOffset = startOffset + paramName.length();
                    line = ocurrence.getLine();
                    message = ((IRfFieldElement)param).isLocalParameter() ? "NON_OVERRIDABLE_PARAMETER: Localparam ''{0}'' cannot be overridden by defparam assignment" : "NON_OVERRIDABLE_PARAMETER: Parameter ''{0}'' cannot be overridden by defparam assignment (is outside parameter port list)";
                    manager.reportProblem(1, ElaborationDebugZone.SECOND_PASS, false, message, defparamTuple2.scopeLocation, defparamTuple2.scopeLocation.getDeclaration(), startOffset, endOffset, line, null, hierarchyPath, paramName);
                    continue;
                }
                lastParamTuple = defparamTuple2;
            }
        }
        if (defparams != null && !defparams.isEmpty() && (defparamTuples = defparams.get(paramName)) != null) {
            for (ELParamValues.ParamKeyValueLocationTuple defparamTuple2 : defparamTuples) {
                if (defparamTuple2 == null) continue;
                if (ELUtils.isVLOGTypeParam(param)) {
                    if (defparamTuple2.scopeLocation == null) continue;
                    paramHidCandidate = defparamTuple2.assign.getLHValue();
                    HidOccurrence hidOccurrence = ocurrence = HidUtils.isHid(paramHidCandidate) ? ((Hid)paramHidCandidate).getOccurrence() : null;
                    if (ocurrence == null) {
                        ocurrence = defparamTuple2.assign.getOccurrence();
                    }
                    startOffset = ocurrence.getOffset();
                    endOffset = startOffset + paramName.length();
                    line = ocurrence.getLine();
                    message = "NON_OVERRIDABLE_PARAMETER: Type parameter ''{0}'' cannot be overridden by defparam assignment";
                    manager.reportProblem(1, ElaborationDebugZone.SECOND_PASS, false, message, defparamTuple2.scopeLocation, defparamTuple2.scopeLocation.getDeclaration(), startOffset, endOffset, line, null, hierarchyPath, paramName);
                    continue;
                }
                if (ELUtils.isVLOGParam(param) && !ELUtils.isVLOGPortListParam((IRfFieldElement)param, hasMissingParameterPortList) && defparamTuple2.scopeLocation != null) {
                    paramHidCandidate = defparamTuple2.assign.getLHValue();
                    HidOccurrence hidOccurrence = ocurrence = HidUtils.isHid(paramHidCandidate) ? ((Hid)paramHidCandidate).getOccurrence() : null;
                    if (ocurrence == null) {
                        ocurrence = defparamTuple2.assign.getOccurrence();
                    }
                    startOffset = ocurrence.getOffset();
                    endOffset = startOffset + paramName.length();
                    line = ocurrence.getLine();
                    message = ((IRfFieldElement)param).isLocalParameter() ? "NON_OVERRIDABLE_PARAMETER: Localparam ''{0}'' cannot be overridden by defparam assignment" : "NON_OVERRIDABLE_PARAMETER: Parameter ''{0}'' cannot be overridden by defparam assignment (is outside parameter port list)";
                    manager.reportProblem(1, ElaborationDebugZone.SECOND_PASS, false, message, defparamTuple2.scopeLocation, defparamTuple2.scopeLocation.getDeclaration(), startOffset, endOffset, line, null, hierarchyPath, paramName);
                    continue;
                }
                lastParamTuple = defparamTuple2;
            }
        }
        if (buildConfigDefparams != null && !buildConfigDefparams.isEmpty() && (defparamTuple = buildConfigDefparams.get(paramName)) != null && !ELUtils.isVLOGTypeParam(param)) {
            IRfSingleLangProject project = null;
            if (ELUtils.isVLOG(param)) {
                project = manager.getStartingVLOGProject();
            } else if (ELUtils.isVHDL(param)) {
                project = manager.getStartingVHDLProject();
            } else {
                return false;
            }
            HidOperator assign = project.getHidBuilders().buildDefparamOperator(defparamTuple.hierarchyPathLocation, param, defparamTuple.value, defparamTuple.offset);
            if (assign != null) {
                return ELResolver.internalComputeDefparamValue(paramName, param, assign, null, defparamTuple.parserPathLocation, defparamTuple.hierarchyPathLocation, working, paramContextEvaluator, paramValuesForDefparams, guardian, hierarchyPath, manager);
            }
        }
        if (lastParamTuple == null) {
            return false;
        }
        return ELResolver.internalComputeDefparamValue(paramName, param, lastParamTuple.assign, lastParamTuple.scopeLocation, lastParamTuple.parserPathLocation, lastParamTuple.hierarchyPathLocation, working, paramContextEvaluator, paramValuesForDefparams, guardian, hierarchyPath, manager);
    }

    private static boolean computeParamValueFromConfigRulePart(boolean isSet, ELParamValues working, String paramName, IRfNamedElement param, IRfConfigurationRule configRule, Map<String, HidOperatorWrapper> overrides, IHidEvaluator contextEvaluator, IHidEvaluator evaluator, ElementPath hierarchyPath, IHidEvaluationGuardian guardian, ELManager manager) {
        IELParamValue finalValue;
        if (isSet) {
            return false;
        }
        if (overrides == null || overrides.isEmpty() || configRule == null) {
            return false;
        }
        HidOperatorWrapper overrideWrapper = overrides.get(paramName);
        if (overrideWrapper == null) {
            return false;
        }
        HidOperator override = (HidOperator)overrideWrapper.hidObject;
        IHidObject valueHidObject = GenericValueUtils.getValue(override);
        if (valueHidObject == null) {
            return false;
        }
        guardian.updateElements(configRule, configRule);
        BitVectorContext context = ELUtils.makeEvaluatorContext(contextEvaluator, param, hierarchyPath, manager);
        if (context != null) {
            context.setTimescaleScope((IRfNamedElement)configRule.getEnclosingScope());
        }
        if ((finalValue = XUtils.getValue(ELUtils.evaluate(valueHidObject, evaluator, context, guardian))) == null) {
            ElementPath errorHierarchyPath = guardian.getHierarchyPath();
            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
            if (errorHierarchyPath != null && !errorHierarchyPath.isEmpty()) {
                attributes.put("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE", errorHierarchyPath.toString());
            }
            if (ELUtils.isVLOG(param) && GenericValueUtils.isFullNamedConnected(override)) {
                int startOffset = override.getOffset();
                int endOffset = startOffset + paramName.length();
                int line = override.getLine();
                manager.reportProblem(ElaborationDebugZone.SECOND_PASS, true, "UNRESOLVED_PARAMETER_VALUE: Cannot determine {0} value of parameter ''{1}'' from expression: {2}", configRule, configRule.getDeclaration(), startOffset, endOffset, line, attributes.isEmpty() ? null : attributes, hierarchyPath, "config", param.getNameAndEnclosing(), HidUtils.toNiceString(valueHidObject));
            } else {
                int startOffset = override.getOffset();
                int endOffset = startOffset + override.getOperatorText().length();
                int line = override.getLine();
                manager.reportProblem(ElaborationDebugZone.SECOND_PASS, true, "UNRESOLVED_PARAMETER_VALUE: Cannot determine {0} value of parameter ''{1}'' from expression: {2}", configRule, configRule.getDeclaration(), startOffset, endOffset, line, attributes.isEmpty() ? null : attributes, hierarchyPath, "config", param.getNameAndEnclosing(), configRule.getLanguageKind() == LanguageKind.VHDL ? HidUtils.toNiceStringVHDL(valueHidObject) : HidUtils.toNiceString(valueHidObject));
            }
        }
        working.putDirectly(paramName, finalValue != null && !ELUtils.isUnsuccessfulEval(finalValue) ? finalValue.setFromConfig(override.getOffset(), overrideWrapper.path) : IELParamValue.UNDEFINED_VALUE);
        manager.logger.debug(ElaborationDebugZone.SECOND_PASS, "* put(", paramName, ",", finalValue, ")");
        manager.state.increaseNofParameterEvals(finalValue);
        return true;
    }

    private static void computeOrGetBinding(ELInstanceInContext instanceInContext, ELManager manager) {
        ELInstance instance = instanceInContext.instance;
        IRfNamedElement binding = instance.getBinding(false);
        if (binding == null) {
            IRfConfiguration config = instanceInContext.context.getConfig();
            boolean isImplicitConfig = config instanceof DVTImplicitConfiguration;
            IELBindingFinder finder = ELUtils.isVHDL(config) || isImplicitConfig && ELUtils.isVHDL(instance.getDescription()) ? ELVHDLCore::computeConfigBinding : ELVLOGCore::computeConfigBinding;
            finder.computeConfigBinding(instanceInContext, manager);
        }
    }

    private static void checkSkippedInstance(ELInstanceInContext instanceInContext, ELManager manager) {
        ELInstance instance = instanceInContext.instance;
        if (!manager.isPermanentElaboration() || instance.isTop()) {
            return;
        }
        IRfNamedElement binding = instance.getBinding(true);
        ElementPath hierarchyPath = instance.getHierarchyPath();
        if (manager.skipBinding(binding) || manager.skipHierarchyPath(hierarchyPath)) {
            manager.logger.debug(ElaborationDebugZone.FIRST_PASS, "\n**** Skipped instance: ", hierarchyPath);
            boolean isBlock = instance.isBlock();
            ELSpecialization newSpec = ELSpecialization.of(ELConstants.SKIPPED_INSTANCE_TYPE);
            IRfNamedElement prevBinding = instance.getBinding(false);
            instanceInContext.visited.remove(prevBinding);
            instance.setSpecialization(newSpec);
            IRfInstanceElement description = instance.getDescription();
            IRfDefElement declaration = description.getDeclaration();
            if (declaration != null) {
                String descrName = description.getName();
                String bindingName = binding.getName();
                int offsetStart = declaration.getLabelStartOffset();
                int offsetEnd = offsetStart + (isBlock ? bindingName.length() : descrName.length());
                int line = declaration.getStartLine();
                manager.reportProblem(2, ElaborationDebugZone.FIRST_PASS, true, isBlock ? "SKIPPED_GENERATE_BLOCK: Generate block ''{0}'' is skipped" : "SKIPPED_INSTANCE: Instance ''{0}'' is skipped", description, declaration, offsetStart, offsetEnd, line, null, hierarchyPath, descrName);
            }
        }
    }

    private static void checkBBoxInstance(ELInstanceInContext instanceInContext, ELManager manager) {
        ELInstance instance = instanceInContext.instance;
        if (!manager.isPermanentElaboration() || instance.isTop()) {
            return;
        }
        IRfNamedElement binding = instance.getBinding(true);
        ElementPath hierarchyPath = instance.getHierarchyPath();
        if (manager.bboxBinding(binding) || manager.bboxHierarchyPath(hierarchyPath)) {
            boolean isBlock = instance.isBlock();
            instanceInContext.depth = Integer.MAX_VALUE;
            IRfInstanceElement description = instance.getDescription();
            IRfDefElement declaration = description.getDeclaration();
            if (declaration != null) {
                String descrName = description.getName();
                String bindingName = binding.getName();
                int offsetStart = declaration.getLabelStartOffset();
                int offsetEnd = offsetStart + (isBlock ? bindingName.length() : descrName.length());
                int line = declaration.getStartLine();
                manager.reportProblem(2, ElaborationDebugZone.FIRST_PASS, true, isBlock ? "BLACK_BOXED_GENERATE_BLOCK: Generate block ''{0}'' is black boxed" : "BLACK_BOXED_INSTANCE: Instance ''{0}'' is black boxed", description, declaration, offsetStart, offsetEnd, line, null, hierarchyPath, descrName);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void computeElaboratedBinds(ELInstance instance, ELParamValues cachedValues, ELManager manager) {
        List<ELManager.PreElaboratedBindInstance> bindsByName;
        List<ELManager.PreElaboratedBindInstance> bindsByElement;
        manager.checkBuildCanceled();
        ElementPath hierarchyPath = instance.getHierarchyPath();
        IRfNamedElement basicBinding = instance.getBinding(true);
        if (basicBinding instanceof IELDesign) {
            manager.updateElaboratedBindScopePath(basicBinding, hierarchyPath);
        }
        if ((bindsByElement = manager.getPotentialBindsByElement(basicBinding)) != null) {
            block13: for (ELManager.PreElaboratedBindInstance preElabInstance : bindsByElement) {
                Hid hid;
                ELBindElementPath.ELBindElementPathKind kind = preElabInstance.preElab.getKind();
                if (kind == ELBindElementPath.ELBindElementPathKind.BY_TYPE_NAME || kind == ELBindElementPath.ELBindElementPathKind.BY_TYPE_NAME_AND_INSTANCE_NAME) {
                    manager.logger.debug(ElaborationDebugZone.BINDS_PASS, "Found wrong type name/instance name pre-elaboration for instance and bind:", instance, preElabInstance.description.getNameAndEnclosing());
                    continue;
                }
                IHidObject hidObject = preElabInstance.preElab.getTarget();
                if (hidObject == null) continue;
                switch (hidObject.getHidKind()) {
                    case ACCESS: {
                        hid = ((HidAccess)hidObject).getParentHid();
                        break;
                    }
                    case HID: {
                        hid = (Hid)hidObject;
                        break;
                    }
                    default: {
                        manager.logger.debug(ElaborationDebugZone.BINDS_PASS, "No pre-elaboration was found for instance and bind:", instance, preElabInstance.description.getNameAndEnclosing());
                        continue block13;
                    }
                }
                if (cachedValues == null) {
                    cachedValues = instance.getParamValues();
                }
                ELParamValuesHidEvaluator evaluator = cachedValues.getHidEvaluator(manager);
                IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.BIND, basicBinding, hierarchyPath, false, manager);
                List<HidNameAndSelects> hidAccessList = hid.getHidAccessList(evaluator, guardian);
                ElementPath newPath = ElementPath.from(hidAccessList);
                if (kind == ELBindElementPath.ELBindElementPathKind.BY_RELATIVE_PATH) {
                    newPath = newPath != null && !newPath.isEmpty() ? ElementPath.join(hierarchyPath, newPath) : null;
                }
                if (newPath == null) {
                    manager.logger.debug(ElaborationDebugZone.BINDS_PASS, "No pre-elaboration was found for instance and bind:", instance, preElabInstance.description.getNameAndEnclosing());
                    continue;
                }
                ELManager.ElaboratedTargetPathWithOrigin newBindWithOrigin = ELManager.ElaboratedTargetPathWithOrigin.of(newPath, preElabInstance.preElab.getKind(), hierarchyPath);
                manager.addElaboratedBind(preElabInstance.description, newBindWithOrigin);
                manager.logger.debug(ElaborationDebugZone.BINDS_PASS, "\n**** Added bind: ", newBindWithOrigin);
            }
        }
        if ((bindsByName = manager.getPotentialBindsByName(basicBinding.getName())) != null) {
            block14: for (ELManager.PreElaboratedBindInstance preElabInstance : bindsByName) {
                ElementPath newPath = null;
                switch (preElabInstance.preElab.getKind()) {
                    case BY_ABSOLUTE_PATH: 
                    case BY_RELATIVE_PATH: {
                        manager.logger.debug(ElaborationDebugZone.BINDS_PASS, "Found wrong absolute/relative pre-elaboration for instance and bind:", instance, preElabInstance.description.getNameAndEnclosing());
                        continue block14;
                    }
                    case BY_TYPE_NAME: {
                        newPath = hierarchyPath;
                        break;
                    }
                    case BY_TYPE_NAME_AND_INSTANCE_NAME: {
                        Hid hid;
                        IHidObject hidObject = preElabInstance.preElab.getTarget();
                        if (hidObject == null) continue block14;
                        switch (hidObject.getHidKind()) {
                            case ACCESS: {
                                hid = ((HidAccess)hidObject).getParentHid();
                                break;
                            }
                            case HID: {
                                hid = (Hid)hidObject;
                                break;
                            }
                            default: {
                                continue block14;
                            }
                        }
                        if (cachedValues == null) {
                            cachedValues = instance.getParamValues();
                        }
                        ELParamValuesHidEvaluator evaluator = cachedValues.getHidEvaluator(manager);
                        IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.BIND, basicBinding, hierarchyPath, false, manager);
                        List<HidNameAndSelects> hidAccessList = hid.getHidAccessList(evaluator, guardian);
                        ElementPath targetPath = ElementPath.from(hidAccessList);
                        IRfInstanceElement description = instance.getDescription();
                        if (description.getName() == null || targetPath == null || targetPath.length() != 1 || !description.getName().equals(targetPath.getSegment(0))) break;
                        newPath = hierarchyPath;
                    }
                }
                if (newPath == null) continue;
                ELManager.ElaboratedTargetPathWithOrigin newBindWithOrigin = ELManager.ElaboratedTargetPathWithOrigin.of(newPath, preElabInstance.preElab.getKind(), ELConstants.LIBRARY_PATH);
                manager.addElaboratedBind(preElabInstance.description, newBindWithOrigin);
                manager.logger.debug(ElaborationDebugZone.BINDS_PASS, "\n**** Added bind: ", newBindWithOrigin);
            }
        }
    }

    static void findBoundInstancesNew(List<ELInstanceInContext> newTops, boolean incremental, ELManager manager) {
        manager.checkBuildCanceled();
        Map<IRfInstanceElement, List<ELManager.ElaboratedTargetPathWithOrigin>> bindsMap = manager.getElaboratedBinds();
        if (bindsMap == null || bindsMap.isEmpty()) {
            return;
        }
        LinkedHashMap<ElementPath, ElementPath> visited = new LinkedHashMap<ElementPath, ElementPath>();
        Iterator<Map.Entry<IRfInstanceElement, List<ELManager.ElaboratedTargetPathWithOrigin>>> entryIterator = bindsMap.entrySet().iterator();
        IELMemory memory = manager.getMemory();
        while (entryIterator.hasNext()) {
            manager.checkBuildCanceled();
            Map.Entry<IRfInstanceElement, List<ELManager.ElaboratedTargetPathWithOrigin>> entry = entryIterator.next();
            IRfInstanceElement description = entry.getKey();
            List<ELManager.ElaboratedTargetPathWithOrigin> targetPathsWithOrigins = entry.getValue();
            if (targetPathsWithOrigins == null || targetPathsWithOrigins.isEmpty()) {
                entryIterator.remove();
                continue;
            }
            List<ElementPath> elaboratedOrigins = null;
            Iterator<ELManager.ElaboratedTargetPathWithOrigin> targetPathsIterator = targetPathsWithOrigins.iterator();
            while (targetPathsIterator.hasNext()) {
                ElementPath newPath;
                manager.checkBuildCanceled();
                ELManager.ElaboratedTargetPathWithOrigin targetPathWithOrigin = targetPathsIterator.next();
                ElementPath targetPath = targetPathWithOrigin.targetPath;
                ELBindElementPath.ELBindElementPathKind preElabKind = targetPathWithOrigin.kind;
                ELInstance targetInstance = memory.instanceFor(targetPath);
                if (targetInstance == null) {
                    manager.reportProblemForElement(ElaborationDebugZone.BINDS_PASS, true, "UNELABORATED_BIND_TARGET: Hierarchical name ''{0}'' is not elaborated", description, null, targetPath);
                    manager.logger.debug(ElaborationDebugZone.BINDS_PASS, "Bind target path not found:", targetPath);
                    continue;
                }
                IRfInstanceElement targetInstanceDescription = targetInstance.getDescription();
                if (!ELUtils.hasValidBinding(targetInstance)) {
                    String unresolvedModule = targetInstanceDescription.getAssociatedTypeName();
                    manager.reportProblemForElement(ElaborationDebugZone.BINDS_PASS, true, "UNRESOLVED_BIND_TARGET_INSTANCE: Module ''{0}'' of bind target instance ''{1}'' is not declared", description, null, unresolvedModule, targetPath);
                    manager.logger.debug(ElaborationDebugZone.BINDS_PASS, "Bind target", unresolvedModule, "is unresolved:", targetPath);
                    continue;
                }
                if (targetInstanceDescription.isInstanceToBind()) {
                    manager.reportProblemForElement(ElaborationDebugZone.BINDS_PASS, true, "INVALID_BIND_UNDERNEATH_BIND_INSTANCE: Cannot bind instance ''{0}'' underneath bind instance ''{1}''", description, null, description.getName(), targetInstanceDescription.getName());
                    manager.logger.debug(ElaborationDebugZone.BINDS_PASS, "Bind underneath bind", description.getName());
                    continue;
                }
                if (description.getTargetScope() != null) {
                    IRfNamedElement targetBinding = targetInstance.getBinding(true);
                    String targetScopeName = description.getTargetScope();
                    if (!targetScopeName.equals(targetBinding.getName())) {
                        manager.reportProblemForElement(ElaborationDebugZone.BINDS_PASS, true, "INVALID_BIND_TARGET_SCOPE: Bind target scope ''{0}'' and module ''{1}'' of bind target instance ''{2}'' must match", description, null, targetScopeName, targetBinding.getName(), targetPath);
                        manager.logger.debug(ElaborationDebugZone.BINDS_PASS, "Bind target scope", targetScopeName, "is different from target instance type", targetBinding.getName(), "for path:", targetPath);
                        continue;
                    }
                }
                if (preElabKind == ELBindElementPath.ELBindElementPathKind.BY_TYPE_NAME || preElabKind == ELBindElementPath.ELBindElementPathKind.BY_TYPE_NAME_AND_INSTANCE_NAME) {
                    if (elaboratedOrigins == null) {
                        elaboratedOrigins = manager.getElaboratedBindScopePaths(description.getEnclosingScope(), description);
                    }
                    if (elaboratedOrigins == null || elaboratedOrigins.isEmpty()) {
                        manager.logger.debug(ElaborationDebugZone.BINDS_PASS, "Found inactive type name/instance name bind:", description.getNameAndEnclosing());
                        continue;
                    }
                    targetPathsIterator.remove();
                    newPath = ELUtils.appendToPath(targetPath, description);
                    for (ElementPath elaboratedOrigin : elaboratedOrigins) {
                        ELResolver.internalFindBoundInstanceNew(newTops, description, elaboratedOrigin, newPath, targetInstance, preElabKind == ELBindElementPath.ELBindElementPathKind.BY_TYPE_NAME, incremental, visited, manager);
                    }
                    continue;
                }
                targetPathsIterator.remove();
                newPath = ELUtils.appendToPath(targetPath, description);
                ELResolver.internalFindBoundInstanceNew(newTops, description, targetPathWithOrigin.origin, newPath, targetInstance, false, incremental, visited, manager);
            }
            if (!targetPathsWithOrigins.isEmpty()) continue;
            entryIterator.remove();
        }
    }

    private static void internalFindBoundInstanceNew(List<ELInstanceInContext> newTops, IRfInstanceElement bind, ElementPath bindOrigin, ElementPath newPath, ELInstance targetInstance, boolean bindByTypeName, boolean incremental, Map<ElementPath, ElementPath> visited, ELManager manager) {
        boolean isUnderProgram;
        ElementPath visitedBindOrigin = visited.get(newPath);
        if (visitedBindOrigin != null) {
            int compare = visitedBindOrigin.compareTo(bindOrigin);
            ElementPath first = compare >= 0 ? bindOrigin : visitedBindOrigin;
            ElementPath second = compare >= 0 ? visitedBindOrigin : bindOrigin;
            manager.reportProblemForElement(ElaborationDebugZone.BINDS_PASS, true, "DUPLICATE_BOUND_INSTANCE: Duplicate bound instance ''{0}''\n    added from both instance ''{1}'' and instance ''{2}''", bind, null, bind.getName(), first, second);
            return;
        }
        visited.put(newPath, bindOrigin);
        IRfNamedElement targetBinding = targetInstance.getBinding(false);
        if (!(targetBinding instanceof IRfDesignElement)) {
            return;
        }
        boolean hasDuplicateElement = false;
        IRfNamedElement prevBindScope = bind.getBindInstanceScope();
        if (prevBindScope == null) {
            IRfDefElement firstDecl;
            IRfNamedElement localMember = targetBinding.getLocalMember(null, bind.getName(), null);
            if (localMember != null && (firstDecl = localMember.getDeclaration()) != null) {
                hasDuplicateElement = true;
                manager.reportProblemForElement(ElaborationDebugZone.BINDS_PASS, true, "DUPLICATE_BOUND_INSTANCE: Name collision in target scope of bound instance ''{0}'' with element declared\n    at line {1,number,#######} in {2}", bind, null, bind.getName(), firstDecl.getStartLine(), firstDecl.getParserPath());
            }
            bind.setBindInstanceScope(targetBinding);
            bind.resolveBindLocalHids();
            IRfLibraryElement enclosingLibrary = bind.getEnclosingLibrary();
            if (enclosingLibrary != null) {
                IRfNamedElement reference = targetBinding instanceof IRfEntityComplement ? ((IRfEntityComplement)((Object)targetBinding)).getEntity() : targetBinding;
                enclosingLibrary.addReference(reference.getName(), bind);
                if (!bindByTypeName) {
                    enclosingLibrary.addReference(targetInstance.getDescription().getName(), bind);
                }
            }
            ((IRfDesignElement)targetBinding).addBindInstance(bind);
        } else if (!prevBindScope.equals(targetBinding)) {
            manager.logger.debug(ElaborationDebugZone.BINDS_PASS, "Different bind target scope", targetBinding, " from previous bind target", prevBindScope);
        }
        ELContext targetContext = ELContext.of(targetInstance);
        ELParamValues targetParamValues = targetInstance.getParamValues();
        OptimizedIdentityHashSet<IRfNamedElement> subInstanceVisited = new OptimizedIdentityHashSet<IRfNamedElement>();
        int[] parentDepth = new int[]{-1};
        ELUtils.computeVisitedAndDepthFromElementPath(newPath, subInstanceVisited, parentDepth, manager.getMemory());
        boolean bl = isUnderProgram = DesignUtils.getDesignKind(targetBinding) == IRfNamedElement.ElementKind.VLOG_PROGRAM || ELResolver.internalIsUnderGenerateInProgram(newPath, manager.getMemory());
        if (bind.isArray()) {
            ELResolver.internalFindArrayOfInstances(bind, targetInstance, targetParamValues, targetContext, bindOrigin, newTops, bindByTypeName ? subInstanceVisited : new OptimizedIdentityHashSet<IRfNamedElement>(), parentDepth[0], isUnderProgram, manager);
        } else {
            ELInstance existingInstance = manager.getMemory().instanceFor(newPath);
            if (!incremental && existingInstance != null) {
                if (!hasDuplicateElement) {
                    manager.reportProblemForElement(ElaborationDebugZone.BINDS_PASS, true, "DUPLICATE_BOUND_INSTANCE: Duplicate bound instance ''{0}'' added from instance ''{1}''", bind, null, bind.getName(), bindOrigin);
                }
                return;
            }
            ELInstance subInstance = ELInstance.of(bind, newPath, manager);
            newTops.add(ELInstanceInContext.of(subInstance, targetContext, bindByTypeName ? subInstanceVisited : new OptimizedIdentityHashSet<IRfNamedElement>(), parentDepth[0], isUnderProgram));
        }
    }

    private static boolean internalIsUnderGenerateInProgram(ElementPath targetInstancePath, IELMemory memory) {
        ELInstance instance;
        if (targetInstancePath == null || memory == null) {
            return false;
        }
        ElementPath starting = ElementPath.upperPathOf(targetInstancePath);
        if (starting == null || starting.isEmpty()) {
            return false;
        }
        IRfNamedElement.ElementKind designKind = IRfNamedElement.ElementKind.UNKNOWN;
        do {
            if ((instance = memory.instanceFor(starting)) != null) continue;
            return false;
        } while ((designKind = DesignUtils.getDesignKind(instance.getBinding(false))) == IRfNamedElement.ElementKind.VLOG_GENERATE && (starting = ELUtils.upperPathOf(starting)) != null && !starting.isEmpty());
        return designKind == IRfNamedElement.ElementKind.VLOG_PROGRAM;
    }
}

