/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELDesign;
import ro.amiq.dvt.elaboration.model.IELParamKeyValueCompact;
import ro.amiq.dvt.model.reflection.ArrayOfInstancesBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;

public class ELSpecialization
implements Comparable<ELSpecialization> {
    public static final ELSpecialization EMPTY = new ELSpecialization(null, ELParamValues.EMPTY, null);
    private final IELDesign binding;
    private final Object[] packedParamValues;
    private Map<String, Supplier<InterfacePortInstance>> interfacePortInstances;

    private ELSpecialization(IELDesign binding, ELParamValues paramValues, Map<String, Supplier<InterfacePortInstance>> interfacePortInstances) {
        this.binding = binding;
        this.packedParamValues = paramValues.pack();
        this.interfacePortInstances = interfacePortInstances;
    }

    public static ELSpecialization of(IELDesign binding) {
        return new ELSpecialization(binding, ELParamValues.EMPTY, null);
    }

    public static ELSpecialization of(IELDesign binding, Map<String, Supplier<InterfacePortInstance>> interfacePortInstances) {
        return new ELSpecialization(binding, ELParamValues.EMPTY, interfacePortInstances);
    }

    public static ELSpecialization packedOf(IELDesign binding, ELParamValues paramValues) {
        return ELSpecialization.packedOf(binding, paramValues, null);
    }

    public static ELSpecialization packedOf(IELDesign binding, ELParamValues paramValues, Map<String, Supplier<InterfacePortInstance>> interfacePortPaths) {
        if (binding == null) {
            throw new IllegalArgumentException("Binding cannot be null");
        }
        if (paramValues == null) {
            throw new IllegalArgumentException("Parameter values cannot be null");
        }
        return new ELSpecialization(binding, paramValues, interfacePortPaths);
    }

    IRfNamedElement getBinding(boolean stripToEntity) {
        return stripToEntity ? ELUtils.unwrapArchitecture(this.binding) : this.binding;
    }

    String getDefaultNettype() {
        if (this.binding instanceof IRfDesignElement) {
            return ((IRfDesignElement)((Object)this.binding)).getDefaultNetType(this.binding);
        }
        return "wire";
    }

    void setSemanticEnable(byte semanticEnable) {
        if (this.binding instanceof IRfDesignElement) {
            ((IRfDesignElement)((Object)this.binding)).setSemanticEnable(semanticEnable);
        }
    }

    ELParamValues getParamValues(boolean isVHDLDescription) {
        boolean isCaseSensitive = !ELUtils.isVHDL(this.binding) && !isVHDLDescription;
        return this.packedParamValues != null ? ELParamValues.unpack(this.packedParamValues, isCaseSensitive) : null;
    }

    ELParamValues getParamValuesWithKeyFilter(Predicate<String> keyFilter, boolean isVHDLDescription) {
        boolean isCaseSensitive = !ELUtils.isVHDL(this.binding) && !isVHDLDescription;
        return this.packedParamValues != null ? ELParamValues.unpackWithKeyFilter(this.packedParamValues, isCaseSensitive, keyFilter) : null;
    }

    void deepClean() {
        if (this.binding != null && !this.binding.hasNoDefs(true)) {
            this.binding.cleanElaborationInfo();
        }
    }

    boolean isArrayOfInstancesBlock() {
        return this.binding instanceof ArrayOfInstancesBlockElement;
    }

    boolean isSkipped() {
        return this.binding == ELConstants.SKIPPED_INSTANCE_TYPE;
    }

    public InterfacePortInstance getInterfacePortInstance(String port) {
        if (this.interfacePortInstances == null) {
            return null;
        }
        Supplier<InterfacePortInstance> portSupplier = this.interfacePortInstances.get(port);
        return portSupplier != null ? portSupplier.get() : null;
    }

    public Map<String, Supplier<InterfacePortInstance>> getInterfacePortInstances() {
        return this.interfacePortInstances;
    }

    public void addInterfacePortInstance(String port, Supplier<InterfacePortInstance> portInstance) {
        if (this.interfacePortInstances == null) {
            this.interfacePortInstances = new HashMap<String, Supplier<InterfacePortInstance>>();
        }
        this.interfacePortInstances.put(port, portInstance);
    }

    public int hashCode() {
        return this.hashCode(true);
    }

    public int hashCode(boolean checkBinding) {
        if (this.interfacePortInstances != null) {
            return System.identityHashCode(this);
        }
        int result = 1;
        result = 31 * result + (this.binding == null || !checkBinding ? 0 : System.identityHashCode(this.binding));
        if (this.packedParamValues != null) {
            Object[] objectArray = this.packedParamValues;
            int n = this.packedParamValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object paramValue = objectArray[n2];
                result = 31 * result + paramValue.hashCode();
                ++n2;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true, false);
    }

    public boolean equals(Object obj, boolean checkBinding, boolean checkOnlyParamValue) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ELSpecialization)) {
            return false;
        }
        ELSpecialization other = (ELSpecialization)obj;
        if (checkBinding && this.binding != other.binding) {
            return false;
        }
        int length = this.packedParamValues.length;
        if (other.packedParamValues.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!(this.packedParamValues[i] instanceof IELParamKeyValueCompact) || !(other.packedParamValues[i] instanceof IELParamKeyValueCompact)) {
                return false;
            }
            IELParamKeyValueCompact o1 = (IELParamKeyValueCompact)this.packedParamValues[i];
            IELParamKeyValueCompact o2 = (IELParamKeyValueCompact)other.packedParamValues[i];
            if (!o1.internalEquals(o2, checkOnlyParamValue)) {
                return false;
            }
            ++i;
        }
        return this.interfacePortInstances == null && other.interfacePortInstances == null;
    }

    @Override
    public int compareTo(ELSpecialization other) {
        boolean otherHasInterfacePorts;
        if (this.binding == null || other.binding == null || this.packedParamValues == null || other.packedParamValues == null) {
            return 0;
        }
        int nameCmp = this.binding.getName().compareTo(other.binding.getName());
        if (nameCmp != 0) {
            return nameCmp;
        }
        int length = Math.min(this.packedParamValues.length, other.packedParamValues.length);
        int i = 0;
        while (i < length) {
            IELParamKeyValueCompact o1 = (IELParamKeyValueCompact)this.packedParamValues[i];
            IELParamKeyValueCompact o2 = (IELParamKeyValueCompact)other.packedParamValues[i];
            int cmp = o1.toString().compareTo(o2.toString());
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        boolean hasInterfacePorts = this.interfacePortInstances != null;
        boolean bl = otherHasInterfacePorts = other.interfacePortInstances != null;
        return hasInterfacePorts == otherHasInterfacePorts ? 0 : (hasInterfacePorts ? 1 : -1);
    }

    public static class InterfacePortInstance {
        private final ELInstance instance;
        private final String modportName;

        public InterfacePortInstance(ELInstance instance, String modportName) {
            this.instance = instance;
            this.modportName = modportName;
        }

        public ELInstance getInstance() {
            return this.instance;
        }

        public IRfNamedElement getType() {
            IRfNamedElement binding = this.instance.getBinding(false);
            return this.modportName == null ? binding : ((IRfDesignElement)binding).getModportWithPrefix(this.modportName, 1);
        }
    }
}

