/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import java.util.Collection;
import java.util.StringJoiner;
import java.util.concurrent.ArrayBlockingQueue;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecialization;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;

public class ELSpecializationWrapper {
    public static final ELSpecializationWrapper EMPTY = new ELSpecializationWrapper(ELSpecialization.EMPTY, false, null);
    public ELSpecialization spec;
    public boolean isVHDLDescription;
    public ArrayBlockingQueue<ElementPath> paths;

    static ELSpecializationWrapper contextOf(ELSpecialization spec) {
        if (spec == null) {
            throw new IllegalArgumentException("Specialization cannot be null");
        }
        return new ELSpecializationWrapper(spec, false, null);
    }

    public static ELSpecializationWrapper of(ELSpecialization spec, boolean isVHDLDescription, ElementPath hierarchyPath) {
        if (spec == null) {
            throw new IllegalArgumentException("Specialization cannot be null");
        }
        if (hierarchyPath == null) {
            throw new IllegalArgumentException("Hierarchy path cannot be null");
        }
        ArrayBlockingQueue<ElementPath> newPaths = new ArrayBlockingQueue<ElementPath>(10);
        newPaths.add(hierarchyPath);
        return new ELSpecializationWrapper(spec, isVHDLDescription, newPaths);
    }

    private ELSpecializationWrapper(ELSpecialization spec, boolean isVHDLDescription, ArrayBlockingQueue<ElementPath> paths) {
        this.spec = spec;
        this.isVHDLDescription = isVHDLDescription;
        this.paths = paths;
    }

    public void addPaths(Collection<ElementPath> path) {
        if (this.paths == null) {
            throw new IllegalArgumentException("Invalid specialization wrapper without paths");
        }
        for (ElementPath elementPath : path) {
            this.paths.offer(elementPath);
        }
    }

    public ELWidthCheckContext getElabContext(ELManager manager) {
        return ELWidthCheckContext.of(this.spec.getParamValues(this.isVHDLDescription), this.paths, manager);
    }

    public IHidEvaluator getHidEvaluator(ELManager manager) {
        ELParamValues paramValues = this.spec.getParamValues(this.isVHDLDescription);
        return paramValues != null ? paramValues.getHidEvaluator(manager) : null;
    }

    public String getPathsText() {
        StringJoiner sj = new StringJoiner(", ");
        for (ElementPath path : this.paths) {
            sj.add(path.toString());
        }
        return sj.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ELParamValues paramValues = this.spec.getParamValues(this.isVHDLDescription);
        if (paramValues != null) {
            sb.append(paramValues.toString());
        }
        if (this.paths != null) {
            sb.append("@").append(this.paths.toString());
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.spec.hashCode(false);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ELSpecializationWrapper other = (ELSpecializationWrapper)obj;
        return this.spec.equals(other.spec, false, false);
    }
}

