/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELContext;
import ro.amiq.dvt.elaboration.core.ELCore;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELInstanceInContext;
import ro.amiq.dvt.elaboration.model.ELLiblist;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.BindingRuleWrapper;
import ro.amiq.dvt.model.reflection.DVTImplicitConfiguration;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public interface ELVHDLCore {
    public static final /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$model$reflection$IRfConfigurationRule$ConfigCoverage;

    public static IRfConfigurationRule getConfigurationRule(IRfInstanceElement desc, IRfDesignElement descrComponent, Collection<? extends IRfConfigurationRule> candidateRules) {
        if (candidateRules == null || candidateRules.isEmpty() || descrComponent == null) {
            return null;
        }
        ArrayList<IRfInstanceElement> usedInstances = new ArrayList<IRfInstanceElement>();
        block5: for (IRfConfigurationRule iRfConfigurationRule : candidateRules) {
            IRfDesignElement computedComponent;
            if (iRfConfigurationRule.isBlockRule() || !descrComponent.equals(computedComponent = iRfConfigurationRule.getComponentElement())) continue;
            switch (iRfConfigurationRule.getRuleCoverage()) {
                case LIST: {
                    List<? extends IRfInstanceElement> listInstances;
                    if (desc == null || (listInstances = iRfConfigurationRule.getSpecificationInstances()) == null) continue block5;
                    for (IRfInstanceElement iRfInstanceElement : listInstances) {
                        if (desc.equals(iRfInstanceElement)) {
                            return iRfConfigurationRule;
                        }
                        usedInstances.add(iRfInstanceElement);
                    }
                    continue block5;
                }
                case OTHERS: {
                    if (desc == null || usedInstances.contains(desc)) continue block5;
                    return iRfConfigurationRule;
                }
                case ALL: {
                    return iRfConfigurationRule;
                }
            }
        }
        return null;
    }

    public static IRfConfigurationRule getBlockConfigurationRule(IRfBlockElement block, IHidObject blockParameterValue, ELParamValues values, ELManager manager, Collection<? extends IRfConfigurationRule> candidateRules) {
        if (block == null || candidateRules == null || candidateRules.isEmpty()) {
            return null;
        }
        for (IRfConfigurationRule iRfConfigurationRule : candidateRules) {
            IRfNamedElement blockSpecification;
            if (!iRfConfigurationRule.isBlockRule() || !((blockSpecification = iRfConfigurationRule.getResolvedDesignMapping(null)) instanceof IRfBlockElement) || !block.equals(blockSpecification) || block.isLoopGenerate() && !ELVHDLCore.matchLoopBlockWithIndex(iRfConfigurationRule, blockParameterValue, values, manager)) continue;
            return iRfConfigurationRule;
        }
        return null;
    }

    public static boolean matchLoopBlockWithIndex(IRfConfigurationRule configRuleBlock, IHidObject blockParameterValue, ELParamValues values, ELManager manager) {
        if (blockParameterValue == null) {
            return false;
        }
        IELParamValue value = XUtils.getValue(ELUtils.evaluate(blockParameterValue, ELParamValues.EMPTY.getHidEvaluator(manager), BitVectorContext.of(configRuleBlock, false), ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.RANGE, configRuleBlock, null, false, manager)));
        if (ELUtils.isUnsuccessfulEval(value)) {
            return false;
        }
        DVTNumber valueNumber = value.getDVTNumber();
        if (!(valueNumber instanceof VlogBitVector)) {
            return false;
        }
        int indexValue = valueNumber.intValue();
        return configRuleBlock.isValidForIndex(indexValue, values, manager);
    }

    public static void computeConfigBinding(ELInstanceInContext instanceInContext, ELManager manager) {
        IRfNamedElement contextBinding;
        BindingRuleWrapper bindingResult;
        ELLiblist liblist;
        ELInstance instance = instanceInContext.instance;
        ELContext context = instanceInContext.context;
        IRfInstanceElement description = instance.getDescription();
        String assocTypeName = description.getAssociatedTypeName();
        IRfDesignElement componentCandidate = description.getVHDLPreElaborationDesign();
        IRfDesignElement componentDesign = DesignUtils.isVHDLComponent(componentCandidate) ? componentCandidate : null;
        IRfConfiguration config = context.getConfig();
        ElementPath instancePath = instance.getHierarchyPath();
        IRfNamedElement binding = null;
        IRfConfigurationRule configRule = null;
        Collection<? extends IRfConfigurationRule> childrenRules = null;
        if (componentDesign != null && !(config instanceof DVTImplicitConfiguration) && (configRule = ELVHDLCore.getConfigurationRule(description, componentDesign, context.getChildrenRules())) != null) {
            binding = configRule.getResolvedDesignMapping(instancePath);
            childrenRules = ELUtils.computeChildrenRulesFromConfigRule(configRule);
        }
        if ((liblist = ELUtils.computeLiblist(context, config)) == null || liblist.isEmpty()) {
            instance.setElaborationConfig(config);
            instance.setBinding(ELConstants.UNRESOLVED_INSTANCE_TYPE);
            manager.reportProblemForElement(ElaborationDebugZone.FIRST_PASS, false, "INVALID_LIBLIST: Liblist is empty for ''{0}''", description, instancePath, description.getName());
            return;
        }
        if (binding == null) {
            binding = description.getPredefinedGate();
        }
        if (binding == null && (bindingResult = ELCore.getInstanceType(description, assocTypeName, instancePath, liblist, config, (contextBinding = context.getBinding(false)) != null ? contextBinding.getEnclosingLibrary() : null, ELUtils.isVHDL(description))) != null) {
            binding = bindingResult.design;
            configRule = bindingResult.rule;
        }
        ELCore.validateConfigBinding(instance, context, description, binding, assocTypeName, liblist, config, configRule, childrenRules, instanceInContext.isUnderProgram(), instanceInContext.visited, manager);
    }
}

