/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.core;

import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELContext;
import ro.amiq.dvt.elaboration.core.ELCore;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELInstanceInContext;
import ro.amiq.dvt.elaboration.model.ELLiblist;
import ro.amiq.dvt.model.reflection.BindingRuleWrapper;
import ro.amiq.dvt.model.reflection.DVTImplicitConfiguration;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;

public interface ELVLOGCore {
    public static IRfConfigurationRule getConfigurationRule(IRfConfiguration configuration, IRfConfigurationRule.ConfigKind configKind, ElementPath instancePath, String instanceTypeName) {
        IRfConfigurationRule instanceRule = configuration.getInstanceRule(configKind, instancePath);
        if (instanceRule != null) {
            return instanceRule;
        }
        IRfConfigurationRule cellRule = configuration.getCellRule(configKind, instanceTypeName);
        if (cellRule != null) {
            return cellRule;
        }
        return null;
    }

    public static void computeConfigBinding(ELInstanceInContext instanceInContext, ELManager manager) {
        IRfNamedElement contextBinding;
        BindingRuleWrapper bindingResult;
        ELInstance instance = instanceInContext.instance;
        ELContext context = instanceInContext.context;
        IRfInstanceElement description = instance.getDescription();
        String assocTypeName = description.getAssociatedTypeName();
        IRfConfiguration config = context.getConfig();
        ElementPath instancePath = instance.getHierarchyPath();
        ELLiblist liblist = null;
        IRfNamedElement binding = null;
        IRfConfigurationRule configRule = null;
        if (config != null && !(config instanceof DVTImplicitConfiguration)) {
            configRule = ELVLOGCore.getConfigurationRule(config, IRfConfigurationRule.ConfigKind.USE, instancePath, assocTypeName);
            if (configRule != null) {
                binding = configRule.getResolvedDesignMapping(instancePath);
            } else {
                configRule = ELVLOGCore.getConfigurationRule(config, IRfConfigurationRule.ConfigKind.LIBLIST, instancePath, assocTypeName);
                if (configRule != null) {
                    liblist = ELLiblist.of(configRule.getResolvedLiblist(), true);
                }
            }
        }
        if (liblist == null) {
            liblist = ELUtils.computeLiblist(context, config);
        }
        if (liblist == null || liblist.isEmpty()) {
            instance.setElaborationConfig(config);
            instance.setBinding(ELConstants.UNRESOLVED_INSTANCE_TYPE);
            manager.reportProblemForElement(ElaborationDebugZone.FIRST_PASS, false, "INVALID_LIBLIST: Liblist is empty for ''{0}''", description, instance.getHierarchyPath(), description.getName());
            return;
        }
        if (binding == null) {
            binding = description.getPredefinedGate();
        }
        if (binding == null && (bindingResult = ELCore.getInstanceType(description, assocTypeName, instancePath, liblist, config, (contextBinding = context.getBinding(false)) != null ? contextBinding.getEnclosingLibrary() : null, ELUtils.isVHDL(description))) != null) {
            binding = bindingResult.design;
            configRule = bindingResult.rule;
        }
        ELCore.validateConfigBinding(instance, context, description, binding, assocTypeName, liblist, config, configRule, null, instanceInContext.isUnderProgram(), instanceInContext.visited, manager);
    }
}

