/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.model;

public abstract class ELDimension {
    public static ELDimension of(int lhs, int rhs) {
        return new ELRangeDimension(lhs, rhs);
    }

    public static ELDimension of(int lhs) {
        return new ELExpressionDimension(lhs);
    }

    public boolean isExpression() {
        return false;
    }

    public boolean isRange() {
        return false;
    }

    protected int getLHS() {
        return -1;
    }

    protected int getRHS() {
        return -1;
    }

    public int getStart() {
        if (this.isExpression()) {
            return 0;
        }
        if (this.isRange()) {
            return this.getLHS();
        }
        throw new UnsupportedOperationException("Neither expression nor range dimension!");
    }

    public int getEnd() {
        if (this.isExpression()) {
            return this.getLHS() - 1;
        }
        if (this.isRange()) {
            return this.getRHS();
        }
        throw new UnsupportedOperationException("Neither expression nor range dimension!");
    }

    public boolean isDescending() {
        return this.getStart() >= this.getEnd();
    }

    private static class ELExpressionDimension
    extends ELDimension {
        private final int lhs;

        private ELExpressionDimension(int lhs) {
            this.lhs = lhs;
        }

        @Override
        public boolean isExpression() {
            return true;
        }

        @Override
        public boolean isRange() {
            return false;
        }

        @Override
        protected int getLHS() {
            return this.lhs;
        }
    }

    private static class ELRangeDimension
    extends ELExpressionDimension {
        public final int rhs;

        private ELRangeDimension(int lhs, int rhs) {
            super(lhs);
            this.rhs = rhs;
        }

        @Override
        public boolean isExpression() {
            return false;
        }

        @Override
        public boolean isRange() {
            return true;
        }

        @Override
        protected int getRHS() {
            return this.rhs;
        }
    }
}

