/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.model;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfEnumElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class ELEnumTypeWrapper {
    private final IRfEnumElement type;
    private final String[] itemNames;
    private final ELParamValues itemValues;

    private ELEnumTypeWrapper(@NotNull IRfEnumElement enumType) {
        this.itemValues = ELParamValues.create(enumType.getLanguageKind() != LanguageKind.VHDL);
        this.type = enumType;
        Collection<IRfNamedElement> enumItems = enumType.getEnumValues();
        int itemCount = enumItems != null ? enumItems.size() : 0;
        this.itemNames = new String[itemCount];
        if (enumItems != null) {
            int i = 0;
            for (IRfNamedElement item : enumItems) {
                this.itemNames[i++] = item.getName();
            }
        }
    }

    public static ELEnumTypeWrapper create(@NotNull IRfEnumElement enumType) {
        return new ELEnumTypeWrapper(enumType);
    }

    public static ELEnumTypeWrapper create(@NotNull IRfEnumElement enumType, ELParamValuesHidEvaluator evaluator, ELManager manager) {
        if (manager == null) {
            return null;
        }
        ELEnumTypeWrapper enumTypeWrapper = manager.getEnumTypeWrapper(enumType);
        if (enumTypeWrapper != null) {
            return enumTypeWrapper;
        }
        enumTypeWrapper = new ELEnumTypeWrapper(enumType);
        String[] enumItems = enumTypeWrapper.getItemNames();
        if (enumItems.length > 0) {
            ELParamValues evaluatorValues = evaluator.getValueContainer(enumItems[0]);
            ELParamValues enumValues = evaluatorValues != null ? evaluatorValues : manager.getExternalConstants(enumType.getEnclosingLibrary());
            enumTypeWrapper.updateValues(enumValues != null ? enumValues.getEntries() : null);
        }
        manager.addEnumTypeWrapper(enumType, enumTypeWrapper);
        return enumTypeWrapper;
    }

    public void updateValues(Map<String, IELParamValue> enumValues) {
        Collection<IRfNamedElement> enumItems = this.type.getEnumValues();
        if (enumItems == null || enumValues == null) {
            return;
        }
        for (IRfNamedElement item : enumItems) {
            String itemName = item.getName();
            IELParamValue value = enumValues.get(itemName);
            if (ELUtils.isUnsuccessfulEval(value)) continue;
            IELParamValue itemValue = ELParamValues.ParamValueNumber.of(value.getDVTNumber(), item, this);
            this.updateItemValue(itemName, itemValue);
        }
    }

    public IELParamValue executePredefinedMethod(IELParamValue paramValue, String methodName, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        if ("first".equals(methodName)) {
            return this.first();
        }
        if ("last".equals(methodName)) {
            return this.last();
        }
        if ("name".equals(methodName)) {
            return this.name(paramValue);
        }
        if ("num".equals(methodName)) {
            return this.num();
        }
        boolean isNext = "next".equals(methodName);
        boolean isPrev = "prev".equals(methodName);
        if (isNext || isPrev) {
            int nth = 1;
            IELParamValue nthValue = null;
            if (specifiedArgumentValues != null && !specifiedArgumentValues.isEmpty()) {
                HidEvalCenter.MethodCallStatement.ArgumentInfo firstArg = specifiedArgumentValues.values().iterator().next();
                nthValue = XUtils.getValue(firstArg.argValueScope);
            }
            if (nthValue != null && !DVTNumber.isUndefined(nthValue.getDVTNumber())) {
                nth = nthValue.intValue();
            }
            return isNext ? this.next(paramValue, nth) : this.prev(paramValue, nth);
        }
        return null;
    }

    public void updateItemValue(String name, IELParamValue enumItemValue) {
        this.itemValues.put(name, enumItemValue);
        if (!ELUtils.isUnsuccessfulEval(enumItemValue) && !DVTNumber.isUndefined(enumItemValue.getDVTNumber())) {
            this.itemValues.put(enumItemValue.toNiceString(null, 2, false, false), ELUtils.stringToValue(name));
        }
    }

    public IELParamValue first() {
        if (this.itemNames.length == 0) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        return this.getItemValue(this.itemNames[0]);
    }

    public IELParamValue last() {
        if (this.itemNames.length == 0) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        return this.getItemValue(this.itemNames[this.itemNames.length - 1]);
    }

    public IELParamValue name(IELParamValue enumItemValue) {
        if (ELUtils.isUnsuccessfulEval(enumItemValue)) {
            return ELUtils.stringToValue("");
        }
        if (DVTNumber.isUndefined(enumItemValue.getDVTNumber())) {
            return ELUtils.stringToValue("");
        }
        String value = enumItemValue.toNiceString(null, 2, false, false);
        IELParamValue nameValue = this.getItemValue(value);
        if (nameValue != null) {
            return nameValue;
        }
        return ELUtils.stringToValue("");
    }

    public IELParamValue num() {
        return ELParamValues.ParamValueNumber.of(VlogBitVector.create(false, 31, 0, BigInteger.valueOf(this.itemNames.length)));
    }

    public IELParamValue next(IELParamValue enumItemValue, int nth) {
        if (this.itemNames.length == 0) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        DVTNumber itemValue = enumItemValue.getDVTNumber();
        int itemIndex = -1;
        int i = 0;
        while (i < this.itemNames.length) {
            IELParamValue tmpItemValue = this.getItemValue(this.itemNames[i]);
            if (tmpItemValue != null && itemValue.equals(tmpItemValue.getDVTNumber())) {
                itemIndex = i;
                break;
            }
            ++i;
        }
        if (itemIndex == -1) {
            return enumItemValue;
        }
        itemIndex += nth;
        while (itemIndex < 0) {
            itemIndex += this.itemNames.length;
        }
        return this.getItemValue(this.itemNames[itemIndex %= this.itemNames.length]);
    }

    public IELParamValue prev(IELParamValue enumItemValue, int nth) {
        return this.next(enumItemValue, -nth);
    }

    public IELParamValue getItemValue(String name) {
        return this.itemValues.getValueDirectly(name);
    }

    public Collection<IELParamValue> getItemValues() {
        return this.itemValues.getEntries().values();
    }

    public String[] getItemNames() {
        return this.itemNames;
    }

    public IRfEnumElement getType() {
        return this.type;
    }

    public String toString() {
        int options = 69;
        return this.type.getQualifiedName(this.type, null, options) + '@' + "enum";
    }

    public String getQualifiedTypeName() {
        int options = 71;
        return this.type.getQualifiedName(this.type, null, options);
    }
}

