/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.model;

import java.util.Set;
import ro.amiq.dvt.elaboration.core.ELContext;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELGraphVertex;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.utils.OptimizedIdentityHashSet;

public class ELInstanceInContext
implements IELGraphVertex<ElementPath> {
    public final ELInstance instance;
    public final ELContext context;
    public final Set<IRfNamedElement> visited;
    public int depth;
    private int graphDegree;

    @NotNull
    public static ELInstanceInContext ofTop(ELInstance instance, ELContext context) {
        if (instance == null || context == null) {
            throw new NullPointerException(instance == null ? "Instance is null" : "Context is null");
        }
        return new ELInstanceInContext(instance, context, new OptimizedIdentityHashSet<IRfNamedElement>(), 0);
    }

    @NotNull
    public static ELInstanceInContext of(ELInstance instance, ELContext context, Set<IRfNamedElement> visited, int parentDepth, boolean isUnderProgram) {
        int newDepth;
        if (instance == null || context == null) {
            throw new NullPointerException(instance == null ? "Instance is null" : "Context is null");
        }
        int n = newDepth = DesignUtils.isBlock(instance.getBinding(false)) ? parentDepth : parentDepth + 1;
        return isUnderProgram ? new ELInstanceInProgramContext(instance, context, visited != null ? visited : new OptimizedIdentityHashSet<IRfNamedElement>(), newDepth) : new ELInstanceInContext(instance, context, visited != null ? visited : new OptimizedIdentityHashSet(), newDepth);
    }

    private ELInstanceInContext(ELInstance instance, ELContext context, Set<IRfNamedElement> visited, int depth) {
        this.instance = instance;
        this.context = context;
        this.visited = visited;
        this.depth = depth;
    }

    @Override
    public void increaseDegree() {
        ++this.graphDegree;
    }

    @Override
    public void decreaseDegree() {
        --this.graphDegree;
    }

    @Override
    public int getDegree() {
        return this.graphDegree;
    }

    @Override
    public ElementPath getID() {
        return this.instance.getHierarchyPath();
    }

    @Override
    public void collectSource(IELGraphVertex<ElementPath> src) {
        if (!(src instanceof ELInstanceInContext) || this.context == null) {
            return;
        }
        this.context.addDefparamInstance(((ELInstanceInContext)src).instance);
    }

    public ELContext getTopologicalContext() {
        return this.context;
    }

    public boolean isUnderProgram() {
        return false;
    }

    public String toString() {
        return this.instance + " { " + this.context + " }";
    }

    private static class ELInstanceInProgramContext
    extends ELInstanceInContext {
        private ELInstanceInProgramContext(ELInstance instance, ELContext context, Set<IRfNamedElement> visited, int depth) {
            super(instance, context, visited, depth);
        }

        @Override
        public boolean isUnderProgram() {
            return true;
        }
    }
}

