/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.function.Supplier;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecialization;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.BitVectorContext;

public class ELMemoryStandard
implements IELMemory {
    private NavigableMap<ElementPath, ELInstance> bindingMemory;

    public ELMemoryStandard() {
        this.bindingMemory = new TreeMap<ElementPath, ELInstance>();
    }

    private ELMemoryStandard(NavigableMap<ElementPath, ELInstance> bindingMemory) {
        this.bindingMemory = bindingMemory;
    }

    @Override
    public ELInstance put(ElementPath hierarchyPath, ELInstance instance) {
        return this.bindingMemory.put(hierarchyPath, instance);
    }

    @Override
    public ELInstance put(ElementPath hierarchyPath, ELParamValues values) {
        throw new UnsupportedOperationException("DO NOT use this method, use ELInstance#setCachedParamValues instead");
    }

    @Override
    public void putAll(IELMemory memory) {
        if (!(memory instanceof ELMemoryStandard)) {
            return;
        }
        this.bindingMemory.putAll(((ELMemoryStandard)memory).getBindingMemoryRaw());
    }

    private NavigableMap<ElementPath, ELInstance> getBindingMemoryRaw() {
        return this.bindingMemory;
    }

    @Override
    public ELInstance instanceFor(ElementPath hierarchyPath) {
        if (hierarchyPath == null) {
            return null;
        }
        return (ELInstance)this.bindingMemory.get(hierarchyPath);
    }

    @Override
    public boolean isEmpty() {
        return this.bindingMemory.isEmpty();
    }

    @Override
    public ELParamValues paramValuesFor(ElementPath hierarchyPath) {
        ELInstance instance = this.instanceFor(hierarchyPath);
        if (instance == null) {
            return null;
        }
        return instance.getParamValues();
    }

    @Override
    public IRfNamedElement bindingFor(ElementPath hierarchyPath, boolean stripToEntity) {
        ELInstance instance = this.instanceFor(hierarchyPath);
        return instance != null ? instance.getBinding(stripToEntity) : null;
    }

    @Override
    public IELMemory subMemory(ElementPath instancePath) {
        ElementPath greaterChildKey = ElementPath.join(instancePath, "{");
        NavigableMap<ElementPath, ELInstance> subtree = this.bindingMemory.subMap(instancePath, true, greaterChildKey, true);
        return new ELMemoryStandard(subtree);
    }

    @Override
    public Map<ElementPath, ELInstance> subtreeOf(ElementPath instancePath, boolean reverseOrder) {
        ElementPath lesserChildKey = ElementPath.join(instancePath, " ");
        ElementPath greaterChildKey = ElementPath.join(instancePath, "{");
        return this.subMap(lesserChildKey, false, greaterChildKey, true, reverseOrder);
    }

    @Override
    public void removeSubtreeOf(ElementPath instancePath) {
        Map<ElementPath, ELInstance> sub = this.subtreeOf(instancePath, false);
        sub.clear();
    }

    @Override
    public ELInstance remove(ElementPath elementPath) {
        return (ELInstance)this.bindingMemory.remove(elementPath);
    }

    @Override
    public ELInstance getFirstInstance() {
        Iterator iterator = this.bindingMemory.entrySet().iterator();
        return iterator.hasNext() ? (ELInstance)iterator.next().getValue() : null;
    }

    @Override
    public Map<ElementPath, ELInstance> subMap(ElementPath fromKey, boolean fromInclusive, ElementPath toKey, boolean toInclusive, boolean reverseOrder) {
        try {
            NavigableMap<ElementPath, ELInstance> subMap = this.bindingMemory.subMap(fromKey, fromInclusive, toKey, toInclusive);
            return reverseOrder ? subMap.descendingMap() : subMap;
        }
        catch (Exception exception) {
            return Collections.emptyMap();
        }
    }

    @Override
    public Map<ElementPath, ELInstance> nextOf(ElementPath elementPath) {
        return this.bindingMemory.tailMap(elementPath, false);
    }

    @Override
    public Map<ElementPath, ELInstance> prevOf(ElementPath elementPath) {
        return this.bindingMemory.headMap(elementPath, false).descendingMap();
    }

    @Override
    public int numOfInstancesInSubtreeOf(ElementPath elementPath) {
        if (elementPath == null) {
            return this.bindingMemory == null ? -1 : this.bindingMemory.keySet().size();
        }
        Map<ElementPath, ELInstance> subtree = this.subtreeOf(elementPath, false);
        return subtree == null ? 0 : subtree.keySet().size();
    }

    @Override
    public void visitBindings(IELMemory.IELMemoryVisitor visitor) {
        for (Map.Entry entry : this.bindingMemory.entrySet()) {
            if (!visitor.visitBindings((ElementPath)entry.getKey(), (ELInstance)entry.getValue())) break;
        }
    }

    @Override
    public void visitBindingsReverseOrder(IELMemory.IELMemoryVisitor visitor) {
        for (ElementPath path : this.bindingMemory.descendingKeySet()) {
            if (!visitor.visitBindings(path, (ELInstance)this.bindingMemory.get(path))) break;
        }
    }

    @Override
    public void visitParamValues(IELMemory.IELMemoryVisitor visitor) {
        for (Map.Entry entry : this.bindingMemory.entrySet()) {
            if (!visitor.visitParamValues((ElementPath)entry.getKey(), ((ELInstance)entry.getValue()).getParamValues())) break;
        }
    }

    @Override
    public boolean hasBindings() {
        return !this.bindingMemory.isEmpty();
    }

    @Override
    public boolean hasParamValues() {
        return this.hasBindings();
    }

    @Override
    public void serialize() {
    }

    @Override
    public int size() {
        return this.bindingMemory.size();
    }

    @Override
    public String toString(ELManager manager, int radix) {
        StringBuilder str = new StringBuilder();
        boolean testMode = TestHelper.isTestMode();
        NavigableMap<ElementPath, ELInstance> mainMemory = this.bindingMemory;
        str.append("\n********************* Binding Memory *********************");
        for (Map.Entry bindingsEntry : mainMemory.entrySet()) {
            str.append("\n").append(bindingsEntry.getKey()).append(" <-- ").append(((ELInstance)bindingsEntry.getValue()).print());
        }
        str.append("\n***Number of entries = " + mainMemory.size());
        NavigableMap<ElementPath, ELInstance> paramValueMemory = mainMemory;
        str.append("\n******************** Parameter Memory ********************");
        for (Map.Entry paramValueEntry : paramValueMemory.entrySet()) {
            ELInstance instance = (ELInstance)paramValueEntry.getValue();
            ELParamValues cachedParamValues = instance.getParamValues();
            IRfNamedElement binding = instance.getBinding(false);
            StringJoiner joiner = new StringJoiner(",");
            if (binding instanceof IRfDesignElement) {
                Map<String, Supplier<ELSpecialization.InterfacePortInstance>> map;
                ELParamValuesHidEvaluator evaluator = cachedParamValues.getHidEvaluator(manager);
                List<? extends IRfNamedElement> parameters = ((IRfDesignElement)binding).getLocalElabConstants();
                if (parameters != null) {
                    for (IRfNamedElement iRfNamedElement : parameters) {
                        if (!testMode && joiner.length() > 1000) {
                            joiner.add("...");
                            break;
                        }
                        IELParamValue value = cachedParamValues.getValueDirectly(iRfNamedElement.getElabName(true));
                        if (value == null) continue;
                        BitVectorContext context = ELUtils.makeEvaluatorContext(evaluator, iRfNamedElement, null, manager);
                        String toNiceString = value.toNiceString(context, radix, false, false);
                        StringBuilder paramSb = new StringBuilder("\n\t").append(iRfNamedElement.getName()).append(" = ").append(toNiceString);
                        if (testMode && ELUtils.isParamValueNumber(value)) {
                            paramSb.append(" (").append(value.toStringRadix(2)).append(")");
                        }
                        joiner.add(paramSb.toString());
                    }
                }
                if ((map = instance.getSpecialization().getInterfacePortInstances()) != null) {
                    for (Map.Entry<String, Supplier<ELSpecialization.InterfacePortInstance>> portInstanceEntry : map.entrySet()) {
                        if (!testMode && joiner.length() > 1000) {
                            joiner.add("...");
                            break;
                        }
                        String port = portInstanceEntry.getKey();
                        ELSpecialization.InterfacePortInstance interfacePortInstance = portInstanceEntry.getValue().get();
                        if (interfacePortInstance == null) continue;
                        ELInstance portInstance = interfacePortInstance.getInstance();
                        joiner.add("\n\t" + port + " : " + (portInstance != null ? portInstance.getHierarchyPath() : null));
                    }
                }
            }
            str.append("\n").append(paramValueEntry.getKey()).append(" <-- ").append("(" + joiner.toString() + ")");
        }
        str.append("\n***Number of entries = " + paramValueMemory.size());
        str.append("\n**********************************************************\n");
        return str.toString();
    }

    @Override
    public void print(ELManager manager, int radix) {
        NavigableMap<ElementPath, ELInstance> mainMemory = this.bindingMemory;
        manager.logger.debug(ElaborationDebugZone.MEMORY, "\n********************* Binding Memory *********************", new Object[0]);
        for (Map.Entry bindingsEntry : mainMemory.entrySet()) {
            manager.logger.debug(ElaborationDebugZone.MEMORY, "\n" + bindingsEntry.getKey() + " <-- " + ((ELInstance)bindingsEntry.getValue()).print(), new Object[0]);
        }
        manager.logger.debug(ElaborationDebugZone.MEMORY, "\n***Number of entries = " + mainMemory.size(), new Object[0]);
        NavigableMap<ElementPath, ELInstance> paramValueMemory = mainMemory;
        manager.logger.debug(ElaborationDebugZone.MEMORY, "\n******************** Parameter Memory ********************", new Object[0]);
        for (Map.Entry paramValueEntry : paramValueMemory.entrySet()) {
            Map<String, Supplier<ELSpecialization.InterfacePortInstance>> interfacePortInstances;
            ELInstance instance = (ELInstance)paramValueEntry.getValue();
            ELParamValues cachedParamValues = instance.getParamValues();
            IRfNamedElement binding = instance.getBinding(false);
            StringJoiner joiner = new StringJoiner(",");
            if (binding instanceof IRfDesignElement) {
                ELParamValuesHidEvaluator evaluator = cachedParamValues.getHidEvaluator(manager);
                List<? extends IRfNamedElement> parameters = ((IRfDesignElement)binding).getLocalElabConstants();
                if (parameters != null) {
                    for (IRfNamedElement iRfNamedElement : parameters) {
                        if (joiner.length() > 1000) {
                            joiner.add("...");
                            break;
                        }
                        IELParamValue value = cachedParamValues.getValueDirectly(iRfNamedElement.getElabName(true));
                        if (value == null) continue;
                        BitVectorContext context = ELUtils.makeEvaluatorContext(evaluator, iRfNamedElement, null, manager);
                        String toNiceString = value.toNiceString(context, radix, false, false);
                        StringBuilder paramSb = new StringBuilder("\n\t").append(iRfNamedElement.getName()).append(" = ").append(toNiceString);
                        joiner.add(paramSb.toString());
                    }
                }
            }
            if ((interfacePortInstances = instance.getSpecialization().getInterfacePortInstances()) != null) {
                for (Map.Entry<String, Supplier<ELSpecialization.InterfacePortInstance>> portInstanceEntry : interfacePortInstances.entrySet()) {
                    if (joiner.length() > 1000) {
                        joiner.add("...");
                        break;
                    }
                    String port = portInstanceEntry.getKey();
                    ELSpecialization.InterfacePortInstance interfacePortInstance = portInstanceEntry.getValue().get();
                    if (interfacePortInstance == null) continue;
                    ELInstance portInstance = interfacePortInstance.getInstance();
                    joiner.add("\n\t" + port + " : " + (portInstance != null ? portInstance.getHierarchyPath() : null));
                }
            }
            manager.logger.debug(ElaborationDebugZone.MEMORY, "\n" + paramValueEntry.getKey() + " <-- " + ("(" + joiner.toString() + ")"), new Object[0]);
        }
        manager.logger.debug(ElaborationDebugZone.MEMORY, "\n***Number of entries = " + paramValueMemory.size(), new Object[0]);
        manager.logger.debug(ElaborationDebugZone.MEMORY, "\n**********************************************************\n", new Object[0]);
    }
}

