/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.model;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XSelectProxy;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.constraints.XCModel;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.DVTNumber;

public class ELParamValueScope {
    public static final ELParamValueScope UNDEFINED_VALUE = new ELParamValueScope(IELParamValue.UNDEFINED_VALUE, null);
    public static final ELParamValueScope IMPLICIT_RESULT = new ELParamValueScope(IELParamValue.IMPLICIT_RESULT, null);
    public static final ELParamValueScope BLACK_BOX_VALUE = new ELParamValueScope(IELParamValue.BLACK_BOX_VALUE, null);
    public IELParamValue value;
    public IHidEvaluator scope;

    private ELParamValueScope(IELParamValue value, IHidEvaluator scope) {
        if (value == null) {
            throw new UnsupportedOperationException("Null value in ELParamValueScope");
        }
        this.value = value;
        this.scope = scope;
    }

    public DVTNumber getDVTNumber() {
        return this.value.getDVTNumber();
    }

    public IHidObject getHidObject() {
        return null;
    }

    public String getElementName() {
        return null;
    }

    public ELParamValueScope doUpdate(IHidOperator parentOperator, IELParamValue rightValue, int updateEvaluator, IHidEvaluator evaluator, IHidObject leftOp, IHidEvaluationGuardian guardian) {
        int uniqueClassScopeId = -1;
        if (evaluator.isInterpreter()) {
            uniqueClassScopeId = this.scope instanceof XInstValueHolder || this.scope instanceof XMethodValueHolder ? -1 : (this.scope instanceof XInstValueHolder.XClockingValueHolder ? -1 : (this.scope instanceof XInstValueHolder.XModportValueHolder ? -1 : (this.scope instanceof XValueHolder ? ((XValueHolder)this.scope).uniqueId() : -1)));
        }
        AtomicBoolean isModified = new AtomicBoolean(false);
        this.value.doUpdate(parentOperator, rightValue, updateEvaluator, isModified, uniqueClassScopeId, evaluator, leftOp, guardian);
        if (isModified.get() && this.scope instanceof XValueHolder && ((XValueHolder)this.scope).isStruct(true) && XUtils.isDesignMemberElement(this.scope.getNamedElement())) {
            do {
                ((IELParamValue)this.scope).doUpdate(parentOperator, (XValueHolder)this.scope, updateEvaluator, isModified, -1, evaluator, leftOp, guardian);
                this.scope = ((XValueHolder)this.scope).getEnclosingValue();
            } while (this.scope instanceof XValueHolder && ((XValueHolder)this.scope).isStruct(true));
        }
        return this;
    }

    public boolean isNull() {
        return this.value.isNull();
    }

    public boolean isUnknown() {
        return this.value.isUnknown();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public int getSize() {
        return this.value.getSize();
    }

    public boolean is4State() {
        return this.value.is4State();
    }

    public BigInteger bigIntegerValue() {
        return this.value.bigIntegerValue();
    }

    public IRfNamedElement getElement() {
        return this.value.getElement();
    }

    public static ELParamValueScope of(IELParamValue value) {
        return ELParamValueScope.of(value, null);
    }

    public static ELParamValueScope of(IELParamValue value, IHidEvaluator scope, String name, IHidObject hidObject) {
        if (value == null) {
            return null;
        }
        if (value == IELParamValue.UNDEFINED_VALUE) {
            return UNDEFINED_VALUE;
        }
        if (value == IELParamValue.IMPLICIT_RESULT) {
            return IMPLICIT_RESULT;
        }
        if (hidObject == null) {
            return new ELParamValueScope_Element(value, scope, name);
        }
        return new ELParamValueScope_HidObject(value, scope, name, hidObject);
    }

    public static ELParamValueScope of(IELParamValue value, IHidEvaluator scope) {
        if (value == null) {
            return null;
        }
        if (value == IELParamValue.UNDEFINED_VALUE) {
            return UNDEFINED_VALUE;
        }
        if (value == IELParamValue.IMPLICIT_RESULT) {
            return IMPLICIT_RESULT;
        }
        return new ELParamValueScope(value, scope);
    }

    public boolean isRandListSizeVariable(XCModel model, String name) {
        if (this.scope instanceof XMethodValueHolder && ((XMethodValueHolder)this.scope).getEnclosingValue() instanceof XArrayValueHolder && "size".equals(name)) {
            return this.isRand(model, ((XMethodValueHolder)this.scope).getEnclosingValue());
        }
        if (this.scope instanceof XArrayValueHolder && "size".equals(name)) {
            return this.isRand(model, (XArrayValueHolder)this.scope);
        }
        return false;
    }

    public boolean isRandListSumVariable(XCModel model, String name) {
        if (this.scope instanceof XMethodValueHolder && ((XMethodValueHolder)this.scope).getEnclosingValue() instanceof XArrayValueHolder && "sum".equals(name)) {
            return this.isRand(model, ((XMethodValueHolder)this.scope).getEnclosingValue());
        }
        if (this.scope instanceof XArrayValueHolder && "sum".equals(name)) {
            return this.isRand(model, (XArrayValueHolder)this.scope);
        }
        return false;
    }

    private boolean isRand(XCModel model, IELParamValue enclosingValue) {
        XSelectProxy selectProxy;
        do {
            if (model.isRand(enclosingValue)) {
                return true;
            }
            selectProxy = enclosingValue.getSelectProxy();
            if (selectProxy != null) continue;
            return false;
        } while ((enclosingValue = selectProxy.getValueBeforeSelect()) != null);
        return false;
    }

    public XArrayValueHolder getArrayValueHolder(String name) {
        if (this.scope instanceof XMethodValueHolder && ((XMethodValueHolder)this.scope).getEnclosingValue() instanceof XArrayValueHolder && ("sum".equals(name) || "size".equals(name))) {
            return (XArrayValueHolder)((XMethodValueHolder)this.scope).getEnclosingValue();
        }
        if (this.scope instanceof XArrayValueHolder && ("sum".equals(name) || "size".equals(name))) {
            return (XArrayValueHolder)this.scope;
        }
        return null;
    }

    private static class ELParamValueScope_Element
    extends ELParamValueScope {
        public String elementName;

        private ELParamValueScope_Element(IELParamValue value, IHidEvaluator scope, String elementName) {
            super(value, scope);
            this.elementName = elementName;
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }
    }

    private static class ELParamValueScope_HidObject
    extends ELParamValueScope_Element {
        public IHidObject hidObject;

        private ELParamValueScope_HidObject(IELParamValue value, IHidEvaluator scope, String name, IHidObject hidObject) {
            super(value, scope, name);
            this.hidObject = hidObject;
        }

        @Override
        public IHidObject getHidObject() {
            return this.hidObject;
        }
    }
}

