/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.model;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.msgpack.core.MessagePacker;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELEnumTypeWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELGraphVertexValues;
import ro.amiq.dvt.elaboration.model.IELParamKeyValueCompact;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXVariableInfo;
import ro.amiq.dvt.interpreter.DVTXVariableType;
import ro.amiq.dvt.interpreter.IXArrayValues;
import ro.amiq.dvt.interpreter.IXIterator;
import ro.amiq.dvt.interpreter.IXLoopAction;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedComputedSelect;
import ro.amiq.dvt.interpreter.XSelectProxy;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUVMElaborationStarters;
import ro.amiq.dvt.interpreter.XUnknownSizeIterator;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.sim.XSimRegion;
import ro.amiq.dvt.interpreter.sim.XSimUpdateEvent;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvaluationGuardianCacheImpl;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IllegalRangeException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.DVTUnpackedStruct;
import ro.amiq.dvt.utils.IDVTRangeSelectable;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.OptimizedLinkedHashMap;
import ro.amiq.dvt.utils.StructMemberContextInfo;
import ro.amiq.dvt.utils.VlogAbstractRealNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class ELParamValues
implements IELGraphVertexValues {
    public static final ELParamValues EMPTY = new ELParamValues(Collections.unmodifiableMap(new LinkedHashMap()), true);
    public static final ELParamValues EMPTY_CASE_INSENSITIVE = new ELParamValues(Collections.unmodifiableMap(new LinkedHashMap()), false);
    public static final IELParamKeyValueCompact[] EMPTY_STORED = new IELParamKeyValueCompact[0];
    private final Map<String, IELParamValue> entries;
    private final boolean isCaseSensitive;

    public static ELParamValues of(Map<String, IELParamValue> entries, boolean isCaseSensitive) {
        return new ELParamValues(entries, isCaseSensitive);
    }

    private ELParamValues(Map<String, IELParamValue> entries, boolean isCaseSensitive) {
        this.entries = entries;
        this.isCaseSensitive = isCaseSensitive;
    }

    @NotNull
    public static ELParamValues create(boolean isCaseSensitive) {
        return new ELParamValues(new OptimizedLinkedHashMap<String, IELParamValue>(), isCaseSensitive);
    }

    @NotNull
    public static ELParamValues create(int size, boolean isCaseSensitive) {
        return new ELParamValues(size < 2 ? new OptimizedLinkedHashMap<String, IELParamValue>() : new Object2ObjectLinkedOpenHashMap(size), isCaseSensitive);
    }

    public IELParamValue putDirectly(String key, IELParamValue value) {
        return this.entries.put(this.adjustLetterCase(key), value);
    }

    private IELParamValue putNoCaseDirectly(String key, IELParamValue value) {
        return this.entries.put(key, value);
    }

    public IELParamValue removeDirectly(String key) {
        return this.entries.remove(this.adjustLetterCase(key));
    }

    public IELParamValue getValueDirectly(String key) {
        return this.entries.get(this.adjustLetterCase(key));
    }

    public IELParamValue putValueDirectly(String key, IELParamValue value) {
        return this.entries.put(this.adjustLetterCase(key), value);
    }

    public IELParamValue put(String key, IELParamValue value) {
        return this.putNoCase(this.adjustLetterCase(key), value);
    }

    private IELParamValue putNoCase(String key, IELParamValue value) {
        IELParamValue existing = this.entries.get(key);
        if (existing instanceof XValueHolder.XShadowHolder) {
            ((XValueHolder.XShadowHolder)existing).setOrAdd(value);
            return value;
        }
        if (existing != null) {
            IRfNamedElement existingElement = existing.getElement();
            IRfNamedElement valueElement = value.getElement();
            if (existingElement != null && valueElement != null) {
                IRfNamedElement existingEnclosingScope = (IRfNamedElement)existingElement.getEnclosingScope();
                IRfNamedElement valueEnclosingScope = (IRfNamedElement)valueElement.getEnclosingScope();
                if (existingEnclosingScope != null && valueEnclosingScope != null && existingEnclosingScope.xIsClass(true) && valueEnclosingScope.xIsClass(true)) {
                    value = new XValueHolder.XShadowHolder(existing, value);
                }
            }
        }
        return this.entries.put(key, value);
    }

    public IELParamValue remove(String key, IRfNamedElement scopeElement) {
        IELParamValue existing = this.entries.get(key = this.adjustLetterCase(key));
        if (existing == null) {
            return this.entries.remove(key);
        }
        if (existing instanceof XValueHolder.XShadowHolder) {
            return ((XValueHolder.XShadowHolder)existing).remove(scopeElement);
        }
        if (scopeElement instanceof IRfClassElement) {
            IRfClassElement classScope2;
            IRfNamedElement element = existing.getElement();
            if (element != null && element.isObjectStatic()) {
                return this.entries.remove(key);
            }
            IRfClassElement classScope1 = XValueHolder.getOriginClassScope(scopeElement);
            if (classScope1 != (classScope2 = XValueHolder.getOriginClassScope(element))) {
                return null;
            }
        }
        return this.entries.remove(key);
    }

    public IELParamValue getValue(String key, IRfNamedElement element) {
        IELParamValue result = this.entries.get(this.adjustLetterCase(key));
        if (result == null) {
            return null;
        }
        if (result instanceof XValueHolder.XShadowHolder) {
            return ((XValueHolder.XShadowHolder)result).get(element);
        }
        IRfNamedElement candidate = result.getElement();
        if (candidate != null && element != null && !candidate.isObjectStatic()) {
            IRfClassElement classScope2;
            if (candidate == element) {
                return result;
            }
            IRfClassElement classScope1 = XValueHolder.getOriginClassScope(element);
            if (classScope1 == (classScope2 = XValueHolder.getOriginClassScope(candidate))) {
                return result;
            }
            return null;
        }
        return result;
    }

    public IELParamValue getValue(String key) {
        IELParamValue result = this.entries.get(this.adjustLetterCase(key));
        if (result instanceof XValueHolder.XShadowHolder) {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    public boolean containsKey(String key) {
        if (this.entries.isEmpty()) {
            return false;
        }
        return this.entries.containsKey(this.adjustLetterCase(key));
    }

    public ELParamValues copy() {
        ELParamValues copy = ELParamValues.create(this.entries.size(), this.isCaseSensitive);
        Iterator<? extends Map.Entry<String, IELParamValue>> it = this.getEntriesIterator();
        while (it.hasNext()) {
            Map.Entry<String, IELParamValue> entry = it.next();
            copy.putNoCaseDirectly(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public void putAll(ELParamValues other) {
        this.entries.putAll(other.entries);
    }

    public void putAllIfAbsent(ELParamValues other) {
        if (other.entries == null || other.entries.isEmpty()) {
            return;
        }
        for (Map.Entry<String, IELParamValue> entry : other.entries.entrySet()) {
            this.entries.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    public ELParamValuesHidEvaluator getHidEvaluator(ELManager manager) {
        return new ELParamValuesHidEvaluator(this, manager);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int size() {
        return this.entries.size();
    }

    public Map<String, IELParamValue> getEntries() {
        return this.entries;
    }

    public Iterator<? extends Map.Entry<String, IELParamValue>> getEntriesIterator() {
        if (this.entries instanceof Object2ObjectMap) {
            return ((Object2ObjectMap)this.entries).object2ObjectEntrySet().iterator();
        }
        return this.entries.entrySet().iterator();
    }

    private String adjustLetterCase(String key) {
        return this.isCaseSensitive || key.indexOf("'") >= 0 ? key : key.toLowerCase();
    }

    @NotNull
    public Object[] pack() {
        if (this.isEmpty()) {
            return EMPTY_STORED;
        }
        int i = 0;
        Object[] result = new IELParamKeyValueCompact[this.entries.size()];
        for (Map.Entry<String, IELParamValue> entry : this.entries.entrySet()) {
            IELParamValue value;
            String key = entry.getKey();
            if (key == null || (value = entry.getValue()) == null) continue;
            result[i++] = value.pack(key);
        }
        return result;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @NotNull
    public static ELParamValues unpack(Object[] packed, boolean isCaseSensitive) {
        return ELParamValues.unpackWithKeyFilter(packed, isCaseSensitive, null);
    }

    public static ELParamValues unpackWithKeyFilter(Object[] packed, boolean isCaseSensitive, Predicate<String> keyPredicate) {
        if (packed == null) {
            return ELParamValues.create(isCaseSensitive);
        }
        ELParamValues result = ELParamValues.create(packed.length, isCaseSensitive);
        Object[] objectArray = packed;
        int n = packed.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Object[] pair = ((IELParamKeyValueCompact)object).unpack();
            if (pair != null && pair.length == 2) {
                String key = (String)pair[0];
                if (keyPredicate == null || keyPredicate.test(key)) {
                    result.putNoCaseDirectly(key, (IELParamValue)pair[1]);
                }
            }
            ++n2;
        }
        return result;
    }

    public String toString() {
        boolean testMode = TestHelper.isTestMode();
        StringJoiner joiner = new StringJoiner(",");
        for (Map.Entry<String, IELParamValue> entry : this.entries.entrySet()) {
            if (!testMode && joiner.length() > 1000) {
                joiner.add("...");
                break;
            }
            IELParamValue value = entry.getValue();
            String stringValue = ELUtils.valueToString(value);
            joiner.add(entry.getKey() + " = " + stringValue);
        }
        return "(" + joiner.toString() + ")";
    }

    public String toDocumentationString(boolean isVHDL) {
        if (isVHDL) {
            return this.entries.entrySet().stream().map(entry -> String.valueOf((String)entry.getKey()) + " => " + (entry.getValue() != null ? Integer.valueOf(((IELParamValue)entry.getValue()).intValue()) : "")).collect(Collectors.joining(", "));
        }
        return this.entries.entrySet().stream().map(entry -> "." + (String)entry.getKey() + "(" + (entry.getValue() != null ? Integer.valueOf(((IELParamValue)entry.getValue()).intValue()) : "") + ")").collect(Collectors.joining(", "));
    }

    public int internalHashCode() {
        int result = 1;
        if (this.entries != null) {
            Iterator<? extends Map.Entry<String, IELParamValue>> it = this.getEntriesIterator();
            while (it.hasNext()) {
                Map.Entry<String, IELParamValue> entry = it.next();
                result = 31 * result + entry.getKey().hashCode() ^ entry.getValue().hashCode();
            }
        } else {
            result *= 31;
        }
        return result;
    }

    public boolean internalEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ELParamValues other = (ELParamValues)obj;
        if (this.isCaseSensitive != other.isCaseSensitive) {
            return false;
        }
        if (this.entries == null) {
            return other.entries == null;
        }
        if (other.entries == null) {
            return false;
        }
        if (this.entries.size() != other.entries.size()) {
            return false;
        }
        Iterator<? extends Map.Entry<String, IELParamValue>> thisIt = this.getEntriesIterator();
        Iterator<? extends Map.Entry<String, IELParamValue>> otherIt = other.getEntriesIterator();
        while (thisIt.hasNext() && otherIt.hasNext()) {
            Map.Entry<String, IELParamValue> thisNext = thisIt.next();
            Map.Entry<String, IELParamValue> otherNext = otherIt.next();
            if (!thisNext.getKey().equals(otherNext.getKey())) {
                return false;
            }
            if (thisNext.getValue().equals(otherNext.getValue())) continue;
            return false;
        }
        return true;
    }

    public static class BuildConfigDefparams {
        private final Map<ElementPath, Map<String, BuildConfigParamKeyValueLocationTuple>> caseSensitivePaths = new HashMap<ElementPath, Map<String, BuildConfigParamKeyValueLocationTuple>>();
        private final Map<ElementPath, Map<String, BuildConfigParamKeyValueLocationTuple>> caseInsensitivePaths = new HashMap<ElementPath, Map<String, BuildConfigParamKeyValueLocationTuple>>();

        public Map<String, BuildConfigParamKeyValueLocationTuple> getDefparams(ElementPath path, boolean caseSensitive) {
            if (caseSensitive) {
                return this.caseSensitivePaths.get(path);
            }
            return this.caseInsensitivePaths.get(path);
        }

        public BuildConfigParamKeyValueLocationTuple addDefparam(ElementPath key, BuildConfigParamKeyValueLocationTuple paramKeyValueLocationTuple) {
            this.caseSensitivePaths.computeIfAbsent(key, k -> new HashMap()).put(paramKeyValueLocationTuple.key, paramKeyValueLocationTuple);
            return this.caseInsensitivePaths.computeIfAbsent(key.copyLowerCase(), k -> new HashMap()).put(paramKeyValueLocationTuple.key.toLowerCase(), paramKeyValueLocationTuple);
        }

        public void clear() {
            this.caseSensitivePaths.clear();
            this.caseInsensitivePaths.clear();
        }
    }

    public static final class BuildConfigParamKeyValueLocationTuple
    extends DefparamValueTuple {
        public final String value;
        public final int offset;

        public BuildConfigParamKeyValueLocationTuple(String key, String value, ElementPath hierarchyPathLocation, int offset, ParserPath parserPathLocation) {
            super(key, hierarchyPathLocation, parserPathLocation);
            this.value = value;
            this.offset = offset;
        }

        public String toString() {
            return this.value + " @" + this.hierarchyPathLocation;
        }
    }

    private static class ChangedValue {
        private int uniqueId;
        private IHidOperator parentOperator;
        private IHidEvaluator evaluator;
        private Hid hid;
        private IELParamValue prevValue;
        private IELParamValue currValue;
        private ListContainer<XComputedSelect> computedSelects;

        public ChangedValue(int uniqueId, IHidOperator parentOperator, IHidEvaluator evaluator, Hid hid, ListContainer<XComputedSelect> computedSelects, IELParamValue prevValue, IELParamValue currValue) {
            this.uniqueId = uniqueId;
            this.parentOperator = parentOperator;
            this.evaluator = evaluator;
            this.hid = hid;
            this.computedSelects = computedSelects;
            this.prevValue = prevValue;
            this.currValue = currValue;
        }
    }

    private static abstract class DefparamValueTuple {
        public final String key;
        public final ElementPath hierarchyPathLocation;
        public final ParserPath parserPathLocation;

        public DefparamValueTuple(String key, ElementPath hierarchyPathLocation, ParserPath parserPathLocation) {
            this.key = key;
            this.hierarchyPathLocation = hierarchyPathLocation;
            this.parserPathLocation = parserPathLocation;
        }
    }

    public static final class ParamKeyValueLocationTuple
    extends DefparamValueTuple {
        public final IHidOperator assign;
        public final IRfNamedElement scopeLocation;

        public ParamKeyValueLocationTuple(String key, IHidOperator assign, ElementPath hierarchyPathLocation, IRfNamedElement scopeLocation, ParserPath parserPathLocation) {
            super(key, hierarchyPathLocation, parserPathLocation);
            this.assign = assign;
            this.scopeLocation = scopeLocation;
        }

        public String toString() {
            return this.assign + " @" + this.hierarchyPathLocation;
        }
    }

    public static class ParamValueExpression
    implements IELParamValue {
        IHidObject expression;

        public static ParamValueExpression of(IHidObject expression) {
            return new ParamValueExpression(expression);
        }

        private ParamValueExpression(IHidObject expression) {
            this.expression = expression;
        }

        @Override
        public ELManager getManager() {
            return null;
        }

        @Override
        public boolean updateValue(IELParamValue newResult, IHidEvaluationGuardian guardian) {
            return false;
        }

        @Override
        public IELParamValue copy() {
            return ParamValueExpression.of(this.expression);
        }

        @Override
        public IELParamValue scalarCopy() {
            return ParamValueExpression.of(this.expression);
        }

        @Override
        public IELParamValue shallowCopy() {
            return ParamValueExpression.of(this.expression);
        }

        public String toString() {
            return HidUtils.toString(this.expression, false, true);
        }

        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return HidUtils.toStringBuilder(this.expression, true, true, false, true, true, false).toString();
        }

        @Override
        public String getDebuggerTypeName(boolean isFormal) {
            return "N/A";
        }

        public boolean equals(Object obj) {
            return obj instanceof ParamValueExpression && this.expression.equals(((ParamValueExpression)obj).expression);
        }

        public int hashCode() {
            return this.expression.hashCode();
        }
    }

    public static class ParamValueNumber
    implements IELParamValue {
        protected DVTNumber value;
        protected IELParamValue original;
        protected XSelectProxy selectProxy;

        public static IELParamValue of(IELParamValue value) {
            return ParamValueNumber.of(value.getDVTNumber(), value.getElement(), value.getEnumTypeWrapper());
        }

        public static IELParamValue of(DVTNumber value) {
            return ParamValueNumber.of(value, null, null);
        }

        public static IELParamValue of(DVTNumber value, IRfNamedElement element, ELEnumTypeWrapper enumType) {
            if (value == null || value == DVTNumber.UNDEFINED) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            if (element == null && enumType == null) {
                return new ParamValueNumber(value);
            }
            if (enumType == null) {
                return new ParamValueNumber_Element(value, element);
            }
            return new ParamValueNumber_Element_Enum(value, element, enumType);
        }

        private ParamValueNumber(DVTNumber value) {
            this.value = value;
        }

        @Override
        public IELParamValue getDefaultValue() {
            if (this.value instanceof VlogBitVector) {
                if (this.value.is4State()) {
                    int size = this.value.getSize();
                    EnumMap<MaskType, BitSet> masks = VlogBitVector.createMaskOfType(MaskType.X, size);
                    return ParamValueNumber.of(VlogBitVector.copy((VlogBitVector)this.value, this.value.bigIntegerValue(), masks));
                }
                if (this.value.isString()) {
                    return ParamValueNumber.of(this.value.getDefaultValue(false));
                }
                return ParamValueNumber.of(VlogBitVector.copy((VlogBitVector)this.value, BigInteger.ZERO));
            }
            if (this.value instanceof VlogAbstractRealNumber) {
                return ParamValueNumber.of(this.value.getDefaultValue(false));
            }
            return IELParamValue.NULL_VALUE;
        }

        @Override
        public IELParamValue doUpdate(IHidOperator parentOperator, IELParamValue rightValue, int updateEvaluator, AtomicBoolean isModified, int uniqueId, IHidEvaluator evaluator, IHidObject leftOp, IHidEvaluationGuardian guardian) {
            if (this.original != null && this.original.getOriginal() instanceof ParamValueNumber_Tristate) {
                return this.original.getOriginal().doUpdate(parentOperator, rightValue, updateEvaluator, isModified, -1, evaluator, leftOp, guardian);
            }
            if (this.original instanceof ParamValueNumber_Tristate) {
                return this.original.doUpdate(parentOperator, rightValue, updateEvaluator, isModified, -1, evaluator, leftOp, guardian);
            }
            return IELParamValue.super.doUpdate(parentOperator, rightValue, updateEvaluator, isModified, uniqueId, evaluator, leftOp, guardian);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ParamValueNumber)) {
                return false;
            }
            ParamValueNumber other = (ParamValueNumber)obj;
            return this.value.equals(other.value);
        }

        @Override
        public DVTNumber getDVTNumber() {
            return this.value;
        }

        public void setDVTNumber(DVTNumber value) {
            this.value = value;
        }

        @Override
        public ELParamValueScope getValue(IHid hid, IHidEvaluator hidEvaluator, BitVectorContext context, boolean isMethod, IHidEvaluationGuardian guardian) {
            if (isMethod && !this.value.isString()) {
                if (this.original != null) {
                    return this.original.getValue(hid, hidEvaluator, context, true, guardian);
                }
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            return this.getValue(hid, context, guardian);
        }

        @Override
        public IXIterator iterator(List<IHidObject> selects, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            return this.value.hasUnknownSize() ? new XUnknownSizeParamIterator(selects, evaluator, guardian) : new XIterator(this.value, selects, evaluator, guardian);
        }

        @Override
        public void foreach(List<IHidObject> indexes, IHidEvaluator evaluator, IXLoopAction loopAction, IHidEvaluationGuardian guardian) {
            boolean increasing;
            IHidObject indexHidObject = indexes.get(0);
            if (!HidUtils.isHid(indexHidObject)) {
                throw new UnknownHidObjectEvaluationException(indexHidObject);
            }
            if (!(this.value instanceof IDVTRangeSelectable)) {
                throw new UnknownHidObjectEvaluationException(indexHidObject);
            }
            int[] firstDimension = ((IDVTRangeSelectable)((Object)this.value)).getFirstDimension();
            if (firstDimension == null) {
                throw new UnknownHidObjectEvaluationException(indexHidObject);
            }
            boolean bl = increasing = firstDimension[0] < firstDimension[1];
            if (increasing) {
                int i = firstDimension[0];
                while (i <= firstDimension[1]) {
                    this.executeLoopAction((Hid)indexHidObject, i, this.value, loopAction, indexes, evaluator, guardian);
                    ++i;
                }
            } else {
                int i = firstDimension[0];
                while (i >= firstDimension[1]) {
                    this.executeLoopAction((Hid)indexHidObject, i, this.value, loopAction, indexes, evaluator, guardian);
                    --i;
                }
            }
        }

        private void executeLoopAction(Hid indexHid, int i, DVTNumber arrayNumber, IXLoopAction loopAction, List<IHidObject> hidObjectSelects, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            VlogBitVector indexBitVector = VlogBitVector.createConstant(i);
            evaluator.updateValue(indexHid.getName(), null, ParamValueNumber.of(indexBitVector), false);
            if (hidObjectSelects.size() > 1) {
                XComputedSelect computedSelect = new XComputedSelect(null, ParamValueNumber.of(indexBitVector));
                DVTNumber select = ((IDVTRangeSelectable)((Object)arrayNumber)).getRangeSelect(computedSelect, false, LanguageKind.VLOG);
                if (DVTNumber.isUndefined(select)) {
                    return;
                }
                IELParamValue selectValue = ParamValueNumber.of(select);
                selectValue.foreach(hidObjectSelects.subList(1, hidObjectSelects.size()), evaluator, loopAction, guardian);
            } else {
                loopAction.execute();
            }
        }

        @Override
        public IELParamValue vlogEq(IELParamValue obj, BitVectorContext context) {
            DVTNumber left = this.getDVTNumber();
            if (DVTNumber.isUndefined(left)) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            DVTNumber right = obj.getDVTNumber();
            if (DVTNumber.isUndefined(right)) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            VlogBitVector resultNumber = DVTNumber.vlogEq(left, right);
            IELParamValue result = ParamValueNumber.of(resultNumber);
            result = context != null ? context.transform(result) : result;
            return result;
        }

        @Override
        public IELParamValue vlogNeq(IELParamValue obj, BitVectorContext context) {
            DVTNumber left = this.getDVTNumber();
            if (DVTNumber.isUndefined(left)) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            DVTNumber right = obj.getDVTNumber();
            if (DVTNumber.isUndefined(right)) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            VlogBitVector temp = DVTNumber.vlogEq(left, right);
            VlogBitVector resultNumber = temp.isAmbiguous() ? temp : (temp == VlogBitVector.BIT_ONE ? VlogBitVector.BIT_ZERO : VlogBitVector.BIT_ONE);
            IELParamValue result = ParamValueNumber.of(resultNumber);
            result = context != null ? context.transform(result) : result;
            return result;
        }

        @Override
        public void setOriginal(IELParamValue original) {
            this.original = original;
        }

        @Override
        public IELParamValue getOriginal() {
            return this.original;
        }

        @Override
        public ELEnumTypeWrapper getEnumTypeWrapper() {
            if (this.original instanceof ParamValueNumber_Element_Enum) {
                return ((ParamValueNumber_Element_Enum)this.original).enumTypeWrapper;
            }
            return IELParamValue.super.getEnumTypeWrapper();
        }

        @Override
        public IRfNamedElement getElement() {
            if (this.original instanceof ParamValueNumber_Element) {
                return ((ParamValueNumber_Element)this.original).element;
            }
            return IELParamValue.super.getElement();
        }

        @Override
        public XSelectProxy getSelectProxy() {
            return this.selectProxy;
        }

        @Override
        public void setSelectProxy(XSelectProxy selectProxy) {
            this.selectProxy = selectProxy;
        }

        @Override
        public IELParamValue getValueBeforeSelect() {
            if (this.selectProxy != null) {
                return this.selectProxy.getValueBeforeSelect();
            }
            return IELParamValue.super.getValueBeforeSelect();
        }

        @Override
        public IELParamKeyValueCompact pack(String key) {
            return new ParamKeyValueNumberCompact(key, this.value);
        }

        @Override
        public ELParamValueScope getValue(IHid hid, BitVectorContext context, IHidEvaluationGuardian guardian) {
            if (this.value instanceof DVTUnpackedStruct) {
                DVTUnpackedStruct struct = (DVTUnpackedStruct)this.value;
                DVTNumber memberSelect = struct.getMemberSelect(hid, false);
                if (DVTNumber.isUndefined(memberSelect)) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                return ELParamValueScope.of(ParamValueNumber.of(memberSelect), this);
            }
            if (this.value instanceof VlogBitVector) {
                int dimensionLow;
                VlogBitVector vlogBitVector = (VlogBitVector)this.value;
                if (!vlogBitVector.isStruct(true)) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                Map<String, StructMemberContextInfo> memberInfo = vlogBitVector.getMemberInfoByName();
                if (memberInfo == null || !memberInfo.containsKey(hid.getName())) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                StructMemberContextInfo memberContextInfo = memberInfo.get(hid.getName());
                int dimensionHigh = vlogBitVector.getLeft();
                if (dimensionHigh < (dimensionLow = vlogBitVector.getRight())) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                int lh = dimensionHigh - memberContextInfo.startingIndex;
                int rh = dimensionHigh - (memberContextInfo.startingIndex + memberContextInfo.context.getSize()) + 1;
                IELParamValue[] computedValues = new IELParamValue[]{ParamValueNumber.of(VlogBitVector.createConstant(lh)), ParamValueNumber.of(VlogBitVector.createConstant(rh))};
                XNamedComputedSelect computedSelect = new XNamedComputedSelect(hid, computedValues);
                ArrayListContainer<XComputedSelect> newSelects = new ArrayListContainer<XComputedSelect>(10);
                XSelectProxy selectProxy = ParamValueNumber.createSelectProxy(this, memberContextInfo, computedSelect, newSelects, guardian);
                IRfNamedElement element = hid.getElement();
                IELParamValue selectedValue = XValueHolderFactory.createSelectProxyValue(selectProxy.getValueBeforeSelectRaw(), selectProxy, false, false, element != null ? element.getLanguageKind() : LanguageKind.VLOG);
                return ELParamValueScope.of(new PackedStructMember(memberContextInfo.context.transform(selectedValue), element, memberContextInfo.context, selectProxy), null);
            }
            return ELParamValueScope.UNDEFINED_VALUE;
        }

        private static XSelectProxy createSelectProxy(IELParamValue value, StructMemberContextInfo memberContextInfo, XComputedSelect computedSelect, ArrayListContainer<XComputedSelect> newSelects, IHidEvaluationGuardian guardian) {
            IELParamValue original = value.getOriginal();
            if (original != null && original.getSelectProxy() != null) {
                value = original;
            }
            if (value.getSelectProxy() != null) {
                IELParamValue valueBeforeSelect = value;
                if (valueBeforeSelect != null && valueBeforeSelect.getSelectProxy() != null) {
                    valueBeforeSelect = ParamValueNumber.collectSelects(newSelects, valueBeforeSelect.getSelectProxy());
                }
                newSelects.add(computedSelect);
                XSelectProxy selectProxy = new XSelectProxy(valueBeforeSelect, newSelects, memberContextInfo.context, guardian);
                return selectProxy;
            }
            IELParamValue valueBeforeSelect = value;
            XSelectProxy selectProxy = new XSelectProxy(valueBeforeSelect, computedSelect, memberContextInfo.context, guardian);
            return selectProxy;
        }

        private static IELParamValue collectSelects(ArrayListContainer<XComputedSelect> selects, XSelectProxy selectProxy) {
            IELParamValue valueBeforeSelect = selectProxy.getValueBeforeSelect();
            if (valueBeforeSelect != null && valueBeforeSelect.getSelectProxy() != null) {
                valueBeforeSelect = ParamValueNumber.collectSelects(selects, valueBeforeSelect.getSelectProxy());
            }
            for (XComputedSelect select : selectProxy.computedSelects) {
                selects.add(select);
            }
            return valueBeforeSelect;
        }

        @Override
        public boolean debuggerHasVariables(boolean isFirstStackFrame) {
            if (this.value instanceof VlogBitVector) {
                VlogBitVector vlogBitVector = (VlogBitVector)this.value;
                if (!vlogBitVector.isStruct(true)) {
                    IRfNamedElement element = this.getElement();
                    if (!(element instanceof IRfAssociatedTypeElement)) {
                        return false;
                    }
                    IDataType dataType = ((IRfAssociatedTypeElement)element).getDataType();
                    if (dataType == null || !dataType.hasPackedDimension()) {
                        return false;
                    }
                    int[] packed = this.value.getPacked();
                    return packed != null && packed.length > 2;
                }
                Map<String, StructMemberContextInfo> memberInfo = vlogBitVector.getMemberInfoByName();
                return memberInfo != null && !memberInfo.isEmpty();
            }
            return false;
        }

        @Override
        public Map<DVTXVariableInfo, IELParamValue> debuggerGetVariables(boolean isFirstStackFrame, boolean isBreakOnFirst) {
            if (!(this.value instanceof VlogBitVector)) {
                return null;
            }
            VlogBitVector vlogBitVector = (VlogBitVector)this.value;
            if (!vlogBitVector.isStruct(true)) {
                return this.debuggerExtractPackedElements(vlogBitVector);
            }
            IRfNamedElement element = this.getElement();
            if (!(element instanceof IRfAssociatedTypeElement)) {
                return null;
            }
            IDataType dataType = ((IRfAssociatedTypeElement)element).getDataType();
            int[] packed = this.value.getPacked();
            if (dataType != null && dataType.hasPackedDimension() && packed != null && packed.length > 2) {
                return this.debuggerExtractPackedElements(vlogBitVector);
            }
            Map<String, StructMemberContextInfo> memberInfo = vlogBitVector.getMemberInfoByName();
            if (memberInfo == null || memberInfo.isEmpty()) {
                return null;
            }
            return this.debuggerExtractStructMembers(isBreakOnFirst, memberInfo);
        }

        private Map<DVTXVariableInfo, IELParamValue> debuggerExtractStructMembers(boolean isBreakOnFirst, Map<String, StructMemberContextInfo> memberInfo) {
            LinkedHashMap<DVTXVariableInfo, IELParamValue> result = new LinkedHashMap<DVTXVariableInfo, IELParamValue>();
            for (Map.Entry<String, StructMemberContextInfo> entry : memberInfo.entrySet()) {
                IRfNamedElement member;
                String memberName = entry.getKey();
                HidUtils.StandInHid hid = HidUtils.StandInHid.create(memberName, null, member = entry.getValue().context.getOrigin(), HidOccurrence.DUMMY_OCCURRENCE);
                ELParamValueScope value = this.getValue(hid, null, IHidEvaluationGuardian.DUMMY_EVAL_GUARDIAN);
                IELParamValue actualValue = XUtils.getValue(value) == null ? null : ParamValueNumber.of(value.value.getDVTNumber(), member, null);
                result.put(new DVTXVariableInfo(memberName, DVTXVariableType.NO_TYPE), actualValue == null ? null : ParamValueNumber_Element.of(actualValue));
                if (!isBreakOnFirst) continue;
                return result;
            }
            return result;
        }

        private Map<DVTXVariableInfo, IELParamValue> debuggerExtractPackedElements(VlogBitVector vlogBitVector) {
            TreeMap<DVTXVariableInfo, IELParamValue> result = new TreeMap<DVTXVariableInfo, IELParamValue>((o1, o2) -> {
                String varName1 = o1.getVariableName();
                String varName2 = o2.getVariableName();
                return Integer.parseInt(varName1.substring(1, varName1.length() - 1)) - Integer.parseInt(varName2.substring(1, varName2.length() - 1));
            });
            IRfNamedElement element = this.getElement();
            if (!(element instanceof IRfAssociatedTypeElement)) {
                return null;
            }
            int[] packed = this.value.getPacked();
            if (packed == null || packed.length == 0) {
                return null;
            }
            int dimensionHigh = packed[0];
            int dimensionLow = packed[1];
            int bitsCnt = vlogBitVector.getSize();
            int bitSelectStartPos = 0;
            IRfNamedElement arrayItemElement = null;
            if (element instanceof IRfFieldElement && element.isPredefined()) {
                arrayItemElement = ((IRfFieldElement)element).xGetAssociatedType(null);
                arrayItemElement = arrayItemElement instanceof IRfListType ? ((IRfListType)arrayItemElement).xGetItemField(((IRfAssociatedTypeElement)arrayItemElement).getAssociatedType()) : ((IRfAssociatedTypeElement)arrayItemElement).getAssociatedType();
            } else if (element instanceof IRfListType) {
                arrayItemElement = ((IRfListType)element).xGetItemField(((IRfAssociatedTypeElement)element).getAssociatedType());
            } else {
                arrayItemElement = ((IRfAssociatedTypeElement)element).getAssociatedType();
                if (!(arrayItemElement instanceof IRfAssociatedTypeElement)) {
                    return null;
                }
                arrayItemElement = arrayItemElement instanceof IRfListType ? ((IRfListType)arrayItemElement).xGetItemField(((IRfAssociatedTypeElement)arrayItemElement).getAssociatedType()) : ((IRfAssociatedTypeElement)arrayItemElement).getAssociatedType();
            }
            if (arrayItemElement == null) {
                return null;
            }
            if (dimensionHigh > dimensionLow) {
                int bitSelectSize = bitsCnt / (dimensionHigh - dimensionLow + 1);
                int i = dimensionHigh;
                while (i >= dimensionLow) {
                    result.put(new DVTXVariableInfo("[" + Integer.toString(i) + "]", DVTXVariableType.NO_TYPE), ParamValueNumber_Element.of(vlogBitVector.getBitSelect(bitSelectStartPos, bitSelectSize), arrayItemElement, null));
                    bitSelectStartPos += bitSelectSize;
                    --i;
                }
                return result;
            }
            int bitSelectSize = bitsCnt / (dimensionLow - dimensionHigh + 1);
            int i = dimensionHigh;
            while (i <= dimensionLow) {
                result.put(new DVTXVariableInfo("[" + Integer.toString(i) + "]", DVTXVariableType.NO_TYPE), ParamValueNumber_Element.of(vlogBitVector.getBitSelect(bitSelectStartPos, bitSelectSize), arrayItemElement, null));
                bitSelectStartPos += bitSelectSize;
                ++i;
            }
            return result;
        }

        @Override
        public IELParamValue setFromConfig(int offset, ParserPath parserPath) {
            return new ParamValueNumberFromConfig(this.value, offset, parserPath);
        }

        @Override
        public IELParamValue setFromDefparam(int offset, ParserPath parserPath, ElementPath defparamHierarchyPath) {
            return new ParamValueNumberFromDefparam(this.value, offset, parserPath, defparamHierarchyPath);
        }

        public String toString() {
            return this.value instanceof DVTUnpackedArray ? this.value.toString(10, false, false) : String.valueOf(this.value.toString(10, false, false)) + " (" + this.value.toString(2, false, false) + ")";
        }

        @Override
        public String toStringRadix(int radix) {
            return this.value.toString(radix, false, false);
        }

        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return this.value.toNiceString(context, radix, useCharLimit, useLowerCaseMaskType);
        }

        public String toNiceStringStructs() {
            if (!(this.value instanceof VlogBitVector)) {
                return "'{}";
            }
            Map<String, StructMemberContextInfo> memberList = ((VlogBitVector)this.value).getMemberInfoByName();
            if (memberList == null || memberList.isEmpty()) {
                return "'{}";
            }
            Map<DVTXVariableInfo, IELParamValue> structMembers = this.debuggerExtractStructMembers(false, memberList);
            StringBuilder result = new StringBuilder("'{");
            for (IELParamValue member : structMembers.values()) {
                if (result.length() > 2) {
                    result.append(", ");
                }
                if (!(member instanceof ParamValueNumber)) continue;
                result.append(member.getElement().getName()).append(":'h");
                XUtils.stripLeadingZeroes(result, ((ParamValueNumber)member).toStringRadix(16));
            }
            return result.append("}").toString();
        }

        @Override
        public ELManager getManager() {
            return null;
        }

        @Override
        public boolean updateValue(IELParamValue newResult, IHidEvaluationGuardian guardian) {
            if (newResult == null) {
                return false;
            }
            int uniqueId = this.value.getUniqueId();
            boolean isModified = this.original == null && this.selectProxy == null && !this.value.equals(newResult.getDVTNumber());
            this.value = newResult.getDVTNumber();
            if (uniqueId >= 0) {
                this.value = this.value.setUniqueId(uniqueId, true);
            }
            if (guardian == null) {
                return isModified;
            }
            if (this.original != null && guardian.isInterpreter()) {
                isModified |= this.original.updateValue(newResult, guardian);
            }
            if (isModified |= this.updateProxy(guardian.isOnlyIfArrayItemExists())) {
                guardian.callbackValueChanged(this);
            }
            return isModified;
        }

        @Override
        public IELParamValue copy() {
            return ParamValueNumber.of(this);
        }

        @Override
        public IELParamValue shallowCopy() {
            return ParamValueNumber.of(this);
        }

        @Override
        public IELParamValue scalarCopy() {
            return ParamValueNumber.of(this);
        }

        private boolean updateProxy(boolean onlyIfArrayItemExists) {
            if (this.selectProxy == null) {
                return false;
            }
            IELParamValue valueBeforeSelect = this.selectProxy.getValueBeforeSelect();
            if (valueBeforeSelect == null) {
                return false;
            }
            return valueBeforeSelect.updateProxyValue(this.selectProxy, this, onlyIfArrayItemExists);
        }

        @Override
        public boolean updateProxyValue(XSelectProxy selectProxy, IELParamValue updateValue, boolean onlyIfArrayItemExists) {
            if (DVTNumber.isUndefined(updateValue.getDVTNumber())) {
                return false;
            }
            DVTNumber number = this.getDVTNumber();
            if (number instanceof IDVTRangeSelectable) {
                DVTNumber updatedSelects = ((IDVTRangeSelectable)((Object)number)).updateSelects(updateValue.getDVTNumber(), selectProxy.computedSelects);
                return this.updateValue(ParamValueNumber.of(updatedSelects), selectProxy.guardian);
            }
            return false;
        }

        @Override
        public String getDebuggerTypeName(boolean isFormal) {
            return "N/A";
        }

        public static IELParamValue tristate(IELParamValue existingValue) {
            if (existingValue instanceof ParamValueNumber_Tristate) {
                return existingValue;
            }
            if (existingValue instanceof XValueHolder) {
                return existingValue;
            }
            return new ParamValueNumber_Tristate(existingValue.getDVTNumber(), existingValue.getElement());
        }

        @Override
        public void xSystemCPackValue(IRfNamedElement typeElement, int options, MessagePacker buffer, boolean preSpecifyMaker) throws Exception {
            Object starter = XUVMElaborationStarters.getStarter(LanguageKind.VLOG);
            starter.getDPICMapperManager().mapValue(this, typeElement, buffer, preSpecifyMaker);
        }

        public static class ArraySliceHolder
        extends ParamValueNumber {
            public static final int SLICE_SIZE = 100;
            private IXArrayValues arrayValues;
            private int offset;
            private int lowerBound;
            private int upperBound;

            public ArraySliceHolder(IXArrayValues arrayValues, int offset, int lowerBound, int upperBound) {
                super(VlogBitVector.ZERO);
                this.arrayValues = arrayValues;
                this.offset = offset;
                this.lowerBound = lowerBound;
                this.upperBound = upperBound;
            }

            public int getLowerBound() {
                return this.lowerBound;
            }

            public int getUpperBound() {
                return this.upperBound;
            }

            public String getVariableName() {
                return DVTStringUtil.appendString("[", this.lowerBound + this.offset, "..", this.upperBound + this.offset, "]");
            }

            @Override
            public Map<DVTXVariableInfo, IELParamValue> debuggerGetVariables(boolean isFirstStackFrame, boolean isBreakOnFirst) {
                int sliceSize = 100;
                int size = this.upperBound - this.lowerBound + 1;
                while (size / sliceSize > 100) {
                    sliceSize *= 100;
                }
                if (size > sliceSize) {
                    TreeMap<DVTXVariableInfo, IELParamValue> result = new TreeMap<DVTXVariableInfo, IELParamValue>((o1, o2) -> Integer.parseInt(o1.getVariableName().substring(1, o1.getVariableName().indexOf(46))) - Integer.parseInt(o2.getVariableName().substring(1, o2.getVariableName().indexOf(46))));
                    int nofChunks = size % sliceSize == 0 ? size / sliceSize : size / sliceSize + 1;
                    int i = 0;
                    while (i < nofChunks) {
                        ArraySliceHolder variableValue = new ArraySliceHolder(this.arrayValues, this.offset, this.lowerBound + i * sliceSize, this.lowerBound + Math.min(size, (i + 1) * sliceSize) - 1);
                        result.put(new DVTXVariableInfo(variableValue.getVariableName(), DVTXVariableType.NO_TYPE), variableValue);
                        ++i;
                    }
                    return result;
                }
                return this.arrayValues.debuggerGetSliceVariables(this.lowerBound, this.upperBound);
            }

            @Override
            public IELParamValue debuggerGetVariable(String variableName, IRfNamedElement element) {
                return super.debuggerGetVariable(variableName, element);
            }

            @Override
            public boolean debuggerHasVariables(boolean isFirstStackFrame) {
                return true;
            }

            @Override
            public String debuggerGetValueString(String variableName, IELParamValue variableValue) {
                if (variableValue instanceof ArraySliceHolder) {
                    return "";
                }
                return super.debuggerGetValueString(variableName, variableValue);
            }
        }

        public static class PackedStructMember
        extends ParamValueNumber_Element_Enum {
            private IRfNamedElement structItem;
            private BitVectorContext structItemContext;
            private XSelectProxy rawSelectProxy;

            public PackedStructMember(IELParamValue value, IRfNamedElement structItem, BitVectorContext structItemContext, XSelectProxy rawSelectProxy) {
                super(value.getDVTNumber(), value.getElement(), value.getEnumTypeWrapper());
                this.original = value.getOriginal();
                this.structItem = structItem;
                this.structItemContext = structItemContext;
                this.rawSelectProxy = rawSelectProxy;
            }

            @Override
            public XSelectProxy getSelectProxy() {
                return this.original.getSelectProxy();
            }

            public IRfNamedElement getStructItem() {
                return this.structItem;
            }

            public BitVectorContext getStructItemContext() {
                return this.structItemContext;
            }

            public XSelectProxy getRawSelectProxy() {
                return this.rawSelectProxy;
            }
        }

        public static class ParamKeyValueNumberCompact
        implements IELParamKeyValueCompact {
            protected final String cKey;
            protected final DVTNumber cValue;

            private ParamKeyValueNumberCompact(String key, DVTNumber value) {
                this.cKey = key;
                this.cValue = value;
            }

            @Override
            public Object[] unpack() {
                return new Object[]{this.cKey, new ParamValueNumber(this.cValue)};
            }

            public String toString() {
                return this.cKey + "=" + (this.cValue != null ? this.cValue.toString() : null);
            }

            public int hashCode() {
                return Objects.hash(this.cKey, this.cValue);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ParamKeyValueNumberCompact other = (ParamKeyValueNumberCompact)obj;
                return Objects.equals(this.cKey, other.cKey) && this.cValue.internalEquals(other.cValue);
            }

            public final boolean equalsOnlyValue(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ParamKeyValueNumberCompact other = (ParamKeyValueNumberCompact)obj;
                return Objects.equals(this.cKey, other.cKey) && this.cValue.internalEquals(other.cValue);
            }

            @Override
            public boolean internalEquals(Object obj, boolean checkOnlyValue) {
                return checkOnlyValue ? this.equalsOnlyValue(obj) : this.equals(obj);
            }
        }

        public static class ParamValueNumberFromConfig
        extends ParamValueNumber {
            private int offset;
            private ParserPath parserPath;

            private ParamValueNumberFromConfig(DVTNumber value, int offset, ParserPath parserPath) {
                super(value);
                this.offset = offset;
                this.parserPath = parserPath;
            }

            public int getOffset() {
                return this.offset;
            }

            public ParserPath getParserPath() {
                return this.parserPath;
            }

            @Override
            public boolean isFromConfig() {
                return true;
            }

            @Override
            public int hashCode() {
                int result = super.hashCode();
                result = 31 * result + Objects.hash(this.offset, this.parserPath);
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!super.equals(obj)) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ParamValueNumberFromConfig other = (ParamValueNumberFromConfig)obj;
                return this.offset == other.offset && Objects.equals(this.parserPath, other.parserPath);
            }

            @Override
            public IELParamKeyValueCompact pack(String key) {
                return new ParamKeyValueNumberCompactFromConfig(key, this.value, this.offset, this.parserPath);
            }

            public static class ParamKeyValueNumberCompactFromConfig
            extends ParamKeyValueNumberCompact {
                private final int cOffset;
                private final ParserPath cParserPath;

                private ParamKeyValueNumberCompactFromConfig(String key, DVTNumber value, int offset, ParserPath parserPath) {
                    super(key, value);
                    this.cOffset = offset;
                    this.cParserPath = parserPath;
                }

                @Override
                public Object[] unpack() {
                    return new Object[]{this.cKey, new ParamValueNumberFromConfig(this.cValue, this.cOffset, this.cParserPath)};
                }

                @Override
                public String toString() {
                    return super.toString() + "@" + this.cParserPath + ":" + this.cOffset;
                }

                @Override
                public int hashCode() {
                    int result = super.hashCode();
                    result = 31 * result + Objects.hash(this.cOffset, this.cParserPath);
                    return result;
                }

                @Override
                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!super.equals(obj)) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    ParamKeyValueNumberCompactFromConfig other = (ParamKeyValueNumberCompactFromConfig)obj;
                    return this.cOffset == other.cOffset && Objects.equals(this.cParserPath, other.cParserPath);
                }
            }
        }

        public static class ParamValueNumberFromDefparam
        extends ParamValueNumber {
            private final int offset;
            private final ParserPath parserPath;
            private final ElementPath hierarchyPath;

            private ParamValueNumberFromDefparam(DVTNumber value, int offset, ParserPath parserPath, ElementPath hierarchyPath) {
                super(value);
                this.offset = offset;
                this.parserPath = parserPath;
                this.hierarchyPath = hierarchyPath;
            }

            public int getOffset() {
                return this.offset;
            }

            public ParserPath getParserPath() {
                return this.parserPath;
            }

            public ElementPath getHierarchyPath() {
                return this.hierarchyPath;
            }

            @Override
            public int hashCode() {
                int result = super.hashCode();
                result = 31 * result + Objects.hash(this.hierarchyPath, this.offset, this.parserPath);
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!super.equals(obj)) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ParamValueNumberFromDefparam other = (ParamValueNumberFromDefparam)obj;
                return Objects.equals(this.hierarchyPath, other.hierarchyPath) && this.offset == other.offset && Objects.equals(this.parserPath, other.parserPath);
            }

            @Override
            public IELParamKeyValueCompact pack(String key) {
                return new ParamKeyValueNumberCompactFromDefparam(key, this.value, this.offset, this.parserPath, this.hierarchyPath);
            }

            public static class ParamKeyValueNumberCompactFromDefparam
            extends ParamKeyValueNumberCompact {
                private final int cOffset;
                private final ParserPath cParserPath;
                private final ElementPath cHierarchyPath;

                private ParamKeyValueNumberCompactFromDefparam(String key, DVTNumber value, int offset, ParserPath parserPath, ElementPath hierarchyPath) {
                    super(key, value);
                    this.cOffset = offset;
                    this.cParserPath = parserPath;
                    this.cHierarchyPath = hierarchyPath;
                }

                @Override
                public Object[] unpack() {
                    return new Object[]{this.cKey, new ParamValueNumberFromDefparam(this.cValue, this.cOffset, this.cParserPath, this.cHierarchyPath)};
                }

                @Override
                public String toString() {
                    return super.toString() + "@" + this.cParserPath + ":" + this.cOffset + ":" + this.cHierarchyPath;
                }

                @Override
                public int hashCode() {
                    int result = super.hashCode();
                    result = 31 * result + Objects.hash(this.cHierarchyPath, this.cOffset, this.cParserPath);
                    return result;
                }

                @Override
                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!super.equals(obj)) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    ParamKeyValueNumberCompactFromDefparam other = (ParamKeyValueNumberCompactFromDefparam)obj;
                    return Objects.equals(this.cHierarchyPath, other.cHierarchyPath) && this.cOffset == other.cOffset && Objects.equals(this.cParserPath, other.cParserPath);
                }
            }
        }

        public static class ParamValueNumber_ConcatList
        extends ParamValueNumber {
            private List<ELParamValueScope> values;

            public ParamValueNumber_ConcatList(@NotNull List<ELParamValueScope> values) {
                super(VlogBitVector.ZERO);
                this.values = values;
                this.value = this.computeDVTNumber();
            }

            private DVTNumber computeDVTNumber() {
                int size = 0;
                boolean is4State = false;
                DVTNumber numberValue = VlogBitVector.ZERO;
                for (ELParamValueScope concatOperandValue : this.values) {
                    DVTNumber dvtNumber = concatOperandValue.getDVTNumber();
                    if (!(dvtNumber instanceof VlogBitVector)) continue;
                    int valueSize = dvtNumber.getSize();
                    is4State |= dvtNumber.is4State();
                    numberValue = DVTNumber.or(dvtNumber, DVTNumber.shiftLeft(numberValue, valueSize, size += valueSize));
                }
                return VlogBitVector.create(false, size - 1, 0, null, is4State, false, false, false, null, numberValue.getMasks(), ((DVTNumber)numberValue).bigIntegerValue());
            }

            @Override
            public IELParamValue doUpdate(IHidOperator parentOperator, IELParamValue rightValue, int updateEvaluator, AtomicBoolean isModified, int uniqueId, IHidEvaluator evaluator, IHidObject leftOp, IHidEvaluationGuardian guardian) {
                try {
                    if (!HidUtils.isOperator(leftOp) || !HidUtils.isOperator(parentOperator)) {
                        throw new UnknownHidObjectEvaluationException(leftOp);
                    }
                    ListContainer<IHidObject> rhValues = ((IHidOperator)leftOp).getRHValues();
                    boolean isSameSize = rhValues.size() == this.values.size();
                    DVTNumber updateNumber = rightValue.getDVTNumber();
                    if (!(updateNumber instanceof IDVTRangeSelectable)) {
                        throw new UnknownHidObjectEvaluationException(leftOp);
                    }
                    int size = this.values.size();
                    LinkedHashSet<Integer> resumeThreads = new LinkedHashSet<Integer>();
                    ArrayList<ChangedValue> changedValues = new ArrayList<ChangedValue>();
                    PostponedNotificationGuardian postponedGuardian = new PostponedNotificationGuardian(guardian, resumeThreads, changedValues);
                    IELParamValue prevValue = XUtils.getValue(ELUtils.evaluate(leftOp, evaluator, null, guardian));
                    int currentSize = 0;
                    int i = 0;
                    while (i < this.values.size()) {
                        ELParamValueScope concatOperandValue = this.values.get(i);
                        int operandSize = concatOperandValue.getDVTNumber().getSize();
                        DVTNumber updateValue = updateNumber.getBitSelect(currentSize, operandSize);
                        if (DVTNumber.isUndefined(updateValue)) {
                            throw new UnknownHidObjectEvaluationException(leftOp);
                        }
                        BitVectorContext lhContext = BitVectorContext.of(concatOperandValue.getDVTNumber(), concatOperandValue.getElement());
                        lhContext.setIsCast(true);
                        IELParamValue transformedUpdateValue = ParamValueNumber.of(lhContext.transform(updateValue));
                        if (!ELUtils.isUnsuccessfulEval(transformedUpdateValue)) {
                            concatOperandValue.doUpdate(new XInstValueHolder.XIndexedCopyConcatOperator((HidOperator)parentOperator, i), transformedUpdateValue, 1, evaluator, isSameSize ? rhValues.get(size - i - 1) : rhValues.get(0), postponedGuardian);
                            currentSize += operandSize;
                        }
                        ++i;
                    }
                    IELParamValue currValue = XUtils.getValue(ELUtils.evaluate(leftOp, evaluator, null, guardian));
                    if (currValue != null && prevValue != null && !currValue.equals(prevValue)) {
                        for (Integer resumeThread : resumeThreads) {
                            guardian.scheduleWaitingThreads(resumeThread, XSimRegion.XRegionKind.Active);
                        }
                        for (ChangedValue changedValue : changedValues) {
                            guardian.callbackValueChanged(changedValue.uniqueId, changedValue.parentOperator, changedValue.evaluator, changedValue.hid, changedValue.computedSelects, changedValue.prevValue, changedValue.currValue);
                        }
                    }
                }
                finally {
                    this.value = this.computeDVTNumber();
                }
                return rightValue;
            }
        }

        public static class ParamValueNumber_Element
        extends ParamValueNumber {
            private IRfNamedElement element;

            private ParamValueNumber_Element(DVTNumber value, IRfNamedElement element) {
                super(value);
                this.element = element;
            }

            public DVTNumber getValue() {
                return this.value;
            }

            @Override
            public IRfNamedElement getElement() {
                return this.element;
            }

            @Override
            public ELManager getManager() {
                IRfSingleLangProject project = this.element.getRfProject();
                return project != null ? project.getELManager() : null;
            }
        }

        public static class ParamValueNumber_Element_Enum
        extends ParamValueNumber_Element {
            private ELEnumTypeWrapper enumTypeWrapper;

            private ParamValueNumber_Element_Enum(DVTNumber value, IRfNamedElement element, ELEnumTypeWrapper enumTypeWrapper) {
                super(value, element);
                this.enumTypeWrapper = enumTypeWrapper;
            }

            @Override
            public IRfNamedElement getNamedElement() {
                if (this.enumTypeWrapper != null) {
                    return this.enumTypeWrapper.getType();
                }
                return null;
            }

            @Override
            public ELParamValueScope getValue(IHid hid, IHidEvaluator hidEvaluator, BitVectorContext context, boolean isMethod, IHidEvaluationGuardian guardian) {
                return super.getValue(hid, hidEvaluator, context, isMethod, guardian);
            }

            @Override
            public ELEnumTypeWrapper getEnumTypeWrapper() {
                return this.enumTypeWrapper;
            }

            public void setEnumTypeWrapper(ELEnumTypeWrapper enumTypeWrapper) {
                this.enumTypeWrapper = enumTypeWrapper;
            }
        }

        public static class ParamValueNumber_StreamConcatList
        extends ParamValueNumber {
            private List<IELParamValue> values;
            private boolean isReverse;
            private int streamedBitsChunkSize;

            public ParamValueNumber_StreamConcatList(boolean isReverse, List<IELParamValue> values, int streamedBitsChunkSize) {
                super(VlogBitVector.ZERO);
                this.values = values;
                this.value = this.computeDVTNumber();
                this.isReverse = isReverse;
                this.streamedBitsChunkSize = streamedBitsChunkSize;
            }

            public List<IELParamValue> getConcatValues() {
                return this.values;
            }

            private DVTNumber computeDVTNumber() {
                int size = 0;
                boolean is4State = false;
                DVTNumber numberValue = VlogBitVector.ZERO;
                for (IELParamValue concatOperandValue : this.values) {
                    DVTNumber dvtNumber = concatOperandValue.getDVTNumber();
                    if (!(dvtNumber instanceof VlogBitVector)) continue;
                    int valueSize = dvtNumber.getSize();
                    is4State |= dvtNumber.is4State();
                    numberValue = DVTNumber.or(dvtNumber, DVTNumber.shiftLeft(numberValue, valueSize, size += valueSize));
                }
                return VlogBitVector.create(false, size - 1, 0, null, is4State, false, false, false, null, numberValue.getMasks(), ((DVTNumber)numberValue).bigIntegerValue());
            }

            @Override
            public IELParamValue doUpdate(IHidOperator parentOperator, IELParamValue rightValue, int updateEvaluator, AtomicBoolean isModified, int uniqueId, IHidEvaluator evaluator, IHidObject leftOp, IHidEvaluationGuardian guardian) {
                try {
                    VlogBitVector updateBits;
                    if (!HidUtils.isOperator(leftOp) || !HidUtils.isOperator(parentOperator)) {
                        throw new UnknownHidObjectEvaluationException(leftOp);
                    }
                    DVTNumber updateNumber = rightValue.getDVTNumber();
                    if (!(updateNumber instanceof IDVTRangeSelectable)) {
                        throw new UnknownHidObjectEvaluationException(leftOp);
                    }
                    if (updateNumber instanceof DVTUnpackedArray || updateNumber instanceof DVTUnpackedStruct) {
                        updateBits = updateNumber.toBitVector();
                    } else if (updateNumber instanceof VlogBitVector) {
                        updateBits = (VlogBitVector)updateNumber;
                    } else {
                        return null;
                    }
                    if (this.isReverse) {
                        updateBits = updateBits.reverse(this.streamedBitsChunkSize);
                    }
                    LinkedHashSet<Integer> resumeThreads = new LinkedHashSet<Integer>();
                    ArrayList<ChangedValue> changedValues = new ArrayList<ChangedValue>();
                    PostponedNotificationGuardian postponedGuardian = new PostponedNotificationGuardian(guardian, resumeThreads, changedValues);
                    int currentSize = 0;
                    int rhTotalBits = updateBits.getSize();
                    boolean isFirstDynamic = true;
                    ArrayList<IELParamValue> newValues = new ArrayList<IELParamValue>();
                    int i = 0;
                    while (i < this.values.size()) {
                        IELParamValue value = this.values.get(i);
                        if (value instanceof XArrayValueHolder && (((XArrayValueHolder)value).isDynamicArray() || ((XArrayValueHolder)value).isQueueArray())) {
                            if (!isFirstDynamic) {
                                ((XArrayValueHolder)value).clear();
                            } else {
                                isFirstDynamic = false;
                                int fixedSizeBitsRemaining = 0;
                                int j = i + 1;
                                while (j < this.values.size()) {
                                    IELParamValue operand = this.values.get(j);
                                    if (!(operand instanceof XArrayValueHolder) || !((XArrayValueHolder)value).isDynamicArray() && !((XArrayValueHolder)value).isQueueArray()) {
                                        fixedSizeBitsRemaining += operand.getSize();
                                    }
                                    ++j;
                                }
                                int dynamicBitLimit = rhTotalBits - currentSize - fixedSizeBitsRemaining;
                                ((XArrayValueHolder)value).initFromNofBits(dynamicBitLimit, postponedGuardian);
                                newValues.addAll(((XArrayValueHolder)value).getZValues());
                            }
                        } else {
                            newValues.add(value);
                            currentSize += value.getSize();
                        }
                        ++i;
                    }
                    currentSize = 0;
                    i = 0;
                    while (i < newValues.size()) {
                        IELParamValue concatOperandValue = (IELParamValue)newValues.get(i);
                        int operandSize = concatOperandValue.getDVTNumber().getSize();
                        DVTNumber updateValue = updateBits.getBitSelect(currentSize, operandSize);
                        if (DVTNumber.isUndefined(updateValue)) {
                            throw new UnknownHidObjectEvaluationException(leftOp);
                        }
                        BitVectorContext lhContext = BitVectorContext.of(concatOperandValue.getDVTNumber(), concatOperandValue.getElement());
                        lhContext.setIsCast(true);
                        IELParamValue transformedUpdateValue = ParamValueNumber.of(lhContext.transform(updateValue));
                        if (!ELUtils.isUnsuccessfulEval(transformedUpdateValue)) {
                            concatOperandValue.doUpdate(new XInstValueHolder.XIndexedCopyConcatOperator((HidOperator)parentOperator, i), transformedUpdateValue, 1, new AtomicBoolean(), -1, evaluator, null, postponedGuardian);
                            currentSize += operandSize;
                        }
                        ++i;
                    }
                }
                finally {
                    this.value = this.computeDVTNumber();
                }
                return rightValue;
            }
        }

        public static class ParamValueNumber_Tristate
        extends ParamValueNumber {
            private IRfNamedElement element;
            private long lastDeltaCycleCount;
            private Map<XInstValueHolder.XEvalOverrideHidOperator, IELParamValue> drivers;
            private int relaxationCount;
            private static final int MAX_RELAXATION = 20;

            private ParamValueNumber_Tristate(DVTNumber value, IRfNamedElement element) {
                super(value);
                this.element = element;
                this.lastDeltaCycleCount = -1L;
                this.drivers = new LinkedHashMap<XInstValueHolder.XEvalOverrideHidOperator, IELParamValue>(4);
            }

            @Override
            public boolean isTristate() {
                return true;
            }

            @Override
            public IRfNamedElement getElement() {
                return this.element;
            }

            @Override
            public IELParamValue doUpdate(IHidOperator parentOperator, IELParamValue rightValue, int updateEvaluator, AtomicBoolean isModified, int uniqueId, IHidEvaluator evaluator, IHidObject leftOp, IHidEvaluationGuardian guardian) {
                if ((rightValue = this.multiDriverValue(parentOperator, evaluator, rightValue, guardian)) == null) {
                    return IMPLICIT_RESULT;
                }
                if (rightValue.equals(this)) {
                    return IMPLICIT_RESULT;
                }
                return super.doUpdate(parentOperator, rightValue, updateEvaluator, isModified, uniqueId, evaluator, leftOp, guardian);
            }

            private IELParamValue multiDriverValue(IHidOperator parentOperator, IHidEvaluator evaluator, IELParamValue rightValue, IHidEvaluationGuardian guardian) {
                IELParamValue newValue;
                if (this.original != null) {
                    throw new UnsupportedOperationException();
                }
                XValueHolderFactory factory = guardian.getFactory();
                long currDeltaCycleCount = factory.getDeltaCycleCount();
                if (this.lastDeltaCycleCount != currDeltaCycleCount) {
                    this.lastDeltaCycleCount = currDeltaCycleCount;
                    this.drivers.clear();
                    this.relaxationCount = 0;
                }
                if (XUtils.hasX(rightValue = this.getMultiDriversValue(parentOperator = XInstValueHolder.XEvalOverrideHidOperator.create((XValueHolder)evaluator, (HidOperator)parentOperator, ((XValueHolder)evaluator).getParserPath()), rightValue, guardian))) {
                    if (XUtils.isPortConnection(parentOperator) && rightValue.equals(newValue = this.getDriversValue(parentOperator))) {
                        return null;
                    }
                    if (this.relaxationCount < 20) {
                        factory.addEvent(XSimRegion.XRegionKind.Active, new XSimUpdateEvent((XInstValueHolder.XEvalOverrideHidOperator)parentOperator, guardian));
                        ++this.relaxationCount;
                        return null;
                    }
                }
                this.drivers.put((XInstValueHolder.XEvalOverrideHidOperator)parentOperator, rightValue);
                if (this.drivers.size() == 1) {
                    return rightValue;
                }
                newValue = this.getDriversValue(null);
                if (newValue == null) {
                    return null;
                }
                if (!XUtils.hasX(newValue) || this.drivers.size() == 1) {
                    return newValue;
                }
                if (this.relaxationCount >= 20) {
                    return newValue;
                }
                ++this.relaxationCount;
                IRfNamedElement.NetType netType = this.element == null ? IRfNamedElement.NetType.WIRE : XUtils.netType(this.element);
                Iterator<Map.Entry<XInstValueHolder.XEvalOverrideHidOperator, IELParamValue>> iterator = this.drivers.entrySet().iterator();
                IELParamValue prevValue = null;
                IELParamValue currValue = rightValue;
                boolean isFirst = true;
                while (iterator.hasNext()) {
                    Map.Entry<XInstValueHolder.XEvalOverrideHidOperator, IELParamValue> entry = iterator.next();
                    if (parentOperator == entry.getKey()) continue;
                    IELParamValue value = entry.getValue();
                    prevValue = currValue;
                    if (!XUtils.hasX(currValue = currValue.multiDriverValue(netType, value, null))) continue;
                    currValue = prevValue;
                    iterator.remove();
                    if (isFirst) {
                        factory.addEvent(XSimRegion.XRegionKind.Active, new XSimUpdateEvent(entry.getKey(), guardian));
                    }
                    isFirst = false;
                }
                return currValue;
            }

            private IELParamValue getMultiDriversValue(IHidOperator parentOperator, IELParamValue rightValue, IHidEvaluationGuardian guardian) {
                IELParamValue rightValueOriginal;
                IELParamValue rightValueBeforeSelect;
                IELParamValue original = rightValue.getOriginal();
                if (original instanceof ParamValueNumber_Tristate) {
                    IELParamValue newRightValue = ((ParamValueNumber_Tristate)original).getDriversValue(parentOperator);
                    if (newRightValue != null) {
                        rightValue = newRightValue;
                    }
                } else if (original != null && original.getOriginal() instanceof ParamValueNumber_Tristate) {
                    IELParamValue newRightValue = ((ParamValueNumber_Tristate)original.getOriginal()).getDriversValue(parentOperator);
                    if (newRightValue != null) {
                        rightValue = newRightValue;
                    }
                } else if (rightValue.getSelectProxy() != null && (rightValueBeforeSelect = rightValue.getValueBeforeSelect()).getOriginal() instanceof ParamValueNumber_Tristate && (rightValueOriginal = this.getMultiDriversValue(parentOperator, rightValue, guardian)) != null) {
                    XSelectProxy selectProxy = rightValue.getSelectProxy();
                    XSelectProxy newSelectProxy = new XSelectProxy(rightValueOriginal, selectProxy.computedSelects, selectProxy.context, guardian);
                    rightValue = XValueHolderFactory.createSelectProxyValue(this, newSelectProxy, false, false, LanguageKind.VLOG);
                }
                return rightValue;
            }

            public IELParamValue getDriversValue(IHidOperator operator) {
                if (this.drivers.isEmpty()) {
                    return null;
                }
                IRfNamedElement.NetType netType = this.element == null ? IRfNamedElement.NetType.WIRE : XUtils.netType(this.element);
                IELParamValue newValue = null;
                for (Map.Entry<XInstValueHolder.XEvalOverrideHidOperator, IELParamValue> driverEntry : this.drivers.entrySet()) {
                    if (XUtils.isInoutOpositeDriver(operator, driverEntry.getKey().getOverrideOperator())) continue;
                    IELParamValue value = driverEntry.getValue();
                    newValue = newValue == null ? value : newValue.multiDriverValue(netType, value, null);
                }
                return newValue;
            }
        }

        private static class XIterator
        implements IXIterator {
            private DVTNumber value;
            private List<IHidObject> selects;
            private IHidEvaluator evaluator;
            private IHidEvaluationGuardian guardian;
            private int index;
            private IXIterator valueIterator;
            private boolean isIncreasing;

            public XIterator(DVTNumber value, List<IHidObject> selects, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
                this.value = value;
                this.selects = selects;
                this.evaluator = evaluator;
                this.guardian = guardian;
                IHidObject indexHidObject = selects.get(0);
                if (!HidUtils.isHid(indexHidObject)) {
                    throw new UnknownHidObjectEvaluationException(indexHidObject);
                }
                if (!(value instanceof IDVTRangeSelectable)) {
                    throw new UnknownHidObjectEvaluationException(indexHidObject);
                }
                int[] firstDimension = ((IDVTRangeSelectable)((Object)value)).getFirstDimension();
                if (firstDimension == null) {
                    throw new UnknownHidObjectEvaluationException(indexHidObject);
                }
                this.isIncreasing = firstDimension[0] < firstDimension[1];
                this.index = firstDimension[0];
            }

            @Override
            public boolean next() {
                if (this.selects == null || this.selects.isEmpty()) {
                    return false;
                }
                if (this.valueIterator != null && this.valueIterator.next()) {
                    return true;
                }
                if (this.value.isString() && ((VlogBitVector)this.value).isEmptyString()) {
                    return false;
                }
                this.valueIterator = null;
                IHidObject indexHidObject = this.selects.get(0);
                int[] firstDimension = ((IDVTRangeSelectable)((Object)this.value)).getFirstDimension();
                if (firstDimension == null) {
                    throw new UnknownHidObjectEvaluationException(indexHidObject);
                }
                if (this.isIncreasing && this.index > firstDimension[1] || !this.isIncreasing && this.index < firstDimension[1]) {
                    return false;
                }
                VlogBitVector indexBitVector = VlogBitVector.createConstant(this.index);
                IELParamValue key = ParamValueNumber.of(indexBitVector);
                XComputedSelect computedSelect = new XComputedSelect(null, key);
                DVTNumber valueNumber = ((IDVTRangeSelectable)((Object)this.value)).getRangeSelect(computedSelect, false, LanguageKind.VLOG);
                IELParamValue value = ParamValueNumber.of(valueNumber);
                this.index = this.isIncreasing ? this.index + 1 : this.index - 1;
                this.evaluator.updateValue(((IHid)indexHidObject).getName(), null, ParamValueNumber.of(key), false);
                if (this.selects.size() > 1) {
                    if (value == null) {
                        return false;
                    }
                    this.valueIterator = value.iterator(this.selects.subList(1, this.selects.size()), this.evaluator, this.guardian);
                    return this.valueIterator.next();
                }
                return true;
            }
        }

        static class XUnknownSizeParamIterator
        extends XUnknownSizeIterator {
            public XUnknownSizeParamIterator(List<IHidObject> selects, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
                super(selects, evaluator, guardian, null);
            }

            @Override
            protected IELParamValue createUnknownIndexValue(IHidObject indexHidObject) {
                return ELUtils.createUnknownValue(ParamValueNumber.of(VlogBitVector.createConstant(0)));
            }
        }
    }

    public static class ParamValueType
    implements IELParamValue {
        protected IRfNamedElement namedElement;
        protected DVTNumber defaultValue;

        public static IELParamValue of(IRfNamedElement namedElement, DVTNumber defaultValue) {
            if (namedElement == null) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            return new ParamValueType(namedElement, defaultValue);
        }

        protected ParamValueType(IRfNamedElement namedElement, DVTNumber defaultValue) {
            this.namedElement = namedElement;
            this.defaultValue = defaultValue;
        }

        @Override
        public IRfNamedElement getNamedElement() {
            return this.namedElement;
        }

        @Override
        public DVTNumber getDVTNumber() {
            return this.defaultValue;
        }

        public int hashCode() {
            if (this.namedElement.getLanguageKind() == LanguageKind.VLOG) {
                return this.namedElement.hashCode();
            }
            return 31 * this.namedElement.hashCode() + Objects.hash(this.defaultValue);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ParamValueType)) {
                return false;
            }
            ParamValueType other = (ParamValueType)obj;
            return Objects.equals(this.namedElement, other.namedElement) && (this.namedElement.getLanguageKind() == LanguageKind.VLOG || this.defaultValue.equals(other.defaultValue));
        }

        @Override
        public IELParamKeyValueCompact pack(String key) {
            return new ParamKeyValueTypeCompact(key, this.defaultValue, this.namedElement);
        }

        @Override
        public IELParamValue setFromConfig(int offset, ParserPath parserPath) {
            return new ParamValueTypeFromConfig(this.defaultValue, this.namedElement, offset, parserPath);
        }

        public String toString() {
            return this.toNiceString(null, -1, true, false);
        }

        @Override
        public String toStringRadix(int radix) {
            return this.toNiceString(null, radix, false, false);
        }

        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            int qualifiedNameOptions = 7;
            if (radix != -1) {
                qualifiedNameOptions |= 0x200;
            }
            if (useCharLimit) {
                qualifiedNameOptions |= 0x100;
            }
            if (useLowerCaseMaskType) {
                qualifiedNameOptions |= 0x80;
            }
            return this.namedElement.getQualifiedName(qualifiedNameOptions);
        }

        @Override
        public ELManager getManager() {
            return null;
        }

        @Override
        public boolean updateValue(IELParamValue newResult, IHidEvaluationGuardian guardian) {
            return false;
        }

        @Override
        public IELParamValue copy() {
            return new ParamValueType(this.namedElement, this.defaultValue);
        }

        @Override
        public IELParamValue scalarCopy() {
            return new ParamValueType(this.namedElement, this.defaultValue);
        }

        @Override
        public IELParamValue shallowCopy() {
            return new ParamValueType(this.namedElement, this.defaultValue);
        }

        @Override
        public String getDebuggerTypeName(boolean isFormal) {
            return this.namedElement.getQualifiedName(71);
        }

        private static class ParamKeyValueTypeCompact
        implements IELParamKeyValueCompact {
            protected final String cKey;
            protected final IRfNamedElement cNamedElement;
            protected final DVTNumber cValue;

            private ParamKeyValueTypeCompact(String cKey, DVTNumber cValue, IRfNamedElement cNamedElement) {
                this.cKey = cKey;
                this.cNamedElement = cNamedElement;
                this.cValue = cValue;
            }

            @Override
            public Object[] unpack() {
                return new Object[]{this.cKey, new ParamValueType(this.cNamedElement, this.cValue)};
            }

            public String toString() {
                return this.cKey + "=" + (this.cNamedElement != null ? this.cNamedElement.getNameAndEnclosing() : (this.cValue != null ? this.cValue.toString() : null));
            }

            public int hashCode() {
                return Objects.hash(this.cKey, this.cNamedElement);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ParamKeyValueTypeCompact other = (ParamKeyValueTypeCompact)obj;
                return Objects.equals(this.cKey, other.cKey) && Objects.equals(this.cNamedElement, other.cNamedElement);
            }

            private final boolean equalsOnlyValue(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ParamKeyValueTypeCompact other = (ParamKeyValueTypeCompact)obj;
                return Objects.equals(this.cKey, other.cKey) && Objects.equals(this.cNamedElement, other.cNamedElement);
            }

            @Override
            public boolean internalEquals(Object obj, boolean checkOnlyValue) {
                return checkOnlyValue ? this.equalsOnlyValue(obj) : this.equals(obj);
            }
        }

        public static class ParamValueTypeFromConfig
        extends ParamValueType {
            private final int offset;
            private final ParserPath parserPath;

            public ParamValueTypeFromConfig(DVTNumber typeNumber, IRfNamedElement namedElement, int offset, ParserPath parserPath) {
                super(namedElement, typeNumber);
                this.offset = offset;
                this.parserPath = parserPath;
            }

            public int getOffset() {
                return this.offset;
            }

            public ParserPath getParserPath() {
                return this.parserPath;
            }

            @Override
            public boolean isFromConfig() {
                return true;
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + this.offset + Objects.hash(this.parserPath);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!super.equals(obj)) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ParamValueTypeFromConfig other = (ParamValueTypeFromConfig)obj;
                return this.offset == other.offset && Objects.equals(this.parserPath, other.parserPath);
            }

            @Override
            public IELParamKeyValueCompact pack(String key) {
                return new ParamKeyValueTypeCompactFromConfig(key, this.defaultValue, this.namedElement, this.offset, this.parserPath);
            }

            private static class ParamKeyValueTypeCompactFromConfig
            extends ParamKeyValueTypeCompact {
                private final int cOffset;
                private final ParserPath cParserPath;

                private ParamKeyValueTypeCompactFromConfig(String key, DVTNumber value, IRfNamedElement namedElement, int offset, ParserPath parserPath) {
                    super(key, value, namedElement);
                    this.cOffset = offset;
                    this.cParserPath = parserPath;
                }

                @Override
                public Object[] unpack() {
                    return new Object[]{this.cKey, new ParamValueTypeFromConfig(this.cValue, this.cNamedElement, this.cOffset, this.cParserPath)};
                }

                @Override
                public String toString() {
                    return super.toString() + "@" + this.cParserPath + ":" + this.cOffset;
                }

                @Override
                public int hashCode() {
                    return 31 * super.hashCode() + this.cOffset + Objects.hash(this.cParserPath);
                }

                @Override
                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!super.equals(obj)) {
                        return false;
                    }
                    ParamKeyValueTypeCompactFromConfig other = (ParamKeyValueTypeCompactFromConfig)obj;
                    return this.cOffset == other.cOffset && Objects.equals(this.cParserPath, other.cParserPath);
                }
            }
        }
    }

    private static class PostponedNotificationGuardian
    extends HidEvaluationGuardianCacheImpl {
        private IHidEvaluationGuardian guardian;
        private Set<Integer> resumeThreads;
        private List<ChangedValue> changedValues;

        public PostponedNotificationGuardian(IHidEvaluationGuardian guardian, Set<Integer> resumeThreads, List<ChangedValue> changedValues) {
            this.guardian = guardian;
            this.resumeThreads = resumeThreads;
            this.changedValues = changedValues;
        }

        @Override
        public ELManager getManager() {
            return this.guardian.getManager();
        }

        @Override
        public void report(UnknownEvaluationException ex) {
            this.guardian.report(ex);
        }

        @Override
        public void report(IllegalRangeException evalEx) {
            this.guardian.report(evalEx);
        }

        @Override
        public void incrementStepCount(int count) {
            this.guardian.incrementStepCount(count);
        }

        @Override
        public void checkEvaluationStepLimit(IHidObject hidObject) {
            this.guardian.checkEvaluationStepLimit(hidObject);
        }

        @Override
        public void resetStepCount() {
            this.guardian.resetStepCount();
        }

        @Override
        public void checkBuildCanceled() {
            this.guardian.checkBuildCanceled();
        }

        @Override
        public boolean shouldSkip(IHidObject obj) {
            return this.guardian.shouldSkip(obj);
        }

        @Override
        public XValueHolderFactory getFactory() {
            return this.guardian.getFactory();
        }

        @Override
        public boolean isInterpreter() {
            return this.guardian.isInterpreter();
        }

        @Override
        public IXSim.XSimMode simulatorMode() {
            return this.guardian.simulatorMode();
        }

        @Override
        public XThread callbackNbaThread(IHidObject firstStatement, IHidEvaluator evaluator, ParserPath parserPath) {
            return this.guardian.callbackNbaThread(firstStatement, evaluator, parserPath);
        }

        @Override
        public void callbackStartAssignmentRhSide(IHidOperator parentOperator) {
            this.guardian.callbackStartAssignmentRhSide(parentOperator);
        }

        @Override
        public void callbackValueChanged(int uniqueId, IHidOperator parentOperator, IHidEvaluator evaluator, Hid hid, ListContainer<XComputedSelect> computedSelects, IELParamValue prevValue, IELParamValue currValue) {
            if (!this.isDisableChangeUpdates()) {
                this.changedValues.add(new ChangedValue(uniqueId, parentOperator, evaluator, hid, computedSelects, prevValue, currValue));
            }
        }

        @Override
        public void scheduleWaitingThreads(int uniqueId, XSimRegion.XRegionKind regionKind) {
            if (!this.isDisableChangeUpdates()) {
                this.resumeThreads.add(uniqueId);
            }
        }
    }
}

