/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.model;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfClockingBlockElement;
import ro.amiq.dvt.model.reflection.IRfConstantsHolder;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEnumElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInterface;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfModportElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.IRfWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.VhdlFunction;

public class ELParamValuesHidEvaluator
implements IHidEvaluator {
    protected ELParamValues values;
    protected ELManager manager;
    private final AtomicBoolean hasParamReferences = new AtomicBoolean(false);
    protected boolean noDataTypeCache;

    public ELParamValuesHidEvaluator(ELParamValues values, ELManager manager) {
        this.values = values;
        this.manager = manager;
        this.noDataTypeCache = false;
    }

    public ELParamValues getValueContainer(String name) {
        return this.values;
    }

    @Override
    public void updateValue(String name, IRfNamedElement element, IELParamValue value, boolean asDeclaration) {
        if (name == null || value == null) {
            return;
        }
        if (asDeclaration) {
            this.getLastValueContainer().putDirectly(name, value);
            return;
        }
        ELParamValues relevantContainer = this.getValueContainer(name);
        if (relevantContainer == null) {
            relevantContainer = this.getLastValueContainer();
        }
        relevantContainer.putDirectly(name, value);
    }

    @Override
    public ELParamValues getLastValueContainer() {
        return this.values;
    }

    @Override
    public void copyValues(IHidEvaluator source) {
        if (source == null) {
            return;
        }
        this.values = source.getLastValueContainer().copy();
    }

    @Override
    public void putAllValues(IHidEvaluator source) {
        if (source == null) {
            return;
        }
        this.values.getEntries().putAll(source.getLastValueContainer().getEntries());
    }

    protected Collection<ELParamValues> getValueContainers() {
        return Collections.singletonList(this.values);
    }

    @Override
    public void pushScope(boolean isCaseSensitive) {
    }

    @Override
    public void popScope() {
    }

    @Override
    public ELManager getManager() {
        return this.manager;
    }

    @Override
    public IELParamValue getValueDirectly(String name) {
        ELParamValues relevantContainer = this.getValueContainer(name);
        return relevantContainer == null ? null : relevantContainer.getValueDirectly(name);
    }

    @Override
    public void putValueDirectly(String name, IELParamValue value) {
        ELParamValues relevantContainer = this.getValueContainer(name);
        if (relevantContainer == null) {
            return;
        }
        relevantContainer.putValueDirectly(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ELParamValueScope getValue(IHid iHid, BitVectorContext context, IHidEvaluationGuardian guardian) {
        ELParamValueScope result;
        IELParamValue value;
        boolean isHid = HidUtils.isHid(iHid);
        HidAccess parentHidAccess = isHid ? ((Hid)iHid).getParentAccess() : null;
        boolean hasHidParent = parentHidAccess != null;
        IRfNamedElement hidElement = iHid.getElement();
        if (!(hasHidParent && (parentHidAccess.getAccessKind() == 2 || parentHidAccess.getAccessKind() == 0 || parentHidAccess.getAccessKind() == 5) || guardian.isEvaluateForSize() && hidElement != null && !(hidElement.getEnclosingScope() instanceof IRfDesignElement) || (value = this.getValueDirectly(iHid.getName())) == null)) {
            Hid hid;
            Hid hid2 = hid = iHid instanceof Hid ? (Hid)iHid : null;
            if (hid != null) {
                Hid hid3 = hid;
                synchronized (hid3) {
                    if (hid.getElement() == null) {
                        this.resolveHidInContext(hid, guardian, false);
                    }
                    this.checkAndIncrementNofParamReferences(hid.getElement());
                }
            }
            return ELParamValueScope.of(value, this);
        }
        if (this.manager == null) {
            throw new UnknownHidObjectEvaluationException(iHid);
        }
        if (!isHid) {
            throw new UnknownHidObjectEvaluationException(iHid);
        }
        Hid hid = (Hid)iHid;
        boolean isMethodCall = false;
        IRfNamedElement parentAccessType = null;
        ELWidthCheckContext parentAccessDesignContext = null;
        Hid hid4 = hid;
        synchronized (hid4) {
            if (hasHidParent || hid.getElement() == null || hid.getParametricDependencyValue() == 15) {
                this.resolveHidInContext(hid, guardian, false);
            }
            hidElement = hid.getElement();
            isMethodCall = hid.isMethodCall(false);
            if (hasHidParent) {
                parentAccessDesignContext = hid.getParentAccess().getElabDesignContext();
                parentAccessType = hid.getParentAccess().getAssociatedType();
            }
        }
        if (isMethodCall) {
            if (context == null || !context.isVHDLMethod()) {
                return null;
            }
            if (hidElement instanceof IRfWrapper) {
                hidElement = ((IRfWrapper)((Object)hidElement)).getNamedElement(IRfMethodElement.class);
            }
            if (hidElement instanceof IRfMethodElement && !((IRfMethodElement)hidElement).isGeneric()) {
                return ELParamValueScope.of(ELParamValues.ParamValueNumber.of(new VhdlFunction((IRfMethodElement)hidElement)), this);
            }
        }
        if ((result = this.getVHDLEnumName(hidElement)) != null) {
            return result;
        }
        IELParamValue resultValue = this.computeAndGetVHDLAlias(hidElement, guardian.getHierarchyPath());
        if (resultValue != null) {
            return ELParamValueScope.of(resultValue, this);
        }
        resultValue = this.computeAndGetExternalConstantValue(hid.getName(), hidElement, parentAccessType, parentAccessDesignContext, hasHidParent && parentHidAccess.getAccessKind() == 2);
        if (resultValue != null) {
            return ELParamValueScope.of(resultValue, this);
        }
        resultValue = this.computeAndGetTypeValue(hidElement, context, guardian);
        if (resultValue != null) {
            return ELParamValueScope.of(resultValue, this);
        }
        if (guardian.isEvaluateForSize()) {
            if (hidElement == null) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            if (hidElement instanceof IRfDesignElement) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            if (!(hidElement instanceof IRfAssociatedTypeElement) && !(hidElement instanceof IRfTypeElement)) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            if (hidElement instanceof IRfFieldElement && (((IRfFieldElement)hidElement).isTypeParameter() || ((IRfFieldElement)hidElement).isParameterNoDataType())) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            ELParamValuesHidEvaluator newEvaluator = this;
            ELParamValues newParamValues = hid.getAccessHidEvaluator(this, this.manager, guardian);
            if (newParamValues != null) {
                newEvaluator = newParamValues.getHidEvaluator(this.manager);
                newEvaluator.setNoDataTypeCache(true);
            }
            BitVectorContext sizeContext = null;
            if (hidElement instanceof IRfAssociatedTypeElement) {
                sizeContext = ((IRfAssociatedTypeElement)hidElement).getDataTypeBitVectorContext(newEvaluator, false, guardian.getHierarchyPath(), this.manager);
            } else if (hidElement instanceof IRfTypeElement) {
                sizeContext = ((IRfTypeElement)hidElement).getBitVectorContext(newEvaluator, guardian, context.getOrigin());
            }
            if (sizeContext != null && sizeContext.getContextNumber() != null) {
                return ELParamValueScope.of(ELParamValues.ParamValueNumber.of(sizeContext.getContextNumber()), this);
            }
        }
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    private IELParamValue computeAndGetTypeValue(IRfNamedElement potentialFieldOrType, BitVectorContext context, IHidEvaluationGuardian guardian) {
        if (context == null || !context.allowTypeEvaluation()) {
            return null;
        }
        if (potentialFieldOrType instanceof IRfTypeAliasElement) {
            BitVectorContext dataTypeContext = ((IRfTypeAliasElement)potentialFieldOrType).getBitVectorContext(this, guardian, potentialFieldOrType);
            if (dataTypeContext != null) {
                return ELParamValues.ParamValueType.of(dataTypeContext.getContextType(), dataTypeContext.getContextNumber());
            }
        } else if (potentialFieldOrType instanceof IRfVhdlTypeElement) {
            BitVectorContext dataTypeContext = ((IRfVhdlTypeElement)potentialFieldOrType).getDataTypeBitVectorContext(this, false, guardian.getHierarchyPath(), this.manager);
            if (dataTypeContext != null) {
                return ELParamValues.ParamValueType.of(dataTypeContext.getContextType(), dataTypeContext.getContextNumber());
            }
        } else {
            if (potentialFieldOrType instanceof IRfTypeElement) {
                BitVectorContext dataTypeContext = ((IRfTypeElement)potentialFieldOrType).getBitVectorContext(this, guardian, potentialFieldOrType);
                return ELParamValues.ParamValueType.of(potentialFieldOrType, dataTypeContext != null ? dataTypeContext.getContextNumber() : null);
            }
            if (potentialFieldOrType instanceof IRfInterface || potentialFieldOrType instanceof IRfModportElement || potentialFieldOrType instanceof IRfClockingBlockElement) {
                return ELParamValues.ParamValueType.of(potentialFieldOrType, null);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private IELParamValue computeAndGetExternalConstantValue(String hidName, IRfNamedElement hidElement, IRfNamedElement parentAccessType, ELWidthCheckContext parentAccessDesignContext, boolean hasColonColonParentAccess) {
        void classType;
        IRfClassElement constantsHolder2;
        IRfNamedElement iRfNamedElement;
        String searchName;
        boolean isVlogConstant = ELUtils.isVLOGConstant(hidElement);
        if (hidElement == null || !isVlogConstant && !ELUtils.isVHDLConstant(hidElement)) {
            return null;
        }
        String string = searchName = ELUtils.isVHDLEnumName(hidElement) ? hidElement.getElabName(false) : hidName;
        if (parentAccessDesignContext != null) {
            return parentAccessDesignContext.getEvaluator(null).getValueDirectly(searchName);
        }
        IRfScopeElement candidateEnclosingScope = hidElement.getEnclosingScope();
        if (candidateEnclosingScope instanceof IRfEnumElement) {
            candidateEnclosingScope = candidateEnclosingScope.getEnclosingScope();
        }
        if (candidateEnclosingScope instanceof IRfPackageElement || isVlogConstant && candidateEnclosingScope instanceof IRfLibraryElement) {
            IRfConstantsHolder constantsHolder2 = (IRfConstantsHolder)candidateEnclosingScope;
            ELParamValues values = this.manager.getExternalConstants(constantsHolder2);
            if (values == null) {
                constantsHolder2.elaborateConstants(this.manager);
                values = this.manager.getExternalConstants(constantsHolder2);
                if (values == null || values.isEmpty()) {
                    return null;
                }
            }
            return values.getValueDirectly(searchName);
        }
        return hasColonColonParentAccess && (iRfNamedElement = parentAccessType) instanceof IRfClassElement && (constantsHolder2 = (IRfClassElement)iRfNamedElement) == (IRfClassElement)iRfNamedElement ? classType.getElabConstantValue(searchName) : null;
    }

    private ELParamValueScope getVHDLEnumName(IRfNamedElement candidate) {
        if (candidate == null || !ELUtils.isVHDLEnumName(candidate)) {
            return null;
        }
        String enumName = candidate.getElabName(false);
        IELParamValue value = this.getValueDirectly(enumName);
        return ELParamValueScope.of(value, this);
    }

    private IELParamValue computeAndGetVHDLAlias(IRfNamedElement alias, ElementPath hierarchyPath) {
        if (!(ELUtils.isVHDL(alias) && alias instanceof IRfTypeAliasElement && alias instanceof IRfFieldElement)) {
            return null;
        }
        int interfaceKind = ((IRfFieldElement)alias).getInterfaceKind();
        if (interfaceKind == 2) {
            return null;
        }
        BitVectorContext dataTypeContext = ((IRfTypeAliasElement)alias).getDataTypeBitVectorContext(this, false, hierarchyPath, this.manager);
        if (dataTypeContext == null) {
            return null;
        }
        if (dataTypeContext.isVHDLMethod() || dataTypeContext.isVHDLPackageInstantiation()) {
            return ELParamValues.ParamValueNumber.of(dataTypeContext.getContextNumber());
        }
        return null;
    }

    protected void checkAndIncrementNofParamReferences(IRfNamedElement element) {
        if (this.hasParamReferences.get()) {
            return;
        }
        if (ELUtils.isVLOGConstant(element) || ELUtils.isVHDLConstant(element)) {
            this.hasParamReferences.set(true);
        }
    }

    @Override
    public AtomicBoolean hasParamReferences() {
        return this.hasParamReferences;
    }

    @Override
    public boolean noDataTypeCache() {
        return this.noDataTypeCache;
    }

    public void setNoDataTypeCache(boolean value) {
        this.noDataTypeCache = value;
    }
}

