/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.model;

import java.util.Collection;
import java.util.Collections;
import java.util.StringJoiner;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;

public abstract class ELWidthCheckContext {
    private boolean isReducedChecks;
    protected ELManager manager;

    private ELWidthCheckContext(ELManager manager) {
        this.manager = manager;
    }

    public ELManager getManager() {
        return this.manager;
    }

    @NotNull
    public abstract String getPathsTextForError();

    public abstract ElementPath getFirstPath(boolean var1);

    public abstract ElementPath getFirstPath(IRfScopeElement var1);

    public abstract IHidEvaluator getEvaluatorForPortConnections(boolean var1);

    public abstract IHidEvaluator getEvaluator(IRfScopeElement var1);

    public abstract ELWidthCheckContext getCopy();

    public static ELWidthCheckContext of(ELParamValues paramValues, ElementPath hierarchyPath, IRfDesignElement binding, ELParamValues contextParamValues, ElementPath contextHierarchyPath, ELManager manager) {
        return new ELPortConnectionWidthCheckContext(paramValues, hierarchyPath, binding, contextParamValues, contextHierarchyPath, manager);
    }

    public static ELWidthCheckContext of(ELParamValues paramValues, Collection<ElementPath> paths, ELManager manager) {
        return new ELCommonWidthCheckContext(paramValues, paths, manager);
    }

    public static ELWidthCheckContext empty(ELManager manager) {
        return new ELCommonWidthCheckContext(ELParamValues.EMPTY, null, manager);
    }

    public IRfDesignElement getBinding() {
        return null;
    }

    public boolean setReducedChecks(boolean value) {
        boolean prevValue = this.isReducedChecks;
        this.isReducedChecks = value;
        return prevValue;
    }

    public boolean isReducedChecks() {
        return this.isReducedChecks;
    }

    private static class ELCommonWidthCheckContext
    extends ELWidthCheckContext {
        private IHidEvaluator evaluator;
        private Collection<ElementPath> paths;
        private ElementPath firstPath;

        private ELCommonWidthCheckContext(ELParamValues paramValues, Collection<ElementPath> paths, ELManager manager) {
            super(manager);
            this.evaluator = paramValues == null ? ELParamValues.EMPTY.getHidEvaluator(manager) : paramValues.getHidEvaluator(manager);
            this.paths = paths == null ? Collections.emptyList() : paths;
            this.firstPath = this.paths.isEmpty() ? null : this.paths.iterator().next();
        }

        public ELCommonWidthCheckContext(ELManager manager) {
            super(manager);
        }

        @Override
        public IHidEvaluator getEvaluatorForPortConnections(boolean isFormalPart) {
            return this.evaluator;
        }

        @Override
        public IHidEvaluator getEvaluator(IRfScopeElement enclosingScope) {
            return this.evaluator;
        }

        @Override
        public String getPathsTextForError() {
            StringJoiner sj = new StringJoiner(",");
            for (ElementPath path : this.paths) {
                sj.add(path.toString());
            }
            return sj.toString();
        }

        @Override
        public ElementPath getFirstPath(IRfScopeElement enclosingScope) {
            return this.firstPath;
        }

        @Override
        public ElementPath getFirstPath(boolean isFormalPart) {
            return this.firstPath;
        }

        @Override
        public ELCommonWidthCheckContext getCopy() {
            ELCommonWidthCheckContext copy = new ELCommonWidthCheckContext(this.manager);
            copy.evaluator = this.evaluator;
            copy.paths = this.paths;
            copy.firstPath = this.firstPath;
            return copy;
        }
    }

    private static class ELPortConnectionWidthCheckContext
    extends ELWidthCheckContext {
        private IHidEvaluator evaluator;
        private ElementPath hierarchyPath;
        private IHidEvaluator contextEvaluator;
        private ElementPath contextHierarchyPath;
        private IRfDesignElement binding;

        private ELPortConnectionWidthCheckContext(ELParamValues paramValues, ElementPath hierarchyPath, IRfDesignElement binding, ELParamValues contextParamValues, ElementPath contextHierarchyPath, ELManager manager) {
            super(manager);
            this.evaluator = paramValues.getHidEvaluator(manager);
            this.hierarchyPath = hierarchyPath;
            this.binding = binding;
            this.contextEvaluator = contextParamValues.getHidEvaluator(manager);
            this.contextHierarchyPath = contextHierarchyPath;
        }

        public ELPortConnectionWidthCheckContext(ELManager manager) {
            super(manager);
        }

        @Override
        public IHidEvaluator getEvaluatorForPortConnections(boolean isFormalPart) {
            return isFormalPart ? this.evaluator : this.contextEvaluator;
        }

        @Override
        public IHidEvaluator getEvaluator(IRfScopeElement enclosingScope) {
            return this.binding.equals(enclosingScope) ? this.evaluator : this.contextEvaluator;
        }

        @Override
        public String getPathsTextForError() {
            return this.contextHierarchyPath.toString();
        }

        @Override
        public ElementPath getFirstPath(IRfScopeElement enclosingScope) {
            return this.binding.equals(enclosingScope) ? this.hierarchyPath : this.contextHierarchyPath;
        }

        @Override
        public ElementPath getFirstPath(boolean isFormalPart) {
            return isFormalPart ? this.hierarchyPath : this.contextHierarchyPath;
        }

        @Override
        public IRfDesignElement getBinding() {
            return this.binding;
        }

        @Override
        public ELPortConnectionWidthCheckContext getCopy() {
            ELPortConnectionWidthCheckContext copy = new ELPortConnectionWidthCheckContext(this.manager);
            copy.evaluator = this.evaluator;
            copy.binding = this.binding;
            copy.contextEvaluator = this.contextEvaluator;
            copy.contextHierarchyPath = this.contextHierarchyPath;
            return copy;
        }
    }
}

