/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;

public interface IELMemory {
    public ELInstance put(ElementPath var1, ELInstance var2);

    public ELInstance put(ElementPath var1, ELParamValues var2);

    public void putAll(IELMemory var1);

    public ELInstance instanceFor(ElementPath var1);

    public ELParamValues paramValuesFor(ElementPath var1);

    public IRfNamedElement bindingFor(ElementPath var1, boolean var2);

    public boolean hasBindings();

    public boolean hasParamValues();

    default public boolean isGenerateBlock(ElementPath hierarchyPath) {
        ELInstance elInstance = this.instanceFor(hierarchyPath);
        return elInstance != null && DesignUtils.isBlock(elInstance.getBinding(false));
    }

    public void visitBindings(IELMemoryVisitor var1);

    public void visitBindingsReverseOrder(IELMemoryVisitor var1);

    public void visitParamValues(IELMemoryVisitor var1);

    public IELMemory subMemory(ElementPath var1);

    public Map<ElementPath, ELInstance> subtreeOf(ElementPath var1, boolean var2);

    public Map<ElementPath, ELInstance> subMap(ElementPath var1, boolean var2, ElementPath var3, boolean var4, boolean var5);

    public Map<ElementPath, ELInstance> nextOf(ElementPath var1);

    public Map<ElementPath, ELInstance> prevOf(ElementPath var1);

    public int numOfInstancesInSubtreeOf(ElementPath var1);

    public void removeSubtreeOf(ElementPath var1);

    public ELInstance remove(ElementPath var1);

    default public boolean hasInstancesFor(final IRfNamedElement binding, final boolean stripToEntity, final int nofInstances) {
        if (binding == null || !this.hasBindings() || nofInstances <= 0) {
            return false;
        }
        final int[] limit = new int[1];
        final boolean isVHDLComponent = DesignUtils.getDesignKind(binding) == IRfNamedElement.ElementKind.VHDL_COMPONENT;
        this.visitBindings(new IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                if (isVHDLComponent) {
                    IRfInstanceElement description = instance.getDescription();
                    if (description != null && description.getVHDLPreElaborationDesign() == binding) {
                        limit[0] = limit[0] + 1;
                    }
                    return limit[0] < nofInstances;
                }
                if (instance.getBinding(stripToEntity) == binding) {
                    limit[0] = limit[0] + 1;
                }
                return limit[0] < nofInstances;
            }
        });
        return limit[0] == nofInstances;
    }

    default public boolean hasInstanceFor(final ElementPath elementPath, final int nofInstances) {
        if (elementPath == null || elementPath.isEmpty()) {
            return false;
        }
        final int[] limit = new int[1];
        this.visitBindings(new IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                if (elementPath.equals(path)) {
                    limit[0] = limit[0] + 1;
                }
                return limit[0] < nofInstances;
            }
        });
        return limit[0] == nofInstances;
    }

    default public List<ELInstance> getInstancesFor(final IRfNamedElement binding, final boolean stripToEntity, final int maxNoOfInstances) {
        if (binding == null || !this.hasBindings()) {
            return Collections.emptyList();
        }
        final ArrayList<ELInstance> result = new ArrayList<ELInstance>(4);
        final boolean isVHDLComponent = DesignUtils.getDesignKind(binding) == IRfNamedElement.ElementKind.VHDL_COMPONENT;
        this.visitBindings(new IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                if (isVHDLComponent) {
                    IRfInstanceElement description = instance.getDescription();
                    if (description != null && description.getVHDLPreElaborationDesign() == binding) {
                        result.add(instance);
                    }
                    return result.size() < maxNoOfInstances;
                }
                if (instance.getBinding(stripToEntity) == binding) {
                    result.add(instance);
                }
                return result.size() < maxNoOfInstances;
            }
        });
        return result;
    }

    default public List<ElementPath> getInstancePathsFor(final IRfNamedElement binding, final int maxNoOfInstances) {
        if (binding == null || !this.hasBindings()) {
            return Collections.emptyList();
        }
        IRfNamedElement.ElementKind bindingKind = DesignUtils.getDesignKind(binding);
        final boolean isVHDLComponent = bindingKind == IRfNamedElement.ElementKind.VHDL_COMPONENT;
        final boolean stripToEntity = bindingKind == IRfNamedElement.ElementKind.VHDL_ENTITY;
        final ArrayList<ElementPath> result = new ArrayList<ElementPath>(4);
        this.visitBindings(new IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                if (isVHDLComponent) {
                    IRfInstanceElement description = instance.getDescription();
                    if (description != null && description.getVHDLPreElaborationDesign() == binding) {
                        result.add(path);
                    }
                    return result.size() < maxNoOfInstances;
                }
                if (instance.getBinding(stripToEntity) == binding) {
                    result.add(path);
                }
                return result.size() < maxNoOfInstances;
            }
        });
        return result;
    }

    default public List<ELInstance> getInstancesFor(final IRfInstanceElement description, final int maxNoOfInstances) {
        if (description == null || !this.hasBindings()) {
            return Collections.emptyList();
        }
        final ArrayList<ELInstance> result = new ArrayList<ELInstance>(4);
        this.visitBindings(new IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                if (instance.getDescription() == description) {
                    result.add(instance);
                }
                return result.size() < maxNoOfInstances;
            }
        });
        return result;
    }

    public ELInstance getFirstInstance();

    public void serialize();

    default public int size() {
        return 0;
    }

    default public String toString(ELManager manager, int radix) {
        return this.toString();
    }

    default public void print(ELManager manager, int radix) {
    }

    default public boolean isEmpty() {
        return true;
    }

    public static enum ELMemoryType {
        STANDARD,
        FAST_UTILS,
        FST,
        MAPDB;

    }

    public static interface IELMemoryVisitor {
        default public boolean visitBindings(ElementPath path, ELInstance instance) {
            return true;
        }

        default public boolean visitParamValues(ElementPath path, ELParamValues values) {
            return true;
        }
    }
}

