/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.elaboration.model;

import java.math.BigInteger;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.msgpack.core.MessagePacker;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamKeyValueCompact;
import ro.amiq.dvt.interpreter.IXIterator;
import ro.amiq.dvt.interpreter.IXLoopAction;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XSelectProxy;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.sim.XSimRegion;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidNameAndSelects;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitSetUtils;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.IDVTMemberSelectable;
import ro.amiq.dvt.utils.IDVTRangeSelectable;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogBitVector;

public interface IELParamValue
extends IHidEvaluator {
    public static final IELParamValue UNDEFINED_VALUE = new UndefinedXValue();
    public static final IELParamValue NULL_VALUE = new NullXValue();
    public static final IELParamValue EMPTY_VALUE = new EmptyXValue();
    public static final IELParamValue IMPLICIT_RESULT = new VoidXValue();
    public static final IELParamValue BLACK_BOX_VALUE = new BBoxValue();
    public static final /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind;
    public static final /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$model$reflection$IRfNamedElement$NetType;

    static {
        $SWITCH_TABLE$ro$amiq$dvt$model$reflection$IRfNamedElement$NetType = IELParamValue.$SWITCH_TABLE$ro$amiq$dvt$model$reflection$IRfNamedElement$NetType();
        $SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind = IELParamValue.$SWITCH_TABLE$ro$amiq$dvt$model$reflection$semantic$extension$IHidObject$HidKind();
    }

    @Override
    default public boolean isInterpreter() {
        return true;
    }

    default public void setOriginal(IELParamValue original) {
    }

    default public IELParamValue getOriginal() {
        return null;
    }

    default public XSelectProxy getSelectProxy() {
        return null;
    }

    default public void setSelectProxy(XSelectProxy selectProxy) {
    }

    default public IELParamValue getValueBeforeSelect() {
        return this;
    }

    default public boolean isNull() {
        return false;
    }

    default public boolean isUnknown() {
        DVTNumber dvtNumber = this.getDVTNumber();
        return dvtNumber != null && dvtNumber.isUnknown();
    }

    default public boolean hasUnknownSize() {
        DVTNumber dvtNumber = this.getDVTNumber();
        return dvtNumber != null && dvtNumber.hasUnknownSize();
    }

    default public void setIsNull(boolean isNull) {
    }

    public boolean updateValue(IELParamValue var1, IHidEvaluationGuardian var2);

    public IELParamValue copy();

    public IELParamValue shallowCopy();

    public IELParamValue scalarCopy();

    default public IELParamValue vlogEq(IELParamValue obj, BitVectorContext context) {
        return UNDEFINED_VALUE;
    }

    default public IELParamValue vlogNeq(IELParamValue obj, BitVectorContext context) {
        return UNDEFINED_VALUE;
    }

    default public boolean isDVTNumber() {
        return true;
    }

    default public DVTNumber getDVTNumber() {
        return DVTNumber.UNDEFINED;
    }

    default public boolean updateProxyValue(XSelectProxy selectProxy, IELParamValue withValue, boolean onlyIfArrayItemExists) {
        return false;
    }

    default public void foreach(List<IHidObject> indexes, IHidEvaluator evaluator, IXLoopAction loopAction, IHidEvaluationGuardian guardian) {
    }

    default public int intValue() {
        DVTNumber number = this.getDVTNumber();
        if (DVTNumber.isUndefined(number)) {
            throw new UnsupportedOperationException();
        }
        return number.intValue();
    }

    default public long longValue() {
        DVTNumber number = this.getDVTNumber();
        if (DVTNumber.isUndefined(number)) {
            throw new UnsupportedOperationException();
        }
        return number.bigIntegerValue().longValue();
    }

    default public BigInteger bigIntegerValue() {
        DVTNumber number = this.getDVTNumber();
        if (DVTNumber.isUndefined(number)) {
            throw new UnsupportedOperationException();
        }
        return number.bigIntegerValue();
    }

    public String toNiceString(BitVectorContext var1, int var2, boolean var3, boolean var4);

    default public String toStringRadix(int radix) {
        return this.toString();
    }

    default public boolean isFromConfig() {
        return false;
    }

    default public IELParamKeyValueCompact pack(String key) {
        throw new UnsupportedOperationException();
    }

    default public IELParamValue setFromConfig(int offset, ParserPath parserPath) {
        throw new UnsupportedOperationException();
    }

    default public IELParamValue setFromDefparam(int offset, ParserPath parserPath, ElementPath defparamHierarchyPath) {
        throw new UnsupportedOperationException();
    }

    public static IELParamValue clearStrengths(IELParamValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof XValueHolder) {
            return value;
        }
        DVTNumber dvtNumber = value.getDVTNumber();
        if (!(dvtNumber instanceof VlogBitVector)) {
            return value;
        }
        VlogBitVector resultVector = (VlogBitVector)dvtNumber;
        EnumMap<MaskType, BitSet> resultMasks = resultVector.getMasks();
        if (resultMasks == null) {
            return value;
        }
        EnumMap<MaskType, BitSet> newMasks = VlogBitVector.copyMasks(resultMasks, MaskType.NonDriveStrengthMasks);
        if (newMasks != null && resultMasks.size() == newMasks.size()) {
            return value;
        }
        return ELParamValues.ParamValueNumber.of(VlogBitVector.copy(resultVector, newMasks));
    }

    public static IELParamValue reduceStrengths(IELParamValue value) {
        BitSet supply1Mask;
        if (value == null) {
            return null;
        }
        if (value instanceof XValueHolder) {
            return value;
        }
        DVTNumber dvtNumber = value.getDVTNumber();
        if (!(dvtNumber instanceof VlogBitVector)) {
            return value;
        }
        if (dvtNumber.getMasks() == null) {
            return value;
        }
        IELParamValue result = ELParamValues.ParamValueNumber.of(VlogBitVector.copy((VlogBitVector)dvtNumber));
        EnumMap<MaskType, BitSet> newMasks = result.getDVTNumber().getMasks();
        BitSet supply0Mask = newMasks.getOrDefault((Object)MaskType.supply0, BitSetUtils.valueOf(0));
        if (!supply0Mask.isEmpty()) {
            BitSet strong0Mask = (BitSet)newMasks.getOrDefault((Object)MaskType.strong0, BitSetUtils.valueOf(0)).clone();
            strong0Mask.or(supply0Mask);
            newMasks.put(MaskType.strong0, strong0Mask);
            newMasks.remove((Object)MaskType.supply0);
        }
        if (!(supply1Mask = newMasks.getOrDefault((Object)MaskType.supply1, BitSetUtils.valueOf(0))).isEmpty()) {
            BitSet strong1Mask = (BitSet)newMasks.getOrDefault((Object)MaskType.strong1, BitSetUtils.valueOf(0)).clone();
            strong1Mask.or(supply1Mask);
            newMasks.put(MaskType.strong1, strong1Mask);
            newMasks.remove((Object)MaskType.supply1);
        }
        return result;
    }

    public static IELParamValue clearStrongStrengths(IELParamValue value) {
        if (value instanceof XValueHolder) {
            return value;
        }
        DVTNumber dvtNumber = value.getDVTNumber();
        if (!(dvtNumber instanceof VlogBitVector)) {
            return value;
        }
        VlogBitVector resultVector = (VlogBitVector)dvtNumber;
        EnumMap<MaskType, BitSet> resultMasks = resultVector.getMasks();
        if (resultMasks == null) {
            return value;
        }
        EnumMap<MaskType, BitSet> newMasks = VlogBitVector.copyMasks(resultMasks);
        resultMasks.remove((Object)MaskType.strong0);
        resultMasks.remove((Object)MaskType.strong1);
        IELParamValue result = ELParamValues.ParamValueNumber.of(VlogBitVector.copy(resultVector, newMasks));
        result.setOriginal(value.getOriginal());
        return result;
    }

    default public IELParamValue doUpdate(IHidOperator parentOperator, IELParamValue rightValue, int updateEvaluator, AtomicBoolean isModified, int uniqueClassScopeId, IHidEvaluator evaluator, IHidObject leftOp, IHidEvaluationGuardian guardian) {
        if (ELUtils.isUnsuccessfulEval(rightValue)) {
            guardian.logError("Fail to update to UNDEFINED value");
            return this;
        }
        IRfNamedElement element = this.getElement();
        if (guardian.isLinterStaticAnalysisMode()) {
            if (!this.equals(rightValue)) {
                guardian.guardValueUpdate(element, parentOperator, this, rightValue);
            } else {
                this.updateValue(rightValue, guardian);
            }
            return this;
        }
        if (evaluator.isInterpreter()) {
            Hid hid = XUtils.getParentHid(leftOp);
            boolean isDesignMemberElement = XUtils.isDesignMemberElement(hid);
            if (isDesignMemberElement && rightValue instanceof ELParamValues.ParamValueNumber) {
                rightValue = this.handleTriWireValue(hid, rightValue);
            }
            rightValue = IELParamValue.clearStrongStrengths(rightValue);
            XSelectProxy selectProxy = this.getSelectProxy();
            if (this.getOriginal() instanceof ELParamValues.ParamValueNumber.PackedStructMember) {
                selectProxy = this.getOriginal().getSelectProxy();
            }
            if (selectProxy != null) {
                IELParamValue valueBeforeSelect = selectProxy.getValueBeforeSelect();
                if (valueBeforeSelect instanceof ELParamValues.ParamValueNumber.ParamValueNumber_Tristate) {
                    IELParamValue newRightValue;
                    IELParamValue rightOriginal = rightValue.getOriginal();
                    if (rightOriginal instanceof ELParamValues.ParamValueNumber.ParamValueNumber_Tristate && (newRightValue = ((ELParamValues.ParamValueNumber.ParamValueNumber_Tristate)rightOriginal).getDriversValue(parentOperator)) != null) {
                        rightValue = newRightValue;
                    }
                    VlogBitVector number = (VlogBitVector)valueBeforeSelect.getDVTNumber();
                    IELParamValue valueUpdate = ELParamValues.ParamValueNumber.of(VlogBitVector.copy(number, VlogBitVector.createMaskOfType(MaskType.Z, number.getSize())));
                    XSelectProxy selectProxyCopy = new XSelectProxy(valueUpdate, selectProxy.computedSelects, selectProxy.context, guardian);
                    IELParamValue selectValue = XValueHolderFactory.createSelectProxyValue(valueUpdate, selectProxyCopy, false, false, LanguageKind.VLOG);
                    selectValue.updateValue(rightValue, guardian);
                    return valueBeforeSelect.doUpdate(parentOperator, valueUpdate, updateEvaluator, isModified, -1, evaluator, leftOp, guardian);
                }
                if (this instanceof XArrayValueHolder && valueBeforeSelect instanceof XArrayValueHolder && (((XArrayValueHolder)valueBeforeSelect).isQueueArray() || ((XArrayValueHolder)valueBeforeSelect).isDynamicArray())) {
                    XArrayValueHolder array = (XArrayValueHolder)valueBeforeSelect;
                    int lBound = array.getLeftBound();
                    int rBound = array.getRightBound();
                    if (lBound == -1 && rBound == -1) {
                        int indexOffset;
                        lBound = indexOffset = array.getIndexOffset();
                        rBound = indexOffset + array.size() - 1;
                    }
                    XArrayValueHolder thisArray = (XArrayValueHolder)this;
                    int thisLBound = thisArray.getLeftBound();
                    int thisRBound = thisArray.getRightBound();
                    if (array.isQueueArray()) {
                        if (rightValue instanceof XArrayValueHolder && ((XArrayValueHolder)rightValue).size() != ((XArrayValueHolder)this).size()) {
                            if (thisLBound == -1 && thisRBound == -1 && thisArray.getSelectProxy() != null) {
                                XComputedSelect firstSelect = thisArray.getSelectProxy().computedSelects.iterator().next();
                                int[] indexes = firstSelect.getIndexes();
                                thisLBound = indexes[0];
                                thisRBound = indexes[1];
                            }
                            if (thisLBound < lBound || thisRBound < lBound || thisLBound > rBound + 1) {
                                return this;
                            }
                            if (thisLBound == rBound + 1 || thisRBound > rBound) {
                                IELParamValue selectWithInit = array.createXValueHolderSelectProxy(selectProxy, false, false, true, LanguageKind.VLOG);
                                return selectWithInit.doUpdate(parentOperator, rightValue, updateEvaluator, isModified, uniqueClassScopeId, evaluator, leftOp, guardian);
                            }
                        }
                    } else if (array.isDynamicArray()) {
                        if (array.isEmpty()) {
                            return this;
                        }
                        if (thisLBound >= 0 && thisLBound < lBound || rBound >= 0 && thisLBound > rBound || thisRBound >= 0 && thisRBound < lBound || rBound >= 0 && thisRBound > rBound) {
                            return this;
                        }
                    }
                }
            }
            XValueHolderFactory factory = guardian.getFactory();
            IELParamValue original = XUtils.getOriginal(this, true);
            int uniqueId = factory.getUniqueId(original, false);
            if (parentOperator == null && uniqueId < 0) {
                isModified.set(this.updateValue(rightValue, guardian));
                return this;
            }
            if (!isDesignMemberElement && uniqueId < 0) {
                isModified.set(this.updateValue(rightValue, guardian));
                if (uniqueClassScopeId >= 0) {
                    factory.scheduleWaitingThreads(uniqueClassScopeId, XSimRegion.XRegionKind.Active);
                }
                return this;
            }
            if (factory.isPreponedId(uniqueId)) {
                factory.addPreponedValue(uniqueId, this);
            }
            isModified.set(this.updateValue(rightValue, guardian) || isModified.get());
            if (!isModified.get()) {
                boolean isClockingOutputDriver = XUtils.isClockingOutputDriver(element);
                if (isClockingOutputDriver) {
                    IELParamValue currValue = this.getValueBeforeSelect();
                    guardian.callbackValueChanged(uniqueId, parentOperator, evaluator, hid, XUtils.selects(selectProxy), null, currValue);
                }
                return this;
            }
            if (uniqueId < 0) {
                return this;
            }
            factory.scheduleWaitingThreads(uniqueId, XSimRegion.XRegionKind.Active);
            if (parentOperator == null) {
                return this;
            }
            if (isDesignMemberElement) {
                IELParamValue currValue = this.getValueBeforeSelect();
                factory.incrementChangedVariableCount(uniqueId);
                guardian.callbackValueChanged(uniqueId, parentOperator, evaluator, hid, XUtils.selects(selectProxy), null, currValue);
            }
            return this;
        }
        IELParamValue zValue = this.getValueBeforeSelect();
        XSelectProxy selectProxy = this.getSelectProxy();
        Hid hid = null;
        this.updateValue(rightValue, guardian);
        switch (leftOp.getHidKind()) {
            case ACCESS: {
                if (selectProxy == null) {
                    throw new UnknownHidObjectEvaluationException(leftOp);
                }
                hid = ((HidAccess)leftOp).getParentHid();
            }
            case HID: {
                HidAccess parentAccess;
                if (hid == null) {
                    hid = (Hid)leftOp;
                }
                if ((parentAccess = hid.getParentAccess()) == null || parentAccess.getAccessKind() != 2 && parentAccess.getAccessKind() != 0) {
                    evaluator.updateValue(hid.getName(), null, zValue, updateEvaluator > 1);
                    return this;
                }
                if (parentAccess == null || parentAccess.getAccessKind() != 0) break;
                Hid ancestorHid = hid.getAncestorHid();
                IELParamValue result = XUtils.getValue(ELUtils.evaluate(ancestorHid, evaluator, BitVectorContext.of(null, false), guardian));
                if (ELUtils.isUnsuccessfulEval(result)) {
                    throw new UnknownHidObjectEvaluationException(leftOp);
                }
                List<HidNameAndSelects> hidNamesSelects = hid.getHidAccessList(evaluator, guardian);
                HidNameAndSelects first = hidNamesSelects.iterator().next();
                if (first.selects != null) {
                    DVTNumber rangeSelect = result.getDVTNumber();
                    ListContainer<XComputedSelect> selectsContainer = first.selects;
                    for (XComputedSelect select : selectsContainer) {
                        if (select == null || select.computedValues == null) {
                            throw new UnknownHidObjectEvaluationException(leftOp);
                        }
                        if (!(rangeSelect instanceof IDVTRangeSelectable)) {
                            throw new UnknownHidObjectEvaluationException(leftOp);
                        }
                        rangeSelect = ((IDVTRangeSelectable)((Object)rangeSelect)).getRangeSelect(select, false, LanguageKind.VLOG);
                    }
                    if (!(rangeSelect instanceof IDVTMemberSelectable)) {
                        throw new UnknownHidObjectEvaluationException(leftOp);
                    }
                    DVTNumber updatedRangeSelect = ((IDVTMemberSelectable)((Object)rangeSelect)).updateMemberSelects(evaluator, rightValue.getDVTNumber(), hidNamesSelects.subList(1, hidNamesSelects.size()), guardian);
                    evaluator.updateValue(ancestorHid.getName(), null, ELParamValues.ParamValueNumber.of(((IDVTRangeSelectable)((Object)result.getDVTNumber())).updateSelects(updatedRangeSelect, selectsContainer)), updateEvaluator > 1);
                    return this;
                }
                if (!(result.getDVTNumber() instanceof IDVTMemberSelectable)) {
                    throw new UnknownHidObjectEvaluationException(leftOp);
                }
                DVTNumber updatedNumber = ((IDVTMemberSelectable)((Object)result.getDVTNumber())).updateMemberSelects(evaluator, rightValue.getDVTNumber(), hidNamesSelects, guardian);
                evaluator.updateValue(ancestorHid.getName(), null, ELParamValues.ParamValueNumber.of(updatedNumber), updateEvaluator > 1);
                return this;
            }
        }
        throw new UnknownHidObjectEvaluationException(leftOp);
    }

    default public boolean isTristate() {
        return false;
    }

    default public IELParamValue handleTriWireValue(Hid hid, IELParamValue rightValue) {
        if (rightValue instanceof XArrayValueHolder) {
            return rightValue;
        }
        IRfNamedElement.NetType netType = XUtils.netType(hid);
        if (netType == IRfNamedElement.NetType.TRI_0 || netType == IRfNamedElement.NetType.TRI_1) {
            IELParamValue multiDriverValue = this.multiDriverValue(netType, rightValue, netType);
            VlogBitVector resultVector = (VlogBitVector)multiDriverValue.getDVTNumber();
            EnumMap<MaskType, BitSet> newMasks = VlogBitVector.copyMasks(resultVector.getMasks(), MaskType.NonDriveStrengthMasks);
            if (newMasks == null) {
                newMasks = new EnumMap(MaskType.class);
            }
            newMasks.put(netType == IRfNamedElement.NetType.TRI_0 ? MaskType.pull0 : MaskType.pull1, BitSetUtils.getPowerOfTwoMask(resultVector.getSize()));
            return ELParamValues.ParamValueNumber.of(VlogBitVector.copy(resultVector, newMasks));
        }
        if (netType == IRfNamedElement.NetType.SUPPLY0 || netType == IRfNamedElement.NetType.SUPPLY1) {
            IELParamValue multiDriverValue = this.multiDriverValue(netType, rightValue, netType);
            VlogBitVector resultVector = (VlogBitVector)multiDriverValue.getDVTNumber();
            EnumMap<MaskType, BitSet> newMasks = VlogBitVector.copyMasks(resultVector.getMasks(), MaskType.NonDriveStrengthMasks);
            if (newMasks == null) {
                newMasks = new EnumMap(MaskType.class);
            }
            newMasks.put(netType == IRfNamedElement.NetType.SUPPLY0 ? MaskType.supply0 : MaskType.supply1, BitSetUtils.getPowerOfTwoMask(resultVector.getSize()));
            return ELParamValues.ParamValueNumber.of(VlogBitVector.copy(resultVector, newMasks));
        }
        return rightValue;
    }

    default public IELParamValue multiDriverValue(IRfNamedElement.NetType triKind, IELParamValue rightValue, IRfNamedElement.NetType netType) {
        if (rightValue instanceof XValueHolder) {
            return rightValue;
        }
        if (triKind == IRfNamedElement.NetType.NONE) {
            return IELParamValue.clearStrengths(rightValue);
        }
        DVTNumber leftNumber = this.getDVTNumber();
        if (DVTNumber.isUndefined(leftNumber)) {
            return rightValue;
        }
        DVTNumber rightNumber = rightValue.getDVTNumber();
        int size = leftNumber.getSize();
        if (!(leftNumber instanceof VlogBitVector) || !(rightNumber instanceof VlogBitVector)) {
            return rightValue;
        }
        BitSet leftMaskX = leftNumber.getMask(MaskType.X) == null ? BitSetUtils.valueOf(0) : leftNumber.getMask(MaskType.X);
        BitSet leftMaskZ = leftNumber.getMask(MaskType.Z) == null ? BitSetUtils.valueOf(0) : leftNumber.getMask(MaskType.Z);
        BitSet rightMaskX = rightNumber.getMask(MaskType.X) == null ? BitSetUtils.valueOf(0) : rightNumber.getMask(MaskType.X);
        BitSet rightMaskZ = rightNumber.getMask(MaskType.Z) == null ? BitSetUtils.valueOf(0) : rightNumber.getMask(MaskType.Z);
        EnumMap<MaskType, BitSet> resultStrengthMap = new EnumMap<MaskType, BitSet>(MaskType.class);
        for (MaskType type : MaskType.DriveStrengths) {
            resultStrengthMap.put(type, BitSetUtils.valueOf(0));
        }
        BitSet resultMaskX = BitSetUtils.valueOf(0);
        BitSet resultMaskZ = BitSetUtils.valueOf(0);
        BitSet resultValue = BitSetUtils.valueOf(0);
        boolean hasForcedLh = netType != null;
        int i = 0;
        while (i < size) {
            boolean leftBit = hasForcedLh ? netType == IRfNamedElement.NetType.TRI_1 || netType == IRfNamedElement.NetType.SUPPLY1 : leftNumber.bigIntegerValue().testBit(i);
            boolean rightBit = rightNumber.bigIntegerValue().testBit(i);
            boolean leftXBit = !hasForcedLh && leftMaskX.get(i);
            boolean rightXBit = rightMaskX.get(i);
            boolean leftZBit = !hasForcedLh && leftMaskZ.get(i);
            boolean rightZBit = rightMaskZ.get(i);
            VlogBitVector.DriveStrength leftDs = hasForcedLh ? (netType == IRfNamedElement.NetType.TRI_0 || netType == IRfNamedElement.NetType.TRI_1 ? VlogBitVector.DriveStrength.PULL : VlogBitVector.DriveStrength.SUPPLY) : ((VlogBitVector)leftNumber).getDriveStrengthsAtIndex(i);
            VlogBitVector.DriveStrength rightDs = ((VlogBitVector)rightNumber).getDriveStrengthsAtIndex(i);
            MaskType leftStrForValue = leftBit ? leftDs.strength1 : leftDs.strength0;
            MaskType rightDsForValue = rightBit ? rightDs.strength1 : rightDs.strength0;
            switch (triKind) {
                case WIRE: 
                case TRI_0: 
                case TRI_1: 
                case SUPPLY0: 
                case SUPPLY1: {
                    byte[] test;
                    MaskType final1;
                    MaskType final0;
                    MaskType drive1Max;
                    MaskType drive0Max;
                    if (leftZBit && rightZBit) {
                        if (triKind == IRfNamedElement.NetType.TRI_0) break;
                        if (triKind == IRfNamedElement.NetType.TRI_1) {
                            resultValue.set(i);
                            break;
                        }
                        resultMaskZ.set(i);
                        break;
                    }
                    if (leftXBit) {
                        if (rightXBit) {
                            drive0Max = MaskType.driveStrongerThan(leftDs.strength0, rightDs.strength0) ? leftDs.strength0 : rightDs.strength0;
                            drive1Max = MaskType.driveStrongerThan(leftDs.strength1, rightDs.strength1) ? leftDs.strength1 : rightDs.strength1;
                            MaskType.updateMaskBit(resultStrengthMap, drive0Max, i);
                            MaskType.updateMaskBit(resultStrengthMap, drive1Max, i);
                            resultMaskX.set(i);
                            break;
                        }
                        if (rightZBit) {
                            MaskType.updateMaskBit(resultStrengthMap, leftDs.strength0, i);
                            MaskType.updateMaskBit(resultStrengthMap, leftDs.strength1, i);
                            resultMaskX.set(i);
                            break;
                        }
                        MaskType ambigDs0 = leftDs.strength0;
                        MaskType ambigDs1 = leftDs.strength1;
                        final0 = rightDsForValue.ordinal() <= ambigDs0.ordinal() ? rightDsForValue : ambigDs0;
                        final1 = rightDsForValue.ordinal() <= ambigDs1.ordinal() ? ambigDs1 : rightDsForValue;
                        test = IELParamValue.testAmbigStrengths(rightBit, rightDsForValue, leftDs);
                        if (test[0] != test[1]) {
                            MaskType.updateMaskBit(resultStrengthMap, final0, i);
                            MaskType.updateMaskBit(resultStrengthMap, final1, i);
                            resultMaskX.set(i);
                            break;
                        }
                        if (test[0] == 2) {
                            MaskType.updateMaskBit(resultStrengthMap, final0, i);
                            MaskType.updateMaskBit(resultStrengthMap, final1, i);
                            resultMaskX.set(i);
                            break;
                        }
                        if (test[0] == 1) {
                            MaskType.updateMaskBit(resultStrengthMap, rightDsForValue, i);
                            resultValue.set(i);
                            break;
                        }
                        if (test[0] != 0) break;
                        MaskType.updateMaskBit(resultStrengthMap, rightDsForValue, i);
                        break;
                    }
                    if (rightXBit) {
                        if (leftXBit) {
                            drive0Max = MaskType.driveStrongerThan(leftDs.strength0, rightDs.strength0) ? leftDs.strength0 : rightDs.strength0;
                            drive1Max = MaskType.driveStrongerThan(leftDs.strength1, rightDs.strength1) ? leftDs.strength1 : rightDs.strength1;
                            MaskType.updateMaskBit(resultStrengthMap, drive0Max, i);
                            MaskType.updateMaskBit(resultStrengthMap, drive1Max, i);
                            resultMaskX.set(i);
                            break;
                        }
                        if (leftZBit) {
                            MaskType.updateMaskBit(resultStrengthMap, rightDs.strength0, i);
                            MaskType.updateMaskBit(resultStrengthMap, rightDs.strength1, i);
                            resultMaskX.set(i);
                            break;
                        }
                        MaskType ambigStr0 = rightDs.strength0;
                        MaskType ambigStr1 = rightDs.strength1;
                        final0 = leftStrForValue.ordinal() <= ambigStr0.ordinal() ? leftStrForValue : ambigStr0;
                        final1 = leftStrForValue.ordinal() <= ambigStr1.ordinal() ? ambigStr1 : leftStrForValue;
                        test = IELParamValue.testAmbigStrengths(leftBit, leftStrForValue, rightDs);
                        if (test[0] != test[1]) {
                            MaskType.updateMaskBit(resultStrengthMap, final0, i);
                            MaskType.updateMaskBit(resultStrengthMap, final1, i);
                            resultMaskX.set(i);
                            break;
                        }
                        if (test[0] == 2) {
                            MaskType.updateMaskBit(resultStrengthMap, final0, i);
                            MaskType.updateMaskBit(resultStrengthMap, final1, i);
                            resultMaskX.set(i);
                            break;
                        }
                        if (test[0] == 1) {
                            MaskType.updateMaskBit(resultStrengthMap, leftStrForValue, i);
                            resultValue.set(i);
                            break;
                        }
                        if (test[0] != 0) break;
                        MaskType.updateMaskBit(resultStrengthMap, leftStrForValue, i);
                        break;
                    }
                    if (leftZBit && rightBit || rightZBit && leftBit) {
                        resultValue.set(i);
                        MaskType.updateMaskBit(resultStrengthMap, leftZBit ? rightDsForValue : leftStrForValue, i);
                        break;
                    }
                    if (leftZBit && !rightBit || rightZBit && !leftBit) {
                        MaskType.updateMaskBit(resultStrengthMap, leftZBit ? rightDsForValue : leftStrForValue, i);
                        break;
                    }
                    if (MaskType.equalDrive(leftStrForValue, rightDsForValue)) {
                        if (leftBit != rightBit) {
                            MaskType.updateMaskBit(resultStrengthMap, leftStrForValue, i);
                            MaskType.updateMaskBit(resultStrengthMap, rightDsForValue, i);
                            resultMaskX.set(i);
                            break;
                        }
                        MaskType.updateMaskBit(resultStrengthMap, leftStrForValue, i);
                        if (!leftBit) break;
                        resultValue.set(i);
                        break;
                    }
                    if (MaskType.driveStrongerThan(leftStrForValue, rightDsForValue)) {
                        MaskType.updateMaskBit(resultStrengthMap, leftStrForValue, i);
                        if (!leftBit) break;
                        resultValue.set(i);
                        break;
                    }
                    if (MaskType.driveStrongerThan(leftStrForValue, rightDsForValue)) break;
                    MaskType.updateMaskBit(resultStrengthMap, rightDsForValue, i);
                    if (!rightBit) break;
                    resultValue.set(i);
                    break;
                }
                case WOR: {
                    if (leftBit || rightBit) {
                        resultValue.set(i);
                        break;
                    }
                    if (leftXBit || rightXBit) {
                        resultMaskX.set(i);
                        break;
                    }
                    if (!leftZBit || !rightZBit) break;
                    resultMaskZ.set(i);
                    break;
                }
                case WAND: {
                    if (leftXBit && rightXBit || leftBit && rightXBit || rightBit && leftXBit || leftZBit && rightXBit || rightZBit && leftXBit) {
                        resultMaskX.set(i);
                        break;
                    }
                    if (leftZBit && rightZBit) {
                        resultMaskZ.set(i);
                        break;
                    }
                    if (!(leftBit && rightBit || leftBit && rightZBit) && (!leftZBit || !rightBit)) break;
                    resultValue.set(i);
                }
            }
            ++i;
        }
        EnumMap<MaskType, BitSet> resultMasks = null;
        if (!resultMaskX.isEmpty() || !resultMaskZ.isEmpty()) {
            resultMasks = new EnumMap<MaskType, BitSet>(MaskType.class);
            if (!resultMaskX.isEmpty()) {
                resultMasks.put(MaskType.X, resultMaskX);
            }
            if (!resultMaskZ.isEmpty()) {
                resultMasks.put(MaskType.Z, resultMaskZ);
            }
        }
        for (Map.Entry entry : resultStrengthMap.entrySet()) {
            BitSet mask = (BitSet)entry.getValue();
            if (mask.isEmpty()) continue;
            if (resultMasks == null) {
                resultMasks = new EnumMap(MaskType.class);
            }
            resultMasks.put(entry.getKey(), mask);
        }
        IELParamValue result = ELParamValues.ParamValueNumber.of(VlogBitVector.copy((VlogBitVector)leftNumber, XUtils.toBigInteger(resultValue), resultMasks), rightValue.getElement(), rightValue.getEnumTypeWrapper());
        result.setOriginal(rightValue.getOriginal());
        result.setSelectProxy(rightValue.getSelectProxy());
        return result;
    }

    public static byte[] testAmbigStrengths(boolean bitValue, MaskType bitValueDriveStrength, VlogBitVector.DriveStrength ambigDs) {
        byte[] test = new byte[2];
        if (MaskType.equalDrive(ambigDs.strength0, bitValueDriveStrength)) {
            test[0] = bitValue ? 2 : 0;
        } else if (MaskType.driveStrongerThan(ambigDs.strength0, bitValueDriveStrength)) {
            test[0] = 0;
        } else {
            byte by = test[0] = bitValue ? (byte)1 : 0;
        }
        test[1] = MaskType.equalDrive(ambigDs.strength1, bitValueDriveStrength) ? (!bitValue ? 2 : 1) : (MaskType.driveStrongerThan(ambigDs.strength1, bitValueDriveStrength) ? 1 : (bitValue ? 1 : 0));
        return test;
    }

    public static IELParamValue getFalseInContext(BitVectorContext context) {
        IELParamValue result = ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
        result = context != null ? context.transform(result) : result;
        return result;
    }

    public static IELParamValue getTrueInContext(BitVectorContext context) {
        IELParamValue result = ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ONE);
        result = context != null ? context.transform(result) : result;
        return result;
    }

    public static IELParamValue getAmbiguousInContext(BitVectorContext context, boolean isUnknown) {
        MaskType ambiguousMaskType;
        MaskType maskType = ambiguousMaskType = isUnknown ? MaskType.UNKNOWN : MaskType.X;
        if (context == null) {
            return ELParamValues.ParamValueNumber.of(VlogBitVector.all(ambiguousMaskType, 1));
        }
        return context.transform(ELParamValues.ParamValueNumber.of(VlogBitVector.all(ambiguousMaskType, context.getSize())));
    }

    public String getDebuggerTypeName(boolean var1);

    default public IXIterator iterator(List<IHidObject> selects, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        return null;
    }

    default public IELParamValue getDefaultValue() {
        return NULL_VALUE;
    }

    default public void xSystemCPackValue(IRfNamedElement typeElement, int options, MessagePacker packer, boolean preSpecifyMaker) throws Exception {
    }

    default public boolean isAmbiguous() {
        DVTNumber dvtNumber = this.getDVTNumber();
        return dvtNumber != null && dvtNumber.isAmbiguous();
    }

    default public boolean isStruct(boolean isStructOrUnion) {
        DVTNumber dvtNumber = this.getDVTNumber();
        return dvtNumber != null && dvtNumber.isStruct(isStructOrUnion);
    }

    default public boolean isUnion() {
        DVTNumber dvtNumber = this.getDVTNumber();
        return dvtNumber != null && dvtNumber.isUnion();
    }

    default public boolean isClass() {
        return false;
    }

    default public boolean is4State() {
        DVTNumber dvtNumber = this.getDVTNumber();
        return dvtNumber != null && dvtNumber.is4State();
    }

    default public int getSize() {
        DVTNumber dvtNumber = this.getDVTNumber();
        return DVTNumber.isUndefined(dvtNumber) ? -2 : dvtNumber.getSize();
    }

    default public boolean hasSign() {
        DVTNumber dvtNumber = this.getDVTNumber();
        return DVTNumber.isUndefined(dvtNumber) || dvtNumber.hasSign();
    }

    default public boolean isString() {
        DVTNumber dvtNumber = this.getDVTNumber();
        return dvtNumber != null && dvtNumber.isString();
    }

    public static class BBoxEvaluationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    public static class BBoxValue
    extends UndefinedXValue {
        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return "[black-box]";
        }

        @Override
        public boolean isBBox() {
            return true;
        }
    }

    public static class EmptyXValue
    extends UndefinedXValue {
        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return "[empty]";
        }
    }

    public static class NullXValue
    extends UndefinedXValue {
        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return "[null]";
        }

        @Override
        public IELParamValue vlogEq(IELParamValue obj, BitVectorContext context) {
            IELParamValue result = obj.isNull() ? ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ONE) : ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
            result = context != null ? context.transform(result) : result;
            return result;
        }

        @Override
        public IELParamValue vlogNeq(IELParamValue obj, BitVectorContext context) {
            IELParamValue result = !obj.isNull() ? ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ONE) : ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
            result = context != null ? context.transform(result) : result;
            return result;
        }

        @Override
        public void xSystemCPackValue(IRfNamedElement typeElement, int options, MessagePacker packer, boolean preSpecifyMaker) throws Exception {
            packer.packInt(0);
        }
    }

    public static class UndefinedXValue
    implements IELParamValue {
        @Override
        public ELManager getManager() {
            return null;
        }

        @Override
        public boolean updateValue(IELParamValue newResult, IHidEvaluationGuardian guardian) {
            return false;
        }

        @Override
        public IELParamValue copy() {
            return this;
        }

        @Override
        public IELParamValue shallowCopy() {
            return this;
        }

        @Override
        public IELParamValue scalarCopy() {
            return null;
        }

        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return "N/A";
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String getDebuggerTypeName(boolean isFormal) {
            return "N/A";
        }

        @Override
        public IELParamValue setFromConfig(int offset, ParserPath parserPath) {
            return this;
        }

        @Override
        public IELParamValue setFromDefparam(int offset, ParserPath parserPath, ElementPath defparamHierarchyPath) {
            return this;
        }
    }

    public static class VoidXValue
    extends UndefinedXValue {
        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return "[void]";
        }
    }
}

