/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory;

import antlr.Token;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.exploratory.BaseLogger;
import ro.amiq.dvt.exploratory.IExploratoryCommandContributor;
import ro.amiq.dvt.exploratory.XPLConfig;
import ro.amiq.dvt.exploratory.XPLUtil;
import ro.amiq.dvt.exploratory.XplLogger;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.guifilters.DVTExplorationGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.utils.BaseUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.MemUtils;
import ro.amiq.dvt.utils.StringMatcher;

@ForTestingOrDebuggingOnly
public abstract class BaseExplorationCommand {
    public static final String TARGET_PROJECT = "Project";
    public static final String TARGET_FILE = "Current File";
    public static final String _1_5 = "1/5";
    public static final String _2_5 = "2/5";
    public static final String _3_5 = "3/5";
    public static final String _4_5 = "4/5";
    public static final String _5_5 = "5/5";
    public static final String FULL = "FULL";
    public static final String HYPERLINK_COMMAND = "hyperlink";
    public static final String INCREMENTAL_COMNAND = "incremental";
    public static final String CONTENT_ASSIST_COMMAND = "content-assist";
    private static final Random random = new Random();
    private static final int NO_RANDOM_FILES = 20;
    private static final int NO_RANDOM_SKIP_TOKENS = 10;
    public static final int MAX_LONG_OPERATIONS_IN_SCOPE = 10;
    private SimpleDateFormat hourFormat;
    private boolean cancelExploration;
    private Set<String> fWaivers = new HashSet<String>();
    private String baseLogPath;
    private String jmapDumpStartStringPath;
    private String jmapDumpEndStringPath;
    private Writer logFileWriter;
    private Writer reportWriter;
    private Writer obfuscatedLogFileWriter;
    private Writer obfuscatedReportWriter;
    private File plainLogFile;
    private File plainReportFile;
    private File obfuscatedLogFile;
    private File obfuscatedReportFile;
    protected AtomicBoolean buildDone;
    protected boolean randomizedExploration;
    private List<XplLogger> loggers;
    private List<StringMatcher> matchOnlyPaths;

    protected BaseExplorationCommand(boolean random) {
        this.hourFormat = new SimpleDateFormat("HH:mm:ss");
        this.randomizedExploration = random;
    }

    protected abstract int getRecordingDelay();

    protected abstract int getRecordingInterval();

    protected abstract int getRecordingMaxDumps();

    protected abstract String getLogPrefix();

    protected abstract boolean triggerTestedFunctionality(DVTEditor var1, Token var2, XPLConfig var3, IExploratoryCommandContributor var4);

    protected abstract boolean skipContentFilteredFiles();

    protected abstract boolean shouldSkipReadOnly();

    protected boolean launchExplorationCommand(IProject selectedProject, List<IFile> filesToExplore, List<IExploratoryCommandContributor> contributors, XPLConfig xplConfig) {
        try {
            new ProgressMonitorDialog(Utils.getActiveShell()).run(false, true, arg_0 -> this.lambda$0(filesToExplore, selectedProject, xplConfig, contributors, arg_0));
        }
        catch (InterruptedException | InvocationTargetException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.cancelExploration = true;
        }
        return this.cancelExploration;
    }

    /*
     * Exception decompiling
     */
    private final void exploreFile(IFile file, int currentFileIndex, int totalNumberOfFiles, IProgressMonitor monitor, List<IExploratoryCommandContributor> contributors, XPLConfig xplConfig) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void writeReportFile() throws IOException {
        for (XplLogger log : this.loggers) {
            log.createReport();
        }
    }

    private boolean createFilesAndOpenStreams(IProject selectedProject) {
        block3: {
            try {
                this.jmapDumpStartStringPath = String.valueOf(this.baseLogPath) + "_heap_dump_start" + "_" + this.getLogPrefix() + ".hprof";
                this.jmapDumpEndStringPath = String.valueOf(this.baseLogPath) + "_heap_dump_end" + "_" + this.getLogPrefix() + ".hprof";
                this.plainLogFile = new File(String.valueOf(this.baseLogPath) + "_" + this.getLogPrefix() + ".expl.log");
                this.plainReportFile = new File(String.valueOf(this.baseLogPath) + "_" + this.getLogPrefix() + ".expl.report");
                this.obfuscatedLogFile = new File(String.valueOf(this.baseLogPath) + "_" + this.getLogPrefix() + ".expl.log.obfuscated");
                this.obfuscatedReportFile = new File(String.valueOf(this.baseLogPath) + "_" + this.getLogPrefix() + ".expl.report.obfuscated");
                if (!(!this.plainLogFile.exists() && !this.plainLogFile.createNewFile() || !this.plainReportFile.exists() && !this.plainReportFile.createNewFile() || !this.obfuscatedLogFile.exists() && !this.obfuscatedLogFile.createNewFile()) && (this.obfuscatedReportFile.exists() || this.obfuscatedReportFile.createNewFile())) break block3;
                return false;
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        this.logFileWriter = new BufferedWriter(new FileWriter(this.plainLogFile));
        this.reportWriter = new BufferedWriter(new FileWriter(this.plainReportFile));
        this.obfuscatedLogFileWriter = new BufferedWriter(new FileWriter(this.obfuscatedLogFile));
        this.obfuscatedReportWriter = new BufferedWriter(new FileWriter(this.obfuscatedReportFile));
        this.loggers.addAll(this.getLoggers(selectedProject));
        return true;
    }

    private void filesAndWaversAndThreadDumpSessionCleanup() {
        this.fWaivers = null;
        DVTUtilsCommon.INSTANCE.closeClosable(this.logFileWriter);
        DVTUtilsCommon.INSTANCE.closeClosable(this.obfuscatedLogFileWriter);
        DVTUtilsCommon.INSTANCE.closeClosable(this.reportWriter);
        DVTUtilsCommon.INSTANCE.closeClosable(this.obfuscatedReportWriter);
    }

    private void createZipLogsAndReports() throws IOException {
        ZipOutputStream logsAndReports = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.baseLogPath) + "_" + this.getLogPrefix() + "_logs_and_reports" + ".zip")));
        this.writeInZip(this.plainLogFile, this.plainReportFile, logsAndReports);
        logsAndReports.close();
        ZipOutputStream logsAndReportsObfuscated = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.baseLogPath) + "_" + this.getLogPrefix() + "_logs_and_reports_obfuscated" + ".zip")));
        this.writeInZip(this.obfuscatedLogFile, this.obfuscatedReportFile, logsAndReportsObfuscated);
        logsAndReportsObfuscated.close();
    }

    private void writeInZip(File logFile, File reportFile, ZipOutputStream zipOut) throws IOException {
        ZipEntry logZipEntry = new ZipEntry(logFile.getName());
        ZipEntry reportZipEntry = new ZipEntry(reportFile.getName());
        try {
            try {
                zipOut.putNextEntry(logZipEntry);
                try (Stream<String> logFileLines = Files.lines(logFile.toPath());){
                    logFileLines.forEach(line -> {
                        try {
                            zipOut.write((String.valueOf(line) + "\n").getBytes());
                        }
                        catch (IOException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    });
                }
                zipOut.flush();
                zipOut.putNextEntry(reportZipEntry);
                try (Stream<String> reportFileLines = Files.lines(reportFile.toPath());){
                    reportFileLines.forEach(line -> {
                        try {
                            zipOut.write((String.valueOf(line) + "\n").getBytes());
                        }
                        catch (IOException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    });
                }
                zipOut.flush();
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                zipOut.close();
            }
        }
        finally {
            zipOut.close();
        }
    }

    private long logMemoryUsage() {
        long usedMem = MemUtils.computeUsedMemory(true) / 1024L / 1024L;
        try {
            for (XplLogger log : this.loggers) {
                log.memoryLog(usedMem);
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return usedMem;
    }

    public List<XplLogger> getLoggers(IProject project) {
        ArrayList<XplLogger> usedLoggers = new ArrayList<XplLogger>();
        usedLoggers.add(new BaseLogger(this.logFileWriter, this.obfuscatedLogFileWriter));
        usedLoggers.addAll(this.getAdditionalLoggers(this.logFileWriter, this.obfuscatedLogFileWriter, project));
        for (XplLogger log : usedLoggers) {
            log.createReporter(this.reportWriter, this.obfuscatedReportWriter);
        }
        return usedLoggers;
    }

    public List<XplLogger> getAdditionalLoggers(Writer logFileWriter, Writer logObfuscatedWriter, IProject project) {
        return new ArrayList<XplLogger>();
    }

    private static String makeFileLineWord(int line, int column, String word) {
        return word + '@' + line + ',' + column;
    }

    public boolean isRandomizedExploration() {
        return this.randomizedExploration;
    }

    private void refreshGUI() {
        try {
            while (Display.getDefault().readAndDispatch()) {
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private List<IFile> filterInputFiles(List<IFile> files, String part, String filters) throws IOException {
        this.matchOnlyPaths = new ArrayList<StringMatcher>();
        if (filters != null) {
            String[] stringArray = filters.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                String filterPath = DVTStringUtil.translatePathPatternToOSPattern(path);
                if (filterPath != null) {
                    filterPath = BaseUtils.canonicPath(filterPath);
                    this.matchOnlyPaths.add(new StringMatcher(filterPath, false, false, true));
                }
                ++n2;
            }
        }
        boolean didFilterFile = false;
        Iterator<IFile> it = files.iterator();
        while (it.hasNext()) {
            IFile file = it.next();
            IPath absolutePath = file.getLocation();
            if (absolutePath == null) {
                it.remove();
                continue;
            }
            String absoluteStringPath = absolutePath.toOSString();
            if (this.shouldSkipReadOnly() && file.isReadOnly()) {
                for (XplLogger log : this.loggers) {
                    log.openFileLog(absoluteStringPath, -1, -1, null, XplLogger.ExploreState.READ_ONLY_SKIP);
                }
                didFilterFile = true;
                it.remove();
                continue;
            }
            if (this.skipContentFilteredFiles() && DVTExplorationGUIFilterMatcher.filterElement(ViewSet.ViewName.COMPILE_ORDER, file.getProject(), absoluteStringPath, () -> absoluteStringPath) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                for (XplLogger log : this.loggers) {
                    log.openFileLog(absoluteStringPath, -1, -1, null, XplLogger.ExploreState.CONTENT_FILTERED);
                }
                didFilterFile = true;
                it.remove();
                continue;
            }
            if (this.matchOnlyPaths.isEmpty()) continue;
            boolean skipFile = true;
            for (StringMatcher matcher : this.matchOnlyPaths) {
                if (!matcher.match(absoluteStringPath)) continue;
                skipFile = false;
                break;
            }
            if (!skipFile) continue;
            for (XplLogger log : this.loggers) {
                log.openFileLog(absoluteStringPath, -1, -1, null, XplLogger.ExploreState.PATH_SKIPPED);
            }
            didFilterFile = true;
            it.remove();
        }
        if (didFilterFile) {
            for (XplLogger log : this.loggers) {
                log.newlineLog();
            }
        }
        if (part.equals(FULL)) {
            return files;
        }
        int partInt = part.charAt(0) - 48;
        if (partInt < 1 || partInt > 5) {
            return files;
        }
        int chunkSize = files.size() / 5;
        int start = (partInt - 1) * chunkSize;
        int end = partInt != 5 ? partInt * chunkSize : files.size();
        return files.subList(start, end);
    }

    private void loadWaivers(IProject project) {
        IFolder dvtFolder = project.getFolder(".dvt");
        if (!dvtFolder.exists()) {
            return;
        }
        IFile waiversFile = dvtFolder.getFile("exploratory_waivers.txt");
        if (!waiversFile.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Stream<String> lines = Files.lines(Paths.get(waiversFile.getLocationURI()));){
                this.fWaivers = lines.collect(Collectors.toSet());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$0(List var1_1, IProject var2_2, XPLConfig var3_3, List var4_4, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block76: {
            block72: {
                block69: {
                    block75: {
                        block71: {
                            block67: {
                                block73: {
                                    block66: {
                                        progressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)var1_1.size());
                                        this.loggers = new ArrayList<XplLogger>();
                                        startMemory = -1L;
                                        buildDoneListener = null;
                                        try {
                                            this.baseLogPath = XPLUtil.INSTANCE.getLogDirectoryPath(true);
                                            progressMonitor.setTaskName("Creating Report Files");
                                            if (!this.createFilesAndOpenStreams(var2_2)) {
                                            }
                                            ** GOTO lbl-1000
                                        }
                                        catch (IOException | CoreException e) {
                                            DVTLogger.INSTANCE.logError(e);
                                            this.cancelExploration = true;
                                            try {
                                                progressMonitor.setTaskName("Writing Report Files");
                                                this.writeReportFile();
                                            }
                                            catch (Exception e) {
                                                DVTLogger.INSTANCE.logError((Throwable)e);
                                                this.cancelExploration = true;
                                            }
                                            var19_26 = this.loggers.iterator();
                                        }
                                        while (true) {
                                            if (!var19_26.hasNext()) break;
                                            log = var19_26.next();
                                            log.stopCommand();
                                        }
                                        var19_26 = this.loggers.iterator();
                                        while (true) {
                                            if (!var19_26.hasNext()) {
                                                progressMonitor.setTaskName("Measuring End Memory Usage");
                                                endMemory = this.logMemoryUsage();
                                                if (startMemory != -1L && !MemUtils.isPossibleMemoryLeak(startMemory, endMemory)) {
                                                    ** try [egrp 11[TRYBLOCK] [13 : 1231->1248)] { 
lbl34:
                                                    // 1 sources

                                                    break;
                                                }
                                                break block66;
                                            }
                                            log = var19_26.next();
                                            log.clear();
                                        }
                                        {
                                            Files.delete(Paths.get(this.jmapDumpStartStringPath, new String[0]));
                                        }
lbl41:
                                        // 1 sources

                                        catch (Exception e) {
                                            DVTLogger.INSTANCE.logError("Could not delete heap dump from: " + this.jmapDumpStartStringPath, (Throwable)e);
                                            this.cancelExploration = true;
                                        }
                                        break block73;
                                    }
                                    MemUtils.dumpHeap(this.jmapDumpEndStringPath);
                                }
                                this.filesAndWaversAndThreadDumpSessionCleanup();
                                try {
                                    this.createZipLogsAndReports();
                                }
                                catch (IOException e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                    this.cancelExploration = true;
                                }
                                this.loggers.clear();
                                DVTMixedLangModelManager.getInstance().removeBuildDoneListener(buildDoneListener);
                                progressMonitor.worked(1);
                                progressMonitor.done();
                                return;
                                catch (Throwable var17_47) {
                                    try {
                                        progressMonitor.setTaskName("Writing Report Files");
                                        this.writeReportFile();
                                    }
                                    catch (Exception e) {
                                        DVTLogger.INSTANCE.logError((Throwable)e);
                                        this.cancelExploration = true;
                                    }
                                    var19_27 = this.loggers.iterator();
                                    break block67;
                                }
                                try {
                                    progressMonitor.setTaskName("Writing Report Files");
                                    this.writeReportFile();
                                }
                                catch (Exception e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                    this.cancelExploration = true;
                                }
                                for (XplLogger log : this.loggers) {
                                    log.stopCommand();
                                }
                                for (XplLogger log : this.loggers) {
                                    log.clear();
                                }
                                progressMonitor.setTaskName("Measuring End Memory Usage");
                                endMemory = this.logMemoryUsage();
                                if (startMemory != -1L && !MemUtils.isPossibleMemoryLeak(startMemory, endMemory)) {
                                    try {
                                        Files.delete(Paths.get(this.jmapDumpStartStringPath, new String[0]));
                                    }
                                    catch (Exception e) {
                                        DVTLogger.INSTANCE.logError("Could not delete heap dump from: " + this.jmapDumpStartStringPath, (Throwable)e);
                                        this.cancelExploration = true;
                                    }
                                } else {
                                    MemUtils.dumpHeap(this.jmapDumpEndStringPath);
                                }
                                this.filesAndWaversAndThreadDumpSessionCleanup();
                                try {
                                    this.createZipLogsAndReports();
                                }
                                catch (IOException e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                    this.cancelExploration = true;
                                }
                                this.loggers.clear();
                                DVTMixedLangModelManager.getInstance().removeBuildDoneListener(buildDoneListener);
                                progressMonitor.worked(1);
                                progressMonitor.done();
                                return;
lbl-1000:
                                // 1 sources

                                {
                                    this.buildDone = new AtomicBoolean(false);
                                    files = this.filterInputFiles(var1_1, var3_3.getPart(), var3_3.getFilters());
                                    progressMonitor.setWorkRemaining(files.size());
                                    progressMonitor.beginTask("Exploring " + this.getLogPrefix() + " for " + files.size() + " files", files.size() + 1);
                                    progressMonitor.setTaskName("Measuring Start Memory Usage");
                                    startMemory = this.logMemoryUsage();
                                    MemUtils.dumpHeap(this.jmapDumpStartStringPath);
                                    for (XplLogger log : this.loggers) {
                                        log.startCommand(var4_4);
                                    }
                                    buildDoneListener = (IBuildDoneListener)LambdaMetafactory.metafactory(null, null, null, (Lro/amiq/dvt/model/IBuildDoneListener$BuildFinishReason;Ljava/lang/String;)V, lambda$1(ro.amiq.dvt.model.IBuildDoneListener$BuildFinishReason java.lang.String ), (Lro/amiq/dvt/model/IBuildDoneListener$BuildFinishReason;Ljava/lang/String;)V)((BaseExplorationCommand)this);
                                    DVTMixedLangModelManager.getInstance().addBuildDoneListener(buildDoneListener);
                                    randomFiles = new HashSet<E>();
                                    if (this.randomizedExploration) {
                                        BaseExplorationCommand.random.ints(20L, 0, files.size()).forEach((IntConsumer)LambdaMetafactory.metafactory(null, null, null, (I)V, lambda$2(java.util.Set int ), (I)V)(randomFiles));
                                    }
                                    this.loadWaivers(var2_2);
                                    analyzedFiles = new HashSet<String>();
                                    i = 0;
                                    while (i < files.size()) {
                                        file = files.get(i);
                                        if (!this.randomizedExploration || randomFiles.contains(i)) {
                                            if (var3_3.isSkipRecompiledFiles()) {
                                                if (analyzedFiles.contains(file.getName())) {
                                                    for (XplLogger log : this.loggers) {
                                                        log.openFileLog(file.getFullPath().toOSString(), i + 1, files.size(), null, XplLogger.ExploreState.PATH_SKIPPED);
                                                        log.newlineLog();
                                                    }
                                                    progressMonitor.worked(1);
                                                } else {
                                                    this.exploreFile(file, i + 1, files.size(), (IProgressMonitor)progressMonitor, var4_4, var3_3);
                                                    analyzedFiles.add(file.getName());
                                                }
                                            } else {
                                                this.exploreFile(file, i + 1, files.size(), (IProgressMonitor)progressMonitor, var4_4, var3_3);
                                            }
                                        }
                                        if (!monitor.isCanceled()) ** GOTO lbl-1000
                                        this.cancelExploration = true;
                                    }
                                    break block69;
                                }
                                {
                                    block74: {
                                        block70: {
                                            try {
                                                progressMonitor.setTaskName("Writing Report Files");
                                                this.writeReportFile();
                                            }
                                            catch (Exception e) {
                                                DVTLogger.INSTANCE.logError((Throwable)e);
                                                this.cancelExploration = true;
                                            }
                                            var19_25 = this.loggers.iterator();
                                            while (true) {
                                                if (!var19_25.hasNext()) break;
                                                log = var19_25.next();
                                                log.stopCommand();
                                            }
                                            var19_25 = this.loggers.iterator();
                                            while (true) {
                                                if (!var19_25.hasNext()) {
                                                    progressMonitor.setTaskName("Measuring End Memory Usage");
                                                    endMemory = this.logMemoryUsage();
                                                    if (startMemory != -1L && !MemUtils.isPossibleMemoryLeak(startMemory, endMemory)) {
                                                        ** try [egrp 6[TRYBLOCK] [4 : 929->946)] { 
lbl165:
                                                        // 1 sources

                                                        break;
                                                    }
                                                    break block70;
                                                }
                                                log = var19_25.next();
                                                log.clear();
                                            }
                                            {
                                                Files.delete(Paths.get(this.jmapDumpStartStringPath, new String[0]));
                                            }
lbl172:
                                            // 1 sources

                                            catch (Exception e) {
                                                DVTLogger.INSTANCE.logError("Could not delete heap dump from: " + this.jmapDumpStartStringPath, (Throwable)e);
                                                this.cancelExploration = true;
                                            }
                                            break block74;
                                        }
                                        MemUtils.dumpHeap(this.jmapDumpEndStringPath);
                                    }
                                    this.filesAndWaversAndThreadDumpSessionCleanup();
                                    try {
                                        this.createZipLogsAndReports();
                                    }
                                    catch (IOException e) {
                                        DVTLogger.INSTANCE.logError((Throwable)e);
                                        this.cancelExploration = true;
                                    }
                                    this.loggers.clear();
                                    DVTMixedLangModelManager.getInstance().removeBuildDoneListener(buildDoneListener);
                                    progressMonitor.worked(1);
                                    progressMonitor.done();
                                    return;
lbl-1000:
                                    // 1 sources

                                    {
                                        this.refreshGUI();
                                        ++i;
                                        continue;
                                        break;
                                    }
                                }
                            }
                            while (true) {
                                if (!var19_27.hasNext()) break;
                                log = var19_27.next();
                                log.stopCommand();
                            }
                            var19_27 = this.loggers.iterator();
                            while (true) {
                                if (!var19_27.hasNext()) {
                                    progressMonitor.setTaskName("Measuring End Memory Usage");
                                    endMemory = this.logMemoryUsage();
                                    if (startMemory != -1L && !MemUtils.isPossibleMemoryLeak(startMemory, endMemory)) {
                                        ** try [egrp 14[TRYBLOCK] [19 : 1500->1517)] { 
lbl208:
                                        // 1 sources

                                        break;
                                    }
                                    break block71;
                                }
                                log = var19_27.next();
                                log.clear();
                            }
                            {
                                Files.delete(Paths.get(this.jmapDumpStartStringPath, new String[0]));
                            }
lbl215:
                            // 1 sources

                            catch (Exception e) {
                                DVTLogger.INSTANCE.logError("Could not delete heap dump from: " + this.jmapDumpStartStringPath, (Throwable)e);
                                this.cancelExploration = true;
                            }
                            break block75;
                        }
                        MemUtils.dumpHeap(this.jmapDumpEndStringPath);
                    }
                    this.filesAndWaversAndThreadDumpSessionCleanup();
                    try {
                        this.createZipLogsAndReports();
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        this.cancelExploration = true;
                    }
                    this.loggers.clear();
                    DVTMixedLangModelManager.getInstance().removeBuildDoneListener(buildDoneListener);
                    progressMonitor.worked(1);
                    progressMonitor.done();
                    progressMonitor = null;
                    throw var17_47;
                }
                try {
                    progressMonitor.setTaskName("Writing Report Files");
                    this.writeReportFile();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    this.cancelExploration = true;
                }
                var19_28 = this.loggers.iterator();
                while (true) {
                    if (!var19_28.hasNext()) break;
                    log = var19_28.next();
                    log.stopCommand();
                }
                var19_28 = this.loggers.iterator();
                while (true) {
                    if (!var19_28.hasNext()) {
                        progressMonitor.setTaskName("Measuring End Memory Usage");
                        endMemory = this.logMemoryUsage();
                        if (startMemory != -1L && !MemUtils.isPossibleMemoryLeak(startMemory, endMemory)) {
                            ** try [egrp 17[TRYBLOCK] [22 : 1767->1784)] { 
lbl256:
                            // 1 sources

                            break;
                        }
                        break block72;
                    }
                    log = var19_28.next();
                    log.clear();
                }
                {
                    Files.delete(Paths.get(this.jmapDumpStartStringPath, new String[0]));
                }
lbl263:
                // 1 sources

                catch (Exception e) {
                    DVTLogger.INSTANCE.logError("Could not delete heap dump from: " + this.jmapDumpStartStringPath, (Throwable)e);
                    this.cancelExploration = true;
                }
                break block76;
            }
            MemUtils.dumpHeap(this.jmapDumpEndStringPath);
        }
        this.filesAndWaversAndThreadDumpSessionCleanup();
        try {
            this.createZipLogsAndReports();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.cancelExploration = true;
        }
        this.loggers.clear();
        DVTMixedLangModelManager.getInstance().removeBuildDoneListener(buildDoneListener);
        progressMonitor.worked(1);
        progressMonitor.done();
    }

    private static /* synthetic */ void lambda$3(String string) {
        SmartCopyUtils.updateStatusBarWithInfo("DVT Thread Dump Collector finished: " + string);
    }

    private /* synthetic */ void lambda$1(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        this.buildDone.set(true);
    }

    private static /* synthetic */ void lambda$2(Set set, int number) {
        boolean bl = set.add(number);
    }
}

