/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory;

import antlr.Token;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.exploratory.BaseReporter;
import ro.amiq.dvt.exploratory.IExploratoryCommandContributor;
import ro.amiq.dvt.exploratory.IdOperationTimePair;
import ro.amiq.dvt.exploratory.XplLogger;

public class BaseLogger
extends XplLogger {
    private BaseReporter reporter;

    public BaseLogger(Writer fileWriter, Writer obfuscatedWriter) {
        super(fileWriter, obfuscatedWriter);
    }

    @Override
    public void createReporter(Writer reportFileWriter, Writer obfuscatedReportFileWriter) {
        this.reporter = new BaseReporter(reportFileWriter, obfuscatedReportFileWriter);
    }

    @Override
    public void afterFunctionalityLog(Token token, IFile file, String timeToken, long functionalityTime) throws IOException {
        String word = token.getText();
        int line = token.getLine();
        int column = token.getColumn();
        this.logFileWriter.append(timeToken).append(" - ").append(BaseLogger.makeFileLineWord(line, column, word)).append(' ').append(String.valueOf(functionalityTime)).append("ms\n");
        this.obfuscatedLogFileWriter.append(timeToken).append(" - ").append(BaseLogger.makeFileLineWord(line, column, BaseLogger.obfuscatedIdentifierName(word.length()))).append(' ').append(String.valueOf(functionalityTime)).append("ms\n");
        this.addReportEntry(new IdOperationTimePair(functionalityTime, word, file.getName(), line, column, file.getLocation().toOSString()));
    }

    private void addReportEntry(IdOperationTimePair entry) {
        this.reporter.addEntry(entry);
    }

    @Override
    public void openFileLog(String absoluteStringPath, int currentFileIndex, int totalNumberOfFiles, IDocument document, XplLogger.ExploreState state) throws IOException {
        String timeStamp = this.hourFormat.format(System.currentTimeMillis());
        this.logFileWriter.append(timeStamp).append(" - ").append(state.toString()).append(" file ").append(absoluteStringPath).append(' ').append(Integer.toString(currentFileIndex)).append('/').append(Integer.toString(totalNumberOfFiles)).append('\n');
        this.obfuscatedLogFileWriter.append(timeStamp).append(" - ").append(state.toString()).append(" file ").append(absoluteStringPath).append(' ').append(Integer.toString(currentFileIndex)).append('/').append(Integer.toString(totalNumberOfFiles)).append('\n');
        if (document == null) {
            return;
        }
        String noLines = String.valueOf(document.getNumberOfLines());
        String fileLength = String.valueOf(document.getLength());
        this.logFileWriter.append(timeStamp).append(" - ").append(noLines).append(" lines; ").append(fileLength).append(" characters\n");
        this.obfuscatedLogFileWriter.append(timeStamp).append(" - ").append(noLines).append(" lines; ").append(fileLength).append(" characters\n");
    }

    @Override
    public void closeFileLog(String absoluteStringPath, IExploratoryCommandContributor contributor) throws IOException {
        String timeStamp = this.hourFormat.format(System.currentTimeMillis());
        this.logFileWriter.append(timeStamp).append(" - Finished file: ").append(absoluteStringPath).append("\n\n");
        this.obfuscatedLogFileWriter.append(timeStamp).append(" - Finished file: ").append(absoluteStringPath).append("\n\n");
    }

    @Override
    public void memoryLog(long usedMem) throws IOException {
        String timeStamp = this.hourFormat.format(System.currentTimeMillis());
        String usedMemMB = String.valueOf(usedMem) + " MB";
        this.logFileWriter.append(timeStamp).append(" - total used memory ").append(usedMemMB).append('\n').append('\n');
        this.obfuscatedLogFileWriter.append(timeStamp).append(" - total used memory ").append(usedMemMB).append('\n').append('\n');
    }

    @Override
    public void createReport() throws IOException {
        this.reporter.report();
    }

    @Override
    public void newlineLog() throws IOException {
        this.logFileWriter.append('\n');
        this.obfuscatedLogFileWriter.append('\n');
    }

    @Override
    public void clear() {
        this.reporter.clear();
    }
}

