/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import ro.amiq.dvt.exploratory.IdOperationTimePair;
import ro.amiq.dvt.exploratory.XplReporter;

public class BaseReporter
extends XplReporter {
    private static final int REPORT_SIZE = 5000;
    private int entriesCount;
    private TreeMap<Long, LinkedList<IdOperationTimePair>> reportEntriesTreeMap = new TreeMap(Collections.reverseOrder());

    protected BaseReporter(Writer reportFileWriter, Writer obuscatedReportFileWriter) {
        super(reportFileWriter, obuscatedReportFileWriter);
    }

    public void addEntry(IdOperationTimePair entry) {
        if (!this.reportEntriesTreeMap.containsKey(entry.getTime())) {
            this.reportEntriesTreeMap.put(entry.getTime(), new LinkedList());
            this.reportEntriesTreeMap.get(entry.getTime()).add(entry);
        } else {
            this.reportEntriesTreeMap.get(entry.getTime()).add(entry);
        }
        ++this.entriesCount;
        if (this.entriesCount > 5000) {
            Map.Entry<Long, LinkedList<IdOperationTimePair>> lastEntry = this.reportEntriesTreeMap.lastEntry();
            if (lastEntry == null) {
                return;
            }
            LinkedList<IdOperationTimePair> fastestOperations = lastEntry.getValue();
            if (fastestOperations == null) {
                this.reportEntriesTreeMap.pollLastEntry();
                return;
            }
            fastestOperations.removeLast();
            if (fastestOperations.isEmpty()) {
                this.reportEntriesTreeMap.pollLastEntry();
            }
            --this.entriesCount;
        }
    }

    @Override
    public void report() throws IOException {
        this.reportWriter.append(IdOperationTimePair.getCsvHeader());
        this.obfuscatedReportWriter.append(IdOperationTimePair.getCsvHeader());
        for (Map.Entry<Long, LinkedList<IdOperationTimePair>> entry : this.reportEntriesTreeMap.entrySet()) {
            for (IdOperationTimePair value : entry.getValue()) {
                this.reportWriter.append(value.toCSVRow());
                this.obfuscatedReportWriter.append(value.toCSVRow(true));
            }
        }
        this.reportWriter.append(StringUtils.repeat((String)"\n", (int)10));
        this.obfuscatedReportWriter.append(StringUtils.repeat((String)"\n", (int)10));
        this.reportWriter.flush();
        this.obfuscatedReportWriter.flush();
    }

    @Override
    public void clear() {
        this.reportEntriesTreeMap.clear();
    }
}

