/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.exploratory.CustomWaiversExploratoryStrategy;
import ro.amiq.dvt.exploratory.ExploratoryCustomWaivers;
import ro.amiq.dvt.exploratory.FilepathCustomWaiversExploratoryStrategy;
import ro.amiq.dvt.exploratory.IdCustomWaiversExploratoryStrategy;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class ExploratoryCustomReader {
    private static final String CUSTOM_XPL_WAIVERS = "custom-xpl-waivers";
    private static final String LANGUAGE = "language";
    private static final String XPL_KIND = "xpl-kind";
    private static final String ID = "id";
    private static final String FILEPATH = "filepath";
    private static final String SCOPE_STACK = "scope-stack";
    private static final String SCOPE_STACK_RECURSIVE = "scope-stack-recursive";

    public List<ExploratoryCustomWaivers> getWaivers(Map<String, Object> dataFromWaiversFile) {
        ArrayList<ExploratoryCustomWaivers> waiversToReturn = new ArrayList<ExploratoryCustomWaivers>();
        try {
            List waiverList = (List)dataFromWaiversFile.get(CUSTOM_XPL_WAIVERS);
            if (waiverList == null) {
                return waiversToReturn;
            }
            for (LinkedHashMap waiverItem : waiverList) {
                List scopeListHashMap;
                if (waiverItem == null || waiverItem.get(LANGUAGE) == null || !waiverItem.get(LANGUAGE).equals(this.getLanguage())) continue;
                ExploratoryCustomWaivers waiver = new ExploratoryCustomWaivers();
                if (waiverItem.containsKey(XPL_KIND)) {
                    waiver.setCommand(waiverItem.get(XPL_KIND).toString());
                }
                if (waiverItem.containsKey(ID)) {
                    waiver.addStrategy(new IdCustomWaiversExploratoryStrategy(waiverItem.get(ID).toString()));
                }
                if (waiverItem.containsKey(FILEPATH)) {
                    waiver.addStrategy(new FilepathCustomWaiversExploratoryStrategy(waiverItem.get(FILEPATH).toString()));
                }
                if (waiverItem.containsKey(SCOPE_STACK)) {
                    scopeListHashMap = (List)waiverItem.get(SCOPE_STACK);
                    waiver.addStrategy(this.getScopeStrategy(scopeListHashMap));
                }
                if (waiverItem.containsKey(SCOPE_STACK_RECURSIVE)) {
                    scopeListHashMap = (List)waiverItem.get(SCOPE_STACK_RECURSIVE);
                    waiver.addStrategy(this.getScopeRecursiveStrategy(scopeListHashMap));
                }
                waiversToReturn.add(waiver);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("Incorrect format for XPL custom waivers", (Throwable)e);
        }
        return waiversToReturn;
    }

    protected abstract String getLanguage();

    protected abstract CustomWaiversExploratoryStrategy getScopeStrategy(List<LinkedHashMap<String, Object>> var1);

    protected abstract CustomWaiversExploratoryStrategy getScopeRecursiveStrategy(List<LinkedHashMap<String, Object>> var1);
}

