/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import ro.amiq.dvt.exploratory.IExploratoryCommandContributor;
import ro.amiq.dvt.exploratory.XPLConfig;
import ro.amiq.dvt.exploratory.XPLUtil;
import ro.amiq.dvt.startup.core.DVTLogger;

public class ExploratoryCustomWaiverToYAML {
    private static final String CUSTOM_XPL_WAIVERS_FILE_NAME = "custom_xpl_waiver.yml";
    private static final String GENERATED_XPL_WAIVERS_FILE_NAME = "generated_xpl_waiver.yml";

    public static void loadWaivers(IProject project, List<IExploratoryCommandContributor> contributors) {
        Map dataFromWaiversFile = null;
        File customWaiversFile = ExploratoryCustomWaiverToYAML.getPropertyFile(project);
        if (customWaiversFile == null || !customWaiversFile.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Iterator<IExploratoryCommandContributor> iterator = null;
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(customWaiversFile.getPath()));){
                dataFromWaiversFile = (Map)new Yaml().load((InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (dataFromWaiversFile == null) {
            return;
        }
        for (IExploratoryCommandContributor contributor : contributors) {
            contributor.loadWaivers(dataFromWaiversFile);
        }
    }

    public static File getPropertyFile(IProject project) {
        if (project == null) {
            return null;
        }
        String path = ExploratoryCustomWaiverToYAML.getPathToPropertyFile(project, false);
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            String deprecatedPath = ExploratoryCustomWaiverToYAML.getPathToPropertyFile(project, true);
            if (deprecatedPath == null) {
                return null;
            }
            File deprecatedFile = new File(deprecatedPath);
            if (deprecatedFile.exists()) {
                return deprecatedFile;
            }
        }
        return file;
    }

    private static String getPathToPropertyFile(IProject project, boolean withPrefix) {
        if (project == null) {
            return null;
        }
        try {
            return String.valueOf(project.getLocation().toOSString()) + '/' + ".dvt" + '/' + (withPrefix ? ".dvt_" : "") + CUSTOM_XPL_WAIVERS_FILE_NAME;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static void dumpGeneratedWaivers(IProject selectedProject, List<IExploratoryCommandContributor> contributors, XPLConfig xplConfig) {
        if (!xplConfig.isGeneratedWaiversEnabled()) {
            return;
        }
        File generatedWaiversFile = new File(String.valueOf(XPLUtil.INSTANCE.getLogDirectoryPath(true)) + "_" + GENERATED_XPL_WAIVERS_FILE_NAME);
        LinkedHashMap dataForGeneratedXPLWaivers = new LinkedHashMap();
        ArrayList<LinkedHashMap<String, Object>> listOfWaivers = new ArrayList<LinkedHashMap<String, Object>>();
        dataForGeneratedXPLWaivers.put("custom-xpl-waivers", listOfWaivers);
        for (IExploratoryCommandContributor contributor : contributors) {
            try {
                if (contributor == null) break;
                List<LinkedHashMap<String, Object>> convertGeneratedCustomWaiverToYAML = contributor.convertGeneratedCustomWaiverToYAML();
                if (convertGeneratedCustomWaiverToYAML == null) continue;
                listOfWaivers.addAll(convertGeneratedCustomWaiverToYAML);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        DumperOptions options = new DumperOptions();
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml generatedYaml = new Yaml(options);
        try {
            Throwable e = null;
            Object var9_12 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(generatedWaiversFile));){
                writer.write(generatedYaml.dump(dataForGeneratedXPLWaivers));
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

