/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory;

import antlr.Token;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import ro.amiq.dvt.exploratory.BaseExplorationCommand;
import ro.amiq.dvt.exploratory.CustomWaiversExploratoryStrategy;
import ro.amiq.dvt.exploratory.contentassist.BaseContentAssistCommand;
import ro.amiq.dvt.exploratory.hyperlink.BaseHyperlinkCommand;
import ro.amiq.dvt.exploratory.incremental.BaseIncrementalCommand;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.ui.editor.DVTEditor;

public class ExploratoryCustomWaivers {
    private String command;
    private StringBuilder description = new StringBuilder();
    private List<CustomWaiversExploratoryStrategy> waivingStrategies = new ArrayList<CustomWaiversExploratoryStrategy>();

    public boolean isApplicable(BaseExplorationCommand command, IFile file, IRfNamedElementAndScope elementAndScope, DVTEditor dvtEditor, Token token) {
        if (command instanceof BaseHyperlinkCommand && !this.command.equals("hyperlink")) {
            return false;
        }
        if (command instanceof BaseIncrementalCommand && !this.command.equals("incremental")) {
            return false;
        }
        if (command instanceof BaseContentAssistCommand && !this.command.equals("content-assist")) {
            return false;
        }
        for (CustomWaiversExploratoryStrategy strategy : this.waivingStrategies) {
            if (strategy.isApplicable(file, elementAndScope, dvtEditor, token)) continue;
            return false;
        }
        return true;
    }

    public void addStrategy(CustomWaiversExploratoryStrategy strategy) {
        this.waivingStrategies.add(strategy);
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public List<CustomWaiversExploratoryStrategy> getStrategies() {
        return this.waivingStrategies;
    }

    public void addToDescription(Token token) {
        this.description.append(token.getText());
        this.description.append("@");
        this.description.append(token.getLine());
        this.description.append(",");
        this.description.append(token.getColumn());
        this.description.append(";");
    }

    public String getDescription() {
        return this.description.toString();
    }
}

