/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import ro.amiq.dvt.exploratory.CustomWaiversExploratoryStrategy;
import ro.amiq.dvt.exploratory.ExploratoryCustomWaivers;
import ro.amiq.dvt.exploratory.FilepathCustomWaiversExploratoryStrategy;
import ro.amiq.dvt.exploratory.IdCustomWaiversExploratoryStrategy;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class ExploratoryCustomWriter {
    private static final String XPL_KIND = "xpl-kind";
    private static final String LANGUAGE = "language";
    private static final String DESCRIPTION = "description";
    private static final String ID = "id";
    private static final String FILEPATH = "filepath";
    private static final String SCOPE_STACK = "scope-stack";
    private static final String SCOPE_STACK_RECURSIVE = "scope-stack-recursive";

    protected abstract String getLanguage();

    protected String getDescription(ExploratoryCustomWaivers waiver) {
        return waiver.getDescription();
    }

    protected String getId(List<CustomWaiversExploratoryStrategy> listOfStrategiesPerWaiver) {
        for (CustomWaiversExploratoryStrategy strategy : listOfStrategiesPerWaiver) {
            if (!(strategy instanceof IdCustomWaiversExploratoryStrategy)) continue;
            return ((IdCustomWaiversExploratoryStrategy)strategy).getId();
        }
        return null;
    }

    protected String getFilepath(List<CustomWaiversExploratoryStrategy> listOfStrategiesPerWaiver) {
        for (CustomWaiversExploratoryStrategy strategy : listOfStrategiesPerWaiver) {
            if (!(strategy instanceof FilepathCustomWaiversExploratoryStrategy)) continue;
            return ((FilepathCustomWaiversExploratoryStrategy)strategy).getFilepath();
        }
        return null;
    }

    protected abstract List<LinkedHashMap<String, Object>> getScopeStack(List<CustomWaiversExploratoryStrategy> var1);

    protected abstract List<LinkedHashMap<String, Object>> getScopeStackRecursive(List<CustomWaiversExploratoryStrategy> var1);

    public List<LinkedHashMap<String, Object>> convertWaiversToYamlFormat(List<ExploratoryCustomWaivers> generatedWaivers) {
        try {
            ArrayList<LinkedHashMap<String, Object>> listOfWaivers = new ArrayList<LinkedHashMap<String, Object>>();
            for (ExploratoryCustomWaivers waiver : generatedWaivers) {
                List<CustomWaiversExploratoryStrategy> listOfStrategiesPerWaiver = waiver.getStrategies();
                LinkedHashMap<String, Object> listOfStrategiesForGeneratedWaivers = new LinkedHashMap<String, Object>();
                String description = this.getDescription(waiver);
                String waiverID = this.getId(listOfStrategiesPerWaiver);
                String filepath = this.getFilepath(listOfStrategiesPerWaiver);
                List<LinkedHashMap<String, Object>> scopeStack = this.getScopeStack(listOfStrategiesPerWaiver);
                List<LinkedHashMap<String, Object>> scopeStackRecursive = this.getScopeStackRecursive(listOfStrategiesPerWaiver);
                listOfStrategiesForGeneratedWaivers.put(XPL_KIND, waiver.getCommand());
                listOfStrategiesForGeneratedWaivers.put(LANGUAGE, this.getLanguage());
                if (description != null) {
                    listOfStrategiesForGeneratedWaivers.put(DESCRIPTION, description);
                }
                if (waiverID != null) {
                    listOfStrategiesForGeneratedWaivers.put(ID, waiverID);
                }
                if (filepath != null) {
                    listOfStrategiesForGeneratedWaivers.put(FILEPATH, filepath);
                }
                if (scopeStack != null) {
                    listOfStrategiesForGeneratedWaivers.put(SCOPE_STACK, scopeStack);
                }
                if (scopeStackRecursive != null) {
                    listOfStrategiesForGeneratedWaivers.put(SCOPE_STACK_RECURSIVE, scopeStackRecursive);
                }
                listOfWaivers.add(listOfStrategiesForGeneratedWaivers);
            }
            return listOfWaivers;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

