/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory;

import java.util.regex.Pattern;

public class IdOperationTimePair
implements Comparable<IdOperationTimePair> {
    private static final Pattern ANY = Pattern.compile("(?s).");
    private long time;
    private String word;
    private int line;
    private int column;
    private String simpleName;
    private String fullName;

    public IdOperationTimePair(long time, String word, String simpleName, int line, int column, String fullName) {
        this.time = time;
        this.word = word;
        this.simpleName = simpleName;
        this.line = line;
        this.column = column;
        this.fullName = fullName;
    }

    public long getTime() {
        return this.time;
    }

    public String getWord() {
        return this.word;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getFullName() {
        return this.fullName;
    }

    public static String getCsvHeader() {
        return IdOperationTimePair.getCsvHeader(", ");
    }

    public static String getCsvHeader(String delimiter) {
        return "Time" + delimiter + "Word" + delimiter + "File Name" + delimiter + "Line" + delimiter + "Column" + delimiter + "Full Path" + System.lineSeparator();
    }

    public String toCSVRow() {
        return this.toCSVRow(", ", false);
    }

    public String toCSVRow(boolean obfuscate) {
        return this.toCSVRow(", ", obfuscate);
    }

    public String toCSVRow(String delimiter) {
        return this.toCSVRow(delimiter, false);
    }

    public String toCSVRow(String delimiter, boolean obfuscate) {
        return this.time + delimiter + (obfuscate ? ANY.matcher(this.word).replaceAll("x") : this.word) + delimiter + this.simpleName + delimiter + this.line + delimiter + this.column + delimiter + this.fullName + System.lineSeparator();
    }

    @Override
    public int compareTo(IdOperationTimePair o) {
        long result = o.getTime() - this.getTime();
        return result < 0L ? -1 : (result == 0L ? 0 : 1);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + (this.fullName == null ? 0 : this.fullName.hashCode());
        result = 31 * result + this.line;
        result = 31 * result + (this.simpleName == null ? 0 : this.simpleName.hashCode());
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (this.word == null ? 0 : this.word.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdOperationTimePair other = (IdOperationTimePair)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName)) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        if (this.simpleName == null ? other.simpleName != null : !this.simpleName.equals(other.simpleName)) {
            return false;
        }
        if (this.time != other.time) {
            return false;
        }
        return !(this.word == null ? other.word != null : !this.word.equals(other.word));
    }
}

