/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.exploratory.BaseExplorationCommand;
import ro.amiq.dvt.exploratory.ExploratoryCustomWaiverToYAML;
import ro.amiq.dvt.exploratory.IExploratoryCommandContributor;
import ro.amiq.dvt.exploratory.XPLConfig;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.IBuildStatusListener;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.CompiledFilesContributorsExtensionRegistry;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.ICompiledFilesContributor;

@ForTestingOrDebuggingOnly
public class LaunchExplorationTrigger {
    public static final String TARGET_PROJECT = "Project";
    public static final String TARGET_FILE = "Current File";
    private static final String DVT_EXPLORATORY_COMMAND_CONTRIBUTOR_EXTENSION_POINT_ID = "ro.amiq.dvt.exploratoryCommandContributor";
    private static final String DVT_EXPLORATORY_COMMAND_CONTRIBUTOR_ELEMENT = "exploratoryCommandContributor";

    public static Object startExploration(XPLConfig xplConfig) {
        Utils.syncExec(() -> {
            try {
                IProject selectedProject = RfGUIReferencesUtils.getSelectedProject();
                if (selectedProject == null) {
                    return;
                }
                block5 : switch (xplConfig.getTarget()) {
                    case "Current File": {
                        IFile file = RfGUIReferencesUtils.getSelectedFile();
                        if (file == null) {
                            LaunchExplorationTrigger.popNoFileOpened();
                            return;
                        }
                        xplConfig.setPart("FULL");
                        LaunchExplorationTrigger.launchExploration(selectedProject, Collections.singletonList(file), xplConfig);
                        break;
                    }
                    case "Project": {
                        int action = TestHelper.isSkippingXplPopUps() ? 1 : new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Project Build", null, "It is recommended to build the project before starting the Project Performance Exploration.", 4, new String[]{"Build Now", "Skip", "Cancel"}, 0).open();
                        switch (action) {
                            case 0: {
                                LaunchExplorationTrigger.buildNowThenStartExploration(selectedProject, xplConfig);
                                break block5;
                            }
                            case 1: {
                                ArrayList<File> filesToExplore = new ArrayList<File>();
                                for (ICompiledFilesContributor delegate : CompiledFilesContributorsExtensionRegistry.getDelegates()) {
                                    if (LanguageKind.VLOG != delegate.getKind() && LanguageKind.VHDL != delegate.getKind()) continue;
                                    filesToExplore.addAll(delegate.getCompiledFiles(selectedProject));
                                }
                                LaunchExplorationTrigger.launchExploration(selectedProject, filesToExplore.stream().map(localFile -> DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(selectedProject, localFile.getAbsolutePath())).collect(Collectors.toList()), xplConfig);
                                break block5;
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
        return null;
    }

    public static void buildNowThenStartExploration(IProject selectedProject, XPLConfig xplConfig) {
        DVTBuildUtils.buildWithProgressDialog(selectedProject);
        IBuildDoneListener[] listenerList = new IBuildDoneListener[1];
        IBuildStatusListener[] statusListenerList = new IBuildStatusListener[1];
        int[] buildStatus = new int[1];
        statusListenerList[0] = status1 -> {
            if (buildStatus[0] == 0) {
                nArray[0] = status1;
            }
        };
        listenerList[0] = (buildFinishReason, projectName) -> {
            if (!IBuildDoneListener.BuildFinishReason.isFullBuild(buildFinishReason) || IBuildDoneListener.BuildFinishReason.isCanceled(buildFinishReason)) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                DVTMixedLangModelManager.getInstance().removeBuildDoneListener(listenerList[0]);
                DVTMixedLangModelManager.getInstance().removeBuildStatusListener(statusListenerList[0]);
                if (buildStatus[0] == 1) {
                    return;
                }
                ArrayList<File> filesToExplore = new ArrayList<File>();
                for (ICompiledFilesContributor delegate : CompiledFilesContributorsExtensionRegistry.getDelegates()) {
                    if (LanguageKind.VLOG != delegate.getKind() && LanguageKind.VHDL != delegate.getKind()) continue;
                    filesToExplore.addAll(delegate.getCompiledFiles(selectedProject));
                }
                LaunchExplorationTrigger.launchExploration(selectedProject, filesToExplore.stream().map(localFile -> DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(selectedProject, localFile.getAbsolutePath())).collect(Collectors.toList()), xplConfig);
            });
        };
        DVTMixedLangModelManager.getInstance().addBuildDoneListener(listenerList[0]);
        DVTMixedLangModelManager.getInstance().addBuildStatusListener(statusListenerList[0]);
    }

    private static void popNoFileOpened() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Operation Not Available", null, "Please open a file and run again.\nTip: Use the Quick Compile Order to locate a particular compiled file.", 2, new String[]{"OK"}, 0);
            dialog.open();
        });
    }

    public static void launchExploration(IProject selectedProject, List<IFile> filesToExplore, XPLConfig xplConfig) {
        ArrayList<IExploratoryCommandContributor> contributors = new ArrayList<IExploratoryCommandContributor>();
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DVT_EXPLORATORY_COMMAND_CONTRIBUTOR_EXTENSION_POINT_ID);
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (!DVT_EXPLORATORY_COMMAND_CONTRIBUTOR_ELEMENT.equals(configurationElement.getName())) {
                        DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + DVT_EXPLORATORY_COMMAND_CONTRIBUTOR_EXTENSION_POINT_ID));
                    }
                    IExploratoryCommandContributor exploratoryCommandContributor = (IExploratoryCommandContributor)configurationElement.createExecutableExtension("class");
                    contributors.add(exploratoryCommandContributor);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        ExploratoryCustomWaiverToYAML.loadWaivers(selectedProject, contributors);
        for (BaseExplorationCommand command : xplConfig.getCommandsList()) {
            if (command.launchExplorationCommand(selectedProject, filesToExplore, contributors, xplConfig)) break;
        }
        ExploratoryCustomWaiverToYAML.dumpGeneratedWaivers(selectedProject, contributors, xplConfig);
        LaunchExplorationTrigger.clearXplWaivers(contributors);
        ObjectionManager.getInstance().clear(Objection.CLI_XPL_DONE);
    }

    private static void clearXplWaivers(List<IExploratoryCommandContributor> contributors) {
        for (IExploratoryCommandContributor contributor : contributors) {
            try {
                if (contributor == null) continue;
                contributor.clearXPLWaivers();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

