/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.exploratory.BaseExplorationCommand;
import ro.amiq.dvt.exploratory.LaunchExplorationTrigger;
import ro.amiq.dvt.exploratory.XPLConfig;
import ro.amiq.dvt.exploratory.contentassist.BaseContentAssistCommand;
import ro.amiq.dvt.exploratory.hyperlink.BaseHyperlinkCommand;
import ro.amiq.dvt.exploratory.incremental.BaseIncrementalCommand;

public class PerformanceExplorationDialog
extends Dialog {
    private static final String[] FEATURES = new String[]{"Hyperlinks", "Incremental Compilation", "Content Assist"};
    private static final String DIALOG_TITLE = "Performance Exploration";
    private static final String FEATURE_LABEL = "Feature:";
    private static final String TARGET_LABEL = "Target:";
    private static final String PART_LABEL = "Part:        ";
    private static final String FILE_LABEL = "Explore only the files matching the path(s) below or leave empty to explore the whole project:";
    private static final String GENERATE_WAIVERS_LABEL = "Generate automatic waivers";
    private static final String RUNTIME_LABEL = "Runtime:";
    private static final String OCCURRENCE_LABEL = "Occurences:";
    private static final String RUNTIME_PLACEHOLDER = "X ms";
    private static final String OCCURRENCE_PLACEHOLDER = "X times";
    private static final String GENERATE_AUTOMATIC_WAIVERS_EXPLANATION = "Automatically generate a performance exploration waiver for the curent scope when the \nfeature execution takes more than 'Runtime' milliseconds, more than 'Occurences' times.";
    private static final String SKIP_DUPLICATE_COMPILED_FILES_LABEL = "Skip analysing files compiled multiple times";
    private Combo targetCombo;
    private Combo partCombo;
    private Text filterText;
    private Button checkboxForGeneratedWaivers;
    private Button checkboxForSkipFiles;
    private Text runtimeText;
    private Text occurencesText;
    private int numberOfFeaturesInUse;
    private Button[] featureCheckboxes = new Button[FEATURES.length];
    private final VerifyListener fVerifyListener = e -> {
        Text text = (Text)e.getSource();
        String oldValue = text.getText();
        String newValue = String.valueOf(oldValue.substring(0, e.start)) + e.text + oldValue.substring(e.end);
        if (newValue.isEmpty()) {
            return;
        }
        try {
            Integer.parseUnsignedInt(newValue);
        }
        catch (NumberFormatException numberFormatException) {
            e.doit = false;
        }
    };

    public PerformanceExplorationDialog(Shell parent) {
        super(parent);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(DIALOG_TITLE);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(5, 5).equalWidth(true).applyTo(container);
        Composite featuresAndTargetComposite = new Composite(container, 4);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(featuresAndTargetComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)featuresAndTargetComposite);
        Label featureLabel = new Label(featuresAndTargetComposite, 0);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)featureLabel);
        featureLabel.setText(FEATURE_LABEL);
        Composite checkboxComposite = new Composite(featuresAndTargetComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(checkboxComposite);
        int i = 0;
        while (i < FEATURES.length) {
            this.featureCheckboxes[i] = new Button(checkboxComposite, 32);
            this.featureCheckboxes[i].setText(FEATURES[i]);
            ++i;
        }
        this.addListenersToFeatureCheckboxes();
        Label targetLabel = new Label(featuresAndTargetComposite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)targetLabel);
        targetLabel.setText(TARGET_LABEL);
        this.targetCombo = new Combo(featuresAndTargetComposite, 2060);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.targetCombo);
        this.targetCombo.add("Project");
        this.targetCombo.add("Current File");
        this.targetCombo.select(0);
        Composite partAndFiltersComposite = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().equalWidth(true).applyTo(partAndFiltersComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)partAndFiltersComposite);
        Composite partComposite = new Composite(partAndFiltersComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(partComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)partComposite);
        Label partLabel = new Label(partComposite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)partLabel);
        partLabel.setText(PART_LABEL);
        this.partCombo = new Combo(partComposite, 2060);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.partCombo);
        this.partCombo.add("1/5");
        this.partCombo.add("2/5");
        this.partCombo.add("3/5");
        this.partCombo.add("4/5");
        this.partCombo.add("5/5");
        this.partCombo.add("FULL");
        this.partCombo.select(5);
        Label filterLabel = new Label(partAndFiltersComposite, 64);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)filterLabel);
        filterLabel.setText(FILE_LABEL);
        this.filterText = new Text(partAndFiltersComposite, 2626);
        GridDataFactory.fillDefaults().hint(-1, 5 * this.filterText.getLineHeight()).align(4, 4).grab(true, true).applyTo((Control)this.filterText);
        this.targetCombo.addModifyListener(e -> this.setEnabled((Control)partAndFiltersComposite, this.targetCombo.getText().equals("Project")));
        Composite generatedWaiversComposite = new Composite(container, 4);
        GridLayoutFactory.fillDefaults().equalWidth(true).applyTo(generatedWaiversComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)generatedWaiversComposite);
        this.createRuntimeAndOccurrenceComposite(generatedWaiversComposite);
        return container;
    }

    private void validateWizard() {
        Button okButton = this.getButton(0);
        String runtime = this.runtimeText.getText();
        String occurrence = this.occurencesText.getText();
        boolean shouldGenerateWaivers = this.checkboxForGeneratedWaivers.getSelection();
        if (this.numberOfFeaturesInUse > 0 && (!shouldGenerateWaivers || shouldGenerateWaivers && !runtime.isEmpty() && !occurrence.isEmpty() && Integer.parseInt(occurrence) != 0)) {
            okButton.setEnabled(true);
        } else {
            okButton.setEnabled(false);
        }
    }

    public void addListenersToFeatureCheckboxes() {
        int i = 0;
        while (i < FEATURES.length) {
            this.featureCheckboxes[i].addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    Button button = (Button)event.widget;
                    PerformanceExplorationDialog.this.numberOfFeaturesInUse = button.getSelection() ? ++PerformanceExplorationDialog.this.numberOfFeaturesInUse : --PerformanceExplorationDialog.this.numberOfFeaturesInUse;
                    PerformanceExplorationDialog.this.validateWizard();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
            ++i;
        }
    }

    private void createRuntimeAndOccurrenceComposite(Composite parent) {
        this.checkboxForSkipFiles = new Button(parent, 32);
        this.checkboxForSkipFiles.setText(SKIP_DUPLICATE_COMPILED_FILES_LABEL);
        this.checkboxForSkipFiles.setSelection(true);
        this.checkboxForGeneratedWaivers = new Button(parent, 32);
        this.checkboxForGeneratedWaivers.setText(GENERATE_WAIVERS_LABEL);
        final Composite generatedWaiversComposite = new Composite(parent, 4);
        GridLayoutFactory.fillDefaults().applyTo(generatedWaiversComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)generatedWaiversComposite);
        Composite maxRuntimeAndMinOccurencesComposite = new Composite(generatedWaiversComposite, 4);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(maxRuntimeAndMinOccurencesComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)maxRuntimeAndMinOccurencesComposite);
        Label maxRuntimeLabel = new Label(maxRuntimeAndMinOccurencesComposite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)maxRuntimeLabel);
        maxRuntimeLabel.setText(RUNTIME_LABEL);
        maxRuntimeLabel.setEnabled(false);
        this.runtimeText = new Text(maxRuntimeAndMinOccurencesComposite, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.runtimeText);
        this.runtimeText.setEnabled(false);
        this.runtimeText.addModifyListener(e -> this.validateWizard());
        this.runtimeText.addVerifyListener(this.fVerifyListener);
        Label minOccurencesLabel = new Label(maxRuntimeAndMinOccurencesComposite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)maxRuntimeLabel);
        minOccurencesLabel.setText(OCCURRENCE_LABEL);
        minOccurencesLabel.setEnabled(false);
        this.occurencesText = new Text(maxRuntimeAndMinOccurencesComposite, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.occurencesText);
        this.occurencesText.setEnabled(false);
        this.occurencesText.addModifyListener(e -> this.validateWizard());
        this.occurencesText.addVerifyListener(this.fVerifyListener);
        Label generateAutomaticWaiversExplanation = new Label(generatedWaiversComposite, 64);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)generateAutomaticWaiversExplanation);
        generateAutomaticWaiversExplanation.setText(GENERATE_AUTOMATIC_WAIVERS_EXPLANATION);
        generateAutomaticWaiversExplanation.setEnabled(false);
        this.checkboxForGeneratedWaivers.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    PerformanceExplorationDialog.this.setEnabled((Control)generatedWaiversComposite, true);
                    PerformanceExplorationDialog.this.runtimeText.setMessage(PerformanceExplorationDialog.RUNTIME_PLACEHOLDER);
                    PerformanceExplorationDialog.this.occurencesText.setMessage(PerformanceExplorationDialog.OCCURRENCE_PLACEHOLDER);
                } else {
                    PerformanceExplorationDialog.this.setEnabled((Control)generatedWaiversComposite, false);
                    PerformanceExplorationDialog.this.runtimeText.setMessage("");
                    PerformanceExplorationDialog.this.occurencesText.setMessage("");
                }
                PerformanceExplorationDialog.this.validateWizard();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
    }

    private void setEnabled(Control control, boolean enabled) {
        control.setEnabled(enabled);
        if (!(control instanceof Composite)) {
            return;
        }
        Control[] controlArray = ((Composite)control).getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            this.setEnabled(child, enabled);
            ++n2;
        }
    }

    protected void okPressed() {
        String filters = this.filterText.getText().isEmpty() ? null : this.filterText.getText();
        ArrayList<BaseExplorationCommand> commandsList = new ArrayList<BaseExplorationCommand>();
        int i = 0;
        while (i < FEATURES.length) {
            if (this.featureCheckboxes[i].getSelection() && this.featureCheckboxes[i].getText().equals(FEATURES[0])) {
                commandsList.add(new BaseHyperlinkCommand(false));
            }
            if (this.featureCheckboxes[i].getSelection() && this.featureCheckboxes[i].getText().equals(FEATURES[1])) {
                commandsList.add(new BaseIncrementalCommand(false));
            }
            if (this.featureCheckboxes[i].getSelection() && this.featureCheckboxes[i].getText().equals(FEATURES[2])) {
                commandsList.add(new BaseContentAssistCommand(false));
            }
            ++i;
        }
        XPLConfig xplConfig = new XPLConfig();
        xplConfig.setCommandsList(commandsList);
        xplConfig.setTarget(this.targetCombo.getText());
        xplConfig.setPart(this.partCombo.getText());
        xplConfig.setFilters(filters);
        xplConfig.setSkipRecompiledFiles(this.checkboxForSkipFiles.getSelection());
        if (this.checkboxForGeneratedWaivers.getSelection()) {
            xplConfig.setGeneratedWaiversSpecifications(Integer.parseInt(this.runtimeText.getText()), Integer.parseInt(this.occurencesText.getText()));
        }
        LaunchExplorationTrigger.startExploration(xplConfig);
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

