/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory;

import java.io.File;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import ro.amiq.dvt.exploratory.BaseExplorationCommand;
import ro.amiq.dvt.exploratory.contentassist.BaseContentAssistCommand;
import ro.amiq.dvt.exploratory.hyperlink.BaseHyperlinkCommand;
import ro.amiq.dvt.exploratory.incremental.BaseIncrementalCommand;
import ro.amiq.dvt.ui.reportissue.ThreadDumpCollectorConstants;

public enum XPLUtil {
    INSTANCE;

    private SimpleDateFormat dateHourFormat = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");

    public String getLogDirectoryPath(boolean addTimestamp) {
        String logDirectoryPath = String.valueOf(ThreadDumpCollectorConstants.getOutputDirectory()) + File.separator + "exploration_logs";
        File logDirectory = new File(logDirectoryPath);
        if (!logDirectory.exists()) {
            logDirectory.mkdirs();
        }
        return String.valueOf(logDirectoryPath) + File.separator + (addTimestamp ? this.dateHourFormat.format(new Timestamp(System.currentTimeMillis())) : "");
    }

    public String getCommandForGeneratedWaivers(BaseExplorationCommand command) {
        String commandAsString = null;
        if (command instanceof BaseHyperlinkCommand) {
            commandAsString = "hyperlink";
        } else if (command instanceof BaseIncrementalCommand) {
            commandAsString = "incremental";
        } else if (command instanceof BaseContentAssistCommand) {
            commandAsString = "content-assist";
        }
        return commandAsString;
    }
}

