/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory;

import antlr.Token;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.exploratory.IExploratoryCommandContributor;

public abstract class XplLogger {
    protected Writer logFileWriter;
    protected Writer obfuscatedLogFileWriter;
    protected SimpleDateFormat hourFormat;
    protected SimpleDateFormat dateHourFormat;

    protected XplLogger(Writer fileWriter, Writer obfuscatedWriter) {
        this.logFileWriter = fileWriter;
        this.obfuscatedLogFileWriter = obfuscatedWriter;
        this.hourFormat = new SimpleDateFormat("HH:mm:ss");
        this.dateHourFormat = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
    }

    public void startCommand(List<IExploratoryCommandContributor> contributors) {
    }

    public void stopCommand() {
    }

    public void createReporter(Writer reportFileWriter, Writer obfuscatedReportFileWriter) {
    }

    public void memoryLog(long usedMem) throws IOException {
    }

    public void openFileLog(String absoluteStringPath, int currentFileIndex, int totalNumberOfFiles, IDocument document, ExploreState state) throws IOException {
    }

    public void afterFunctionalityLog(Token token, IFile file, String timeToken, long functionalityTime) throws IOException {
    }

    public void closeFileLog(String absoluteStringPath, IExploratoryCommandContributor contributor) throws IOException {
    }

    public void createReport() throws IOException {
    }

    public void newlineLog() throws IOException {
    }

    public void clear() {
    }

    protected static String makeFileLineWord(int line, int column, String word) {
        return word + '@' + line + ',' + column;
    }

    protected static String obfuscatedIdentifierName(int n) {
        char[] obfuscated = new char[n];
        Arrays.fill(obfuscated, 'x');
        return new String(obfuscated);
    }

    public static enum ExploreState {
        PATH_SKIPPED,
        Exploring,
        READ_ONLY_SKIP,
        CONTENT_FILTERED;

    }
}

