/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory.contentassist;

import antlr.Token;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import ro.amiq.dvt.exploratory.BaseExplorationCommand;
import ro.amiq.dvt.exploratory.IExploratoryCommandContributor;
import ro.amiq.dvt.exploratory.XPLConfig;
import ro.amiq.dvt.exploratory.XplLogger;
import ro.amiq.dvt.exploratory.contentassist.ContentAssistLogger;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.benchmark.StopWatch;

@ForTestingOrDebuggingOnly
public class BaseContentAssistCommand
extends BaseExplorationCommand {
    private static final int RECORDING_DELAY_MS = 1000;
    private static final int RECORDING_INTERVAL_MS = 100;
    private static final int RECORDING_MAX_DUMPS = 10;
    private static final int CONTENT_ASSIST_TRIES = 4;
    private static final int MAX_ACCEPTABLE_CONTENT_ASSIST_DURATION = 3000;
    private ContentAssistLogger contentAssistLogger;

    public BaseContentAssistCommand(boolean randomized) {
        super(randomized);
    }

    @Override
    protected boolean triggerTestedFunctionality(DVTEditor editor, Token token, XPLConfig xplConfig, IExploratoryCommandContributor contributor) {
        boolean result = false;
        boolean isCreateGeneratedWaiverEnable = false;
        try {
            int offset = token.getOffset();
            String name = token.getText();
            StopWatch stopWatch = new StopWatch("");
            int i = 0;
            while (i < 4) {
                if (name.length() >= i) {
                    stopWatch.reset().start();
                    int score = this.getProposalIndex(offset + i, name);
                    stopWatch.stop();
                    long contentAssistTime = stopWatch.timeMillisGCInvariant();
                    if (contentAssistTime > 3000L) {
                        result = true;
                    }
                    if (contentAssistTime >= (long)xplConfig.getGeneratedWaiverRuntime()) {
                        isCreateGeneratedWaiverEnable = true;
                    }
                    this.contentAssistLogger.logContentAssist(token, score, i, contentAssistTime, editor.getCurrentFile());
                }
                ++i;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (isCreateGeneratedWaiverEnable && xplConfig.isGeneratedWaiversEnabled()) {
            contributor.createGeneratedWaiverIfScopeOccurencesMatch(xplConfig, editor, token, this);
        }
        return result;
    }

    private int getProposalIndex(int offset, String expectedProposal) {
        ICompletionProposal[] proposals = TestHelper.getProposals(offset);
        int i = 0;
        while (i < proposals.length) {
            String displayString = proposals[i].getDisplayString();
            if (displayString.startsWith(expectedProposal) && (displayString.length() == expectedProposal.length() || !Character.isJavaIdentifierPart(displayString.charAt(expectedProposal.length())))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected String getLogPrefix() {
        return "contentAssist";
    }

    @Override
    public List<XplLogger> getAdditionalLoggers(Writer logFileWriter, Writer logObfuscatedWriter, IProject project) {
        this.contentAssistLogger = new ContentAssistLogger(logFileWriter, logObfuscatedWriter);
        return Arrays.asList(this.contentAssistLogger);
    }

    @Override
    protected int getRecordingDelay() {
        return 1000;
    }

    @Override
    protected int getRecordingInterval() {
        return 100;
    }

    @Override
    protected int getRecordingMaxDumps() {
        return 10;
    }

    @Override
    protected boolean skipContentFilteredFiles() {
        return true;
    }

    @Override
    protected boolean shouldSkipReadOnly() {
        return false;
    }
}

