/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory.contentassist;

import java.util.regex.Pattern;
import ro.amiq.dvt.exploratory.IdOperationTimePair;

public class ContentAssistEntryPair
extends IdOperationTimePair {
    private static final Pattern ANY = Pattern.compile("(?s).");
    private int score;
    private int distanceFromOffset;

    public ContentAssistEntryPair(long time, String word, String simpleFileName, int line, int column, String fullFileName, int score, int distanceFromOffset) {
        super(time, word, simpleFileName, line, column, fullFileName);
        this.score = score;
        this.distanceFromOffset = distanceFromOffset;
    }

    public int getScore() {
        return this.score;
    }

    public int getDistanceFromOffset() {
        return this.distanceFromOffset;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentAssistEntryPair other = (ContentAssistEntryPair)obj;
        if (this.getColumn() != other.getColumn()) {
            return false;
        }
        if (this.getFullName() == null ? other.getFullName() != null : !this.getFullName().equals(other.getFullName())) {
            return false;
        }
        if (this.getLine() != other.getLine()) {
            return false;
        }
        if (this.getSimpleName() == null ? other.getSimpleName() != null : !this.getSimpleName().equals(other.getSimpleName())) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        if (this.getWord() == null ? other.getWord() != null : !this.getWord().equals(other.getWord())) {
            return false;
        }
        if (this.score != other.score) {
            return false;
        }
        return this.distanceFromOffset == other.distanceFromOffset;
    }

    public static String getCsvHeader() {
        return ContentAssistEntryPair.getCsvHeader(", ");
    }

    public static String getCsvHeader(String delimiter) {
        return "Time" + delimiter + "Word" + delimiter + "File Name" + delimiter + "Line" + delimiter + "Column" + delimiter + "Full Path" + delimiter + "Score" + delimiter + "Distance From Offset" + System.lineSeparator();
    }

    @Override
    public String toCSVRow(String delimiter, boolean obfuscate) {
        return this.getTime() + delimiter + (obfuscate ? ANY.matcher(this.getWord()).replaceAll("x") : this.getWord()) + delimiter + this.getSimpleName() + delimiter + this.getLine() + delimiter + this.getColumn() + delimiter + this.getFullName() + delimiter + this.score + delimiter + this.distanceFromOffset + System.lineSeparator();
    }

    @Override
    public int compareTo(IdOperationTimePair other) {
        if (this == other) {
            return 0;
        }
        if (!(other instanceof ContentAssistEntryPair)) {
            return super.compareTo(other);
        }
        ContentAssistEntryPair obj = (ContentAssistEntryPair)other;
        int compareResult = Integer.compare(obj.score, this.score);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = Integer.compare(obj.distanceFromOffset, this.distanceFromOffset);
        if (compareResult != 0) {
            return compareResult;
        }
        long functionalityCompare = Long.compare(obj.getTime(), this.getTime());
        if (functionalityCompare != 0L) {
            return (int)functionalityCompare;
        }
        return 0;
    }
}

