/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory.contentassist;

import antlr.Token;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import ro.amiq.dvt.exploratory.XplLogger;
import ro.amiq.dvt.exploratory.contentassist.ContentAssistEntryPair;
import ro.amiq.dvt.exploratory.contentassist.ContentAssistReporter;

public class ContentAssistLogger
extends XplLogger {
    private ContentAssistReporter reporter;

    public ContentAssistLogger(Writer fileWriter, Writer obfuscatedWriter) {
        super(fileWriter, obfuscatedWriter);
    }

    public void logContentAssist(Token token, int score, int distanceFromOffset, long functionalityTime, IFile file) throws IOException {
        String word = token.getText();
        int line = token.getLine();
        int column = token.getColumn();
        String timeStamp = this.hourFormat.format(System.currentTimeMillis());
        this.logFileWriter.append(timeStamp).append(" - ").append(ContentAssistLogger.makeFileLineWord(line, column, word)).append(' ').append(String.valueOf(String.valueOf(score)) + ' ' + distanceFromOffset + ' ').append(String.valueOf(functionalityTime)).append("ms\n");
        this.obfuscatedLogFileWriter.append(timeStamp).append(" - ").append(ContentAssistLogger.makeFileLineWord(line, column, ContentAssistLogger.obfuscatedIdentifierName(word.length()))).append(' ').append(String.valueOf(String.valueOf(score)) + ' ' + distanceFromOffset + ' ').append(String.valueOf(functionalityTime)).append("ms\n");
        this.reporter.addDetailedEntry(new ContentAssistEntryPair(functionalityTime, word, file.getName(), line, column, file.getLocation().toOSString(), score, distanceFromOffset));
        this.reporter.addEntry(new ContentAssistEntryPair(functionalityTime, word, file.getName(), line, column, file.getLocation().toOSString(), score, distanceFromOffset));
    }

    @Override
    public void createReporter(Writer reportFileWriter, Writer obfuscatedReportFileWriter) {
        this.reporter = new ContentAssistReporter(reportFileWriter, obfuscatedReportFileWriter);
    }

    @Override
    public void createReport() throws IOException {
        this.reporter.report();
    }

    @Override
    public void clear() {
        this.reporter.clear();
    }
}

