/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory.contentassist;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import ro.amiq.dvt.exploratory.XplReporter;
import ro.amiq.dvt.exploratory.contentassist.ContentAssistEntryPair;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;

@ForTestingOrDebuggingOnly
public class ContentAssistReporter
extends XplReporter {
    private static final int REPORT_SIZE = 5000;
    private static final int REPORT_ENTRY_SIZE = 200;
    private static final String CONTENT_ASSIST_REPORT = "\nContent Assist Report\n";
    private static final String NO_MATCH_ENTRIES = "\nNo match entries\n";
    private static final String DIFFICULT_MATCH_ENTRIES = "\nDifficult match entries\n";
    private int entriesCount;
    private TreeMap<Long, LinkedList<ContentAssistEntryPair>> reportEntriesTreeMap = new TreeMap(Collections.reverseOrder());
    private HashMap<Integer, List<ContentAssistEntryPair>> notFoundProposoalsMap = new HashMap();
    private HashMap<Integer, TreeSet<ContentAssistEntryPair>> difficultProposoalsMap = new HashMap();

    protected ContentAssistReporter(Writer reportFileWriter, Writer obuscatedReportFileWriter) {
        super(reportFileWriter, obuscatedReportFileWriter);
    }

    public void addEntry(ContentAssistEntryPair entry) {
        if (!this.reportEntriesTreeMap.containsKey(entry.getTime())) {
            this.reportEntriesTreeMap.put(entry.getTime(), new LinkedList());
            this.reportEntriesTreeMap.get(entry.getTime()).add(entry);
        } else {
            this.reportEntriesTreeMap.get(entry.getTime()).add(entry);
        }
        ++this.entriesCount;
        if (this.entriesCount > 5000) {
            Map.Entry<Long, LinkedList<ContentAssistEntryPair>> lastEntry = this.reportEntriesTreeMap.lastEntry();
            if (lastEntry == null) {
                return;
            }
            LinkedList<ContentAssistEntryPair> fastestOperations = lastEntry.getValue();
            if (fastestOperations == null) {
                this.reportEntriesTreeMap.pollLastEntry();
                return;
            }
            fastestOperations.removeLast();
            if (fastestOperations.isEmpty()) {
                this.reportEntriesTreeMap.pollLastEntry();
            }
            --this.entriesCount;
        }
    }

    public void addDetailedEntry(ContentAssistEntryPair entry) {
        int distance = entry.getDistanceFromOffset();
        if (entry.getScore() == -1) {
            if (!this.notFoundProposoalsMap.containsKey(distance)) {
                this.notFoundProposoalsMap.put(distance, new LinkedList());
                this.notFoundProposoalsMap.get(distance).add(entry);
            } else if (this.notFoundProposoalsMap.get(distance).size() <= 200) {
                this.notFoundProposoalsMap.get(distance).add(entry);
            }
        } else if (!this.difficultProposoalsMap.containsKey(distance)) {
            TreeSet set = new TreeSet();
            this.difficultProposoalsMap.put(distance, set);
            this.difficultProposoalsMap.get(distance).add(entry);
        } else {
            this.difficultProposoalsMap.get(distance).add(entry);
            if (this.difficultProposoalsMap.get(distance).size() > 200) {
                this.difficultProposoalsMap.get(distance).pollLast();
            }
        }
    }

    @Override
    public void report() throws IOException {
        this.reportWriter.append(CONTENT_ASSIST_REPORT);
        this.obfuscatedReportWriter.append(CONTENT_ASSIST_REPORT);
        this.reportWriter.append(ContentAssistEntryPair.getCsvHeader());
        this.obfuscatedReportWriter.append(ContentAssistEntryPair.getCsvHeader());
        for (Map.Entry<Long, LinkedList<ContentAssistEntryPair>> entry : this.reportEntriesTreeMap.entrySet()) {
            for (ContentAssistEntryPair value : entry.getValue()) {
                this.reportWriter.append(value.toCSVRow());
                this.obfuscatedReportWriter.append(value.toCSVRow(true));
            }
        }
        this.reportWriter.append(StringUtils.repeat((String)"\n", (int)10));
        this.obfuscatedReportWriter.append(StringUtils.repeat((String)"\n", (int)10));
        this.reportWriter.append(NO_MATCH_ENTRIES);
        this.obfuscatedReportWriter.append(NO_MATCH_ENTRIES);
        for (Map.Entry<Number, List<ContentAssistEntryPair>> entry : this.notFoundProposoalsMap.entrySet()) {
            Collections.sort(entry.getValue());
            for (ContentAssistEntryPair value : entry.getValue()) {
                this.reportWriter.append(value.toCSVRow());
                this.obfuscatedReportWriter.append(value.toCSVRow(true));
            }
        }
        this.reportWriter.append(StringUtils.repeat((String)"\n", (int)10));
        this.obfuscatedReportWriter.append(StringUtils.repeat((String)"\n", (int)10));
        this.reportWriter.append(DIFFICULT_MATCH_ENTRIES);
        this.obfuscatedReportWriter.append(DIFFICULT_MATCH_ENTRIES);
        for (Map.Entry<Number, SequencedCollection<ContentAssistEntryPair>> entry : this.difficultProposoalsMap.entrySet()) {
            for (ContentAssistEntryPair value : (TreeSet)entry.getValue()) {
                this.reportWriter.append(value.toCSVRow());
                this.obfuscatedReportWriter.append(value.toCSVRow(true));
            }
        }
        this.reportWriter.append(StringUtils.repeat((String)"\n", (int)10));
        this.obfuscatedReportWriter.append(StringUtils.repeat((String)"\n", (int)10));
        this.reportWriter.flush();
        this.obfuscatedReportWriter.flush();
    }

    @Override
    public void clear() {
        this.reportEntriesTreeMap.clear();
        this.notFoundProposoalsMap.clear();
        this.difficultProposoalsMap.clear();
    }
}

