/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory.hyperlink;

import antlr.Token;
import ro.amiq.dvt.exploratory.BaseExplorationCommand;
import ro.amiq.dvt.exploratory.IExploratoryCommandContributor;
import ro.amiq.dvt.exploratory.XPLConfig;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.benchmark.StopWatch;

@ForTestingOrDebuggingOnly
public class BaseHyperlinkCommand
extends BaseExplorationCommand {
    public static final int RECORDING_HYPERLINK_TIMEOUT_MS = 5000;
    private static final int RECORDING_DELAY_MS = 500;
    private static final int RECORDING_INTERVAL_MS = 100;
    private static final int RECORDING_MAX_DUMPS = 10;
    private static final int MAX_ACCEPTABLE_HYPERLINK_DURATION = 3000;

    public BaseHyperlinkCommand(boolean randomized) {
        super(randomized);
    }

    @Override
    protected boolean triggerTestedFunctionality(DVTEditor editor, Token token, XPLConfig xplConfig, IExploratoryCommandContributor contributor) {
        StopWatch stopWatch = new StopWatch("");
        stopWatch.reset().start();
        int tokeOffset = token.getOffset();
        TestHelper.getAllHyperlinks(editor, tokeOffset, false);
        stopWatch.stop();
        if (xplConfig.isGeneratedWaiversEnabled() && stopWatch.timeMillis() >= (long)xplConfig.getGeneratedWaiverRuntime()) {
            contributor.createGeneratedWaiverIfScopeOccurencesMatch(xplConfig, editor, token, this);
        }
        return stopWatch.timeMillisGCInvariant() > 3000L;
    }

    @Override
    protected String getLogPrefix() {
        return "hyperlinks";
    }

    @Override
    protected int getRecordingDelay() {
        return 500;
    }

    @Override
    protected int getRecordingInterval() {
        return 100;
    }

    @Override
    protected int getRecordingMaxDumps() {
        return 10;
    }

    @Override
    protected boolean skipContentFilteredFiles() {
        return true;
    }

    @Override
    protected boolean shouldSkipReadOnly() {
        return false;
    }
}

