/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory.incremental;

import antlr.Token;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.exploratory.BaseExplorationCommand;
import ro.amiq.dvt.exploratory.IExploratoryCommandContributor;
import ro.amiq.dvt.exploratory.XPLConfig;
import ro.amiq.dvt.exploratory.XplLogger;
import ro.amiq.dvt.exploratory.incremental.IncrementalLogger;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.benchmark.StopWatch;

@ForTestingOrDebuggingOnly
public class BaseIncrementalCommand
extends BaseExplorationCommand {
    private static final int RECORDING_DELAY_MS = 3000;
    private static final int RECORDING_INTERVAL_MS = 100;
    private static final int RECORDING_MAX_DUMPS = 10;
    private static final int MAX_INCREMENTAL_DURATION = 20000;
    private static final int MAX_ACCEPTABLE_INCREMENTAL_DURATION = 10000;
    private static final String BASE_REPLACEMENT_STRING = "DVT_EXPLORATORY_REPLACEMENT";
    private long counter;
    private IncrementalLogger incrementalLogger;

    public BaseIncrementalCommand(boolean randomized) {
        super(randomized);
    }

    @Override
    protected boolean triggerTestedFunctionality(DVTEditor editor, Token token, XPLConfig xplConfig, IExploratoryCommandContributor contributor) {
        IDocument document;
        boolean isCreateGeneratedWaiverEnable;
        boolean result;
        block27: {
            result = false;
            isCreateGeneratedWaiverEnable = false;
            document = editor.getDocument();
            if (document != null) break block27;
            return false;
        }
        try {
            IRfSingleLangProject rfProject;
            IProgressMonitor buildProgressMonitor;
            StopWatch incrementalStopWatch;
            long incrementalTime;
            IRfSingleLangProject rfProject2;
            IProgressMonitor buildProgressMonitor2;
            String replacementString = BASE_REPLACEMENT_STRING + this.counter;
            if (replacementString.equals(token.getText())) {
                replacementString = BASE_REPLACEMENT_STRING + ++this.counter;
            }
            document.replace(token.getOffset(), token.getLength(), replacementString);
            this.buildDone.set(false);
            editor.doSave(null);
            long start = System.currentTimeMillis();
            while (!this.buildDone.get() && System.currentTimeMillis() < start + 20000L) {
                try {
                    while (Display.getDefault().readAndDispatch()) {
                    }
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            if (!this.buildDone.get() && (buildProgressMonitor2 = (rfProject2 = RfMixedLangManager.getInstance().getRfSingleLangProject(editor.getProject(), contributor.getLanguage().NATURE_ID, false)).getBuildProgressMonitor()) != null) {
                buildProgressMonitor2.setCanceled(true);
                while (buildProgressMonitor2 != null) {
                    try {
                        while (Display.getDefault().readAndDispatch()) {
                        }
                        Thread.sleep(10L);
                        buildProgressMonitor2 = rfProject2.getBuildProgressMonitor();
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
            if ((incrementalTime = (incrementalStopWatch = StopWatch.get("[BUILD]  incremental")).timeMillisGCInvariant()) > 10000L) {
                result = true;
            }
            this.incrementalLogger.logIncrementalTime(token, true, replacementString, incrementalTime, editor.getCurrentFile());
            if (incrementalStopWatch.timeMillis() >= (long)xplConfig.getGeneratedWaiverRuntime()) {
                isCreateGeneratedWaiverEnable = true;
            }
            document.replace(token.getOffset(), replacementString.length(), token.getText());
            this.buildDone.set(false);
            editor.doSave(null);
            start = System.currentTimeMillis();
            while (!this.buildDone.get() && System.currentTimeMillis() < start + 20000L) {
                try {
                    while (Display.getDefault().readAndDispatch()) {
                    }
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            if (!this.buildDone.get() && (buildProgressMonitor = (rfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(editor.getProject(), contributor.getLanguage().NATURE_ID, false)).getBuildProgressMonitor()) != null) {
                buildProgressMonitor.setCanceled(true);
                while (buildProgressMonitor != null) {
                    try {
                        while (Display.getDefault().readAndDispatch()) {
                        }
                        Thread.sleep(10L);
                        buildProgressMonitor = rfProject.getBuildProgressMonitor();
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
            if ((incrementalTime = incrementalStopWatch.timeMillisGCInvariant()) > 10000L) {
                result = true;
            }
            this.incrementalLogger.logIncrementalTime(token, false, replacementString, incrementalTime, editor.getCurrentFile());
            if (incrementalStopWatch.timeMillis() >= (long)xplConfig.getGeneratedWaiverRuntime()) {
                isCreateGeneratedWaiverEnable = true;
            }
            ++this.counter;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (isCreateGeneratedWaiverEnable && xplConfig.isGeneratedWaiversEnabled()) {
            contributor.createGeneratedWaiverIfScopeOccurencesMatch(xplConfig, editor, token, this);
        }
        return result;
    }

    @Override
    protected String getLogPrefix() {
        return "incremental";
    }

    @Override
    public List<XplLogger> getAdditionalLoggers(Writer logFileWriter, Writer logObfuscatedWriter, IProject project) {
        this.incrementalLogger = new IncrementalLogger(logFileWriter, logObfuscatedWriter, project, this.buildDone);
        return Arrays.asList(this.incrementalLogger);
    }

    @Override
    protected int getRecordingDelay() {
        return 3000;
    }

    @Override
    protected int getRecordingInterval() {
        return 100;
    }

    @Override
    protected int getRecordingMaxDumps() {
        return 10;
    }

    @Override
    protected boolean skipContentFilteredFiles() {
        return true;
    }

    @Override
    protected boolean shouldSkipReadOnly() {
        return true;
    }
}

