/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory.incremental;

import antlr.Token;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.exploratory.IExploratoryCommandContributor;
import ro.amiq.dvt.exploratory.IdOperationTimePair;
import ro.amiq.dvt.exploratory.XplLogger;
import ro.amiq.dvt.exploratory.incremental.IncrementalReporter;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.utils.BaseUtils;
import ro.amiq.dvt.utils.DVTBuildUtils;

@ForTestingOrDebuggingOnly
public class IncrementalLogger
extends XplLogger {
    private IncrementalReporter reporter;
    private IProject selectedProject;
    private Set<DVTProblem> problemsDumpReference;
    private AtomicBoolean buildDone;

    protected IncrementalLogger(Writer fileWriter, Writer obfuscatedWriter, IProject project, AtomicBoolean buildDone) {
        super(fileWriter, obfuscatedWriter);
        this.selectedProject = project;
        this.buildDone = buildDone;
    }

    @Override
    public void startCommand(List<IExploratoryCommandContributor> contributors) {
        this.problemsDumpReference = new HashSet<DVTProblem>();
        for (IExploratoryCommandContributor contributor : contributors) {
            this.problemsDumpReference.addAll(this.getDVTProblems(contributor));
        }
    }

    @Override
    public void createReporter(Writer reportFileWriter, Writer obfuscatedReportFileWriter) {
        this.reporter = new IncrementalReporter(reportFileWriter, obfuscatedReportFileWriter);
    }

    @Override
    public void createReport() throws IOException {
        this.reporter.report();
    }

    @Override
    public void clear() {
        this.reporter.clear();
    }

    @Override
    public void closeFileLog(String absoluteStringPath, IExploratoryCommandContributor contributor) throws IOException {
        Set<DVTProblem> problems = this.getDVTProblems(contributor);
        if (this.problemsDumpReference.equals(problems)) {
            return;
        }
        String timeStamp = this.hourFormat.format(System.currentTimeMillis());
        this.logFileWriter.append(timeStamp).append(" In file: ").append(absoluteStringPath).append(" found markers differences\n\n");
        this.obfuscatedLogFileWriter.append(timeStamp).append(" In file: ").append(absoluteStringPath).append(" found markers differences\n\n");
        this.logFileWriter.append("REMOVALS:\n");
        this.obfuscatedLogFileWriter.append("REMOVALS:\n");
        for (DVTProblem problem : Sets.difference(this.problemsDumpReference, problems)) {
            this.logFileWriter.append(problem.getPath()).append(' ').append(problem.getMessage()).append("\n");
            this.obfuscatedLogFileWriter.append(problem.getPath()).append(' ').append(problem.getMessage()).append("\n");
        }
        this.logFileWriter.append("ADDITIONS:\n");
        this.obfuscatedLogFileWriter.append("ADDITIONS:\n");
        for (DVTProblem problem : Sets.difference(problems, this.problemsDumpReference)) {
            this.logFileWriter.append(problem.getPath()).append(' ').append(problem.getMessage()).append("\n\n");
            this.obfuscatedLogFileWriter.append(problem.getPath()).append(' ').append(problem.getMessage()).append("\n\n");
        }
        this.reporter.addDifferentProblemsFiles(absoluteStringPath);
        try {
            this.buildDone.set(false);
            DVTBuildUtils.testFullBuildWithProgress(this.selectedProject);
            while (!this.buildDone.get()) {
                try {
                    while (Display.getDefault().readAndDispatch()) {
                    }
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            this.problemsDumpReference = this.getDVTProblems(contributor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private Set<DVTProblem> getDVTProblems(IExploratoryCommandContributor contributor) {
        HashSet<DVTProblem> problemsSet = new HashSet<DVTProblem>();
        List<DVTProblemCategory> errorCategories = BaseUtils.getErrorCategories(contributor.getLanguage());
        for (DVTProblemCategory errorCategory : errorCategories) {
            Map<String, Collection<DVTProblem>> problemsWithCategoryByFile = DVTProblemManager.getInstance().getProblemsWithCategoryByFile(this.selectedProject, errorCategory);
            Set<String> keySet = problemsWithCategoryByFile.keySet();
            ArrayList<String> keySetList = new ArrayList<String>();
            keySetList.addAll(keySet);
            for (String file : keySetList) {
                Collection<DVTProblem> value = problemsWithCategoryByFile.get(file);
                if (value == null || value.isEmpty()) continue;
                problemsSet.addAll(value);
            }
        }
        return problemsSet;
    }

    public void logIncrementalTime(Token token, boolean firstChanged, String replacementString, long functionalityTime, IFile file) throws IOException {
        String word = token.getText();
        int line = token.getLine();
        int column = token.getColumn();
        String timeStamp = this.hourFormat.format(System.currentTimeMillis());
        if (firstChanged) {
            this.logFileWriter.append(timeStamp).append(" - ").append(IncrementalLogger.makeFileLineIncrementalWord(line, column, word, replacementString)).append(' ').append(String.valueOf(functionalityTime)).append("ms\n");
        } else {
            this.logFileWriter.append(timeStamp).append(" - ").append(IncrementalLogger.makeFileLineIncrementalWord(line, column, replacementString, word)).append(' ').append(String.valueOf(functionalityTime)).append("ms\n");
        }
        this.obfuscatedLogFileWriter.append(timeStamp).append(" - ").append(IncrementalLogger.makeFileLineIncrementalWord(line, column, replacementString, replacementString)).append(' ').append(String.valueOf(functionalityTime)).append("ms\n");
        if (firstChanged) {
            this.reporter.addEntry(new IdOperationTimePair(functionalityTime, String.valueOf(word) + "->" + replacementString, file.getName(), line, column, file.getLocation().toOSString()));
        } else {
            this.reporter.addEntry(new IdOperationTimePair(functionalityTime, String.valueOf(replacementString) + "->" + word, file.getName(), line, column, file.getLocation().toOSString()));
        }
    }

    private static String makeFileLineIncrementalWord(int line, int column, String fromWord, String toWord) {
        return fromWord + " -> " + toWord + '@' + line + ',' + column;
    }
}

