/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.exploratory.incremental;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import ro.amiq.dvt.exploratory.IdOperationTimePair;
import ro.amiq.dvt.exploratory.XplReporter;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;

@ForTestingOrDebuggingOnly
public class IncrementalReporter
extends XplReporter {
    private static final int REPORT_SIZE = 5000;
    private static final String NO_ENTRIES = "No marker differences were found.\n";
    private static final String FOUND_DIFFERENCES = "\nFound markers differences in files:\n";
    private static final String INCREMENTAL_REPORT = "\nIncremental Report\n";
    private int entriesCount;
    private TreeMap<Long, LinkedList<IdOperationTimePair>> reportEntriesTreeMap = new TreeMap(Collections.reverseOrder());
    private ArrayList<String> differentProblemsFiles = new ArrayList();

    protected IncrementalReporter(Writer reportFileWriter, Writer obuscatedReportFileWriter) {
        super(reportFileWriter, obuscatedReportFileWriter);
    }

    public void addEntry(IdOperationTimePair entry) {
        if (!this.reportEntriesTreeMap.containsKey(entry.getTime())) {
            this.reportEntriesTreeMap.put(entry.getTime(), new LinkedList());
            this.reportEntriesTreeMap.get(entry.getTime()).add(entry);
        } else {
            this.reportEntriesTreeMap.get(entry.getTime()).add(entry);
        }
        ++this.entriesCount;
        if (this.entriesCount > 5000) {
            Map.Entry<Long, LinkedList<IdOperationTimePair>> lastEntry = this.reportEntriesTreeMap.lastEntry();
            if (lastEntry == null) {
                return;
            }
            LinkedList<IdOperationTimePair> fastestOperations = lastEntry.getValue();
            if (fastestOperations == null) {
                this.reportEntriesTreeMap.pollLastEntry();
                return;
            }
            fastestOperations.removeLast();
            if (fastestOperations.isEmpty()) {
                this.reportEntriesTreeMap.pollLastEntry();
            }
            --this.entriesCount;
        }
    }

    public void addDifferentProblemsFiles(String absolutePath) {
        this.differentProblemsFiles.add(absolutePath);
    }

    @Override
    public void report() throws IOException {
        this.reportWriter.append(INCREMENTAL_REPORT);
        this.obfuscatedReportWriter.append(INCREMENTAL_REPORT);
        for (Map.Entry<Long, LinkedList<IdOperationTimePair>> entry : this.reportEntriesTreeMap.entrySet()) {
            for (IdOperationTimePair value : entry.getValue()) {
                this.reportWriter.append(value.toCSVRow());
                this.obfuscatedReportWriter.append(value.toCSVRow(true));
            }
        }
        this.reportWriter.append(FOUND_DIFFERENCES);
        this.obfuscatedReportWriter.append(FOUND_DIFFERENCES);
        if (this.differentProblemsFiles.isEmpty()) {
            this.reportWriter.append(NO_ENTRIES);
            this.obfuscatedReportWriter.append(NO_ENTRIES);
        } else {
            for (String fileName : this.differentProblemsFiles) {
                this.reportWriter.append(fileName).append("\n");
                this.obfuscatedReportWriter.append(fileName).append("\n");
            }
        }
        this.reportWriter.append(StringUtils.repeat((String)"\n", (int)10));
        this.obfuscatedReportWriter.append(StringUtils.repeat((String)"\n", (int)10));
        this.reportWriter.flush();
        this.obfuscatedReportWriter.flush();
    }

    @Override
    public void clear() {
        this.reportEntriesTreeMap.clear();
        this.differentProblemsFiles.clear();
    }
}

