/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.part.PageBookView;
import ro.amiq.dvt.externaltools.IConsoleScanListener;
import ro.amiq.dvt.externaltools.ScanConsoleRegionJob;
import ro.amiq.dvt.startup.core.DVTLogger;

public class ConsoleHighlightModelManager {
    public static final int CONSOLE_HIGHLIGHT_DELAY = 100;
    private static ConsoleHighlightModelManager fInstance;
    public final Map<IConsole, Queue<IConsoleScanListener>> fConsoleToListeners = new ConcurrentHashMap<IConsole, Queue<IConsoleScanListener>>();
    public final Map<IConsole, ScanConsoleRegionJob> fConsoleToHighlightJob = new ConcurrentHashMap<IConsole, ScanConsoleRegionJob>();
    public static final ISchedulingRule JOB_SCHED_RULE_CONSOLE_HIGHLIGHT;

    static {
        JOB_SCHED_RULE_CONSOLE_HIGHLIGHT = new ISchedulingRule(){

            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this;
            }

            public boolean contains(ISchedulingRule rule) {
                return rule == this;
            }
        };
    }

    public static synchronized ConsoleHighlightModelManager getInstance() {
        if (fInstance == null) {
            fInstance = new ConsoleHighlightModelManager();
        }
        return fInstance;
    }

    public TextConsoleViewer getConsoleViewer() {
        TextConsoleViewer[] consoleViewer = new TextConsoleViewer[1];
        Display.getDefault().syncExec(() -> {
            try {
                PageBookView consolePageBookView;
                IViewPart consoleView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.console.ConsoleView");
                if (consoleView instanceof PageBookView && (consolePageBookView = (PageBookView)consoleView).getCurrentPage() instanceof TextConsolePage) {
                    TextConsolePage consolePage = (TextConsolePage)consolePageBookView.getCurrentPage();
                    textConsoleViewerArray[0] = consolePage.getViewer();
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
        return consoleViewer[0];
    }

    public void launchScanJob(TextConsole console, TextConsoleViewer consoleViewer, int offset, int length) {
        if (console == null || consoleViewer == null) {
            return;
        }
        IDocument document = console.getDocument();
        if (document == null || document.getLength() == 0) {
            return;
        }
        ScanConsoleRegionJob highlightJob = this.fConsoleToHighlightJob.getOrDefault(console, null);
        if (highlightJob != null) {
            highlightJob.cancel();
            highlightJob = null;
        }
        highlightJob = new ScanConsoleRegionJob(console, consoleViewer, offset, length);
        highlightJob.schedule(100L);
        this.fConsoleToHighlightJob.put((IConsole)console, highlightJob);
    }
}

