/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.VariablesPlugin;

public class DvtCLIVariableResolver
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        try {
            String dvtHomeFolder = VariablesPlugin.getDefault().getStringVariableManager().getDynamicVariable("env_var").getValue("DVT_HOME");
            if (dvtHomeFolder == null) {
                throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", "Unable to locate the dvt_cli.sh script while resolving ${dvt_cli}\n($DVT_HOME not set)."));
            }
            String workspaceFolder = VariablesPlugin.getDefault().getStringVariableManager().getDynamicVariable("workspace_loc").getValue(null);
            if (workspaceFolder == null) {
                throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", "Unable to determine workspace location while resolving ${dvt_cli}\n(${workspace_loc} not set)."));
            }
            String dvtCLIFullPath = String.valueOf(dvtHomeFolder) + "/bin/dvt_cli.sh";
            if (!new File(dvtCLIFullPath).canExecute()) {
                throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", "Unable to locate the dvt_cli.sh script while resolving ${dvt_cli}\n($DVT_HOME/bin/dvt_cli.sh does not exist)."));
            }
            return String.valueOf(dvtCLIFullPath) + " -workspace " + workspaceFolder;
        }
        catch (NullPointerException nullPointerException) {
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", "The ${dvt_cli} requires some variables that cannot be resolved."));
        }
    }
}

