/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorSelection;
import ro.amiq.dvt.externaltools.DvtPathToSignalCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.actions.CopyHierarchyPathAction;

public class DvtPathToSignal
extends DvtPathToSignalCommon
implements IDynamicVariableResolver {
    private static final String NULL_ACTIVE_PAGE_ERROR_MESSAGE = "Internal error - null active page.";
    private static final String NO_OPEN_EDITOR_ERROR_MESSAGE = "No editor is opened.";
    private static final String NO_SIGNAL_SELECTED_ERROR_MESSAGE = "No signal is selected.";
    private static final String UNSUPPORTED_EDITOR_ERROR_MESSAGE = "Unsupported editor type.";
    private static final String UNEXPECTED_EXCEPTION_MESSAGE = "Unexpected error.";
    private static final String ERROR_PREFIX = "Cannot resolve DVT Run Configuration variable ${dvt_path_to_signal}: ";

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        try {
            return this.internalResolveValue(argument);
        }
        catch (DvtPathToSignalException e) {
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", e.getMessage()));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", "Cannot resolve DVT Run Configuration variable ${dvt_path_to_signal}: Unexpected error."));
        }
    }

    private String internalResolveValue(String pathSeparator) throws Exception {
        IWorkbenchPage activePage = DVTUiUtils.getActivePage();
        if (activePage == null) {
            throw new DvtPathToSignalException(NULL_ACTIVE_PAGE_ERROR_MESSAGE);
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == null) {
            throw new DvtPathToSignalException(NO_OPEN_EDITOR_ERROR_MESSAGE);
        }
        if (activeEditor instanceof DDiagramEditor) {
            return this.internalResolveDiagramValue((DDiagramEditor)activeEditor, pathSeparator);
        }
        if (activeEditor instanceof MultiPageEditorPart) {
            activeEditor = this.getSelectedPage((MultiPageEditorPart)activeEditor);
        }
        if (!(activeEditor instanceof ITextEditor)) {
            throw new DvtPathToSignalException(UNSUPPORTED_EDITOR_ERROR_MESSAGE);
        }
        return this.internalResolveTextEditorValue((ITextEditor)activeEditor);
    }

    private ITextEditor getSelectedPage(MultiPageEditorPart activeEditorPart) {
        AtomicReference result = new AtomicReference();
        Runnable r = () -> {
            try {
                Object page = activeEditorPart.getSelectedPage();
                if (page instanceof ITextEditor) {
                    result.set((ITextEditor)page);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                result.set(null);
            }
        };
        if (Display.getCurrent() != null) {
            r.run();
        } else {
            DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(r);
        }
        return (ITextEditor)result.get();
    }

    private String internalResolveTextEditorValue(ITextEditor activeEditor) throws Exception {
        if (activeEditor == null) {
            throw new DvtPathToSignalException(UNSUPPORTED_EDITOR_ERROR_MESSAGE);
        }
        String pathToSignalUnderCursor = this.getPathToSignalUnderCursor(activeEditor);
        if (pathToSignalUnderCursor == null || pathToSignalUnderCursor.isEmpty()) {
            throw new DvtPathToSignalException(NO_SIGNAL_SELECTED_ERROR_MESSAGE);
        }
        return pathToSignalUnderCursor;
    }

    private String getPathToSignalUnderCursor(ITextEditor editor) {
        StringBuilder result = new StringBuilder();
        Runnable r = () -> {
            try {
                IAction action = editor.getAction("CopyHierarchyPath");
                if (!(action instanceof CopyHierarchyPathAction)) {
                    return;
                }
                String pathToSignalUnderCursor = ((CopyHierarchyPathAction)action).computeResult();
                if (pathToSignalUnderCursor == null) {
                    return;
                }
                result.append(pathToSignalUnderCursor);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        };
        if (Display.getCurrent() != null) {
            r.run();
        } else {
            DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(r);
        }
        return result.toString();
    }

    private String internalResolveDiagramValue(DDiagramEditor diagramEditor, String pathSeparator) throws Exception {
        ISelection diagramSelection = diagramEditor.getSelection();
        if (!(diagramSelection instanceof DDiagramEditorSelection)) {
            throw new DvtPathToSignalException(UNSUPPORTED_EDITOR_ERROR_MESSAGE);
        }
        DDiagramEditorSelection selection = (DDiagramEditorSelection)diagramSelection;
        if (!(selection.getDiagram() instanceof DTopPathDiagram)) {
            throw new DvtPathToSignalException(UNSUPPORTED_EDITOR_ERROR_MESSAGE);
        }
        String pathToSignalFromDiagram = DvtPathToSignal.getPathToSignalFromDiagram(selection, pathSeparator);
        if (pathToSignalFromDiagram == null || pathToSignalFromDiagram.isEmpty()) {
            throw new DvtPathToSignalException(NO_SIGNAL_SELECTED_ERROR_MESSAGE);
        }
        return pathToSignalFromDiagram;
    }

    private static class DvtPathToSignalException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected DvtPathToSignalException(String message) {
            super(DvtPathToSignal.ERROR_PREFIX + message);
        }
    }
}

