/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorSelection;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.utils.DVTStringUtil;

abstract class DvtPathToSignalCommon {
    private static String DEFAULT_PATH_SEPARATOR = DVTStringUtil.LINE_SEPARATOR;

    DvtPathToSignalCommon() {
    }

    protected static String getPathToSignalFromDiagram(DDiagramEditorSelection selections, String pathSeparator) {
        Set<DSelectable> selectedElements;
        if (selections == null) {
            return "";
        }
        if (pathSeparator == null || pathSeparator.isEmpty()) {
            pathSeparator = DEFAULT_PATH_SEPARATOR;
        }
        if ((selectedElements = selections.getElements()) == null || selectedElements.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        HashSet<String> selectedPaths = new HashSet<String>(1);
        for (DSelectable selectedElement : selectedElements) {
            String selectedPath;
            ElementPath elementPath;
            INLViewSelectable nlSelectable = KLayDrawUtils.getNLViewSelectable(selectedElement);
            if (nlSelectable == null || (elementPath = DvtPathToSignalCommon.computeSelectedElementPath(nlSelectable)) == null || selectedPaths.contains(selectedPath = elementPath.toString())) continue;
            selectedPaths.add(selectedPath);
            if (result.length() != 0) {
                result.append(pathSeparator);
            }
            result.append(selectedPath);
        }
        return result.toString();
    }

    private static ElementPath computeSelectedElementPath(INLViewSelectable selectable) {
        if (selectable instanceof NLInstanceGate && !(selectable instanceof NLLogicGate)) {
            return NLUtils.getGatePathToTop((NLInstanceGate)selectable);
        }
        if (!(selectable instanceof NLPort) && !(selectable instanceof NLConnection)) {
            return null;
        }
        NLGate enclosingGate = ((NLAbstractBase)((Object)selectable)).getEnclosingGate();
        if (!(enclosingGate instanceof NLInstanceGate)) {
            return null;
        }
        if (enclosingGate instanceof NLLogicGate) {
            enclosingGate = enclosingGate.getEnclosingGate();
        }
        return ElementPath.join(NLUtils.getGatePathToTop((NLInstanceGate)enclosingGate), ((NLAbstractBase)((Object)selectable)).getLabel());
    }
}

