/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleListener;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.externaltools.ExternalToolsColorManager;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversManager;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTExceptionHandler;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.Utils;

public class ExternalToolsBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "ro.amiq.dvt.DVTExternBuilder";
    private static IWindowListener fWindowListener;
    protected ConsoleTerminatedListener fConsoleListener;
    public static IFile fIncrementalFile;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        List<IExternalToolsConfiguration> configurations;
        if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
            return null;
        }
        if (args != null && args.containsKey("justClean") && args.get("justClean").equals("true")) {
            return null;
        }
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        ArrayList<String> selectedConfigsNames = new ArrayList<String>();
        if (args != null && args.containsKey("configurations") && args.get("configurations") instanceof String) {
            String selectedConfigs = (String)args.get("configurations");
            if (selectedConfigs.contains("\n")) {
                String[] tmpArr = selectedConfigs.split("\n");
                selectedConfigsNames.addAll(Arrays.asList(tmpArr));
            } else if (!selectedConfigs.isEmpty()) {
                selectedConfigsNames.add(selectedConfigs);
            }
        }
        if ((configurations = ExternalToolsModelManager.getInstance().getBuilderConfigsWorkingCopy(project, true)) == null || configurations.isEmpty()) {
            return null;
        }
        ExternalToolsColorManager.getInstance().init(project);
        DVTProblemManager.getInstance().clearWaivers(project);
        CompileWaiversManager.INSTANCE.loadWaivers(project);
        for (IExternalToolsConfiguration config : configurations) {
            if (!selectedConfigsNames.isEmpty() && !selectedConfigsNames.contains(config.getName())) continue;
            this.launch(kind, project, monitor, config);
        }
        return null;
    }

    private boolean checkLicAvailable(IProject project) {
        return DVTPlugin.getDefault().collect().c(project, "F636F7265");
    }

    private void launch(int kind, IProject project, IProgressMonitor monitor, IExternalToolsConfiguration config) {
        ExternalToolsUtil.setVariables(project, null, true);
        this.launchWithProjectVariablesSet(kind, project, monitor, config);
        ExternalToolsUtil.removeVariables();
    }

    private void launchWithProjectVariablesSet(int kind, IProject project, IProgressMonitor monitor, final IExternalToolsConfiguration config) {
        Process process = null;
        try {
            if (!this.checkLicAvailable(project)) {
                return;
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (project == null || !project.isAccessible() || project.getLocation() == null) {
                return;
            }
            IPath workingDirectoryPath = ExternalToolsUtil.getWorkingDirectory(config);
            if (monitor.isCanceled()) {
                return;
            }
            if (monitor.isCanceled()) {
                return;
            }
            File workingDirectory = project.getLocation().toFile();
            if (workingDirectoryPath != null) {
                workingDirectory = workingDirectoryPath.toFile();
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (fWindowListener == null) {
                fWindowListener = new ProgramLaunchWindowListener();
                PlatformUI.getWorkbench().addWindowListener(fWindowListener);
            }
            fIncrementalFile = null;
            String autoFile = null;
            if (kind != 6 && kind != 15) {
                if (kind == 10 || kind == 9) {
                    autoFile = ExternalToolsUtil.silentGetDynamicVariable("resource_loc");
                    if (autoFile == null) {
                        return;
                    }
                    IFile file = ExternalToolsUtil.delegateResolveResource(project, autoFile);
                    if (file == null || !file.exists() || !ExternalToolsUtil.delegateHasRelevantContentType(file)) {
                        return;
                    }
                    IResourceDelta delta = this.getDelta(project);
                    IResourceDelta changed = delta.findMember(file.getProjectRelativePath());
                    if (changed == null) {
                        return;
                    }
                    ExternalToolsUtil.clean((IResource)file, config.getName());
                    DVTProblemManager.getInstance().removeProblems(file.getProject(), DVTProblemCategories.EXTERNALTOOLS, Utils.canonicPath(file.getLocation()), config.getName());
                    fIncrementalFile = file;
                } else {
                    return;
                }
            }
            if (!this.checkLicAvailable(project)) {
                return;
            }
            String[] commandLine = ExternalToolsUtil.getCommandLine(project, config, kind);
            if (commandLine == null || commandLine.length == 0) {
                return;
            }
            try {
                List<String> envpForProcess = ExternalToolsUtil.getEnvironment(project, config.getAttribute("ATTR_ENVIRONMENT_VARIABLES", (Map)null), config.getAttribute("ATTR_APPEND_ENVIRONMENT_VARIABLES", true));
                ExternalToolsUtil.addCustomEnv(envpForProcess, project);
                process = DebugPlugin.exec((String[])commandLine, (File)workingDirectory, (String[])envpForProcess.toArray(new String[envpForProcess.size()]));
                IProcess runtimeProcess = null;
                ILaunchConfigurationWorkingCopy launchConfig = this.createConfiguration();
                Launch launch = new Launch((ILaunchConfiguration)launchConfig, "run", null);
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                if (process != null) {
                    monitor.beginTask(NLS.bind((String)ExternalToolsMessages.ProgramLaunchDelegate_3, (Object[])new String[]{config.getName()}), -1);
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("ro.amiq.dvt.launch.GENERIC_COMMAND_ATTR", ExternalToolsUtil.commandToString(commandLine));
                    attributes.put("ro.amiq.dvt.launch.WORKING_DIRECTORY", workingDirectory.getAbsolutePath());
                    attributes.put("ro.amiq.dvt.launch.PROJECT_LOCATION_ATTR", project.getLocation().toOSString());
                    runtimeProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)config.getName(), attributes);
                }
                if (process == null || runtimeProcess == null) {
                    if (process != null) {
                        process.destroy();
                    }
                    throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", 150, ExternalToolsMessages.ProgramLaunchDelegate_4, null));
                }
                runtimeProcess.setAttribute(IProcess.ATTR_CMDLINE, this.generateCommandLine(commandLine));
                runtimeProcess.setAttribute(IProcess.ATTR_PROCESS_LABEL, "[" + project.getName().trim() + "] " + "[" + config.getName() + "]");
                final IProcess finalProcess = runtimeProcess;
                ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(new IConsoleListener(){

                    public void consolesRemoved(IConsole[] consoles) {
                    }

                    public void consolesAdded(IConsole[] consoles) {
                        IConsole[] iConsoleArray = consoles;
                        int n = consoles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConsole console = iConsoleArray[n2];
                            if (console == DebugUITools.getConsole((IProcess)finalProcess)) {
                                ExternalToolsBuilder.this.fConsoleListener = new ConsoleTerminatedListener(console);
                                console.addPropertyChangeListener((IPropertyChangeListener)ExternalToolsBuilder.this.fConsoleListener);
                            }
                            ++n2;
                        }
                    }
                });
                launch.addProcess(runtimeProcess);
                launchManager.addLaunch((ILaunch)launch);
                IConsole console = DVTJobsUtils.waitForConsole(runtimeProcess, monitor);
                ExternalToolsModelManager.getInstance().setProcessConsole(console, project, config, autoFile, 0, workingDirectory.getAbsolutePath());
                while (!(runtimeProcess.isTerminated() || this.fConsoleListener == null || this.fConsoleListener.isTerminated() || monitor.isCanceled())) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                if (!runtimeProcess.isTerminated()) {
                    runtimeProcess.terminate();
                }
            }
            catch (CoreException e) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DVTExceptionHandler.handle(e, config.getName(), "DVT External Builder Error");
                    }
                });
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            if (process != null) {
                DVTUtilsCommon.INSTANCE.closeClosable(process.getOutputStream());
                DVTUtilsCommon.INSTANCE.closeClosable(process.getInputStream());
                DVTUtilsCommon.INSTANCE.closeClosable(process.getErrorStream());
                process.destroy();
            }
            monitor.done();
            fIncrementalFile = null;
        }
    }

    protected ILaunchConfigurationWorkingCopy createConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        ILaunchConfigurationType configType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("ro.amiq.dvt.launch.ExternalToolsConfigurationDelegateType");
        wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom("External Tools"));
        wc.setAttribute("process_factory_id", "ro.amiq.dvt.launch.DVTProcessFactory");
        return wc;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        ExternalToolsUtil.clean((IResource)project, null);
        DVTProblemManager.getInstance().clearWaivers(project);
        DVTProblemManager.getInstance().removeProblemsWithCategory(project, DVTProblemCategories.EXTERNALTOOLS);
        List<IExternalToolsConfiguration> configurations = ExternalToolsModelManager.getInstance().getBuilderConfigsWorkingCopy(project, true);
        if (configurations == null || configurations.isEmpty()) {
            return;
        }
        for (IExternalToolsConfiguration config : configurations) {
            this.launch(15, project, monitor, config);
        }
    }

    private String generateCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < commandLine.length) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuilder command = new StringBuilder();
            boolean containsSpace = false;
            int j = 0;
            while (j < characters.length) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append((CharSequence)command);
                buf.append('\"');
            } else {
                buf.append((CharSequence)command);
            }
            ++i;
        }
        return buf.toString();
    }

    static class ConsoleTerminatedListener
    implements IPropertyChangeListener {
        private IConsole fConsole;
        private boolean fIsTerminated;

        public ConsoleTerminatedListener(IConsole console) {
            this.fConsole = console;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE)) {
                this.fConsole.removePropertyChangeListener((IPropertyChangeListener)this);
                this.fIsTerminated = true;
            }
        }

        public boolean isTerminated() {
            return this.fIsTerminated;
        }
    }

    private class ProgramLaunchWindowListener
    implements IWindowListener {
        private ProgramLaunchWindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 1) {
                return;
            }
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType programType = manager.getLaunchConfigurationType(ExternalToolsBuilder.BUILDER_ID);
            if (programType == null) {
                return;
            }
            ILaunch[] launches = manager.getLaunches();
            int i = 0;
            while (i < launches.length) {
                block6: {
                    ILaunchConfigurationType configType;
                    try {
                        ILaunchConfiguration config = launches[i].getLaunchConfiguration();
                        if (config == null) break block6;
                        configType = config.getType();
                    }
                    catch (CoreException coreException) {
                        break block6;
                    }
                    if (configType.equals(programType) && !launches[i].isTerminated()) {
                        MessageDialog.openWarning((Shell)window.getShell(), (String)ExternalToolsMessages.ProgramLaunchDelegate_Workbench_Closing_1, (String)ExternalToolsMessages.ProgramLaunchDelegate_The_workbench_is_exiting);
                        break;
                    }
                }
                ++i;
            }
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

