/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Color;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.externaltools.ExternalToolsMessageStyle;
import ro.amiq.dvt.externaltools.ExternalToolsNameValue;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.theme.DVTThemeUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.XMLParser;

public class ExternalToolsColorManager {
    private static final String INSTANCE_KEYWORD = "INSTANCE";
    private static final Object fSyncInstance = new Object();
    private static volatile ExternalToolsColorManager fInstance;
    public static final Color PREDEFINED_ERROR_COLOR;
    public static final Color PREDEFINED_WARNING_COLOR;
    private static final ExternalToolsMessageStyle PREDEFINED_ERROR_STYLE;
    private static final ExternalToolsMessageStyle PREDEFINED_WARNING_STYLE;
    private static final ExternalToolsMessageStyle PREDEFINED_NOTE_STYLE;
    public static final String DEFAULT_PATH_SPLIT_SEPARATOR;
    public static final String LOG_COLOR_USER_FILE_DEPRECATED = "log_styles";
    public static final String LOG_COLOR_USER_FILE = "log_styles.xml";
    private static final ExternalToolsMessageStyle[] PREDEFINED_NOTE_RANDOM_FOREGROUND;
    private static final ExternalToolsMessageStyle[] PREDEFINED_NOTE_RANDOM_BACKGROUND;
    public static final int FOREGROUND = 0;
    public static final int BACKGROUND = 1;
    private final HashMap<String, ProjectColorMap> fColorPaternNameMap = new HashMap();
    private static Boolean isDarkUI;

    static {
        PREDEFINED_ERROR_COLOR = DVTColorUtil.INSTANCE.getColor(255, 0, 0);
        PREDEFINED_WARNING_COLOR = DVTColorUtil.INSTANCE.getColor(255, 140, 0);
        PREDEFINED_ERROR_STYLE = new ExternalToolsMessageStyle(PREDEFINED_ERROR_COLOR, 1, 0, false);
        PREDEFINED_WARNING_STYLE = new ExternalToolsMessageStyle(PREDEFINED_WARNING_COLOR, 1, 0, false);
        PREDEFINED_NOTE_STYLE = new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 0, 0)) : DVTColorUtil.INSTANCE.getColor(0, 0, 0), 1, 0, false);
        DEFAULT_PATH_SPLIT_SEPARATOR = System.getProperty("path.separator");
        PREDEFINED_NOTE_RANDOM_FOREGROUND = new ExternalToolsMessageStyle[]{new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 0, 204)) : DVTColorUtil.INSTANCE.getColor(0, 0, 204), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 102, 0)) : DVTColorUtil.INSTANCE.getColor(0, 102, 0), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 102, 204)) : DVTColorUtil.INSTANCE.getColor(0, 102, 204), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 139, 139)) : DVTColorUtil.INSTANCE.getColor(0, 139, 139), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 153, 0)) : DVTColorUtil.INSTANCE.getColor(0, 153, 0), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 153, 102)) : DVTColorUtil.INSTANCE.getColor(0, 153, 102), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 191, 255)) : DVTColorUtil.INSTANCE.getColor(0, 191, 255), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 51, 102)) : DVTColorUtil.INSTANCE.getColor(51, 51, 102), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 51, 0)) : DVTColorUtil.INSTANCE.getColor(102, 51, 0), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 51, 102)) : DVTColorUtil.INSTANCE.getColor(102, 51, 102), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 51, 153)) : DVTColorUtil.INSTANCE.getColor(102, 51, 153), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 102, 102)) : DVTColorUtil.INSTANCE.getColor(102, 102, 102), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 102, 153)) : DVTColorUtil.INSTANCE.getColor(102, 102, 153), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 205, 0)) : DVTColorUtil.INSTANCE.getColor(102, 205, 0), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(138, 43, 226)) : DVTColorUtil.INSTANCE.getColor(138, 43, 226), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 102, 0)) : DVTColorUtil.INSTANCE.getColor(153, 102, 0), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 102, 102)) : DVTColorUtil.INSTANCE.getColor(153, 102, 102), 1, 0, false), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 0, 204)) : DVTColorUtil.INSTANCE.getColor(204, 0, 204), 1, 0, false)};
        PREDEFINED_NOTE_RANDOM_BACKGROUND = new ExternalToolsMessageStyle[]{new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(173, 255, 47)) : DVTColorUtil.INSTANCE.getColor(173, 255, 47), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(122, 197, 205)) : DVTColorUtil.INSTANCE.getColor(122, 197, 205), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(138, 43, 226)) : DVTColorUtil.INSTANCE.getColor(138, 43, 226), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(233, 150, 122)) : DVTColorUtil.INSTANCE.getColor(233, 150, 122), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(189, 183, 109)) : DVTColorUtil.INSTANCE.getColor(189, 183, 109), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(238, 201, 0)) : DVTColorUtil.INSTANCE.getColor(238, 201, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(202, 255, 112)) : DVTColorUtil.INSTANCE.getColor(202, 255, 112), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 20, 147)) : DVTColorUtil.INSTANCE.getColor(255, 20, 147), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(127, 255, 212)) : DVTColorUtil.INSTANCE.getColor(127, 255, 212), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(205, 183, 158)) : DVTColorUtil.INSTANCE.getColor(205, 183, 158), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 204, 204)) : DVTColorUtil.INSTANCE.getColor(0, 204, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 255, 204)) : DVTColorUtil.INSTANCE.getColor(102, 255, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 204, 153)) : DVTColorUtil.INSTANCE.getColor(102, 204, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 204, 153)) : DVTColorUtil.INSTANCE.getColor(153, 204, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 102, 153)) : DVTColorUtil.INSTANCE.getColor(204, 102, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 153, 102)) : DVTColorUtil.INSTANCE.getColor(204, 153, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 204, 153)) : DVTColorUtil.INSTANCE.getColor(204, 204, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 255, 255)) : DVTColorUtil.INSTANCE.getColor(0, 255, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 204, 51)) : DVTColorUtil.INSTANCE.getColor(102, 204, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 102, 102)) : DVTColorUtil.INSTANCE.getColor(255, 102, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 255, 51)) : DVTColorUtil.INSTANCE.getColor(255, 255, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 255, 204)) : DVTColorUtil.INSTANCE.getColor(255, 255, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 102, 0)) : DVTColorUtil.INSTANCE.getColor(255, 102, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 153, 255)) : DVTColorUtil.INSTANCE.getColor(153, 153, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 153, 255)) : DVTColorUtil.INSTANCE.getColor(102, 153, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 255, 51)) : DVTColorUtil.INSTANCE.getColor(102, 255, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 102, 204)) : DVTColorUtil.INSTANCE.getColor(255, 102, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 204, 0)) : DVTColorUtil.INSTANCE.getColor(51, 204, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 102, 255)) : DVTColorUtil.INSTANCE.getColor(255, 102, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 255, 102)) : DVTColorUtil.INSTANCE.getColor(102, 255, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 153, 51)) : DVTColorUtil.INSTANCE.getColor(153, 153, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 255, 0)) : DVTColorUtil.INSTANCE.getColor(51, 255, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 204, 102)) : DVTColorUtil.INSTANCE.getColor(204, 204, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 102, 255)) : DVTColorUtil.INSTANCE.getColor(204, 102, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 204, 153)) : DVTColorUtil.INSTANCE.getColor(255, 204, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 204, 0)) : DVTColorUtil.INSTANCE.getColor(204, 204, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 204, 51)) : DVTColorUtil.INSTANCE.getColor(204, 204, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 204, 255)) : DVTColorUtil.INSTANCE.getColor(102, 204, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 255, 0)) : DVTColorUtil.INSTANCE.getColor(204, 255, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 204, 0)) : DVTColorUtil.INSTANCE.getColor(102, 204, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 255, 51)) : DVTColorUtil.INSTANCE.getColor(204, 255, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 255, 255)) : DVTColorUtil.INSTANCE.getColor(102, 255, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 153, 51)) : DVTColorUtil.INSTANCE.getColor(204, 153, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 204, 255)) : DVTColorUtil.INSTANCE.getColor(51, 204, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 255, 153)) : DVTColorUtil.INSTANCE.getColor(0, 255, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 153, 0)) : DVTColorUtil.INSTANCE.getColor(204, 153, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 153, 0)) : DVTColorUtil.INSTANCE.getColor(255, 153, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 255, 0)) : DVTColorUtil.INSTANCE.getColor(255, 255, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 255, 255)) : DVTColorUtil.INSTANCE.getColor(255, 255, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 153, 153)) : DVTColorUtil.INSTANCE.getColor(102, 153, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 255, 153)) : DVTColorUtil.INSTANCE.getColor(153, 255, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 102, 153)) : DVTColorUtil.INSTANCE.getColor(255, 102, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 153, 102)) : DVTColorUtil.INSTANCE.getColor(255, 153, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 153, 204)) : DVTColorUtil.INSTANCE.getColor(102, 153, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 255, 255)) : DVTColorUtil.INSTANCE.getColor(51, 255, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 153, 0)) : DVTColorUtil.INSTANCE.getColor(255, 153, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 255, 153)) : DVTColorUtil.INSTANCE.getColor(51, 255, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 204, 153)) : DVTColorUtil.INSTANCE.getColor(0, 204, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 255, 102)) : DVTColorUtil.INSTANCE.getColor(204, 255, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 153, 255)) : DVTColorUtil.INSTANCE.getColor(204, 153, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 204, 0)) : DVTColorUtil.INSTANCE.getColor(255, 204, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 153, 102)) : DVTColorUtil.INSTANCE.getColor(153, 153, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 204, 204)) : DVTColorUtil.INSTANCE.getColor(102, 204, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 153, 204)) : DVTColorUtil.INSTANCE.getColor(255, 153, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 255, 204)) : DVTColorUtil.INSTANCE.getColor(204, 255, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 255, 51)) : DVTColorUtil.INSTANCE.getColor(51, 255, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 204, 255)) : DVTColorUtil.INSTANCE.getColor(153, 204, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 255, 102)) : DVTColorUtil.INSTANCE.getColor(0, 255, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 153, 204)) : DVTColorUtil.INSTANCE.getColor(204, 153, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 153, 153)) : DVTColorUtil.INSTANCE.getColor(255, 153, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 204, 102)) : DVTColorUtil.INSTANCE.getColor(153, 204, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 204, 204)) : DVTColorUtil.INSTANCE.getColor(255, 204, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 153, 204)) : DVTColorUtil.INSTANCE.getColor(153, 153, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 255, 255)) : DVTColorUtil.INSTANCE.getColor(204, 255, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 255, 204)) : DVTColorUtil.INSTANCE.getColor(51, 255, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 204, 51)) : DVTColorUtil.INSTANCE.getColor(51, 204, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 255, 153)) : DVTColorUtil.INSTANCE.getColor(255, 255, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 153, 0)) : DVTColorUtil.INSTANCE.getColor(153, 153, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 255, 51)) : DVTColorUtil.INSTANCE.getColor(153, 255, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 204, 255)) : DVTColorUtil.INSTANCE.getColor(0, 204, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 153, 255)) : DVTColorUtil.INSTANCE.getColor(255, 153, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 153, 51)) : DVTColorUtil.INSTANCE.getColor(255, 153, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 255, 255)) : DVTColorUtil.INSTANCE.getColor(153, 255, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 204, 255)) : DVTColorUtil.INSTANCE.getColor(255, 204, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 255, 0)) : DVTColorUtil.INSTANCE.getColor(0, 255, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 255, 102)) : DVTColorUtil.INSTANCE.getColor(51, 255, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 153, 153)) : DVTColorUtil.INSTANCE.getColor(204, 153, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 204, 255)) : DVTColorUtil.INSTANCE.getColor(204, 204, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 204, 204)) : DVTColorUtil.INSTANCE.getColor(153, 204, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 102, 51)) : DVTColorUtil.INSTANCE.getColor(255, 102, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 255, 153)) : DVTColorUtil.INSTANCE.getColor(204, 255, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 204, 0)) : DVTColorUtil.INSTANCE.getColor(153, 204, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 204, 204)) : DVTColorUtil.INSTANCE.getColor(204, 204, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 255, 204)) : DVTColorUtil.INSTANCE.getColor(153, 255, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 204, 51)) : DVTColorUtil.INSTANCE.getColor(153, 204, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 255, 102)) : DVTColorUtil.INSTANCE.getColor(153, 255, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 204, 204)) : DVTColorUtil.INSTANCE.getColor(51, 204, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 255, 102)) : DVTColorUtil.INSTANCE.getColor(255, 255, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 255, 204)) : DVTColorUtil.INSTANCE.getColor(0, 255, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 204, 153)) : DVTColorUtil.INSTANCE.getColor(51, 204, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(51, 204, 102)) : DVTColorUtil.INSTANCE.getColor(51, 204, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 255, 153)) : DVTColorUtil.INSTANCE.getColor(102, 255, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(153, 153, 153)) : DVTColorUtil.INSTANCE.getColor(153, 153, 153), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(0, 255, 51)) : DVTColorUtil.INSTANCE.getColor(0, 255, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 204, 51)) : DVTColorUtil.INSTANCE.getColor(255, 204, 51), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 204, 102)) : DVTColorUtil.INSTANCE.getColor(102, 204, 102), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(204, 102, 204)) : DVTColorUtil.INSTANCE.getColor(204, 102, 204), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 51, 255)) : DVTColorUtil.INSTANCE.getColor(255, 51, 255), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(102, 255, 0)) : DVTColorUtil.INSTANCE.getColor(102, 255, 0), 0, 0, true), new ExternalToolsMessageStyle(ExternalToolsColorManager.isDarkUI() ? DVTColorUtil.INSTANCE.getColor(ColorFactory.getInstance().invertRGB(255, 204, 102)) : DVTColorUtil.INSTANCE.getColor(255, 204, 102), 0, 0, true)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalToolsColorManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new ExternalToolsColorManager();
            }
        }
        return fInstance;
    }

    public void init(IProject project) {
        this.fColorPaternNameMap.clear();
        this.load(project);
    }

    public ExternalToolsMessageStyle getMessageStyle(IProject project, String patternName, int severity, ArrayList<ExternalToolsNameValue> variables) {
        if (this.fColorPaternNameMap.containsKey(project.getName())) {
            ProjectColorMap projectColorMap = this.fColorPaternNameMap.get(project.getName());
            if (projectColorMap == null || projectColorMap.getMap().size() == 0) {
                return this.getDefaultSeverityMessageStyle(project, patternName, severity, variables);
            }
            if (projectColorMap.getMap().containsKey(patternName)) {
                ArrayList<VariablesColorContainer> containers = projectColorMap.getMap().get(patternName);
                if (containers == null) {
                    return this.getDefaultSeverityMessageStyle(project, patternName, severity, variables);
                }
                for (VariablesColorContainer container : containers) {
                    if (!container.match(variables)) continue;
                    return container.fMessageStyle;
                }
            }
        }
        return this.getDefaultSeverityMessageStyle(project, patternName, severity, variables);
    }

    private ExternalToolsMessageStyle getDefaultSeverityMessageStyle(IProject project, String patternName, int severity, ArrayList<ExternalToolsNameValue> variables) {
        if (severity == 1) {
            return PREDEFINED_ERROR_STYLE;
        }
        if (severity == 2) {
            return PREDEFINED_WARNING_STYLE;
        }
        return this.getRandomNoteMessageStyle(project, patternName, severity, variables);
    }

    private ExternalToolsMessageStyle getRandomNoteMessageStyle(IProject project, String patternName, int severity, ArrayList<ExternalToolsNameValue> variables) {
        if (variables == null || variables.isEmpty()) {
            return PREDEFINED_NOTE_STYLE;
        }
        boolean containsInstance = false;
        for (ExternalToolsNameValue nameValue : variables) {
            if (!nameValue.fName.equals(INSTANCE_KEYWORD)) continue;
            containsInstance = true;
            break;
        }
        if (!containsInstance) {
            return PREDEFINED_NOTE_STYLE;
        }
        ProjectColorMap projectNameMap = null;
        if (this.fColorPaternNameMap.containsKey(project.getName())) {
            projectNameMap = this.fColorPaternNameMap.get(project.getName());
        } else {
            projectNameMap = new ProjectColorMap();
            this.fColorPaternNameMap.put(project.getName(), projectNameMap);
        }
        if (projectNameMap.fHighlightMode == 0 && projectNameMap.fRandomColorCount >= PREDEFINED_NOTE_RANDOM_FOREGROUND.length) {
            return PREDEFINED_NOTE_STYLE;
        }
        if (projectNameMap.fHighlightMode == 1 && projectNameMap.fRandomColorCount >= PREDEFINED_NOTE_RANDOM_BACKGROUND.length) {
            return PREDEFINED_NOTE_STYLE;
        }
        VariablesColorContainer container = new VariablesColorContainer();
        for (ExternalToolsNameValue variable : variables) {
            container.addVariable(variable);
        }
        ArrayList<Object> containers = null;
        if (projectNameMap.getMap().containsKey(patternName)) {
            containers = projectNameMap.getMap().get(patternName);
        } else {
            containers = new ArrayList();
            projectNameMap.getMap().put(patternName, containers);
        }
        containers.add(container);
        HashMap<String, ArrayList<VariablesColorContainer>> allPaternNames = projectNameMap.getMap();
        for (ArrayList<VariablesColorContainer> vccs : allPaternNames.values()) {
            for (VariablesColorContainer vcc : vccs) {
                if (vcc == container || !vcc.hasSameVarPatterns(container)) continue;
                container.fMessageStyle = vcc.fMessageStyle;
                return container.fMessageStyle;
            }
        }
        if (projectNameMap.fHighlightMode == 0) {
            container.fMessageStyle = PREDEFINED_NOTE_RANDOM_FOREGROUND[projectNameMap.fRandomColorCount];
        } else if (projectNameMap.fHighlightMode == 1) {
            container.fMessageStyle = PREDEFINED_NOTE_RANDOM_BACKGROUND[projectNameMap.fRandomColorCount];
        }
        ++projectNameMap.fRandomColorCount;
        return container.fMessageStyle;
    }

    public void load(IProject project) {
        try {
            if (project == null) {
                return;
            }
            ProjectColorMap projectNameMap = new ProjectColorMap();
            this.fColorPaternNameMap.put(project.getName(), projectNameMap);
            ArrayList<File> userFiles = this.getPropertyFiles(project);
            for (File userFile : userFiles) {
                if (userFile == null || !userFile.exists()) continue;
                String fileName = userFile.getAbsolutePath();
                if (fileName.endsWith(LOG_COLOR_USER_FILE)) {
                    XMLParser parser = new XMLParser("attributes");
                    parser.load(userFile.getAbsolutePath());
                    String version = parser.get("version");
                    if (version.equals("1")) {
                        String[] items;
                        Map allArrayItems = parser.getAllArrayItems();
                        if (allArrayItems == null || allArrayItems.isEmpty()) {
                            return;
                        }
                        String useRandomDefaults = parser.get("use-random-defaults");
                        if (useRandomDefaults == null || useRandomDefaults.equals("false")) {
                            projectNameMap.fRandomColorCount = 1000;
                        }
                        if ((items = (String[])allArrayItems.get(LOG_COLOR_USER_FILE_DEPRECATED)) == null) {
                            return;
                        }
                        int i = 0;
                        while (i < items.length) {
                            this.decodePreference(projectNameMap, items[i].trim(), i + 1, fileName);
                            ++i;
                        }
                        continue;
                    }
                    return;
                }
                if (!fileName.endsWith(LOG_COLOR_USER_FILE_DEPRECATED)) continue;
                Throwable throwable = null;
                Object var8_10 = null;
                try (BufferedReader input = new BufferedReader(new FileReader(userFile));){
                    String text = null;
                    int lineNumber = 1;
                    while ((text = input.readLine()) != null) {
                        this.decodePreference(projectNameMap, text.trim(), lineNumber, fileName);
                        ++lineNumber;
                    }
                    input.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    private void decodePreference(ProjectColorMap projectNameMap, String lineText, int lineNumber, String fileName) {
        if (lineText.length() == 0) {
            return;
        }
        if (lineText.startsWith("//") || lineText.startsWith("--") || lineText.startsWith("#")) {
            return;
        }
        String[] propertyes = lineText.split("\\s*,\\s*");
        VariablesColorContainer container = new VariablesColorContainer();
        container.fMessageStyle = new ExternalToolsMessageStyle(PREDEFINED_NOTE_STYLE.getColor(), PREDEFINED_NOTE_STYLE.getFontStyle(), PREDEFINED_NOTE_STYLE.getBorderStyle(), projectNameMap.fHighlightMode == 1);
        String patternName = null;
        String[] stringArray = propertyes;
        int n = propertyes.length;
        int n2 = 0;
        while (n2 < n) {
            block41: {
                String property = stringArray[n2];
                String[] decoded = property.split("\\s*=\\s*");
                if (decoded.length != 2) {
                    DVTLogger.INSTANCE.logError("External Tool Color Manager ERROR: Wrong property format: '" + property + "' at line " + lineNumber + " file " + fileName);
                } else {
                    if (decoded[0].equalsIgnoreCase("HIGHLIGHT_MODE")) {
                        if (decoded[1].equalsIgnoreCase("FOREGROUND")) {
                            projectNameMap.fHighlightMode = 0;
                        } else if (decoded[1].equalsIgnoreCase("BACKGROUND")) {
                            projectNameMap.fHighlightMode = 1;
                        } else {
                            DVTLogger.INSTANCE.logError("External Tool Color Manager ERROR: Unknown HIGHLIGHT_MODE: '" + decoded[1].toUpperCase() + "' only BACKGROUND and FOREGROUND supported at line " + lineNumber + " file " + fileName);
                        }
                        return;
                    }
                    if (decoded[0].equalsIgnoreCase("BORDER_STYLE")) {
                        if (decoded[1].equalsIgnoreCase("SOLID")) {
                            container.fMessageStyle.setBorderStyle(1);
                        } else if (decoded[1].equalsIgnoreCase("DOT")) {
                            container.fMessageStyle.setBorderStyle(4);
                        } else if (decoded[1].equalsIgnoreCase("NONE")) {
                            container.fMessageStyle.setBorderStyle(0);
                        } else {
                            DVTLogger.INSTANCE.logError("External Tool Color Manager ERROR: Unknown BORDER_STYLE: '" + decoded[1].toUpperCase() + "' only SOLID, DOT and NONE supported at line " + lineNumber + " file " + fileName);
                        }
                    } else if (decoded[0].equalsIgnoreCase("COLOR")) {
                        try {
                            if (decoded[1].startsWith("#") && decoded[1].length() == 7) {
                                String colorCode = decoded[1].substring(1);
                                container.fMessageStyle.setColor(DVTColorUtil.INSTANCE.getColor(Integer.parseInt(colorCode.substring(0, 2), 16), Integer.parseInt(colorCode.substring(2, 4), 16), Integer.parseInt(colorCode.substring(4, 6), 16)));
                                break block41;
                            }
                            DVTLogger.INSTANCE.logError("External Tool Color Manager ERROR: Unknown COLOR: '" + decoded[1].toUpperCase() + "' only #XXXXXX format supported at line " + lineNumber + " file " + fileName);
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError("External Tool Color Manager ERROR: Unknown COLOR: '" + decoded[1].toUpperCase() + "' only #XXXXXX format supported at line " + lineNumber + " file " + fileName);
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    } else if (decoded[0].equalsIgnoreCase("FONT_STYLE")) {
                        if (decoded[1].contains("|")) {
                            String[] split = decoded[1].split("\\s*[|]\\s*");
                            int i = 0;
                            while (i < split.length) {
                                if (split[i].equalsIgnoreCase("BOLD")) {
                                    container.fMessageStyle.setFontStyle(container.fMessageStyle.getFontStyle() | 1);
                                } else if (split[i].equalsIgnoreCase("ITALIC")) {
                                    container.fMessageStyle.setFontStyle(container.fMessageStyle.getFontStyle() | 2);
                                } else {
                                    DVTLogger.INSTANCE.logError("External Tool Color Manager ERROR: Unknown FONT_STYLE: '" + decoded[1].toUpperCase() + "' only ITALIC and BOLD supported at line " + lineNumber + " file " + fileName);
                                }
                                ++i;
                            }
                        } else if (decoded[1].equalsIgnoreCase("BOLD")) {
                            container.fMessageStyle.setFontStyle(1);
                        } else if (decoded[1].equalsIgnoreCase("ITALIC")) {
                            container.fMessageStyle.setFontStyle(2);
                        } else {
                            DVTLogger.INSTANCE.logError("External Tool Color Manager ERROR: Unknown FONT_STYLE: '" + decoded[1].toUpperCase() + "' only ITALIC and BOLD supported at line " + lineNumber + " file " + fileName);
                        }
                    } else if (decoded[0].equalsIgnoreCase("PATTERN_NAME")) {
                        patternName = decoded[1];
                    } else {
                        container.addVariable(new ExternalToolsNameValue(decoded[0], decoded[1]));
                    }
                }
            }
            ++n2;
        }
        if (patternName != null) {
            ArrayList<Object> containers = null;
            if (projectNameMap.getMap().containsKey(patternName)) {
                containers = projectNameMap.getMap().get(patternName);
            } else {
                containers = new ArrayList();
                projectNameMap.getMap().put(patternName, containers);
            }
            containers.add(0, container);
        }
    }

    private String getPathToPropertyFile(IProject project, String fileName, boolean withPrefix) {
        try {
            return String.valueOf(project.getLocation().toOSString()) + '/' + ".dvt" + '/' + (withPrefix ? ".dvt_" : "") + fileName;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private ArrayList<File> getPropertyFiles(IProject project) {
        String path;
        ArrayList<File> result = new ArrayList<File>();
        List preferenceFiles = DVTSFiles.LOG_STYLES.getAllFiles(true);
        if (preferenceFiles != null && !preferenceFiles.isEmpty()) {
            result.addAll(preferenceFiles);
        }
        result.add((path = this.getPathToPropertyFile(project, LOG_COLOR_USER_FILE, false)) == null ? null : new File(path));
        return result;
    }

    private static boolean isDarkUI() {
        if (isDarkUI == null) {
            isDarkUI = DVTThemeUtils.isDarkUI();
        }
        return isDarkUI;
    }

    static class ProjectColorMap {
        private final HashMap<String, ArrayList<VariablesColorContainer>> fPaternNameMap = new HashMap();
        int fRandomColorCount = 0;
        int fHighlightMode = 0;

        public HashMap<String, ArrayList<VariablesColorContainer>> getMap() {
            return this.fPaternNameMap;
        }
    }

    static class VariablesColorContainer {
        private ExternalToolsMessageStyle fMessageStyle;
        private HashMap<String, Pattern> fVariablePatterns;

        VariablesColorContainer() {
        }

        public void addVariable(ExternalToolsNameValue namePattern) {
            if (namePattern == null) {
                return;
            }
            if (this.fVariablePatterns == null) {
                this.fVariablePatterns = new HashMap();
            }
            try {
                this.fVariablePatterns.put(namePattern.fName, Pattern.compile("^" + Pattern.quote(namePattern.fValue) + "$"));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        public boolean match(ArrayList<ExternalToolsNameValue> variables) {
            if (this.fVariablePatterns == null || this.fVariablePatterns.size() == 0 || variables == null || variables.isEmpty()) {
                return true;
            }
            if (variables.size() != this.fVariablePatterns.size()) {
                return false;
            }
            for (ExternalToolsNameValue variable : variables) {
                Pattern p;
                Matcher m;
                if (!this.fVariablePatterns.containsKey(variable.fName) || (m = (p = this.fVariablePatterns.get(variable.fName)).matcher(variable.fValue)).find()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            if (this.fVariablePatterns == null) {
                return "";
            }
            return this.fVariablePatterns.toString();
        }

        public boolean hasSameVarPatterns(VariablesColorContainer vcc) {
            if (this.fVariablePatterns == null) {
                return false;
            }
            return this.fVariablePatterns.equals(vcc.fVariablePatterns);
        }
    }
}

