/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;

public class ExternalToolsConfiguration
implements IExternalToolsConfiguration {
    private Map<String, Object> fAttributesMap = new HashMap<String, Object>();
    private String fAutoCommand = "";
    private String fCleanCommand = "";
    private boolean fEnable = true;
    private String fFullCommand = "";
    private String fName = "";
    private ExternalToolsPattern[] fPatterns;
    private String fWorkingDir = "";
    private String[] fFilterKinds = new String[]{""};
    private boolean fWSLink = true;

    public ExternalToolsConfiguration() {
    }

    private ExternalToolsConfiguration(IExternalToolsConfiguration config) {
        this.fAutoCommand = config.getAutoCommand();
        this.fCleanCommand = config.getCleanCommand();
        this.fFullCommand = config.getFullCommand();
        this.fEnable = config.getEnable();
        this.fName = config.getName();
        this.fWorkingDir = config.getWorkingDir();
        this.fFilterKinds = config.getFilterKinds();
        if (config.getPatterns() != null) {
            this.fPatterns = new ExternalToolsPattern[config.getPatterns().length];
            int i = 0;
            while (i < config.getPatterns().length) {
                this.fPatterns[i] = new ExternalToolsPattern(config.getPatterns()[i]);
                ++i;
            }
        }
        this.fWSLink = config.isWSLink();
        this.fAttributesMap = config.getAttributes();
    }

    @Override
    public IExternalToolsConfiguration getWorkingCopy() {
        return new ExternalToolsConfiguration(this);
    }

    @Override
    public String getConfigurationType() {
        return "External Builder (generic)";
    }

    @Override
    public String getAutoCommand() {
        return this.fAutoCommand;
    }

    @Override
    public String getCleanCommand() {
        return this.fCleanCommand;
    }

    @Override
    public boolean getEnable() {
        return this.fEnable;
    }

    @Override
    public String getFullCommand() {
        return this.fFullCommand;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public ExternalToolsPattern[] getPatterns() {
        return this.fPatterns;
    }

    @Override
    public String[] getFilterKinds() {
        return this.fFilterKinds;
    }

    @Override
    public String getWorkingDir() {
        return this.fWorkingDir;
    }

    @Override
    public void setAutoCommand(String autoCommand) {
        this.fAutoCommand = autoCommand;
    }

    @Override
    public void setCleanCommand(String cleanCommand) {
        this.fCleanCommand = cleanCommand;
    }

    @Override
    public void setEnable(boolean builderEnable) {
        this.fEnable = builderEnable;
    }

    @Override
    public void setFullCommand(String fullCommand) {
        this.fFullCommand = fullCommand;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public void setPatterns(ExternalToolsPattern[] patterns) {
        this.fPatterns = patterns;
    }

    @Override
    public void setFilterKinds(String[] filterKinds) {
        this.fFilterKinds = filterKinds;
    }

    @Override
    public void setWorkingDir(String workingDir) {
        this.fWorkingDir = workingDir;
    }

    @Override
    public void setWSLink(boolean wSLink) {
        this.fWSLink = wSLink;
    }

    @Override
    public boolean isWSLink() {
        return this.fWSLink;
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) {
        this.fAttributesMap.put(attributeName, attributeValue);
    }

    @Override
    public boolean getAttribute(String attributeName, boolean defaultValue) {
        Object tmpValue = this.fAttributesMap.get(attributeName);
        if (tmpValue == null) {
            return defaultValue;
        }
        if (tmpValue instanceof Boolean) {
            return (Boolean)tmpValue;
        }
        return defaultValue;
    }

    @Override
    public String getAttribute(String attributeName, String defaultValue) {
        Object tmpValue = this.fAttributesMap.get(attributeName);
        if (tmpValue == null) {
            return defaultValue;
        }
        if (tmpValue instanceof Boolean) {
            return Boolean.toString((Boolean)tmpValue);
        }
        return defaultValue;
    }

    @Override
    public int getAttribute(String attributeName, int defaultValue) {
        Object tmpValue = this.fAttributesMap.get(attributeName);
        if (tmpValue == null) {
            return defaultValue;
        }
        if (tmpValue instanceof Integer) {
            return (Integer)tmpValue;
        }
        return defaultValue;
    }

    @Override
    public List getAttribute(String attributeName, List defaultValue) {
        Object tmpValue = this.fAttributesMap.get(attributeName);
        if (tmpValue == null) {
            return defaultValue;
        }
        if (tmpValue instanceof List) {
            return (List)tmpValue;
        }
        return defaultValue;
    }

    @Override
    public Set getAttribute(String attributeName, Set defaultValue) {
        Object tmpValue = this.fAttributesMap.get(attributeName);
        if (tmpValue == null) {
            return defaultValue;
        }
        if (tmpValue instanceof Set) {
            return (Set)tmpValue;
        }
        return defaultValue;
    }

    @Override
    public Map getAttribute(String attributeName, Map defaultValue) {
        Object tmpValue = this.fAttributesMap.get(attributeName);
        if (tmpValue == null) {
            return defaultValue;
        }
        if (tmpValue instanceof Map) {
            return (Map)tmpValue;
        }
        return defaultValue;
    }

    @Override
    public void removeAttribute(String attributeName) {
        this.fAttributesMap.remove(attributeName);
    }

    @Override
    public boolean hasAttribute(String attributeName) {
        return this.fAttributesMap.containsKey(attributeName);
    }

    @Override
    public Map getAttributes() {
        return this.fAttributesMap;
    }

    @Override
    public void setAttributes(Map attributes) {
        HashMap tmpAttr = attributes;
        if (tmpAttr == null) {
            tmpAttr = new HashMap();
        }
        this.fAttributesMap = tmpAttr;
    }

    public boolean equals(Object obj) {
        boolean answer;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalToolsConfiguration)) {
            return false;
        }
        ExternalToolsConfiguration conf = (ExternalToolsConfiguration)obj;
        boolean bl = answer = this.getName().equals(conf.getName()) && this.getFullCommand().equals(conf.getFullCommand()) && this.getAutoCommand().equals(conf.getAutoCommand()) && this.getCleanCommand().equals(conf.getCleanCommand()) && this.getConfigurationType().equals(conf.getConfigurationType()) && this.getEnable() == conf.getEnable();
        if (!answer) {
            return false;
        }
        return Arrays.equals(this.getFilterKinds(), conf.getFilterKinds());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + (this.fFullCommand == null ? 0 : this.fFullCommand.hashCode());
        result = 31 * result + (this.fAutoCommand == null ? 0 : this.fAutoCommand.hashCode());
        result = 31 * result + (this.fCleanCommand == null ? 0 : this.fCleanCommand.hashCode());
        String configurationType = this.getConfigurationType();
        result = 31 * result + (configurationType == null ? 0 : configurationType.hashCode());
        result = 31 * result + Boolean.hashCode(this.fEnable);
        result = 31 * result + Arrays.hashCode(this.fFilterKinds);
        return result;
    }
}

