/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.externaltools.ExternalToolsColorManager;
import ro.amiq.dvt.externaltools.ExternalToolsMessageStyle;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsNameValue;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.ExternalToolsPosition;
import ro.amiq.dvt.externaltools.ExternalToolsProblem;
import ro.amiq.dvt.externaltools.ExternalToolsStyleListener;
import ro.amiq.dvt.externaltools.IConsoleScanListener;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.pattern.DVTHyperlinkCommand;
import ro.amiq.dvt.externaltools.ui.ErrorIdMessageDialog;
import ro.amiq.dvt.externaltools.ui.markers.ExternalToolsProblemsManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTConsoleHyperlinkUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class ExternalToolsConsoleListener
implements IConsoleScanListener,
IPropertyChangeListener {
    public static final String PROBLEM_POSITION_CATEGORY = "ro.amiq.dvt.externaltools.PROBLEM_POSITION_CATEGORY";
    private static final String URL_VARIABLE = "${url}";
    public static final String UNABLE_TO_OPEN_TEXT = "Unable to open";
    public static final String DUE_TO_TEXT = "due to";
    public static final String MODULE_REDEFINED_TEXT = "The module was previously declared at:";
    public static final String REDECLARED_TEXT = "It is redeclared later at:";
    public static final String MACRO_REDEFINED_TEXT = "Text macro redefined";
    public static final String PREVIOUS_DEFINITION_IN = "previous definition in ";
    public static final String IN_TEXT = "In ";
    public static final String DEFINED_TEXT = ", it was defined.";
    public static final int MAX_MESSAGE_LENGTH = 2500;
    public static final String ATTR_SIMULATOR_HELP_COMMAND = "simulatorHelpCommand";
    public static final String ATTR_CONSOLE_HASH_CODE = "consoleHashCode";
    public static final String ATTR_CONSOLE_OFFSET = "consoleOffset";
    public static final String ATTR_CONSOLE_MESSAGE = "attrConsoleMessage";
    private static final String FILE_PATTERN = "((?:(?:[\\.]*[\\\\/]+(?:[\\.]+[\\\\/]+)*|[a-zA-Z][a-zA-Z_0-9]*:[\\\\/])(?:\\.?[a-zA-Z0-9&$:_\\-][ a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*|(?:\\.?[a-zA-Z0-9&$:_\\-][a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*)?[a-zA-Z0-9&:_\\-\\.]+)";
    private static final String LINE_PATTERN = "([0-9]+(?:[,.][0-9]+)*)";
    private static final Pattern URL_PATTERN = Pattern.compile("(?:http|https|ftp|file)://\\S+");
    private static final Pattern VCS_ERROR_PATTERN = Pattern.compile("\"?((?:(?:[\\.]*[\\\\/]+(?:[\\.]+[\\\\/]+)*|[a-zA-Z][a-zA-Z_0-9]*:[\\\\/])(?:\\.?[a-zA-Z0-9&$:_\\-][ a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*|(?:\\.?[a-zA-Z0-9&$:_\\-][a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*)?[a-zA-Z0-9&:_\\-\\.]+)\"?(?:,|:\\s+line)\\n?\\s+([0-9]+(?:[,.][0-9]+)*)");
    private static final Pattern IUS_MULTILINE_ERROR_PATTERN = Pattern.compile("[\\(\\[]([^,\\(\\)\\[\\]]+),\\s?([0-9]+(?:[,.][0-9]+)*)[\\)\\]]");
    private static final Pattern QUESTA_MULTILINE_ERROR_PATTERN = Pattern.compile("at\\s+([^,\\(\\)]+)\\(([0-9]+(?:[,.][0-9]+)*)\\)");
    private static final Pattern[] fSpecmanPatterns = new Pattern[]{Pattern.compile("File:\\s+((?:(?:[\\.]*[\\\\/]+(?:[\\.]+[\\\\/]+)*|[a-zA-Z][a-zA-Z_0-9]*:[\\\\/])(?:\\.?[a-zA-Z0-9&$:_\\-][ a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*|(?:\\.?[a-zA-Z0-9&$:_\\-][a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*)?[a-zA-Z0-9&:_\\-\\.]+)\\s+Line:\\s+([0-9]+(?:[,.][0-9]+)*)"), Pattern.compile("(?:[Dd]efined|[Dd]eclared)\\s+at\\s+line\\s+([0-9]+(?:[,.][0-9]+)*)\\s*\\n?\\s*in\\s*\\n?\\s*@?((?:(?:[\\.]*[\\\\/]+(?:[\\.]+[\\\\/]+)*|[a-zA-Z][a-zA-Z_0-9]*:[\\\\/])(?:\\.?[a-zA-Z0-9&$:_\\-][ a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*|(?:\\.?[a-zA-Z0-9&$:_\\-][a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*)?[a-zA-Z0-9&:_\\-\\.]+)"), Pattern.compile("\\s+line\\s+([0-9]+(?:[,.][0-9]+)*)\\s+(?:in|file)\\s+@?'?((?:(?:[\\.]*[\\\\/]+(?:[\\.]+[\\\\/]+)*|[a-zA-Z][a-zA-Z_0-9]*:[\\\\/])(?:\\.?[a-zA-Z0-9&$:_\\-][ a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*|(?:\\.?[a-zA-Z0-9&$:_\\-][a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*)?[a-zA-Z0-9&:_\\-\\.]+)'?"), Pattern.compile("No\\ssuch\\sfile\\sor\\sdirectory:\\s*@?((?:(?:[\\.]*[\\\\/]+(?:[\\.]+[\\\\/]+)*|[a-zA-Z][a-zA-Z_0-9]*:[\\\\/])(?:\\.?[a-zA-Z0-9&$:_\\-][ a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*|(?:\\.?[a-zA-Z0-9&$:_\\-][a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*)?[a-zA-Z0-9&:_\\-\\.]+)"), Pattern.compile("for\\simported\\sfile\\s*@?'?((?:(?:[\\.]*[\\\\/]+(?:[\\.]+[\\\\/]+)*|[a-zA-Z][a-zA-Z_0-9]*:[\\\\/])(?:\\.?[a-zA-Z0-9&$:_\\-][ a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*|(?:\\.?[a-zA-Z0-9&$:_\\-][a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*)?[a-zA-Z0-9&:_\\-\\.]+)'?"), Pattern.compile("imported\\sby\\s*@?'?((?:(?:[\\.]*[\\\\/]+(?:[\\.]+[\\\\/]+)*|[a-zA-Z][a-zA-Z_0-9]*:[\\\\/])(?:\\.?[a-zA-Z0-9&$:_\\-][ a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*|(?:\\.?[a-zA-Z0-9&$:_\\-][a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*)?[a-zA-Z0-9&:_\\-\\.]+)'?")};
    private TextConsole fConsole;
    private ExternalToolsPattern fPattern;
    private IProject fProject;
    private IExternalToolsConfiguration fConfiguration;
    private String fAutoFile;
    private int fLaunchKind;
    private IConsoleManager fConsoleManager = ConsolePlugin.getDefault().getConsoleManager();
    private String fWorkingDirectory;
    private boolean fIsTheLastPattern = false;
    private String fConsoleTitle;
    private String fOriginalConsoleTitle;
    private TextConsoleViewer fConsoleViewer;
    private static final Method SET_NAME_METHOD;

    static {
        Method method = null;
        try {
            method = AbstractConsole.class.getDeclaredMethod("setName", String.class);
            method.setAccessible(true);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        SET_NAME_METHOD = method;
    }

    public ExternalToolsConsoleListener(IProject project, IExternalToolsConfiguration config, ExternalToolsPattern pattern, String autoFile, Integer launchKind, String workingDirectory, boolean isTheLastPattern) {
        this.fProject = project;
        this.fPattern = pattern;
        this.fConfiguration = config;
        this.fAutoFile = autoFile;
        this.fLaunchKind = launchKind;
        this.fWorkingDirectory = workingDirectory;
        this.fIsTheLastPattern = isTheLastPattern;
    }

    @Override
    public TextConsole getConsole() {
        return this.fConsole;
    }

    @Override
    public TextConsoleViewer getConsoleViewer() {
        return this.fConsoleViewer;
    }

    @Override
    public void setConsoleViewer(TextConsoleViewer newConsoleViewer) {
        this.fConsoleViewer = newConsoleViewer;
    }

    public void connect(TextConsole console) {
        this.fConsole = console;
        this.fOriginalConsoleTitle = (String)console.getAttribute("ro.amiq.dvt.launch.ORIGINAL_CONSOLE_TITLE");
        this.fConsole.addPropertyChangeListener((IPropertyChangeListener)this);
        TestHelper.setTextConsole(console);
    }

    private void setName(final String name, final boolean terminate) {
        UIJob job = new UIJob("Update console title"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    SET_NAME_METHOD.invoke((Object)ExternalToolsConsoleListener.this.fConsole, name);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
                ExternalToolsConsoleListener.this.fConsoleManager.warnOfContentChange((IConsole)ExternalToolsConsoleListener.this.fConsole);
                if (terminate) {
                    ExternalToolsConsoleListener.this.fConsole = null;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE)) {
            if (this.fConsole != null && SET_NAME_METHOD != null && this.fConsoleTitle != null) {
                this.setName("<terminated>" + this.fConsoleTitle, true);
            }
            if (this.fConsole != null) {
                this.fConsole.removePropertyChangeListener((IPropertyChangeListener)this);
            }
            if (this.fIsTheLastPattern && this.fProject != null && this.fLaunchKind != 1) {
                if (this.fAutoFile == null) {
                    ExternalToolsProblemsManager.getInstance().update(this.fProject);
                } else {
                    IFile file = DVTFileUtils.getInstance().findProjectFile(this.fProject, this.fAutoFile);
                    ExternalToolsProblemsManager.getInstance().update(file);
                }
            }
            ObjectionManager.getInstance().clear(Objection.CONSOLE_OUTPUT_COMPLETE);
        }
    }

    @Override
    public void addErrorPosition(int offset, int length) {
        if (ExternalToolsModelManager.fAppliedProblemsPatterns.containsKey(offset)) {
            return;
        }
        try {
            IDocument document = this.fConsole.getDocument();
            if (!document.containsPositionCategory(PROBLEM_POSITION_CATEGORY)) {
                document.addPositionCategory(PROBLEM_POSITION_CATEGORY);
            }
            int severity = 0;
            if (this.fPattern.getType().equals(PrefConst.EXTERNAL_BUILDER_NOTIFICATION_TYPE[0])) {
                severity = 1;
            } else if (this.fPattern.getType().equals(PrefConst.EXTERNAL_BUILDER_NOTIFICATION_TYPE[1])) {
                severity = 2;
            }
            if (severity == 2 || severity == 1) {
                ExternalToolsModelManager.fAppliedProblemsPatterns.put(offset, length);
                document.addPosition(PROBLEM_POSITION_CATEGORY, (Position)new DVTPosition(offset, 0));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void addHyperlink(int offset, int length) {
        int totalLength = length;
        try {
            if (this.fProject == null) {
                return;
            }
            IDocument document = this.fConsole.getDocument();
            String fullMessage = document.get(offset, length);
            if (ExternalToolsModelManager.fAppliedPatterns.containsKey(offset)) {
                return;
            }
            int severity = 0;
            if (this.fPattern.getType().equals(PrefConst.EXTERNAL_BUILDER_NOTIFICATION_TYPE[0])) {
                severity = 1;
            } else if (this.fPattern.getType().equals(PrefConst.EXTERNAL_BUILDER_NOTIFICATION_TYPE[1])) {
                severity = 2;
            }
            HashMap<String, Integer> variablesMap = this.fPattern.getVariablesMap();
            HashMap<String, DVTHyperlinkCommand> hyperlinkCommandsMap = this.fPattern.getHyperlinkCommandsMap();
            Matcher m = this.fPattern.getPattern().matcher(fullMessage);
            String simulatorHelpCommand = null;
            if (m.find()) {
                String message;
                int start;
                String vErrorCode;
                Matcher matcher;
                int len;
                int start2;
                Object hyperlink;
                String url;
                int lineIndex = this.intValue(variablesMap.get("__DVT_L"));
                int fileIndex = this.intValue(variablesMap.get("__DVT_F"));
                int messageIndex = this.intValue(variablesMap.get("__DVT_M"));
                int ncErrorIdIndex = this.intValue(variablesMap.get("__DVT_NC_E"));
                int ncToolNameIndex = this.intValue(variablesMap.get("__DVT_NC_T"));
                int urlIndex = this.intValue(variablesMap.get("__DVT_U"));
                int vErrorIdIndex = this.intValue(variablesMap.get("__DVT_V_E"));
                int vErrorToolNameIndex = this.intValue(variablesMap.get("__DVT_V_T"));
                ArrayList<Integer> hyperlinkCommandIndexes = new ArrayList<Integer>();
                if (hyperlinkCommandsMap != null && !hyperlinkCommandsMap.keySet().isEmpty()) {
                    for (String hyperlinkIndex : hyperlinkCommandsMap.keySet()) {
                        hyperlinkCommandIndexes.add(this.intValue(variablesMap.get(hyperlinkIndex)));
                    }
                }
                ExternalToolsMessageStyle messageStyle = ExternalToolsColorManager.getInstance().getMessageStyle(this.fProject, this.fPattern.getName(), severity, this.getVariableValues(variablesMap, m));
                if (this.fPattern.getKind().equals("DVTConsoleTitle")) {
                    this.fConsoleTitle = this.fOriginalConsoleTitle;
                    int i = 1;
                    while (i <= m.groupCount()) {
                        if (m.group(i) != null && !m.group().isEmpty()) {
                            this.fConsoleTitle = String.valueOf(this.fConsoleTitle) + " [" + m.group(i) + "]";
                        }
                        ++i;
                    }
                    this.setName(this.fConsoleTitle, false);
                }
                ArrayList<HyperlinkPosition> addedHyperlinks = new ArrayList<HyperlinkPosition>();
                String ncToolName = ncToolNameIndex == -1 ? null : m.group(ncToolNameIndex);
                String ncErrCode = ncErrorIdIndex == -1 ? null : m.group(ncErrorIdIndex);
                String string = url = urlIndex == -1 ? null : m.group(urlIndex);
                if (url != null) {
                    hyperlink = new URLHyperlink(url);
                    start2 = offset + m.start(urlIndex);
                    len = url.length();
                    this.fConsole.addHyperlink((IHyperlink)hyperlink, start2, len);
                    addedHyperlinks.add(new HyperlinkPosition(start2, len));
                    if (this.fPattern.getPatternString().contains(URL_VARIABLE)) {
                        int pos = this.fPattern.getPatternString().length();
                        matcher = URL_PATTERN.matcher(fullMessage);
                        while (this.fPattern.getPatternString().lastIndexOf(URL_VARIABLE, pos - 1) != -1) {
                            pos = this.fPattern.getPatternString().lastIndexOf(URL_VARIABLE, pos - 1);
                            if (!matcher.find()) continue;
                            url = matcher.group();
                            URLHyperlink urlHyperlink = new URLHyperlink(url);
                            start2 = offset + matcher.start();
                            len = url.length();
                            if (this.fConsole.getHyperlink(start2) != null) continue;
                            this.fConsole.addHyperlink((IHyperlink)urlHyperlink, start2, len);
                            addedHyperlinks.add(new HyperlinkPosition(start2, len));
                        }
                    }
                }
                if (ncToolName != null && ncErrCode != null) {
                    simulatorHelpCommand = IDVTConstants.ncHelpSysVarValue != null ? String.valueOf(new File(IDVTConstants.ncHelpSysVarValue).getName()) + " " + ncToolName + " " + ncErrCode : "nchelp " + ncToolName + " " + ncErrCode;
                    hyperlink = new SimulatorHelpHyperlink(new DVTHyperlinkCommand(simulatorHelpCommand, ""), true, null);
                    start2 = offset + m.start(ncErrorIdIndex);
                    len = ncErrCode.length();
                    this.fConsole.addHyperlink((IHyperlink)hyperlink, start2, len);
                    addedHyperlinks.add(new HyperlinkPosition(start2, len));
                }
                String vErrorToolName = vErrorToolNameIndex > -1 ? m.group(vErrorToolNameIndex) : null;
                String string2 = vErrorCode = vErrorIdIndex > -1 ? m.group(vErrorIdIndex) : null;
                if (vErrorToolName != null && vErrorCode != null) {
                    simulatorHelpCommand = IDVTConstants.vErrorSysVarValue != null ? String.valueOf(new File(IDVTConstants.vErrorSysVarValue).getName()) + " " + vErrorToolName + "-" + vErrorCode : "verror " + vErrorToolName + "-" + vErrorCode;
                    SimulatorHelpHyperlink hyperlink2 = new SimulatorHelpHyperlink(new DVTHyperlinkCommand(simulatorHelpCommand, ""), true, null);
                    int start3 = offset + m.start(vErrorToolNameIndex);
                    int len2 = vErrorToolName.length() + vErrorCode.length() + 1;
                    this.fConsole.addHyperlink((IHyperlink)hyperlink2, start3, len2);
                    addedHyperlinks.add(new HyperlinkPosition(start3, len2));
                }
                if (hyperlinkCommandsMap != null && !hyperlinkCommandsMap.keySet().isEmpty()) {
                    int i = 0;
                    while (i < hyperlinkCommandIndexes.size()) {
                        String matchedHyperlinkCommand;
                        int hyperlinkCommandIndex = (Integer)hyperlinkCommandIndexes.get(i);
                        String string3 = matchedHyperlinkCommand = hyperlinkCommandIndex == -1 ? null : m.group(hyperlinkCommandIndex);
                        if (matchedHyperlinkCommand != null && hyperlinkCommandsMap.get("__DVT_C_R" + i) != null) {
                            Pattern pattern = Pattern.compile(hyperlinkCommandsMap.get("__DVT_C_R" + i).getPattern());
                            Matcher mtc = pattern.matcher(matchedHyperlinkCommand);
                            ArrayList<String> capturingGroups = new ArrayList<String>();
                            int j = 0;
                            while (j <= mtc.groupCount()) {
                                capturingGroups.add(m.group(hyperlinkCommandIndex + j));
                                ++j;
                            }
                            SimulatorHelpHyperlink hyperlink3 = new SimulatorHelpHyperlink(hyperlinkCommandsMap.get("__DVT_C_R" + i), false, capturingGroups);
                            start = offset + m.start(hyperlinkCommandIndex);
                            int len3 = matchedHyperlinkCommand.length();
                            this.fConsole.addHyperlink((IHyperlink)hyperlink3, start, len3);
                            addedHyperlinks.add(new HyperlinkPosition(start, len3));
                        }
                        ++i;
                    }
                }
                if (severity == 2 || severity == 1) {
                    if (fileIndex == -1 && lineIndex == -1) {
                        this.setMessageStyle(document, offset + m.start(), offset + m.end(), messageStyle, addedHyperlinks);
                        return;
                    }
                } else if (fileIndex == -1 && urlIndex == -1 && addedHyperlinks.isEmpty()) {
                    document.addPosition(ExternalToolsStyleListener.HYPER_LINK_CATEGORY, (Position)new ExternalToolsPosition(offset + m.start(), m.end() - m.start(), messageStyle));
                    return;
                }
                String fileName = null;
                int lineNumber = -1;
                if (this.fPattern.getName().equals("VCS Error Filter")) {
                    matcher = VCS_ERROR_PATTERN.matcher(fullMessage);
                    fileName = "";
                    lineNumber = 0;
                    while (matcher.find()) {
                        String fileN = matcher.group(1);
                        String lineNrStr = matcher.group(2);
                        int lineNr = DVTStringUtil.parseInt(lineNrStr, 0);
                        int lineStart = matcher.start(1);
                        Hyperlink link = new Hyperlink(fileN, lineNr);
                        this.fConsole.addHyperlink((IHyperlink)link, offset + lineStart, fileN.length());
                        addedHyperlinks.add(new HyperlinkPosition(offset + lineStart, fileN.length()));
                        lineStart = matcher.start(2);
                        link = new Hyperlink(fileN, lineNr);
                        this.fConsole.addHyperlink((IHyperlink)link, offset + lineStart, lineNrStr.length());
                        addedHyperlinks.add(new HyperlinkPosition(offset + lineStart, lineNrStr.length()));
                        if (!fileName.isEmpty() || lineNumber != 0) continue;
                        fileName = fileN;
                        lineNumber = lineNr;
                    }
                    this.setMessageStyle(document, offset, offset + fullMessage.length(), messageStyle, addedHyperlinks);
                    fileName = this.getAbsolutePath(fileName);
                    this.addToProblemsView(severity, fileName, lineNumber, fullMessage, simulatorHelpCommand, this.fConsole.hashCode(), offset);
                    ExternalToolsModelManager.fAppliedPatterns.put(offset, offset + length);
                    return;
                }
                if (this.fPattern.getKind().equals("Specman") || this.fPattern.getKind().equals("General") || this.fPattern.getKind().equals("DVT")) {
                    Pattern[] lineNr = fSpecmanPatterns;
                    int lineNrStr = fSpecmanPatterns.length;
                    int fileN = 0;
                    while (fileN < lineNrStr) {
                        Pattern pattern = lineNr[fileN];
                        Matcher matcher2 = pattern.matcher(fullMessage);
                        while (matcher2.find()) {
                            String fileNameTmp;
                            int lineIndTmp = pattern.pattern().indexOf(LINE_PATTERN);
                            int fileIndTmp = pattern.pattern().indexOf(FILE_PATTERN);
                            if (fileIndTmp < 0) continue;
                            int lineGroupIndex = -1;
                            int fileGroupIndex = -1;
                            if (lineIndTmp > 0) {
                                lineGroupIndex = lineIndTmp < fileIndTmp ? 1 : 2;
                                fileGroupIndex = lineGroupIndex == 2 ? 1 : 2;
                            } else if (lineIndTmp < 0) {
                                fileGroupIndex = 1;
                            }
                            int lineNumberTmp = 0;
                            String lineNrStr2 = "0";
                            if (lineGroupIndex > -1) {
                                lineNrStr2 = matcher2.group(lineGroupIndex);
                                lineNumberTmp = DVTStringUtil.parseInt(lineNrStr2, 0);
                            }
                            String fullFileName = fileNameTmp = matcher2.group(fileGroupIndex);
                            int fileStartPosition = matcher2.start(fileGroupIndex);
                            int hyperLength = fileNameTmp.length();
                            int hyperStart = offset + fileStartPosition;
                            if (fullMessage.charAt(matcher2.start(fileGroupIndex) - 1) == '@') {
                                --hyperStart;
                                ++hyperLength;
                                fullFileName = String.valueOf(fileNameTmp) + ".e";
                            }
                            Hyperlink link = new Hyperlink(fullFileName, lineNumberTmp);
                            this.fConsole.addHyperlink((IHyperlink)link, hyperStart, hyperLength);
                            addedHyperlinks.add(new HyperlinkPosition(hyperStart, hyperLength));
                            if (lineGroupIndex > -1) {
                                int lineStartPosition = matcher2.start(lineGroupIndex);
                                link = new Hyperlink(fullFileName, lineNumberTmp);
                                this.fConsole.addHyperlink((IHyperlink)link, offset + lineStartPosition, lineNrStr2.length());
                                addedHyperlinks.add(new HyperlinkPosition(offset + lineStartPosition, lineNrStr2.length()));
                            }
                            if (fileName != null && !fileName.isEmpty()) continue;
                            fileName = fullFileName;
                            lineNumber = lineNumberTmp;
                        }
                        ++fileN;
                    }
                    this.setMessageStyle(document, offset, offset + fullMessage.length(), messageStyle, addedHyperlinks);
                    if (fileName != null && !fileName.isEmpty()) {
                        fileName = this.getAbsolutePath(fileName);
                        this.addToProblemsView(severity, fileName, lineNumber, fullMessage, simulatorHelpCommand, this.fConsole.hashCode(), offset);
                    }
                    ExternalToolsModelManager.fAppliedPatterns.put(offset, offset + length);
                    return;
                }
                if (lineIndex == -1) {
                    lineNumber = 0;
                } else {
                    String group = m.group(lineIndex);
                    lineNumber = DVTStringUtil.parseInt(group, -1);
                }
                if (vErrorToolName != null && vErrorCode != null && severity == 0) {
                    if (fileIndex != -1 && m.group(fileIndex) != null && !m.group(fileIndex).isEmpty()) {
                        String groupFileName = m.group(fileIndex);
                        fileName = Path.fromOSString((String)groupFileName).toOSString();
                        if (fileName.endsWith(".")) {
                            fileName = fileName.substring(0, fileName.length() - 1);
                        }
                        int file_p1 = m.start(fileIndex);
                        Hyperlink link = new Hyperlink(fileName, 0);
                        this.fConsole.addHyperlink((IHyperlink)link, file_p1 + offset, groupFileName.length());
                        addedHyperlinks.add(new HyperlinkPosition(file_p1 + offset, groupFileName.length()));
                    }
                    this.setMessageStyle(document, offset, offset + fullMessage.length(), messageStyle, addedHyperlinks);
                    ExternalToolsModelManager.fAppliedPatterns.put(offset, offset + length);
                    return;
                }
                if (lineNumber == -1 && !this.fPattern.getName().startsWith("IUS Warning")) {
                    if (ncToolName != null && ncErrCode != null) {
                        document.addPosition(ExternalToolsStyleListener.HYPER_LINK_CATEGORY, (Position)new ExternalToolsPosition(offset, m.start(ncErrorIdIndex), messageStyle));
                        document.addPosition(ExternalToolsStyleListener.HYPER_LINK_CATEGORY, (Position)new ExternalToolsPosition(offset + m.end(ncErrorIdIndex), m.end() - m.end(ncErrorIdIndex), messageStyle));
                        ExternalToolsModelManager.fAppliedPatterns.put(offset, offset + length);
                        return;
                    }
                    if (this.fPattern.getName().equals("VCS File Open Error Filter")) {
                        String documentText = document.get(offset, Math.min(2500, document.getLength() - offset));
                        int p1 = documentText.indexOf(UNABLE_TO_OPEN_TEXT, 0) + UNABLE_TO_OPEN_TEXT.length();
                        int p2 = documentText.indexOf(DUE_TO_TEXT, p1);
                        String message2 = documentText.substring(0, p1);
                        String tmpFileName = documentText.substring(p1, p2).replace('\n', ' ').replace('\r', ' ').replace('\'', ' ').trim();
                        int linkStart = documentText.indexOf(tmpFileName, p1);
                        document.addPosition(ExternalToolsStyleListener.HYPER_LINK_CATEGORY, (Position)new ExternalToolsPosition(offset, linkStart, messageStyle));
                        Hyperlink link = new Hyperlink(tmpFileName, 0);
                        this.fConsole.addHyperlink((IHyperlink)link, linkStart + offset, tmpFileName.length());
                        fileName = this.getAbsolutePath(fileName);
                        this.addToProblemsView(severity, fileName, lineNumber, message2, simulatorHelpCommand, this.fConsole.hashCode(), offset);
                        ExternalToolsModelManager.fAppliedPatterns.put(offset, offset + length);
                        return;
                    }
                    if (m.group(fileIndex) != null && !m.group(fileIndex).isEmpty()) {
                        fileName = Path.fromOSString((String)m.group(fileIndex)).toOSString();
                        if (fileName.endsWith(".")) {
                            fileName = fileName.substring(0, fileName.length() - 1);
                        }
                        message = m.group(messageIndex);
                        int file_p1 = m.start(fileIndex);
                        int end = file_p1 + offset;
                        this.setMessageStyle(document, offset, end, messageStyle, addedHyperlinks);
                        Hyperlink link = new Hyperlink(fileName, 0);
                        this.fConsole.addHyperlink((IHyperlink)link, file_p1 + offset, fileName.length());
                        fileName = this.getAbsolutePath(fileName);
                        this.addToProblemsView(severity, fileName, lineNumber, message, simulatorHelpCommand, this.fConsole.hashCode(), offset);
                        ExternalToolsModelManager.fAppliedPatterns.put(offset, offset + length);
                        return;
                    }
                    document.addPosition(ExternalToolsStyleListener.HYPER_LINK_CATEGORY, (Position)new ExternalToolsPosition(offset + m.start(), m.end() - m.start(), messageStyle));
                    ExternalToolsModelManager.fAppliedPatterns.put(offset, offset + length);
                    return;
                }
                if (fileIndex != -1 && m.group(fileIndex) != null && ((fileName = Path.fromOSString((String)m.group(fileIndex)).toOSString()) == null || lineNumber == -1)) {
                    return;
                }
                String string4 = message = messageIndex == -1 ? "" : m.group(messageIndex);
                if (this.fPattern.getName().equals("IUS UPF/CPF Error Filter") && (message.isEmpty() || message.equals("."))) {
                    String string5 = message = m.group(4) == null ? message : m.group(4);
                }
                if (this.fPattern.getName().equals("IUS Error Filter Multiline 2") || this.fPattern.getName().equals("IUS Warning Filter Multiline") || this.fPattern.getName().equals("IUS Warning Filter Multiline 2")) {
                    extendedMessage = "";
                    if (messageIndex > lineIndex && messageIndex > fileIndex) {
                        extendedMessage = m.group(0).substring(m.start(messageIndex));
                    }
                    if (extendedMessage.length() > message.length()) {
                        tmpPattern = IUS_MULTILINE_ERROR_PATTERN;
                        lines = this.splitLines(extendedMessage);
                        int tmpOffset = offset + m.start(messageIndex);
                        String[] fileGroupIndex = lines;
                        int lineGroupIndex = lines.length;
                        int link = 0;
                        while (link < lineGroupIndex) {
                            String line = fileGroupIndex[link];
                            Matcher tmpMatcher = tmpPattern.matcher(line);
                            if (tmpMatcher.find() && tmpMatcher.groupCount() >= 2) {
                                String tmpFile = tmpMatcher.group(1);
                                int tmpLine = DVTStringUtil.parseInt(tmpMatcher.group(2), 0);
                                Hyperlink link2 = new Hyperlink(tmpFile, tmpLine);
                                int start4 = tmpOffset + tmpMatcher.start(1);
                                length = tmpMatcher.end(1) - tmpMatcher.start(1);
                                this.fConsole.addHyperlink((IHyperlink)link2, start4, length);
                                addedHyperlinks.add(new HyperlinkPosition(start4, length));
                                start4 = tmpOffset + tmpMatcher.start(2);
                                length = tmpMatcher.end(2) - tmpMatcher.start(2);
                                this.fConsole.addHyperlink((IHyperlink)link2, start4, length);
                                addedHyperlinks.add(new HyperlinkPosition(start4, length));
                            }
                            tmpOffset += line.length() + 1;
                            ++link;
                        }
                        if (!extendedMessage.isEmpty()) {
                            message = extendedMessage;
                        }
                        start = 0;
                        Hyperlink link2 = new Hyperlink(fileName, lineNumber);
                        if (lineIndex != -1 && fileIndex != -1) {
                            start = offset + m.start(lineIndex);
                            length = m.end(lineIndex) - m.start(lineIndex);
                            this.fConsole.addHyperlink((IHyperlink)link2, start, length);
                            addedHyperlinks.add(new HyperlinkPosition(start, length));
                        }
                        if (fileIndex != -1) {
                            start = offset + m.start(fileIndex);
                            length = m.end(fileIndex) - m.start(fileIndex);
                            this.fConsole.addHyperlink((IHyperlink)link2, start, length);
                            addedHyperlinks.add(new HyperlinkPosition(start, length));
                        }
                        this.setMessageStyle(document, offset, offset + fullMessage.length(), messageStyle, addedHyperlinks);
                        fileName = this.getAbsolutePath(fileName);
                        this.addToProblemsView(severity, fileName, lineNumber, message, simulatorHelpCommand, this.fConsole.hashCode(), offset);
                        ExternalToolsModelManager.fAppliedPatterns.put(offset, offset + length);
                        return;
                    }
                } else if (this.fPattern.getName().equals("Questa Error Filter Multiline") || this.fPattern.getName().equals("Questa Warning Filter Multiline")) {
                    extendedMessage = "";
                    if (messageIndex > lineIndex && messageIndex > fileIndex) {
                        extendedMessage = m.group(0).substring(0, m.start(fileIndex));
                    }
                    tmpPattern = QUESTA_MULTILINE_ERROR_PATTERN;
                    lines = this.splitLines(extendedMessage);
                    int tmpOffset = offset;
                    String[] fileGroupIndex = lines;
                    int lineGroupIndex = lines.length;
                    link = 0;
                    while (link < lineGroupIndex) {
                        String line = fileGroupIndex[link];
                        Matcher tmpMatcher = tmpPattern.matcher(line);
                        if (tmpMatcher.find() && tmpMatcher.groupCount() >= 2) {
                            String tmpFile = tmpMatcher.group(1);
                            int tmpLine = DVTStringUtil.parseInt(tmpMatcher.group(2), 0);
                            Hyperlink link = new Hyperlink(tmpFile, tmpLine);
                            int start5 = tmpOffset + tmpMatcher.start(1);
                            length = tmpMatcher.end(1) - tmpMatcher.start(1);
                            this.fConsole.addHyperlink((IHyperlink)link, start5, length);
                            addedHyperlinks.add(new HyperlinkPosition(start5, length));
                            start5 = tmpOffset + tmpMatcher.start(2);
                            length = tmpMatcher.end(2) - tmpMatcher.start(2);
                            this.fConsole.addHyperlink((IHyperlink)link, start5, length);
                            addedHyperlinks.add(new HyperlinkPosition(start5, length));
                        }
                        tmpOffset += line.length() + 1;
                        ++link;
                    }
                } else if (this.fPattern.getName().equals("VCS Module Prev Decl Error Filter")) {
                    documentText = document.get(offset, Math.min(2500, document.getLength() - offset));
                    int messageEnd = documentText.indexOf(MODULE_REDEFINED_TEXT) + MODULE_REDEFINED_TEXT.length();
                    message = documentText.substring(messageEnd);
                    int p1 = documentText.indexOf(REDECLARED_TEXT) + REDECLARED_TEXT.length();
                    int p2 = documentText.indexOf(58, p1);
                    String tmp = documentText.substring(p1, p2);
                    p3 = tmp.indexOf(44);
                    String fileN = tmp.substring(0, p3).replace('\"', ' ').trim();
                    String lineN = tmp.substring(p3 + 1).trim();
                    int filePos1 = tmp.indexOf(fileN);
                    int linePos1 = tmp.indexOf(lineN, filePos1);
                    Hyperlink link = new Hyperlink(fileN, DVTStringUtil.parseInt(lineN, 0));
                    this.fConsole.addHyperlink((IHyperlink)link, p1 + filePos1 + offset, fileN.length());
                    this.fConsole.addHyperlink((IHyperlink)link, p1 + linePos1 + offset, lineN.length());
                } else if (this.fPattern.getName().equals("VCS Macro Redefined Warning Filter")) {
                    documentText = document.get(offset, Math.min(2500, document.getLength() - offset));
                    int messageEnd = documentText.indexOf(MACRO_REDEFINED_TEXT) + MACRO_REDEFINED_TEXT.length();
                    message = documentText.substring(0, messageEnd);
                    int p1 = documentText.indexOf(IN_TEXT) + IN_TEXT.length();
                    int p2 = documentText.indexOf(DEFINED_TEXT, p1);
                    String tmp = documentText.substring(p1, p2);
                    p3 = tmp.indexOf(44);
                    String fileN = tmp.substring(0, p3).replace('\"', ' ').trim();
                    String lineN = tmp.substring(p3 + 1).trim();
                    int filePos1 = tmp.indexOf(fileN);
                    int linePos1 = tmp.indexOf(lineN, filePos1);
                    Hyperlink link = new Hyperlink(fileN, DVTStringUtil.parseInt(lineN, 0));
                    this.fConsole.addHyperlink((IHyperlink)link, p1 + filePos1 + offset, fileN.length());
                    this.fConsole.addHyperlink((IHyperlink)link, p1 + linePos1 + offset, lineN.length());
                } else if (this.fPattern.getName().equals("PowerArtist Macro Redefined Warning Filter")) {
                    int messageStart = fullMessage.indexOf("Redefinition of macro");
                    message = fullMessage.substring(messageStart);
                    int p1 = fullMessage.indexOf(PREVIOUS_DEFINITION_IN) + PREVIOUS_DEFINITION_IN.length();
                    String tmp = fullMessage.substring(p1, fullMessage.length() - 1);
                    int p2 = tmp.indexOf(" line ");
                    String fileN = tmp.substring(0, p2).replace('\"', ' ').trim();
                    String lineN = tmp.substring(p2 + 6).trim();
                    int filePos1 = tmp.indexOf(fileN);
                    int linePos1 = tmp.indexOf(lineN, filePos1);
                    Hyperlink link = new Hyperlink(fileN, DVTStringUtil.parseInt(lineN, 0));
                    this.fConsole.addHyperlink((IHyperlink)link, p1 + filePos1 + offset, fileN.length());
                    this.fConsole.addHyperlink((IHyperlink)link, p1 + linePos1 + offset, lineN.length());
                    addedHyperlinks.add(new HyperlinkPosition(p1 + filePos1 + offset, fileN.length()));
                    addedHyperlinks.add(new HyperlinkPosition(p1 + linePos1 + offset, lineN.length()));
                }
                if (message.isEmpty()) {
                    int index = 0;
                    index = fullMessage.indexOf(10);
                    message = index > 0 ? fullMessage.substring(0, index) : fullMessage;
                }
                fileName = this.getAbsolutePath(fileName);
                this.addToProblemsView(severity, fileName, lineNumber, message, simulatorHelpCommand, this.fConsole.hashCode(), offset);
                int start6 = 0;
                Hyperlink link = new Hyperlink(fileName, lineNumber);
                if (lineIndex != -1 && fileIndex != -1) {
                    start6 = offset + m.start(lineIndex);
                    length = m.end(lineIndex) - m.start(lineIndex);
                    this.fConsole.addHyperlink((IHyperlink)link, start6, length);
                }
                if (fileIndex != -1) {
                    start6 = offset + m.start(fileIndex);
                    length = m.end(fileIndex) - m.start(fileIndex);
                    this.fConsole.addHyperlink((IHyperlink)link, start6, length);
                }
                if (lineIndex != -1 && fileIndex != -1) {
                    int index1 = fileIndex;
                    int index2 = lineIndex;
                    if (m.start(index2) < m.start(index1) && m.start(index2) > 0) {
                        index1 = lineIndex;
                        index2 = fileIndex;
                    }
                    if (m.start(index1) < m.start(index2) && m.start(index1) >= 0) {
                        if (ncToolName != null && ncErrCode != null) {
                            start6 = offset;
                            length = m.start(ncErrorIdIndex);
                            this.setMessageStyle(document, start6, start6 + length, messageStyle, addedHyperlinks);
                            start6 = offset + m.end(ncErrorIdIndex);
                            length = m.start(index1) - m.end(ncErrorIdIndex);
                        } else {
                            start6 = offset;
                            length = m.start(index1);
                        }
                        this.setMessageStyle(document, start6, start6 + length, messageStyle, addedHyperlinks);
                        if (m.end(index1) < m.start(index2)) {
                            start6 = offset + m.end(index1);
                            length = m.start(index2) - m.end(index1);
                            this.setMessageStyle(document, start6, start6 + length, messageStyle, addedHyperlinks);
                        }
                        if (m.end(index2) < totalLength) {
                            start6 = offset + m.end(index2);
                            length = totalLength - m.end(index2);
                            length = this.adjustLength(m.group(), length);
                            this.setMessageStyle(document, start6, start6 + length, messageStyle, addedHyperlinks);
                        }
                        ExternalToolsModelManager.fAppliedPatterns.put(offset, offset + length);
                        return;
                    }
                } else if (fileIndex != -1) {
                    if (m.start(fileIndex) > 0) {
                        start6 = offset;
                    }
                    length = m.start(fileIndex);
                    this.setMessageStyle(document, start6, start6 + length, messageStyle, addedHyperlinks);
                    start6 = offset + m.end(fileIndex);
                    length = m.end() - m.end(fileIndex);
                    this.setMessageStyle(document, start6, start6 + length, messageStyle, addedHyperlinks);
                    ExternalToolsModelManager.fAppliedPatterns.put(offset, offset + length);
                    return;
                }
                if (severity == 2 || severity == 1) {
                    this.setMessageStyle(document, offset + m.start(), offset + m.end(), messageStyle, addedHyperlinks);
                    return;
                }
            }
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
    }

    private void setMessageStyle(IDocument document, int start, int end, ExternalToolsMessageStyle messageStyle, List<HyperlinkPosition> addedHyperlinks) throws BadLocationException, BadPositionCategoryException {
        if (addedHyperlinks.isEmpty()) {
            document.addPosition(ExternalToolsStyleListener.HYPER_LINK_CATEGORY, (Position)new ExternalToolsPosition(start, end - start, messageStyle));
        } else {
            Collections.sort(addedHyperlinks, new Comparator<HyperlinkPosition>(){

                @Override
                public int compare(HyperlinkPosition o1, HyperlinkPosition o2) {
                    return o1.getOffset() - o2.getOffset();
                }
            });
            for (HyperlinkPosition hyperlinkPosition : addedHyperlinks) {
                if (start > hyperlinkPosition.getOffset() || hyperlinkPosition.getOffset() + hyperlinkPosition.getLength() > end) continue;
                document.addPosition(ExternalToolsStyleListener.HYPER_LINK_CATEGORY, (Position)new ExternalToolsPosition(start, hyperlinkPosition.getOffset() - start, messageStyle));
                start = hyperlinkPosition.getOffset() + hyperlinkPosition.getLength();
            }
            if (end > start) {
                document.addPosition(ExternalToolsStyleListener.HYPER_LINK_CATEGORY, (Position)new ExternalToolsPosition(start, end - start, messageStyle));
            }
        }
    }

    private String[] splitLines(String message) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int end = 0;
        while ((end = message.indexOf(10, start)) > 0) {
            result.add(message.substring(start, end));
            start = end + 1;
        }
        if (start < message.length()) {
            result.add(message.substring(start));
        }
        return result.toArray(new String[result.size()]);
    }

    private String getAbsolutePath(String fileName) {
        IFile projectFile;
        if (fileName == null) {
            return "";
        }
        if (this.fProject != null) {
            fileName = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(fileName, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, name -> BuildConfigManager.getenv(this.fProject).get(name));
        }
        if (!Path.fromOSString((String)fileName).isAbsolute()) {
            fileName = Path.fromOSString((String)this.fWorkingDirectory).append(fileName).toOSString();
        }
        if ((projectFile = DVTFileUtils.getInstance().findProjectFile(this.fProject, fileName)) != null && projectFile.getLocation() != null) {
            fileName = projectFile.getLocation().toOSString();
        }
        return fileName;
    }

    private int intValue(Integer integer) {
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    private ArrayList<ExternalToolsNameValue> getVariableValues(HashMap<String, Integer> variablesMap, Matcher matcher) {
        if (variablesMap == null) {
            return null;
        }
        ArrayList<ExternalToolsNameValue> result = new ArrayList<ExternalToolsNameValue>();
        for (Map.Entry<String, Integer> entry : variablesMap.entrySet()) {
            String variable = entry.getKey();
            if (variable.equals("__DVT_L") || variable.equals("__DVT_F") || variable.equals("__DVT_T") || variable.equals("__DVT_M")) continue;
            result.add(new ExternalToolsNameValue(variable, matcher.group(entry.getValue())));
        }
        return result;
    }

    private int adjustLength(String text, int length) {
        int i = text.length() - 1;
        while (i >= 0) {
            char c = text.charAt(i);
            if (c != '\n' && c != '\r') break;
            --length;
            --i;
        }
        return length;
    }

    public int getCompilerFlags() {
        return 0;
    }

    public String getPattern() {
        if (this.fPattern.getPattern() == null) {
            return null;
        }
        return this.fPattern.getPattern().pattern();
    }

    @Override
    public Pattern getWholePattern() {
        return this.fPattern.getPattern();
    }

    public String getLineQualifier() {
        return null;
    }

    private String customizeMessage(String message) {
        if (message != null && message.length() > 0) {
            return "[" + this.fConfiguration.getName() + "] " + message.substring(0, 1).toUpperCase() + message.substring(1) + " [Right click to show in console]";
        }
        return "";
    }

    private void addToProblemsView(int severity, String fileName, int lineNumber, String message, String simulatorHelpCommand, int hashCode, int offset) {
        if (severity == 0) {
            return;
        }
        if (this.fLaunchKind == 1) {
            return;
        }
        if (this.fAutoFile != null && !Path.fromOSString((String)this.fAutoFile).equals((Object)Path.fromOSString((String)fileName))) {
            return;
        }
        if (this.fConfiguration == null) {
            return;
        }
        ExternalToolsProblem extToolsProblem = new ExternalToolsProblem(severity, fileName, lineNumber, this.customizeMessage(message));
        extToolsProblem.setAttribute(ATTR_CONSOLE_HASH_CODE, String.valueOf(hashCode));
        extToolsProblem.setAttribute(ATTR_CONSOLE_OFFSET, String.valueOf(offset));
        extToolsProblem.setAttribute(ATTR_CONSOLE_MESSAGE, message);
        if (simulatorHelpCommand != null) {
            extToolsProblem.setAttribute(ATTR_SIMULATOR_HELP_COMMAND, simulatorHelpCommand);
        }
        if (this.fProject != null) {
            ExternalToolsProblemsManager.getInstance().notifyResource(this.fProject, extToolsProblem, this.fConfiguration.getName());
        }
    }

    public void disconnect() {
    }

    private class Hyperlink
    implements IHyperlink {
        private String fFile;
        private int fLine;

        public Hyperlink(String file, int line) {
            this.fFile = file;
            this.fLine = line;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            DVTConsoleHyperlinkUtils.getInstance().openFileHyperlink(ExternalToolsConsoleListener.this.fProject, this.fFile, this.fLine, ExternalToolsConsoleListener.this.fPattern.getWorkingDir(), ExternalToolsConsoleListener.this.fConfiguration.isWSLink());
        }
    }

    static class HyperlinkPosition
    extends DVTPosition {
        public HyperlinkPosition(int start, int length) {
            super(start, length);
        }
    }

    static class SimulatorHelpHyperlink
    implements IHyperlink {
        private static final String DVT_KEY_HYPERLINK_MAP = "DVT_HYPERLINK_COMMAND_CAPTURING_GROUP_";
        private final String fCommand;
        private List<String> fCapturingGroups;
        private final boolean fDisplayOutput;

        public SimulatorHelpHyperlink(DVTHyperlinkCommand hc, boolean displayOutput, List<String> capturingGroups) {
            this.fCommand = hc.getCommand();
            this.fDisplayOutput = displayOutput;
            this.fCapturingGroups = capturingGroups;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            if (this.fDisplayOutput) {
                new ErrorIdMessageDialog(this.fCommand).open();
            } else {
                try {
                    ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                    ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations();
                    boolean removeOldLaunches = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.auto_remove_old_launches");
                    ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
                    int n = launchConfigurations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                        if (config.getName().equals(this.fCommand) && config.supportsMode("run")) {
                            HashMap<String, String> hyperlinkMap = new HashMap<String, String>();
                            ILaunchConfigurationWorkingCopy copy = config.getWorkingCopy();
                            if (this.fCapturingGroups != null && !this.fCapturingGroups.isEmpty()) {
                                for (String group : this.fCapturingGroups) {
                                    hyperlinkMap.put(DVT_KEY_HYPERLINK_MAP + this.fCapturingGroups.indexOf(group), group);
                                }
                            }
                            copy.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, hyperlinkMap);
                            if (removeOldLaunches) {
                                copy.setAttribute("ro.amiq.dvt.launchENABLE_AUTO_REMOVE_OLD_LAUNCHES", true);
                            }
                            DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", false);
                            DebugUITools.launch((ILaunchConfiguration)copy, (String)"run");
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
    }

    private class URLHyperlink
    implements IHyperlink {
        private String fURLString;

        public URLHyperlink(String url) {
            this.fURLString = url;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            try {
                if (this.fURLString.startsWith("file://")) {
                    Path path = new Path(this.fURLString.substring(7));
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(path.removeLastSegments(1));
                    fileStore = fileStore.getChild(path.lastSegment());
                    IFileInfo fetchInfo = fileStore.fetchInfo();
                    try {
                        if (!fetchInfo.isDirectory() && fetchInfo.exists()) {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IWorkbenchPage page = window.getActivePage();
                            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                            return;
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                } else {
                    try {
                        IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                        browser.openURL(new URL(this.fURLString));
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                IPath workingDir = ExternalToolsConsoleListener.this.fPattern.getWorkingDir();
                Program.launch((String)this.fURLString, (String)workingDir.toOSString());
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

