/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.internal.console.WordWrapAction;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import ro.amiq.dvt.DisableWordWrapFix;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.builders.DVTConsoleButtonsDescription;
import ro.amiq.dvt.builders.DVTMessageConsole;
import ro.amiq.dvt.builders.DVTMessageReportConsole;
import ro.amiq.dvt.externaltools.ConsoleHighlightModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsStyleListener;
import ro.amiq.dvt.externaltools.IConsoleScanListener;
import ro.amiq.dvt.externaltools.IDVTRunConsoleDebugActions;
import ro.amiq.dvt.externaltools.IDVTTerminatable;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.debug.IDebugConsole;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.DVTFileUtils;

public class ExternalToolsConsolePageParticipant
implements IConsolePageParticipant {
    private StopBuildAction fStopBuildAction;

    public void activated() {
    }

    public void deactivated() {
    }

    public void dispose() {
    }

    public void init(IPageBookViewPage page, IConsole console) {
        String consoleName = console.getName();
        if (consoleName.startsWith("<terminated>")) {
            consoleName = consoleName.substring(13).trim();
        }
        if (page instanceof TextConsolePage) {
            TextConsoleViewer consoleViewer = ((TextConsolePage)page).getViewer();
            ExternalToolsStyleListener styleListener = new ExternalToolsStyleListener(((TextConsole)console).getDocument());
            StyledText styledText = consoleViewer.getTextWidget();
            styledText.removeLineStyleListener((LineStyleListener)consoleViewer);
            styledText.removeLineBackgroundListener((LineBackgroundListener)consoleViewer);
            styledText.addLineStyleListener((LineStyleListener)styleListener);
            styledText.addLineBackgroundListener((LineBackgroundListener)styleListener);
            IToolBarManager toolBarManager = ((TextConsolePage)page).getSite().getActionBars().getToolBarManager();
            this.addButtons(toolBarManager, console, styledText, page);
            IContributionItem[] iContributionItemArray = toolBarManager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action;
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof WordWrapAction) {
                    DisableWordWrapFix.INSTANCE.installWordWrapListeners(styledText, (Action)((WordWrapAction)action));
                }
                ++n2;
            }
            ((TextConsolePage)page).getControl().addDisposeListener(e -> {
                try {
                    if (styledText.isDisposed()) {
                        return;
                    }
                    for (IConsoleScanListener listener : ConsoleHighlightModelManager.getInstance().fConsoleToListeners.get(console)) {
                        consoleViewer.removeViewportListener((IViewportListener)listener);
                        if (!(console instanceof TextConsole)) continue;
                        ((TextConsole)console).removePatternMatchListener((IPatternMatchListener)listener);
                    }
                    ConsoleHighlightModelManager.getInstance().fConsoleToListeners.remove(console);
                    ConsoleHighlightModelManager.getInstance().fConsoleToHighlightJob.remove(console);
                    styledText.removeLineStyleListener((LineStyleListener)styleListener);
                    styledText.removeLineBackgroundListener((LineBackgroundListener)styleListener);
                }
                catch (Exception exception) {}
            });
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    private static String getProjectNameFromConsoleName(IConsole console) {
        String consoleName = console.getName();
        if (consoleName == null || consoleName.isEmpty()) {
            return "";
        }
        if (consoleName.startsWith("DVT Internal Build Console for project")) {
            return consoleName.substring("DVT Internal Build Console for project".length()).replace("[", "").replace("]", "").trim();
        }
        if (consoleName.startsWith("DVT Internal Build Report Console for project")) {
            return consoleName.substring("DVT Internal Build Report Console for project".length()).replace("[", "").replace("]", "").trim();
        }
        if (consoleName.startsWith("UVM Runtime Elaboration Console for project")) {
            return consoleName.substring("UVM Runtime Elaboration Console for project".length()).replace("[", "").replace("]", "").trim();
        }
        if (consoleName.startsWith("DVT Run All Console for project") && XUtils.DVT_ENABLE_SV_INTERP_DEBUG) {
            return consoleName.substring("DVT Run All Console for project".length()).replace("[", "").replace("]", "").trim();
        }
        return "";
    }

    private void addButtons(IToolBarManager toolBarManager, IConsole console, StyledText styledText, IPageBookViewPage page) {
        if (console instanceof DVTMessageConsole) {
            DVTConsoleButtonsDescription buttonsDescription = ((DVTMessageConsole)console).getButtonsDescription();
            if (buttonsDescription == null) {
                return;
            }
            if (buttonsDescription.hasStopButton()) {
                this.fStopBuildAction = new StopBuildAction(console, (TextConsolePage)page);
                toolBarManager.appendToGroup("launchGroup", (IAction)this.fStopBuildAction);
                toolBarManager.appendToGroup("outputGroup", (IContributionItem)new Separator());
            }
            if (buttonsDescription.hasBuildReportButton()) {
                toolBarManager.appendToGroup("outputGroup", (IContributionItem)new Separator());
                toolBarManager.appendToGroup("outputGroup", (IAction)(console instanceof DVTMessageReportConsole ? new ShowBuildReportAction(console) : new ShowBuildAction(console)));
            }
            if (buttonsDescription.hasArrowButtons()) {
                toolBarManager.appendToGroup("outputGroup", (IContributionItem)new Separator());
                toolBarManager.appendToGroup("outputGroup", (IAction)new JumpToProblemAction(console, styledText, true));
                toolBarManager.appendToGroup("outputGroup", (IAction)new JumpToProblemAction(console, styledText, false));
                if (console instanceof IDVTRunConsoleDebugActions && ((IDVTRunConsoleDebugActions)console).hasPrintStackTraceOption()) {
                    toolBarManager.appendToGroup("outputGroup", (IAction)new XPrintStackTraceAction(console));
                    if (XUtils.DVT_ENABLE_SV_INTERP_DEBUG) {
                        XPrintChangeVerbosityAction printChangeVerbosityAction = new XPrintChangeVerbosityAction(console);
                        toolBarManager.appendToGroup("outputGroup", (IAction)printChangeVerbosityAction);
                        ((IDVTRunConsoleDebugActions)console).setVerbosityAction(printChangeVerbosityAction);
                        XPrintSimTime printSimTime = new XPrintSimTime(console);
                        toolBarManager.appendToGroup("outputGroup", (IAction)printSimTime);
                        XPrintConcurrentAssertionAction printConcurrentAssertionAction = new XPrintConcurrentAssertionAction(console);
                        toolBarManager.appendToGroup("outputGroup", (IAction)printConcurrentAssertionAction);
                    }
                }
            }
            return;
        }
        if (console instanceof IDebugConsole) {
            this.fStopBuildAction = new StopBuildAction((IConsole)((IDebugConsole)console), (TextConsolePage)page);
            toolBarManager.appendToGroup("launchGroup", (IAction)this.fStopBuildAction);
            toolBarManager.appendToGroup("outputGroup", (IContributionItem)new Separator());
            return;
        }
        if (console instanceof IOConsole) {
            toolBarManager.appendToGroup("outputGroup", (IContributionItem)new Separator());
            toolBarManager.appendToGroup("outputGroup", (IAction)new JumpToProblemAction(console, styledText, true));
            toolBarManager.appendToGroup("outputGroup", (IAction)new JumpToProblemAction(console, styledText, false));
        }
    }

    private static class JumpToProblemAction
    extends Action {
        private IConsole fConsole;
        private boolean fNext;
        private StyledText fStyledText;

        public JumpToProblemAction(IConsole console, StyledText styledText, boolean next) {
            this.fConsole = console;
            this.fNext = next;
            this.fStyledText = styledText;
        }

        public ImageDescriptor getImageDescriptor() {
            return this.fNext ? DVTImages.SEARCH_NEXT_A : DVTImages.SEARCH_PREV_A;
        }

        public boolean isEnabled() {
            return true;
        }

        public String getToolTipText() {
            return this.fNext ? "Next Problem" : "Prev Problem";
        }

        public void run() {
            if (!(this.fConsole instanceof TextConsole)) {
                return;
            }
            IDocument document = ((TextConsole)this.fConsole).getDocument();
            if (document == null || !document.containsPositionCategory("ro.amiq.dvt.externaltools.PROBLEM_POSITION_CATEGORY")) {
                return;
            }
            try {
                Position[] problemPositions = document.getPositions("ro.amiq.dvt.externaltools.PROBLEM_POSITION_CATEGORY");
                if (problemPositions == null || problemPositions.length == 0) {
                    return;
                }
                int line = this.fStyledText.getTopIndex();
                IRegion lineRegion = document.getLineInformation(line);
                int offset = lineRegion.getOffset() + (this.fNext ? lineRegion.getLength() : 0);
                int index = Arrays.binarySearch(problemPositions, new DVTPosition(offset, 0), new Comparator<Position>(){

                    @Override
                    public int compare(Position o1, Position o2) {
                        return o1.offset - o2.offset;
                    }
                });
                index = index < 0 ? (this.fNext ? -index - 1 : -index - 2) : (this.fNext ? index + 1 : index - 1);
                index = Math.max(index, 0);
                index = Math.min(index, problemPositions.length - 1);
                int problemOffset = problemPositions[index].offset;
                int problemLength = problemPositions[index].length;
                int lineOfOffset = document.getLineOfOffset(problemOffset);
                this.fStyledText.setTopIndex(lineOfOffset);
                TextConsoleViewer consoleViewer = ConsoleHighlightModelManager.getInstance().getConsoleViewer();
                ConsoleHighlightModelManager.getInstance().launchScanJob((TextConsole)this.fConsole, consoleViewer, problemOffset, problemLength);
            }
            catch (BadLocationException | BadPositionCategoryException e) {
                DVTLogger.INSTANCE.logError(e);
            }
        }
    }

    private static enum ReportShow {
        LOG("Open Log File in Editor"),
        BUILD_CONSOLE("Show Build Console"),
        HIDE_BUILD_REPORT("Hide Build Report Console");

        String name;

        private ReportShow(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static enum Show {
        LOG("Open Log File in Editor"),
        REPORT("Show Build Report Console");

        String name;

        private Show(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class ShowBuildAction
    extends Action
    implements IMenuCreator {
        private IConsole fConsole;
        private Menu menu;

        public ShowBuildAction(IConsole console) {
            super("Build report actions", 4);
            this.fConsole = console;
            this.setToolTipText("Build report actions");
            this.setEnabled(true);
            this.setImageDescriptor(DVTImages.SHOW_BUILD_LOG_FILE);
        }

        public boolean isEnabled() {
            return true;
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = null;
        }

        public void run() {
            this.setMenuCreator(this);
            this.getMenu((Control)DVTUiUtils.getActiveWorkbenchWindow().getShell());
            this.menu.setVisible(true);
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                return this.menu;
            }
            this.menu = new Menu(parent);
            this.createMenu();
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            if (this.menu != null) {
                return this.menu;
            }
            this.menu = new Menu(parent);
            this.createMenu();
            return null;
        }

        private void createMenu() {
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Object widgetData = e.widget.getData();
                    if (widgetData == null || !(widgetData instanceof Show)) {
                        return;
                    }
                    Show show = (Show)((Object)widgetData);
                    String projectName = ExternalToolsConsolePageParticipant.getProjectNameFromConsoleName(fConsole);
                    if (projectName.isEmpty()) {
                        return;
                    }
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    DVTBuildConsole console = DVTBuildConsoleRegistry.getConsole(project);
                    if (console == null) {
                        return;
                    }
                    switch (show) {
                        case LOG: {
                            if (console.getLogFile().exists() && console.isBuildLogToFile()) {
                                DVTFileUtils.getInstance().openEditor(console.getLogFile(), 0);
                                break;
                            }
                            MessageDialog.openInformation((Shell)Utils.getActiveShell(), (String)"No build log file!", (String)("Build log file '" + console.getLogFile() + "' for project '" + projectName + "' was not generated" + (console.isBuildLogToFile() ? "." : " because +dvt_build_log_to_file is set to false in the build configuration.")));
                            break;
                        }
                        case REPORT: {
                            DVTBuildConsoleRegistry.getConsole(project).printBuildReport(true);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            };
            Show[] showArray = Show.values();
            int n = showArray.length;
            int n2 = 0;
            while (n2 < n) {
                Show crtItem = showArray[n2];
                MenuItem item = new MenuItem(this.menu, 8);
                item.setText(crtItem.getName());
                item.setData((Object)crtItem);
                item.addSelectionListener(selectionListener);
                ++n2;
            }
        }
    }

    private static class ShowBuildReportAction
    extends Action
    implements IMenuCreator {
        private IConsole fReportConsole;
        private Menu menu;

        public ShowBuildReportAction(IConsole console) {
            super("Build report actions", 4);
            this.fReportConsole = console;
            this.setToolTipText("Build report actions");
            this.setEnabled(true);
            this.setImageDescriptor(DVTImages.SHOW_BUILD_LOG_FILE);
        }

        public boolean isEnabled() {
            return true;
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = null;
        }

        public void run() {
            this.setMenuCreator(this);
            this.getMenu((Control)DVTUiUtils.getActiveWorkbenchWindow().getShell());
            this.menu.setVisible(true);
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                return this.menu;
            }
            this.menu = new Menu(parent);
            this.createMenu();
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            if (this.menu != null) {
                return this.menu;
            }
            this.menu = new Menu(parent);
            this.createMenu();
            return null;
        }

        private void createMenu() {
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Object widgetData = e.widget.getData();
                    if (widgetData == null || !(widgetData instanceof ReportShow)) {
                        return;
                    }
                    ReportShow reportShow = (ReportShow)((Object)widgetData);
                    String projectName = ExternalToolsConsolePageParticipant.getProjectNameFromConsoleName(fReportConsole);
                    if (projectName.isEmpty()) {
                        return;
                    }
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    DVTBuildConsole console = DVTBuildConsoleRegistry.getConsole(project);
                    if (console == null) {
                        return;
                    }
                    switch (reportShow) {
                        case LOG: {
                            if (console.getLogFile().exists() && console.isBuildLogToFile()) {
                                DVTFileUtils.getInstance().openEditor(console.getLogFile(), 0);
                                break;
                            }
                            MessageDialog.openInformation((Shell)Utils.getActiveShell(), (String)"No build log file!", (String)("Build log file '" + console.getLogFile() + "' for project '" + projectName + "' was not generated" + (console.isBuildLogToFile() ? "." : " because +dvt_build_log_to_file is set to false in the build configuration.")));
                            break;
                        }
                        case BUILD_CONSOLE: {
                            DVTBuildConsoleRegistry.getConsole(project).removeReportConsole();
                            DVTBuildConsoleRegistry.getConsole(project).showBuildConsole();
                            break;
                        }
                        case HIDE_BUILD_REPORT: {
                            DVTBuildConsoleRegistry.getConsole(project).removeReportConsole();
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            };
            ReportShow[] reportShowArray = ReportShow.values();
            int n = reportShowArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReportShow crtItem = reportShowArray[n2];
                MenuItem item = new MenuItem(this.menu, 8);
                item.setText(crtItem.getName());
                item.setData((Object)crtItem);
                item.addSelectionListener(selectionListener);
                ++n2;
            }
        }
    }

    private class StopBuildAction
    extends Action {
        private IConsole fConsole;
        private TextConsolePage fPage;
        private boolean isRunningBuildPhase;

        public StopBuildAction(IConsole console, TextConsolePage page) {
            this.fConsole = console;
            this.fPage = page;
            String projectName = ExternalToolsConsolePageParticipant.getProjectNameFromConsoleName(this.fConsole);
            if (projectName.isEmpty()) {
                return;
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ResourcesPlugin.getWorkspace().addResourceChangeListener(event -> {
                if (event.getBuildKind() == 2000) {
                    this.isRunningBuildPhase = true;
                    this.enableStopBuildAction(this.isRunningBuildPhase);
                } else if (event.getBuildKind() == -2000) {
                    this.isRunningBuildPhase = false;
                    this.enableStopBuildAction(this.isRunningBuildPhase);
                }
                if (event.getBuildKind() == 1000) {
                    this.isRunningBuildPhase = true;
                    this.enableStopBuildAction(this.isRunningBuildPhase);
                } else if (event.getBuildKind() == -1000) {
                    this.isRunningBuildPhase = false;
                    this.enableStopBuildAction(this.isRunningBuildPhase);
                } else if (!this.isRunningBuildPhase) {
                    IProject sourceProject = null;
                    if (event.getSource() instanceof IProject) {
                        sourceProject = (IProject)event.getSource();
                    }
                    if (sourceProject != null && sourceProject.getName().equals(project.getName())) {
                        if (event.getBuildKind() == 15) {
                            if (event.getType() == 8) {
                                this.enableStopBuildAction(true);
                            }
                        } else if (event.getType() == 16) {
                            this.enableStopBuildAction(false);
                        }
                    } else if (event.getSource() instanceof IWorkspace) {
                        if (event.getType() == 8) {
                            this.enableStopBuildAction(true);
                        }
                        if (event.getType() == 16) {
                            this.enableStopBuildAction(false);
                        }
                    }
                }
            }, 24);
        }

        private void enableStopBuildAction(boolean state) {
            if (ExternalToolsConsolePageParticipant.this.fStopBuildAction.isEnabled() == state) {
                return;
            }
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display.isDisposed()) {
                return;
            }
            ExternalToolsConsolePageParticipant.this.fStopBuildAction.setEnabled(state);
            display.asyncExec(() -> {
                if (this.fPage == null) {
                    return;
                }
                IPageSite site = this.fPage.getSite();
                if (site == null) {
                    return;
                }
                IActionBars actionBars = site.getActionBars();
                if (actionBars == null) {
                    return;
                }
                IToolBarManager toolBarManager = actionBars.getToolBarManager();
                if (toolBarManager == null) {
                    return;
                }
                toolBarManager.update(true);
            });
        }

        public ImageDescriptor getImageDescriptor() {
            return DVTImages.STOP_CURRENT_BUILD_PROCESS;
        }

        public boolean isEnabled() {
            return super.isEnabled();
        }

        public String getToolTipText() {
            return "Stop Current Rebuild Job";
        }

        public void run() {
            Job[] allJobs;
            String projectName;
            if (this.fConsole instanceof IDVTTerminatable) {
                ((IDVTTerminatable)this.fConsole).terminate();
            }
            if ((projectName = ExternalToolsConsolePageParticipant.getProjectNameFromConsoleName(this.fConsole)).isEmpty()) {
                return;
            }
            Job[] jobArray = allJobs = Job.getJobManager().find(null);
            int n = allJobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                Object projectBuiltByJob = job.getProperty(IDVTConstants.BUILD_JOB_PROJECT_NAME);
                if (projectBuiltByJob instanceof String && projectBuiltByJob.equals(projectName)) {
                    try {
                        job.cancel();
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
            this.enableStopBuildAction(false);
        }
    }

    public static class XPrintChangeVerbosityAction
    extends Action
    implements IMenuCreator {
        private Menu menu;
        private IConsole console;
        private static final String[] verbosityLevels = new String[]{"UVM_NONE", "UVM_LOW", "UVM_MEDIUM", "UVM_HIGH", "UVM_FULL", "UVM_DEBUG"};

        public XPrintChangeVerbosityAction(IConsole console) {
            super(((IDVTRunConsoleDebugActions)console).getVerbosity(), 4);
            this.setToolTipText("Select UVM Verbosity");
            this.setEnabled(true);
            this.setMenuCreator(this);
            this.console = console;
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = null;
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                return this.menu;
            }
            this.menu = new Menu(parent);
            this.createMenu();
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            if (this.menu != null) {
                return this.menu;
            }
            this.menu = new Menu(parent);
            this.createMenu();
            return this.menu;
        }

        private void createMenu() {
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!((MenuItem)e.widget).getSelection()) {
                        return;
                    }
                    Object verbosityLevel = e.widget.getData();
                    if (verbosityLevel == null || !(verbosityLevel instanceof String)) {
                        return;
                    }
                    this.setText((String)verbosityLevel);
                    ((IDVTRunConsoleDebugActions)console).changeVerbosity((String)verbosityLevel);
                    XUtils.setVerbosityChanged(true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            };
            String selectVerbosity = ((IDVTRunConsoleDebugActions)this.console).getVerbosity();
            String[] stringArray = verbosityLevels;
            int n = verbosityLevels.length;
            int n2 = 0;
            while (n2 < n) {
                String verbosityLevel = stringArray[n2];
                MenuItem item = new MenuItem(this.menu, 16);
                item.setText(verbosityLevel);
                item.setData((Object)verbosityLevel);
                item.setSelection(verbosityLevel.equals(selectVerbosity));
                item.addSelectionListener(selectionListener);
                ++n2;
            }
        }

        public void setSelection(String verbosityLevel) {
            MenuItem[] items;
            if (this.menu == null) {
                return;
            }
            MenuItem[] menuItemArray = items = this.menu.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                Object data = item.getData();
                if (data != null && data instanceof String && data == verbosityLevel) {
                    item.setSelection(true);
                    ((IDVTRunConsoleDebugActions)this.console).changeVerbosity(verbosityLevel);
                } else {
                    item.setSelection(false);
                }
                ++n2;
            }
        }
    }

    private static class XPrintConcurrentAssertionAction
    extends Action {
        private IConsole fConsole;

        public XPrintConcurrentAssertionAction(IConsole console) {
            this.fConsole = console;
        }

        public ImageDescriptor getImageDescriptor() {
            return DVTImages.SORT_EXEC;
        }

        public boolean isEnabled() {
            return true;
        }

        public String getToolTipText() {
            return "Print Concurrent Assertions Cursors";
        }

        public void run() {
            try {
                if (this.fConsole instanceof IDVTRunConsoleDebugActions) {
                    ((IDVTRunConsoleDebugActions)this.fConsole).printConcurrentAssertionsCursors();
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private static class XPrintSimTime
    extends Action {
        private IConsole fConsole;

        public XPrintSimTime(IConsole console) {
            this.fConsole = console;
        }

        public ImageDescriptor getImageDescriptor() {
            return DVTImages.OUTLINE_CLOCKING;
        }

        public boolean isEnabled() {
            return true;
        }

        public String getToolTipText() {
            return "Print Sim Time";
        }

        public void run() {
            try {
                if (this.fConsole instanceof IDVTRunConsoleDebugActions) {
                    ((IDVTRunConsoleDebugActions)this.fConsole).printSimTime();
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private static class XPrintStackTraceAction
    extends Action {
        private IConsole fConsole;

        public XPrintStackTraceAction(IConsole console) {
            this.fConsole = console;
        }

        public ImageDescriptor getImageDescriptor() {
            return DVTImages.PRINT_STACK_TRACE;
        }

        public boolean isEnabled() {
            return true;
        }

        public String getToolTipText() {
            return "Print Stack Trace";
        }

        public void run() {
            try {
                if (this.fConsole instanceof IDVTRunConsoleDebugActions) {
                    ((IDVTRunConsoleDebugActions)this.fConsole).printStackTrace();
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

