/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsoleViewer;
import ro.amiq.dvt.externaltools.ConsoleHighlightModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsConsoleListener;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.ExternalToolsStoreUtil;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.IConsoleScanListener;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.IExternalToolsDelegate;
import ro.amiq.dvt.externaltools.defaults.HALBuilderConfiguration;
import ro.amiq.dvt.externaltools.defaults.IrunBuilderConfigurationVhdl;
import ro.amiq.dvt.externaltools.defaults.IrunBuilderConfigurationVlog;
import ro.amiq.dvt.externaltools.defaults.IrunBuilderOVMConfigurationVlog;
import ro.amiq.dvt.externaltools.defaults.IrunBuilderUVMConfigurationVlog;
import ro.amiq.dvt.externaltools.defaults.NCVlogBuilderConfigurationVhdl;
import ro.amiq.dvt.externaltools.defaults.NCVlogBuilderConfigurationVlog;
import ro.amiq.dvt.externaltools.defaults.NCVlogBuilderOVMConfigurationVlog;
import ro.amiq.dvt.externaltools.defaults.NCVlogBuilderUVMConfigurationVlog;
import ro.amiq.dvt.externaltools.defaults.QuestaBuilderConfigurationVhdl;
import ro.amiq.dvt.externaltools.defaults.QuestaBuilderConfigurationVlog;
import ro.amiq.dvt.externaltools.defaults.SpecmanBuilderConfiguration;
import ro.amiq.dvt.externaltools.defaults.VCSBuilderConfigurationVlog;
import ro.amiq.dvt.externaltools.pattern.PatternContextTypeRegistry;
import ro.amiq.dvt.externaltools.pattern.PatternContributionContextTypeRegistry;
import ro.amiq.dvt.externaltools.ui.markers.ExternalToolsProblemsManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.PrefConst;

public class ExternalToolsModelManager {
    public static final ConcurrentHashMap<Integer, Integer> fAppliedPatterns = new ConcurrentHashMap();
    public static final ConcurrentHashMap<Integer, Integer> fAppliedProblemsPatterns = new ConcurrentHashMap();
    private static final Object fSyncInstance = new Object();
    private static volatile ExternalToolsModelManager fInstance;
    private List<IExternalToolsConfiguration> fBuilderTypes;
    private PatternContributionContextTypeRegistry fRegistry;
    private List<IExternalToolsDelegate> fExternalToolsDelegates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalToolsModelManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new ExternalToolsModelManager();
            }
        }
        return fInstance;
    }

    public void init() {
        try {
            this.fBuilderTypes = new ArrayList<IExternalToolsConfiguration>();
            this.fBuilderTypes.add(new ExternalToolsConfiguration());
            this.fBuilderTypes.add(new VCSBuilderConfigurationVlog());
            this.fBuilderTypes.add(new NCVlogBuilderConfigurationVhdl());
            this.fBuilderTypes.add(new NCVlogBuilderConfigurationVlog());
            this.fBuilderTypes.add(new NCVlogBuilderOVMConfigurationVlog());
            this.fBuilderTypes.add(new NCVlogBuilderUVMConfigurationVlog());
            this.fBuilderTypes.add(new IrunBuilderConfigurationVhdl());
            this.fBuilderTypes.add(new IrunBuilderConfigurationVlog());
            this.fBuilderTypes.add(new IrunBuilderOVMConfigurationVlog());
            this.fBuilderTypes.add(new IrunBuilderUVMConfigurationVlog());
            this.fBuilderTypes.add(new QuestaBuilderConfigurationVlog());
            this.fBuilderTypes.add(new QuestaBuilderConfigurationVhdl());
            this.fBuilderTypes.add(new SpecmanBuilderConfiguration());
            this.fBuilderTypes.add(new HALBuilderConfiguration());
            this.fRegistry = new PatternContributionContextTypeRegistry();
            int i = 0;
            while (i < PrefConst.FILTER_TYPES.length) {
                this.fRegistry.addContextType(PrefConst.FILTER_TYPES[i]);
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public List<IExternalToolsConfiguration> getBuilderConfigsWorkingCopy(IProject project, boolean onlyEnabled) {
        ArrayList<IExternalToolsConfiguration> workingCopy = new ArrayList<IExternalToolsConfiguration>();
        List<IExternalToolsConfiguration> builderConfigs = ExternalToolsStoreUtil.getBuilderConfigurations(project);
        if (builderConfigs == null || builderConfigs.isEmpty()) {
            return workingCopy;
        }
        try {
            IProjectDescription projectDescription = project.getDescription();
            ArrayList<ICommand> commands = new ArrayList<ICommand>(Arrays.asList(projectDescription.getBuildSpec()));
            ICommand builderCommand = projectDescription.newCommand();
            builderCommand.setBuilderName("ro.amiq.dvt.DVTExternBuilder");
            if (!commands.contains(builderCommand)) {
                commands.add(builderCommand);
                projectDescription.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
                project.setDescription(projectDescription, null);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        for (IExternalToolsConfiguration config : builderConfigs) {
            if (!config.getEnable() && onlyEnabled) continue;
            IExternalToolsConfiguration configCopy = config.getWorkingCopy();
            workingCopy.add(configCopy);
        }
        return workingCopy;
    }

    public void saveBuilderConfigs(IProject project, List<IExternalToolsConfiguration> newConfigs, List<IExternalToolsConfiguration> oldConfigs) throws Exception {
        ExternalToolsUtil.clean(project, newConfigs, oldConfigs);
        ExternalToolsStoreUtil.save(project, newConfigs);
        IProjectDescription projectDescription = project.getDescription();
        ArrayList<ICommand> commands = new ArrayList<ICommand>(Arrays.asList(projectDescription.getBuildSpec()));
        ICommand builderCommand = projectDescription.newCommand();
        builderCommand.setBuilderName("ro.amiq.dvt.DVTExternBuilder");
        boolean enabledConfigs = this.hasEnabledConfigs(newConfigs);
        if (enabledConfigs && !commands.contains(builderCommand)) {
            commands.add(builderCommand);
        } else if (!enabledConfigs && commands.contains(builderCommand)) {
            ExternalToolsUtil.clean((IResource)project, null);
            commands.remove(builderCommand);
        }
        projectDescription.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
        project.setDescription(projectDescription, null);
    }

    private boolean hasEnabledConfigs(List<IExternalToolsConfiguration> configs) {
        if (configs == null) {
            return false;
        }
        for (IExternalToolsConfiguration config : configs) {
            if (!config.getEnable()) continue;
            return true;
        }
        return false;
    }

    public List<IExternalToolsConfiguration> getBuilderTypes() {
        if (this.fBuilderTypes == null) {
            return null;
        }
        ArrayList<IExternalToolsConfiguration> result = new ArrayList<IExternalToolsConfiguration>();
        for (IExternalToolsConfiguration builder : this.fBuilderTypes) {
            result.add(builder);
        }
        return result;
    }

    public IExternalToolsConfiguration getBuilderForName(ArrayList<IExternalToolsConfiguration> builderConfigs, String name) {
        if (builderConfigs != null) {
            for (IExternalToolsConfiguration data : builderConfigs) {
                if (data == null || !data.getName().equals(name)) continue;
                return data;
            }
        }
        return null;
    }

    public PatternContextTypeRegistry getContextTypeRegistry() {
        return this.fRegistry;
    }

    public void addExternalToolsDelegate(IExternalToolsDelegate delegate) {
        if (this.fExternalToolsDelegates == null) {
            this.fExternalToolsDelegates = new ArrayList<IExternalToolsDelegate>();
        }
        if (!this.fExternalToolsDelegates.contains(delegate)) {
            this.fExternalToolsDelegates.add(delegate);
        }
    }

    public IExternalToolsDelegate getExternalToolDelegate(IProject project, String builderKind) {
        if (this.fExternalToolsDelegates == null) {
            return null;
        }
        for (IExternalToolsDelegate delegate : this.fExternalToolsDelegates) {
            if (!delegate.getBuilderKind().equals(builderKind)) continue;
            return delegate;
        }
        return null;
    }

    public void setProcessConsole(IConsole console, IProject project, IExternalToolsConfiguration config, String autoFile, int launchKind, String workingDirectory) {
        try {
            if (console == null) {
                return;
            }
            fAppliedPatterns.clear();
            fAppliedProblemsPatterns.clear();
            ExternalToolsProblemsManager.getInstance();
            List<ExternalToolsPattern> patterns = ExternalToolsUtil.getEnabledPatterns(ExternalToolsUtil.getPatterns(config));
            LinkedList<ExternalToolsPattern> userDefPatterns = new LinkedList<ExternalToolsPattern>();
            LinkedList<ExternalToolsPattern> nonUserDefPatterns = new LinkedList<ExternalToolsPattern>();
            LinkedList<ExternalToolsPattern> orderedPatterns = new LinkedList<ExternalToolsPattern>();
            for (ExternalToolsPattern pattern : patterns) {
                if (pattern.getKind().equals("User defined")) {
                    userDefPatterns.add(pattern);
                    continue;
                }
                nonUserDefPatterns.add(pattern);
            }
            orderedPatterns.addAll(userDefPatterns);
            orderedPatterns.addAll(nonUserDefPatterns);
            int index = 0;
            ConsoleHighlightModelManager.getInstance().fConsoleToListeners.putIfAbsent(console, new ConcurrentLinkedQueue());
            Queue<IConsoleScanListener> listeners = ConsoleHighlightModelManager.getInstance().fConsoleToListeners.get(console);
            this.removeOldListeners(listeners, (IOConsole)console);
            for (ExternalToolsPattern pattern : orderedPatterns) {
                pattern.setWorkingDir(ExternalToolsUtil.getWorkingDirectory(config));
                ExternalToolsConsoleListener listener = new ExternalToolsConsoleListener(project, config, pattern, autoFile, launchKind, workingDirectory, ++index == orderedPatterns.size());
                listeners.add(listener);
                ((IOConsole)console).addPatternMatchListener((IPatternMatchListener)listener);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void removeOldListeners(Queue<IConsoleScanListener> listeners, IOConsole console) {
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            IConsoleScanListener listener = (IConsoleScanListener)it.next();
            if (!(listener instanceof ExternalToolsConsoleListener)) continue;
            console.removePatternMatchListener((IPatternMatchListener)listener);
            console.removePropertyChangeListener((IPropertyChangeListener)((ExternalToolsConsoleListener)listener));
            TextConsoleViewer consoleViewer = listener.getConsoleViewer();
            if (consoleViewer != null) {
                consoleViewer.removeViewportListener((IViewportListener)listener);
            }
            it.remove();
        }
    }
}

